/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classfileparser;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassfileBinaryParser {
    private static final int BUFFER_SIZE = 8192;
    private static final Pattern TYPE_PARAM_PATTERN = Pattern.compile("(^[\\[]*|[;<]+)[+-]?L([^;<>*]+)");

    private static String readAnnotation(DataInputStream inp, Object[] constantPool, String className) throws IOException {
        String annotationFieldDescriptor = ClassfileBinaryParser.readRefdClassName(inp, constantPool);
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1) : annotationFieldDescriptor;
        int numElementValuePairs = inp.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            inp.skipBytes(2);
            ClassfileBinaryParser.readAnnotationElementValue(inp, constantPool, className);
        }
        return annotationClassName;
    }

    private static void readAnnotationElementValue(DataInputStream inp, Object[] constantPool, String className) throws IOException {
        int tag = inp.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                inp.skipBytes(2);
                break;
            }
            case 101: {
                inp.skipBytes(4);
                break;
            }
            case 99: {
                inp.skipBytes(2);
                break;
            }
            case 64: {
                ClassfileBinaryParser.readAnnotation(inp, constantPool, className);
                break;
            }
            case 91: {
                int count = inp.readUnsignedShort();
                for (int l = 0; l < count; ++l) {
                    ClassfileBinaryParser.readAnnotationElementValue(inp, constantPool, className);
                }
                break;
            }
            default: {
                throw new RuntimeException("Class " + className + " has unknown annotation element type tag '" + (char)tag + "': element size unknown, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
            }
        }
    }

    private static String readRefdString(DataInputStream inp, Object[] constantPool) throws IOException {
        return (String)constantPool[inp.readUnsignedShort()];
    }

    private static String readRefdClassName(DataInputStream inp, Object[] constantPool) throws IOException {
        String refdString = ClassfileBinaryParser.readRefdString(inp, constantPool);
        return refdString == null ? null : refdString.replace('/', '.');
    }

    private static void addFieldTypeDescriptorParts(String className, String typeDescriptor, ScanSpec scanSpec, ClassInfo classInfo, Map<String, ClassInfo> classNameToClassInfo, HashSet<String> loggedFieldTypeNames) {
        Matcher matcher = TYPE_PARAM_PATTERN.matcher(typeDescriptor);
        while (matcher.find()) {
            String descriptorPart = matcher.group(2);
            String fieldTypeName = descriptorPart.replace('/', '.');
            if (!scanSpec.classIsNotBlacklisted(fieldTypeName) || fieldTypeName.startsWith("java.lang.") || fieldTypeName.startsWith("java.util.")) continue;
            if (FastClasspathScanner.verbose && loggedFieldTypeNames.add(fieldTypeName)) {
                Log.log(5, "Class " + className + " has a field with type or type parameter " + fieldTypeName);
            }
            classInfo.addFieldType(fieldTypeName, classNameToClassInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readClassInfoFromClassfileHeader(String relativePath, InputStream inputStream, Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch, ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo) {
        try (DataInputStream inp = new DataInputStream(new BufferedInputStream(inputStream, 8192));){
            int attributeLength;
            int methodCount;
            int i;
            if (inp.readInt() != -889275714) {
                if (FastClasspathScanner.verbose) {
                    Log.log(5, "File does not have correct classfile magic number: " + relativePath);
                }
                boolean bl = false;
                return bl;
            }
            inp.readUnsignedShort();
            inp.readUnsignedShort();
            int cpCount = inp.readUnsignedShort();
            Object[] constantPool = new Object[cpCount];
            int[] indirectStringRef = new int[cpCount];
            Arrays.fill(indirectStringRef, -1);
            block53: for (i = 1; i < cpCount; ++i) {
                int tag = inp.readUnsignedByte();
                switch (tag) {
                    case 1: {
                        constantPool[i] = inp.readUTF();
                        continue block53;
                    }
                    case 3: {
                        constantPool[i] = inp.readInt();
                        continue block53;
                    }
                    case 4: {
                        constantPool[i] = Float.valueOf(inp.readFloat());
                        continue block53;
                    }
                    case 5: {
                        constantPool[i] = inp.readLong();
                        ++i;
                        continue block53;
                    }
                    case 6: {
                        constantPool[i] = inp.readDouble();
                        ++i;
                        continue block53;
                    }
                    case 7: 
                    case 8: {
                        indirectStringRef[i] = inp.readUnsignedShort();
                        continue block53;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        inp.skipBytes(4);
                        continue block53;
                    }
                    case 15: {
                        inp.skipBytes(3);
                        continue block53;
                    }
                    case 16: {
                        inp.skipBytes(2);
                        continue block53;
                    }
                    case 18: {
                        inp.skipBytes(4);
                        continue block53;
                    }
                    default: {
                        throw new RuntimeException("Classfile " + relativePath + " has unknown constant pool tag " + tag + ": element size unknown, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
                    }
                }
            }
            for (i = 1; i < cpCount; ++i) {
                if (indirectStringRef[i] < 0) continue;
                constantPool[i] = constantPool[indirectStringRef[i]];
            }
            int flags = inp.readUnsignedShort();
            boolean isInterface = (flags & 0x200) != 0;
            boolean isAnnotation = (flags & 0x2000) != 0;
            String className = ClassfileBinaryParser.readRefdClassName(inp, constantPool);
            if ("java.lang.Object".equals(className)) {
                boolean bl = false;
                return bl;
            }
            if (!className.equals(relativePath.substring(0, relativePath.length() - 6).replace('/', '.'))) {
                if (FastClasspathScanner.verbose) {
                    Log.log(5, "Class " + className + " is at incorrect relative path " + relativePath + " -- ignoring");
                }
                boolean bl = false;
                return bl;
            }
            ClassInfo classInfo = ClassInfo.addScannedClass(className, isInterface, isAnnotation, classNameToClassInfo);
            if (classInfo == null) {
                if (FastClasspathScanner.verbose) {
                    Log.log(5, className + " occurs more than once on classpath, ignoring all but first instance");
                }
                boolean bl = false;
                return bl;
            }
            String superclassName = ClassfileBinaryParser.readRefdClassName(inp, constantPool);
            if (FastClasspathScanner.verbose) {
                Log.log(5, "Found " + (isAnnotation ? "annotation class" : (isInterface ? "interface class" : "class")) + " " + className + (superclassName == null || "java.lang.Object".equals(superclassName) ? "" : " with " + (isInterface && !isAnnotation ? "superinterface" : "superclass") + " " + superclassName));
            }
            if (scanSpec.classIsNotBlacklisted(superclassName)) {
                classInfo.addSuperclass(superclassName, classNameToClassInfo);
            }
            int interfaceCount = inp.readUnsignedShort();
            for (int i2 = 0; i2 < interfaceCount; ++i2) {
                String interfaceName = ClassfileBinaryParser.readRefdClassName(inp, constantPool);
                if (!scanSpec.classIsNotBlacklisted(interfaceName)) continue;
                if (FastClasspathScanner.verbose) {
                    Log.log(6, "Class " + className + " implements interface " + interfaceName);
                }
                classInfo.addImplementedInterface(interfaceName, classNameToClassInfo);
            }
            HashSet<String> staticFinalFieldsToMatch = classNameToStaticFinalFieldsToMatch.get(classInfo.className);
            HashSet<String> loggedFieldTypeNames = FastClasspathScanner.verbose ? new HashSet<String>() : null;
            int fieldCount = inp.readUnsignedShort();
            int i3 = 0;
            while (true) {
                boolean foundConstantValue;
                int attributesCount;
                String fieldTypeDescriptor;
                boolean isMatchedFieldName;
                String fieldName;
                boolean isStaticFinal;
                if (i3 < fieldCount) {
                    int accessFlags = inp.readUnsignedShort();
                    isStaticFinal = (accessFlags & 0x18) == 24;
                    fieldName = ClassfileBinaryParser.readRefdString(inp, constantPool);
                    isMatchedFieldName = staticFinalFieldsToMatch != null && staticFinalFieldsToMatch.contains(fieldName);
                    fieldTypeDescriptor = ClassfileBinaryParser.readRefdString(inp, constantPool);
                    attributesCount = inp.readUnsignedShort();
                    ClassfileBinaryParser.addFieldTypeDescriptorParts(className, fieldTypeDescriptor, scanSpec, classInfo, classNameToClassInfo, loggedFieldTypeNames);
                    if (!isStaticFinal && isMatchedFieldName) {
                        Log.log(6, "Cannot match requested field " + classInfo.className + "." + fieldName + " because it is either not static or not final");
                    }
                    foundConstantValue = false;
                } else {
                    methodCount = inp.readUnsignedShort();
                    break;
                }
                for (int j = 0; j < attributesCount; ++j) {
                    String attributeName = ClassfileBinaryParser.readRefdString(inp, constantPool);
                    int attributeLength2 = inp.readInt();
                    if (isStaticFinal && isMatchedFieldName && "ConstantValue".equals(attributeName)) {
                        Object constValue = constantPool[inp.readUnsignedShort()];
                        switch (fieldTypeDescriptor) {
                            case "B": {
                                constValue = ((Integer)constValue).byteValue();
                                break;
                            }
                            case "C": {
                                constValue = Character.valueOf((char)((Integer)constValue).intValue());
                                break;
                            }
                            case "S": {
                                constValue = ((Integer)constValue).shortValue();
                                break;
                            }
                            case "Z": {
                                constValue = (Integer)constValue != 0;
                                break;
                            }
                            case "I": 
                            case "J": 
                            case "F": 
                            case "D": 
                            case "Ljava.lang.String;": {
                                break;
                            }
                        }
                        if (FastClasspathScanner.verbose) {
                            Log.log(6, "Class " + className + " has field " + fieldName + " with static constant initializer " + constValue);
                        }
                        classInfo.addFieldConstantValue(fieldName, constValue);
                        foundConstantValue = true;
                    } else if ("Signature".equals(attributeName)) {
                        String fieldTypeSignature = ClassfileBinaryParser.readRefdString(inp, constantPool);
                        ClassfileBinaryParser.addFieldTypeDescriptorParts(className, fieldTypeSignature, scanSpec, classInfo, classNameToClassInfo, loggedFieldTypeNames);
                    } else {
                        inp.skipBytes(attributeLength2);
                    }
                    if (foundConstantValue || !isStaticFinal || !isMatchedFieldName) continue;
                    Log.log(6, "Requested static final field " + classInfo.className + "." + fieldName + " is not initialized with a constant literal value, so there is no initializer value in the constant pool of the classfile");
                }
                ++i3;
            }
            for (int i4 = 0; i4 < methodCount; ++i4) {
                inp.skipBytes(6);
                int attributesCount = inp.readUnsignedShort();
                for (int j = 0; j < attributesCount; ++j) {
                    inp.skipBytes(2);
                    attributeLength = inp.readInt();
                    inp.skipBytes(attributeLength);
                }
            }
            int attributesCount = inp.readUnsignedShort();
            int i5 = 0;
            while (i5 < attributesCount) {
                String attributeName = ClassfileBinaryParser.readRefdString(inp, constantPool);
                attributeLength = inp.readInt();
                if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                    int annotationCount = inp.readUnsignedShort();
                    for (int m = 0; m < annotationCount; ++m) {
                        String annotationName = ClassfileBinaryParser.readAnnotation(inp, constantPool, className);
                        if (!scanSpec.classIsNotBlacklisted(annotationName) || annotationName.startsWith("java.lang.annotation.")) continue;
                        if (FastClasspathScanner.verbose) {
                            Log.log(6, "Class " + className + " has annotation " + annotationName);
                        }
                        classInfo.addAnnotation(annotationName, classNameToClassInfo);
                    }
                } else {
                    inp.skipBytes(attributeLength);
                }
                ++i5;
            }
            return true;
        }
        catch (Exception e) {
            Log.log(6, "Exception while attempting to load classfile " + relativePath + ": " + e);
        }
        return true;
    }
}

