/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecursiveScanner {
    private final ClasspathFinder classpathFinder;
    private final ScanSpec scanSpec;
    private final List<FilePathTesterAndMatchProcessorWrapper> filePathTestersAndMatchProcessorWrappers = new ArrayList<FilePathTesterAndMatchProcessorWrapper>();
    private final Set<String> previouslyScannedCanonicalPaths = new HashSet<String>();
    private final AtomicInteger numDirsScanned = new AtomicInteger();
    private final AtomicInteger numJarfileDirsScanned = new AtomicInteger();
    private final AtomicInteger numFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfileFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfilesScanned = new AtomicInteger();
    private long lastModified = 0L;

    public RecursiveScanner(ClasspathFinder classpathFinder, ScanSpec scanSpec) {
        this.classpathFinder = classpathFinder;
        this.scanSpec = scanSpec;
    }

    public void addFilePathMatcher(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
        this.filePathTestersAndMatchProcessorWrappers.add(new FilePathTesterAndMatchProcessorWrapper(filePathTester, fileMatchProcessorWrapper));
    }

    private boolean previouslyScanned(File classpathElt) {
        try {
            boolean previouslyScanned;
            String canonicalPath = classpathElt.getCanonicalPath();
            boolean bl = previouslyScanned = !this.previouslyScannedCanonicalPaths.add(canonicalPath);
            if (previouslyScanned && FastClasspathScanner.verbose) {
                Log.log(3, "Reached duplicate classpath element, ignoring: " + classpathElt);
            }
            return previouslyScanned;
        }
        catch (IOException | SecurityException e) {
            return true;
        }
    }

    private void scanFile(File classpathElt, String relativePath, File file, boolean scanTimestampsOnly) {
        if (this.previouslyScanned(file)) {
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Reached duplicate file, ignoring: " + file);
            }
            return;
        }
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanning file: " + file);
        }
        this.numFilesScanned.incrementAndGet();
        if (!scanTimestampsOnly) {
            long startTime = System.nanoTime();
            boolean filePathMatches = false;
            for (FilePathTesterAndMatchProcessorWrapper fileMatcher : this.filePathTestersAndMatchProcessorWrappers) {
                block21: {
                    if (!fileMatcher.filePathTester.filePathMatches(classpathElt, relativePath)) continue;
                    if (FastClasspathScanner.verbose) {
                        Log.log(4, "Calling MatchProcessor for file " + file);
                    }
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        fileMatcher.fileMatchProcessorWrapper.processMatch(classpathElt, relativePath, inputStream, file.length());
                    }
                    catch (Exception e) {
                        if (!FastClasspathScanner.verbose) break block21;
                        Log.log(5, "Exception while processing classpath element " + classpathElt + ", file " + relativePath + " : " + e.getMessage());
                    }
                }
                filePathMatches = true;
            }
            if (FastClasspathScanner.verbose && filePathMatches) {
                Log.log(4, "Scanned file " + file, System.nanoTime() - startTime);
            }
        }
    }

    private void scanZipfile(File classpathElt, boolean scanTimestampsOnly) {
        if (this.previouslyScanned(classpathElt)) {
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Reached duplicate jarfile, ignoring: " + classpathElt);
            }
            return;
        }
        if (this.scanSpec.jarIsWhitelisted(classpathElt.getName())) {
            long startTime;
            block43: {
                if (FastClasspathScanner.verbose) {
                    Log.log(3, "Scanning jarfile: " + classpathElt);
                }
                startTime = System.nanoTime();
                try (ZipFile zipfile = new ZipFile(classpathElt);){
                    Enumeration<? extends ZipEntry> entries = zipfile.entries();
                    while (entries.hasMoreElements()) {
                        long entryStartTime = System.nanoTime();
                        ZipEntry entry = entries.nextElement();
                        String relativePath = entry.getName();
                        if (relativePath.startsWith("/")) {
                            relativePath = relativePath.substring(1);
                        }
                        if (entry.isDirectory()) {
                            if (this.scanSpec.pathIsWhitelisted(relativePath)) {
                                this.numJarfileDirsScanned.incrementAndGet();
                                if (!FastClasspathScanner.verbose) continue;
                                this.numJarfileFilesScanned.incrementAndGet();
                                Log.log(4, "Scanned jarfile-internal directory " + relativePath, System.nanoTime() - entryStartTime);
                                continue;
                            }
                            if (!FastClasspathScanner.verbose) continue;
                            Log.log(4, "Skipping non-whitelisted jarfile-internal directory " + relativePath);
                            continue;
                        }
                        if (!this.scanSpec.pathIsWhitelisted(relativePath)) continue;
                        if (!scanTimestampsOnly) {
                            boolean filePathMatches = false;
                            for (FilePathTesterAndMatchProcessorWrapper fileMatcher : this.filePathTestersAndMatchProcessorWrappers) {
                                block42: {
                                    if (!fileMatcher.filePathTester.filePathMatches(classpathElt, relativePath)) continue;
                                    if (FastClasspathScanner.verbose) {
                                        Log.log(4, "Calling MatchProcessor for file " + classpathElt + "!" + relativePath);
                                    }
                                    try (InputStream inputStream = zipfile.getInputStream(entry);){
                                        fileMatcher.fileMatchProcessorWrapper.processMatch(classpathElt, relativePath, inputStream, classpathElt.length());
                                    }
                                    catch (Exception e) {
                                        if (!FastClasspathScanner.verbose) break block42;
                                        Log.log(5, "Exception while processing classpath element " + classpathElt + ", file " + relativePath + " : " + e.getMessage());
                                    }
                                }
                                filePathMatches = true;
                            }
                            if (!FastClasspathScanner.verbose || !filePathMatches) continue;
                            this.numJarfileFilesScanned.incrementAndGet();
                            Log.log(5, "Scanned jarfile-internal file " + relativePath, System.nanoTime() - entryStartTime);
                            continue;
                        }
                        if (!FastClasspathScanner.verbose) continue;
                        Log.log(4, "Skipping non-whitelisted jarfile-internal file " + relativePath);
                    }
                }
                catch (IOException e) {
                    if (!FastClasspathScanner.verbose) break block43;
                    Log.log(3, "Error while opening zipfile " + classpathElt + " : " + e.toString());
                }
            }
            if (FastClasspathScanner.verbose) {
                Log.log(4, "Scanned jarfile " + classpathElt, System.nanoTime() - startTime);
            }
        } else if (FastClasspathScanner.verbose) {
            Log.log(3, "Skipping jarfile that did not match whitelist/blacklist criteria: " + classpathElt.getName());
        }
    }

    private void scanDir(File classpathElt, File dir, int ignorePrefixLen, boolean inWhitelistedPath, boolean scanTimestampsOnly) {
        String relativePath;
        String dirPath = dir.getPath();
        String string = relativePath = ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        if (this.previouslyScanned(dir)) {
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Reached duplicate directory, ignoring: " + dir);
            }
            return;
        }
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanning directory: " + dir);
        }
        this.numDirsScanned.incrementAndGet();
        boolean keepRecursing = false;
        boolean atWhitelistedClassPackage = false;
        switch (this.scanSpec.pathWhitelistMatchStatus(relativePath)) {
            case WITHIN_BLACKLISTED_PATH: {
                if (FastClasspathScanner.verbose) {
                    Log.log(3, "Reached blacklisted path: " + relativePath);
                }
                return;
            }
            case WITHIN_WHITELISTED_PATH: {
                if (FastClasspathScanner.verbose) {
                    Log.log(3, "Reached whitelisted path: " + relativePath);
                }
                inWhitelistedPath = true;
                break;
            }
            case ANCESTOR_OF_WHITELISTED_PATH: {
                keepRecursing = true;
                break;
            }
            case AT_WHITELISTED_CLASS_PACKAGE: {
                atWhitelistedClassPackage = true;
                break;
            }
            case NOT_WITHIN_WHITELISTED_PATH: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown match status");
            }
        }
        if (keepRecursing || inWhitelistedPath || atWhitelistedClassPackage) {
            long startTime = System.nanoTime();
            this.lastModified = Math.max(this.lastModified, dir.lastModified());
            File[] subFiles = dir.listFiles();
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    File subFileCanonical;
                    block22: {
                        subFileCanonical = null;
                        try {
                            subFileCanonical = subFile.getCanonicalFile();
                        }
                        catch (IOException | SecurityException e) {
                            if (!FastClasspathScanner.verbose) break block22;
                            Log.log(4, "Could not access file " + subFile + ": " + e.getMessage());
                        }
                    }
                    if (subFileCanonical == null) continue;
                    if (subFileCanonical.isDirectory()) {
                        if (!inWhitelistedPath && !keepRecursing) continue;
                        this.scanDir(classpathElt, subFileCanonical, ignorePrefixLen, inWhitelistedPath, scanTimestampsOnly);
                        continue;
                    }
                    if (!subFileCanonical.isFile()) continue;
                    String subFileName = subFileCanonical.getName();
                    boolean fileIsWhitelisted = false;
                    if (inWhitelistedPath) {
                        fileIsWhitelisted = true;
                    } else if (atWhitelistedClassPackage && subFileName.endsWith(".class")) {
                        String className = (relativePath + subFileName.substring(0, subFileName.length() - 6)).replace('/', '.');
                        fileIsWhitelisted = this.scanSpec.classIsWhitelisted(className);
                    }
                    if (!fileIsWhitelisted) continue;
                    this.scanFile(classpathElt, "/".equals(relativePath) ? subFileName : relativePath + subFileName, subFileCanonical, scanTimestampsOnly);
                }
            }
            if (FastClasspathScanner.verbose) {
                Log.log(4, "Scanned directory " + dir + " and any subdirectories", System.nanoTime() - startTime);
            }
        }
    }

    private synchronized void scan(boolean scanTimestampsOnly) {
        List<File> uniqueClasspathElts = this.classpathFinder.getUniqueClasspathElements();
        if (FastClasspathScanner.verbose) {
            Log.log(1, "Starting scan" + (scanTimestampsOnly ? " (scanning classpath timestamps only)" : ""));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "false");
        this.previouslyScannedCanonicalPaths.clear();
        this.numDirsScanned.set(0);
        this.numFilesScanned.set(0);
        this.numJarfileDirsScanned.set(0);
        this.numJarfileFilesScanned.set(0);
        this.numJarfilesScanned.set(0);
        for (File classpathElt : uniqueClasspathElts) {
            boolean isJar;
            String path = classpathElt.getPath();
            boolean isDirectory = classpathElt.isDirectory();
            boolean isFile = classpathElt.isFile();
            if (!isDirectory && !isFile) {
                if (!FastClasspathScanner.verbose) continue;
                Log.log(2, "Skipping non-file/non-dir on classpath: " + classpathElt);
                continue;
            }
            boolean bl = isJar = isFile && ClasspathFinder.isJar(path);
            if (FastClasspathScanner.verbose) {
                Log.log(2, "Found " + (isDirectory ? "directory" : (isJar ? "jar" : "file")) + " on classpath: " + path);
            }
            if (isDirectory && this.scanSpec.scanNonJars) {
                this.numDirsScanned.incrementAndGet();
                this.scanDir(classpathElt, classpathElt, path.length() + 1, false, scanTimestampsOnly);
                continue;
            }
            if (isJar && this.scanSpec.scanJars) {
                if (!scanTimestampsOnly) {
                    long startTime = System.nanoTime();
                    this.scanZipfile(classpathElt, scanTimestampsOnly);
                    if (FastClasspathScanner.verbose) {
                        Log.log(2, "Scanned jarfile " + classpathElt, System.nanoTime() - startTime);
                    }
                }
                this.updateLastModifiedTimestamp(classpathElt.lastModified());
                this.numJarfilesScanned.incrementAndGet();
                continue;
            }
            if (!isJar && this.scanSpec.scanNonJars) {
                if (this.previouslyScanned(classpathElt)) {
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(3, "Reached duplicate file, ignoring: " + classpathElt);
                    continue;
                }
                String parentStr = classpathElt.getParent();
                if (parentStr == null) continue;
                this.scanFile(classpathElt, classpathElt.getName(), classpathElt, scanTimestampsOnly);
                this.updateLastModifiedTimestamp(classpathElt.lastModified());
                this.numFilesScanned.incrementAndGet();
                continue;
            }
            if (!FastClasspathScanner.verbose) continue;
            Log.log(2, "Skipping classpath element due to scan spec restriction: " + path);
        }
        if (FastClasspathScanner.verbose) {
            Log.log(1, "Number of resources scanned: directories: " + this.numDirsScanned.get() + "; files: " + this.numFilesScanned.get() + "; jarfiles: " + this.numJarfilesScanned.get() + "; jarfile-internal directories: " + this.numJarfileDirsScanned + "; jarfile-internal files: " + this.numJarfileFilesScanned);
        }
    }

    public void scan() {
        this.scan(false);
    }

    private void updateLastModifiedTimestamp(long fileLastModified) {
        this.lastModified = Math.max(this.lastModified, Math.min(System.currentTimeMillis(), fileLastModified));
    }

    public boolean classpathContentsModifiedSinceScan() {
        long oldLastModified = this.lastModified;
        if (oldLastModified == 0L) {
            return true;
        }
        this.scan(true);
        long newLastModified = this.lastModified;
        return newLastModified > oldLastModified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.lastModified;
    }

    private static class FilePathTesterAndMatchProcessorWrapper {
        FilePathTester filePathTester;
        FileMatchProcessorWrapper fileMatchProcessorWrapper;

        public FilePathTesterAndMatchProcessorWrapper(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessorWrapper = fileMatchProcessorWrapper;
        }
    }

    public static interface FileMatchProcessorWrapper {
        public void processMatch(File var1, String var2, InputStream var3, long var4) throws IOException;
    }

    public static interface FilePathTester {
        public boolean filePathMatches(File var1, String var2);
    }
}

