/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class Log {
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmX").withZone(ZoneOffset.UTC);
    private static DecimalFormat nanoFormatter = new DecimalFormat("0.000000");

    private Log() {
    }

    private static String indent(String msg, int indentLevel) {
        int numIndentChars = 2 * indentLevel;
        StringBuilder buf = new StringBuilder(msg.length() + numIndentChars);
        for (int i = 0; i < numIndentChars - 1; ++i) {
            buf.append('-');
        }
        if (numIndentChars > 0) {
            buf.append(" ");
        }
        buf.append(msg);
        return buf.toString();
    }

    public static void log(int indentLevel, String msg) {
        System.err.println(dateTimeFormatter.format(Instant.now()) + "\t" + FastClasspathScanner.class.getSimpleName() + "\t" + Log.indent(msg, indentLevel));
    }

    public static void log(String msg) {
        Log.log(0, msg);
    }

    public static void log(int indentLevel, String msg, long elapsedTimeNanos) {
        System.err.println(dateTimeFormatter.format(Instant.now()) + "\t" + FastClasspathScanner.class.getSimpleName() + "\t" + Log.indent(msg, indentLevel) + " in " + nanoFormatter.format((double)elapsedTimeNanos * 1.0E-9) + " sec");
    }

    public static void log(String msg, long elapsedTimeNanos) {
        Log.log(0, msg, elapsedTimeNanos);
    }
}

