/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.DAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.InterfaceNode;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassGraphBuilder {
    private final HashMap<String, ClassNode> classNameToClassNode = new HashMap();
    private final HashMap<String, InterfaceNode> interfaceNameToInterfaceNode = new HashMap();
    private final HashMap<String, ArrayList<String>> annotationNameToClassName = new HashMap();
    private final HashMap<String, ArrayList<String>> interfaceNameToClassNames = new HashMap();
    private final HashSet<String> classesEncounteredSoFarDuringScan = new HashSet();
    private final HashMap<String, HashMap<String, StaticFinalFieldMatchProcessor>> classNameToStaticFieldnameToMatchProcessor = new HashMap();

    public void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashMap<String, StaticFinalFieldMatchProcessor> fieldNameToMatchProcessor = this.classNameToStaticFieldnameToMatchProcessor.get(className);
        if (fieldNameToMatchProcessor == null) {
            fieldNameToMatchProcessor = new HashMap();
            this.classNameToStaticFieldnameToMatchProcessor.put(className, fieldNameToMatchProcessor);
        }
        fieldNameToMatchProcessor.put(fieldName, staticFinalFieldMatchProcessor);
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        ArrayList<String> classes = this.annotationNameToClassName.get(annotationName);
        if (classes == null) {
            return Collections.emptyList();
        }
        return classes;
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        ArrayList<String> classes = this.interfaceNameToClassNames.get(interfaceName);
        if (classes == null) {
            return Collections.emptyList();
        }
        return classes;
    }

    public List<String> getNamesOfSubclassesOf(String className) {
        ArrayList<String> subclasses = new ArrayList<String>();
        ClassNode classNode = this.classNameToClassNode.get(className);
        if (classNode != null) {
            for (DAGNode subNode : classNode.allSubNodes) {
                subclasses.add(subNode.name);
            }
        }
        return subclasses;
    }

    public List<String> getNamesOfSuperclassesOf(String className) {
        ArrayList<String> superclasses = new ArrayList<String>();
        ClassNode classNode = this.classNameToClassNode.get(className);
        if (classNode != null) {
            for (DAGNode subNode : classNode.allSuperNodes) {
                superclasses.add(subNode.name);
            }
        }
        return superclasses;
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        ArrayList<String> subinterfaces = new ArrayList<String>();
        InterfaceNode interfaceNode = this.interfaceNameToInterfaceNode.get(interfaceName);
        if (interfaceNode != null) {
            for (DAGNode subNode : interfaceNode.allSubNodes) {
                subinterfaces.add(subNode.name);
            }
        }
        return subinterfaces;
    }

    public List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        ArrayList<String> superinterfaces = new ArrayList<String>();
        InterfaceNode interfaceNode = this.interfaceNameToInterfaceNode.get(interfaceName);
        if (interfaceNode != null) {
            for (DAGNode superNode : interfaceNode.allSuperNodes) {
                superinterfaces.add(superNode.name);
            }
        }
        return superinterfaces;
    }

    public Set<String> getNamesOfAllClasses() {
        return this.classNameToClassNode.keySet();
    }

    private void linkToSuperclassAndInterfaces(String className, String superclassName, ArrayList<String> interfaces, HashSet<String> annotations) {
        ClassNode thisClassNode = this.classNameToClassNode.get(className);
        if (thisClassNode == null) {
            thisClassNode = new ClassNode(className, interfaces, annotations);
            this.classNameToClassNode.put(className, thisClassNode);
        } else {
            thisClassNode.encounter(interfaces, annotations);
        }
        ClassNode superclassNode = this.classNameToClassNode.get(superclassName);
        if (superclassNode == null) {
            superclassNode = new ClassNode(superclassName, thisClassNode);
            this.classNameToClassNode.put(superclassName, superclassNode);
        } else {
            superclassNode.addSubNode(thisClassNode);
        }
    }

    private void linkToSuperinterfaces(String interfaceName, ArrayList<String> superInterfaces) {
        InterfaceNode thisInterfaceInfo = this.interfaceNameToInterfaceNode.get(interfaceName);
        if (thisInterfaceInfo == null) {
            thisInterfaceInfo = new InterfaceNode(interfaceName);
            this.interfaceNameToInterfaceNode.put(interfaceName, thisInterfaceInfo);
        } else {
            thisInterfaceInfo.encounter();
        }
        if (superInterfaces != null) {
            for (String superInterfaceName : superInterfaces) {
                InterfaceNode superInterfaceNode = this.interfaceNameToInterfaceNode.get(superInterfaceName);
                if (superInterfaceNode == null) {
                    superInterfaceNode = new InterfaceNode(superInterfaceName, thisInterfaceInfo);
                    this.interfaceNameToInterfaceNode.put(superInterfaceName, superInterfaceNode);
                    continue;
                }
                superInterfaceNode.addSubNode(thisInterfaceInfo);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void finalizeGraph() {
        int i;
        if (this.classNameToClassNode.isEmpty() && this.interfaceNameToInterfaceNode.isEmpty()) {
            return;
        }
        ArrayList<DAGNode> classNodeTopoOrder = DAGNode.topoSort(this.classNameToClassNode.values());
        int n = classNodeTopoOrder.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DAGNode classNode = classNodeTopoOrder.get(i2);
            HashSet<DAGNode> allSuperNodes = new HashSet<DAGNode>(classNode.allSuperNodes);
            for (DAGNode dAGNode : classNode.allSuperNodes) {
                allSuperNodes.addAll(dAGNode.allSuperNodes);
            }
            classNode.allSuperNodes = allSuperNodes;
        }
        for (int i2 = classNodeTopoOrder.size() - 1; i2 >= 0; --i2) {
            DAGNode classNode = classNodeTopoOrder.get(i2);
            HashSet<DAGNode> allSubNodes = new HashSet<DAGNode>(classNode.allSubNodes);
            for (DAGNode dAGNode : classNode.allSubNodes) {
                allSubNodes.addAll(dAGNode.allSubNodes);
            }
            classNode.allSubNodes = allSubNodes;
        }
        ArrayList<DAGNode> interfaceNodeTopoOrder = DAGNode.topoSort(this.interfaceNameToInterfaceNode.values());
        int n2 = interfaceNodeTopoOrder.size();
        for (i = 0; i < n2; ++i) {
            DAGNode interfaceNode = interfaceNodeTopoOrder.get(i);
            HashSet<DAGNode> hashSet = new HashSet<DAGNode>(interfaceNode.allSuperNodes);
            for (DAGNode dAGNode : interfaceNode.allSuperNodes) {
                hashSet.addAll(dAGNode.allSuperNodes);
            }
            interfaceNode.allSuperNodes = hashSet;
        }
        for (i = interfaceNodeTopoOrder.size() - 1; i >= 0; --i) {
            DAGNode interfaceNode = interfaceNodeTopoOrder.get(i);
            HashSet<DAGNode> allSubNodes = new HashSet<DAGNode>(interfaceNode.allSubNodes);
            for (DAGNode dAGNode : interfaceNode.allSubNodes) {
                allSubNodes.addAll(dAGNode.allSubNodes);
            }
            interfaceNode.allSubNodes = allSubNodes;
        }
        HashMap<String, HashSet<DAGNode>> annotationToClassNodes = new HashMap<String, HashSet<DAGNode>>();
        HashMap interfaceToClassNodes = new HashMap();
        for (DAGNode dAGNode : classNodeTopoOrder) {
            ClassNode classNode = (ClassNode)dAGNode;
            if (classNode.annotationNames != null) {
                for (String string : classNode.annotationNames) {
                    HashSet<DAGNode> classList = (HashSet<DAGNode>)annotationToClassNodes.get(string);
                    if (classList == null) {
                        classList = new HashSet<DAGNode>();
                        annotationToClassNodes.put(string, classList);
                    }
                    classList.add(dAGNode);
                }
            }
            if (classNode.interfaceNames == null) continue;
            HashSet<String> hashSet = new HashSet<String>();
            for (String interfaceName : classNode.interfaceNames) {
                hashSet.add(interfaceName);
                InterfaceNode interfaceNode = this.interfaceNameToInterfaceNode.get(interfaceName);
                if (interfaceNode == null) continue;
                for (DAGNode superinterfaceNode : interfaceNode.allSuperNodes) {
                    hashSet.add(superinterfaceNode.name);
                }
            }
            for (String interfaceName : hashSet) {
                HashSet<DAGNode> classList = (HashSet<DAGNode>)interfaceToClassNodes.get(interfaceName);
                if (classList == null) {
                    classList = new HashSet<DAGNode>();
                    interfaceToClassNodes.put(interfaceName, classList);
                }
                classList.add(dAGNode);
            }
        }
        for (DAGNode dAGNode : interfaceNodeTopoOrder) {
            void var9_58;
            HashSet hashSet = (HashSet)interfaceToClassNodes.get(dAGNode.name);
            if (hashSet == null) continue;
            HashSet<DAGNode> hashSet2 = new HashSet<DAGNode>(hashSet);
            for (DAGNode implementingClass : hashSet) {
                hashSet2.addAll(implementingClass.allSubNodes);
            }
            HashSet hashSet3 = (HashSet)interfaceToClassNodes.get(dAGNode.name);
            if (hashSet3 == null) {
                HashSet hashSet4 = new HashSet();
                interfaceToClassNodes.put(dAGNode.name, hashSet4);
            }
            var9_58.addAll(hashSet2);
        }
        for (Map.Entry entry : annotationToClassNodes.entrySet()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.annotationNameToClassName.put((String)entry.getKey(), arrayList);
            HashSet hashSet = (HashSet)entry.getValue();
            if (hashSet == null) continue;
            for (DAGNode classNode : hashSet) {
                arrayList.add(classNode.name);
            }
        }
        for (Map.Entry entry : interfaceToClassNodes.entrySet()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.interfaceNameToClassNames.put((String)entry.getKey(), arrayList);
            HashSet hashSet = (HashSet)entry.getValue();
            if (hashSet == null) continue;
            for (DAGNode classNode : hashSet) {
                arrayList.add(classNode.name);
            }
        }
    }

    public void reset() {
        this.classNameToClassNode.clear();
        this.interfaceNameToInterfaceNode.clear();
        this.annotationNameToClassName.clear();
        this.interfaceNameToClassNames.clear();
        this.classesEncounteredSoFarDuringScan.clear();
    }

    private String readAnnotation(DataInputStream inp, Object[] constantPool) throws IOException {
        String annotationFieldDescriptor = ClassGraphBuilder.readRefdString(inp, constantPool);
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1).replace('/', '.') : annotationFieldDescriptor;
        int numElementValuePairs = inp.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            inp.skipBytes(2);
            this.readAnnotationElementValue(inp, constantPool);
        }
        return annotationClassName;
    }

    private void readAnnotationElementValue(DataInputStream inp, Object[] constantPool) throws IOException {
        int tag = inp.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                inp.skipBytes(2);
                break;
            }
            case 101: {
                inp.skipBytes(4);
                break;
            }
            case 99: {
                inp.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(inp, constantPool);
                break;
            }
            case 91: {
                int count = inp.readUnsignedShort();
                for (int l = 0; l < count; ++l) {
                    this.readAnnotationElementValue(inp, constantPool);
                }
                break;
            }
        }
    }

    private static String readRefdString(DataInputStream inp, Object[] constantPool) throws IOException {
        return (String)constantPool[inp.readUnsignedShort()];
    }

    public void readClassInfoFromClassfileHeader(InputStream inputStream, boolean verbose) throws IOException {
        int attributesCount;
        int i;
        DataInputStream inp = new DataInputStream(new BufferedInputStream(inputStream, 1024));
        if (inp.readInt() != -889275714) {
            return;
        }
        inp.readUnsignedShort();
        inp.readUnsignedShort();
        int cpCount = inp.readUnsignedShort();
        Object[] constantPool = new Object[cpCount];
        int[] indirectStringRef = new int[cpCount];
        Arrays.fill(indirectStringRef, -1);
        block30: for (i = 1; i < cpCount; ++i) {
            int tag = inp.readUnsignedByte();
            switch (tag) {
                case 1: {
                    constantPool[i] = inp.readUTF();
                    continue block30;
                }
                case 3: {
                    constantPool[i] = inp.readInt();
                    continue block30;
                }
                case 4: {
                    constantPool[i] = Float.valueOf(inp.readFloat());
                    continue block30;
                }
                case 5: {
                    constantPool[i] = inp.readLong();
                    ++i;
                    continue block30;
                }
                case 6: {
                    constantPool[i] = inp.readDouble();
                    ++i;
                    continue block30;
                }
                case 7: 
                case 8: {
                    indirectStringRef[i] = inp.readUnsignedShort();
                    continue block30;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    inp.skipBytes(4);
                    continue block30;
                }
                case 15: {
                    inp.skipBytes(3);
                    continue block30;
                }
                case 16: {
                    inp.skipBytes(2);
                    continue block30;
                }
                case 18: {
                    inp.skipBytes(4);
                    continue block30;
                }
            }
        }
        for (i = 1; i < cpCount; ++i) {
            if (indirectStringRef[i] < 0) continue;
            constantPool[i] = constantPool[indirectStringRef[i]];
        }
        int flags = inp.readUnsignedShort();
        boolean isInterface = (flags & 0x200) != 0;
        String className = ClassGraphBuilder.readRefdString(inp, constantPool).replace('/', '.');
        if (className.equals("java.lang.Object")) {
            return;
        }
        if (!this.classesEncounteredSoFarDuringScan.add(className)) {
            return;
        }
        String superclassName = ClassGraphBuilder.readRefdString(inp, constantPool).replace('/', '.');
        HashMap<String, StaticFinalFieldMatchProcessor> staticFieldnameToMatchProcessor = this.classNameToStaticFieldnameToMatchProcessor.get(className);
        int interfaceCount = inp.readUnsignedShort();
        ArrayList<String> interfaces = interfaceCount > 0 ? new ArrayList<String>() : null;
        for (int i2 = 0; i2 < interfaceCount; ++i2) {
            interfaces.add(ClassGraphBuilder.readRefdString(inp, constantPool).replace('/', '.'));
        }
        int fieldCount = inp.readUnsignedShort();
        for (int i3 = 0; i3 < fieldCount; ++i3) {
            int accessFlags = inp.readUnsignedShort();
            boolean isStaticFinal = (accessFlags & 0x18) == 24;
            String fieldName = ClassGraphBuilder.readRefdString(inp, constantPool);
            StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor = staticFieldnameToMatchProcessor != null ? staticFieldnameToMatchProcessor.get(fieldName) : null;
            String descriptor = ClassGraphBuilder.readRefdString(inp, constantPool);
            int attributesCount2 = inp.readUnsignedShort();
            if (!isStaticFinal && staticFinalFieldMatchProcessor != null) {
                System.err.println(StaticFinalFieldMatchProcessor.class.getSimpleName() + ": cannot match requested field " + className + "." + fieldName + " because it is either not static or not final");
                continue;
            }
            if (!isStaticFinal || staticFinalFieldMatchProcessor == null) {
                for (int j = 0; j < attributesCount2; ++j) {
                    inp.skipBytes(2);
                    int attributeLength = inp.readInt();
                    inp.skipBytes(attributeLength);
                }
                continue;
            }
            boolean foundConstantValue = false;
            for (int j = 0; j < attributesCount2; ++j) {
                String attributeName = ClassGraphBuilder.readRefdString(inp, constantPool);
                int attributeLength = inp.readInt();
                if (attributeName.equals("ConstantValue")) {
                    Object constValue = constantPool[inp.readUnsignedShort()];
                    switch (descriptor) {
                        case "B": {
                            constValue = ((Integer)constValue).byteValue();
                            break;
                        }
                        case "C": {
                            constValue = Character.valueOf((char)((Integer)constValue).intValue());
                            break;
                        }
                        case "S": {
                            constValue = ((Integer)constValue).shortValue();
                            break;
                        }
                        case "Z": {
                            constValue = (Integer)constValue != 0;
                            break;
                        }
                        case "I": 
                        case "J": 
                        case "F": 
                        case "D": 
                        case "Ljava.lang.String;": {
                            break;
                        }
                    }
                    if (verbose) {
                        Log.log("Found static final field " + className + "." + fieldName + " = " + constValue);
                    }
                    staticFinalFieldMatchProcessor.processMatch(className, fieldName, constValue);
                    foundConstantValue = true;
                } else {
                    inp.skipBytes(attributeLength);
                }
                if (foundConstantValue) continue;
                System.err.println(StaticFinalFieldMatchProcessor.class.getSimpleName() + ": Requested static final field " + className + "." + fieldName + "is not initialized with a constant literal value, so there is no " + "initializer value in the constant pool of the classfile");
            }
        }
        int methodCount = inp.readUnsignedShort();
        for (int i4 = 0; i4 < methodCount; ++i4) {
            inp.skipBytes(6);
            attributesCount = inp.readUnsignedShort();
            for (int j = 0; j < attributesCount; ++j) {
                inp.skipBytes(2);
                int attributeLength = inp.readInt();
                inp.skipBytes(attributeLength);
            }
        }
        HashSet<String> annotations = null;
        attributesCount = inp.readUnsignedShort();
        for (int i5 = 0; i5 < attributesCount; ++i5) {
            String attributeName = ClassGraphBuilder.readRefdString(inp, constantPool);
            int attributeLength = inp.readInt();
            if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                int annotationCount = inp.readUnsignedShort();
                for (int m = 0; m < annotationCount; ++m) {
                    String annotationName = this.readAnnotation(inp, constantPool);
                    if (annotations == null) {
                        annotations = new HashSet<String>();
                    }
                    annotations.add(annotationName);
                }
                continue;
            }
            inp.skipBytes(attributeLength);
        }
        if (isInterface) {
            this.linkToSuperinterfaces(className, interfaces);
        } else {
            this.linkToSuperclassAndInterfaces(className, superclassName, interfaces, annotations);
        }
    }
}

