/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.InterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FastClasspathScanner {
    private final ArrayList<File> classpathElements = new ArrayList();
    private final HashSet<String> classpathElementsSet = new HashSet();
    private final String[] whitelistedPaths;
    private final String[] blacklistedPaths;
    private long lastModified = 0L;
    private static final boolean USE_ZIPFILE_ENTRY_MODIFICATION_TIMES = false;
    private final ArrayList<ClassMatcher> classMatchers = new ArrayList();
    private final ArrayList<FilePathMatcher> filePathMatchers = new ArrayList();
    private final ClassGraphBuilder classGraphBuilder = new ClassGraphBuilder();
    private boolean verbose = false;

    public FastClasspathScanner(String ... packagesToScan) {
        this.parseSystemClasspath();
        HashSet uniqueWhitelistedPaths = new HashSet();
        HashSet<String> uniqueBlacklistedPaths = new HashSet<String>();
        boolean scanAll = false;
        if (packagesToScan.length == 0) {
            scanAll = true;
        } else {
            for (String packageToScan : packagesToScan) {
                if (packageToScan.isEmpty()) {
                    scanAll = true;
                    break;
                }
                String pkg = packageToScan.replace('.', '/') + "/";
                boolean blacklisted = pkg.startsWith("-");
                if (blacklisted) {
                    pkg = pkg.substring(1);
                }
                (blacklisted ? uniqueBlacklistedPaths : uniqueWhitelistedPaths).add(pkg);
            }
        }
        uniqueWhitelistedPaths.removeAll(uniqueBlacklistedPaths);
        if (scanAll) {
            this.whitelistedPaths = new String[]{"/"};
        } else {
            this.whitelistedPaths = new String[uniqueWhitelistedPaths.size()];
            int i = 0;
            for (String path : uniqueWhitelistedPaths) {
                this.whitelistedPaths[i++] = path;
            }
        }
        this.blacklistedPaths = new String[uniqueBlacklistedPaths.size()];
        int i = 0;
        for (String path : uniqueBlacklistedPaths) {
            this.blacklistedPaths[i++] = path;
        }
        this.matchFilenameExtension("class", new FileMatchProcessor(){

            @Override
            public void processMatch(String relativePath, InputStream inputStream, int lengthBytes) throws IOException {
                FastClasspathScanner.this.classGraphBuilder.readClassInfoFromClassfileHeader(inputStream, FastClasspathScanner.this.verbose);
            }
        });
    }

    public <T> Class<? extends T> loadClass(String className) {
        try {
            Class<?> klass = Class.forName(className);
            return klass;
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError e) {
            throw new RuntimeException("Exception while loading or initializing class " + className, e);
        }
    }

    private static String annotationName(Class<?> annotation) {
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException("Class " + annotation.getName() + " is not an annotation");
        }
        return annotation.getName();
    }

    private static String[] annotationNames(Class<?>[] annotations) {
        String[] annotationNames = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotationNames[i] = FastClasspathScanner.annotationName(annotations[i]);
        }
        return annotationNames;
    }

    private static String interfaceName(Class<?> iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException("Class " + iface.getName() + " is not an interface");
        }
        return iface.getName();
    }

    private static String[] interfaceNames(Class<?>[] interfaces) {
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = FastClasspathScanner.interfaceName(interfaces[i]);
        }
        return interfaceNames;
    }

    private static String className(Class<?> klass) {
        if (klass.isAnnotation()) {
            throw new IllegalArgumentException(klass.getName() + " is an annotation, not a regular class");
        }
        if (klass.isInterface()) {
            throw new IllegalArgumentException(klass.getName() + " is an interface, not a regular class");
        }
        return klass.getName();
    }

    public <T> FastClasspathScanner matchSubclassesOf(final Class<T> superclass, final SubclassMatchProcessor<T> subclassMatchProcessor) {
        final String superclassName = FastClasspathScanner.className(superclass);
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String subclassName : FastClasspathScanner.this.classGraphBuilder.getNamesOfSubclassesOf(superclass.getName())) {
                    if (FastClasspathScanner.this.verbose) {
                        Log.log("Found subclass of " + superclassName + ": " + subclassName);
                    }
                    Class klass = FastClasspathScanner.this.loadClass(subclassName);
                    subclassMatchProcessor.processMatch(klass);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfSubclassesOf(Class<?> superclass) {
        return this.getNamesOfSubclassesOf(FastClasspathScanner.className(superclass));
    }

    public List<String> getNamesOfSubclassesOf(String superclassName) {
        return this.classGraphBuilder.getNamesOfSubclassesOf(superclassName);
    }

    public List<String> getNamesOfSuperclassesOf(Class<?> subclass) {
        return this.getNamesOfSuperclassesOf(FastClasspathScanner.className(subclass));
    }

    public List<String> getNamesOfSuperclassesOf(String subclassName) {
        return this.classGraphBuilder.getNamesOfSuperclassesOf(subclassName);
    }

    public <T> FastClasspathScanner matchSubinterfacesOf(final Class<T> superinterface, final SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        final String superinterfaceName = FastClasspathScanner.interfaceName(superinterface);
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String subinterfaceName : FastClasspathScanner.this.classGraphBuilder.getNamesOfSubinterfacesOf(superinterface.getName())) {
                    if (FastClasspathScanner.this.verbose) {
                        Log.log("Found subinterface of " + superinterfaceName + ": " + subinterfaceName);
                    }
                    Class klass = FastClasspathScanner.this.loadClass(subinterfaceName);
                    subinterfaceMatchProcessor.processMatch(klass);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfSubinterfacesOf(Class<?> superInterface) {
        return this.getNamesOfSubinterfacesOf(FastClasspathScanner.interfaceName(superInterface));
    }

    public List<String> getNamesOfSubinterfacesOf(String superInterfaceName) {
        return this.classGraphBuilder.getNamesOfSubinterfacesOf(superInterfaceName);
    }

    public List<String> getNamesOfSuperinterfacesOf(Class<?> subInterface) {
        return this.getNamesOfSuperinterfacesOf(FastClasspathScanner.interfaceName(subInterface));
    }

    public List<String> getNamesOfSuperinterfacesOf(String subInterfaceName) {
        return this.classGraphBuilder.getNamesOfSuperinterfacesOf(subInterfaceName);
    }

    public <T> FastClasspathScanner matchClassesImplementing(final Class<T> implementedInterface, final InterfaceMatchProcessor<T> interfaceMatchProcessor) {
        final String implementedInterfaceName = FastClasspathScanner.interfaceName(implementedInterface);
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String implClass : FastClasspathScanner.this.classGraphBuilder.getNamesOfClassesImplementing(implementedInterface.getName())) {
                    if (FastClasspathScanner.this.verbose) {
                        Log.log("Found class implementing interface " + implementedInterfaceName + ": " + implClass);
                    }
                    Class klass = FastClasspathScanner.this.loadClass(implClass);
                    interfaceMatchProcessor.processMatch(klass);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfClassesImplementing(Class<?> implementedInterface) {
        return this.getNamesOfClassesImplementing(FastClasspathScanner.interfaceName(implementedInterface));
    }

    public List<String> getNamesOfClassesImplementing(String implementedInterfaceName) {
        return this.classGraphBuilder.getNamesOfClassesImplementing(implementedInterfaceName);
    }

    public List<String> getNamesOfClassesImplementingAllOf(Class<?> ... implementedInterfaces) {
        return this.getNamesOfClassesImplementingAllOf(FastClasspathScanner.interfaceNames(implementedInterfaces));
    }

    public List<String> getNamesOfClassesImplementingAllOf(String ... implementedInterfaceNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < implementedInterfaceNames.length; ++i) {
            String implementedInterfaceName = implementedInterfaceNames[i];
            List<String> namesOfImplementingClasses = this.getNamesOfClassesImplementing(implementedInterfaceName);
            if (i == 0) {
                classNames.addAll(namesOfImplementingClasses);
                continue;
            }
            classNames.retainAll(namesOfImplementingClasses);
        }
        return new ArrayList<String>(classNames);
    }

    public FastClasspathScanner matchClassesWithAnnotation(final Class<?> annotation, final ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        final String annotationName = FastClasspathScanner.annotationName(annotation);
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String classWithAnnotation : FastClasspathScanner.this.classGraphBuilder.getNamesOfClassesWithAnnotation(annotation.getName())) {
                    if (FastClasspathScanner.this.verbose) {
                        Log.log("Found class with annotation " + annotationName + ": " + classWithAnnotation);
                    }
                    Class klass = FastClasspathScanner.this.loadClass(classWithAnnotation);
                    classAnnotationMatchProcessor.processMatch(klass);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfClassesWithAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithAnnotation(FastClasspathScanner.annotationName(annotation));
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        return this.classGraphBuilder.getNamesOfClassesWithAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAllOf(FastClasspathScanner.annotationNames(annotations));
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < annotationNames.length; ++i) {
            String annotationName = annotationNames[i];
            List<String> namesOfClassesWithMetaAnnotation = this.getNamesOfClassesWithAnnotation(annotationName);
            if (i == 0) {
                classNames.addAll(namesOfClassesWithMetaAnnotation);
                continue;
            }
            classNames.retainAll(namesOfClassesWithMetaAnnotation);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAnyOf(FastClasspathScanner.annotationNames(annotations));
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (String annotationName : annotationNames) {
            classNames.addAll(this.getNamesOfClassesWithAnnotation(annotationName));
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithMetaAnnotation(Class<?> metaAnnotation) {
        return this.getNamesOfClassesWithMetaAnnotation(FastClasspathScanner.annotationName(metaAnnotation));
    }

    public List<String> getNamesOfClassesWithMetaAnnotation(String metaAnnotationName) {
        return this.classGraphBuilder.getNamesOfClassesWithMetaAnnotation(metaAnnotationName);
    }

    public List<String> getNamesOfClassesWithMetaAnnotationsAllOf(Class<?> ... metaAnnotations) {
        return this.getNamesOfClassesWithMetaAnnotationsAllOf(FastClasspathScanner.annotationNames(metaAnnotations));
    }

    public List<String> getNamesOfClassesWithMetaAnnotationsAllOf(String ... metaAnnotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < metaAnnotationNames.length; ++i) {
            String metaAnnotationName = metaAnnotationNames[i];
            List<String> namesOfClassesWithMetaAnnotation = this.getNamesOfClassesWithMetaAnnotation(metaAnnotationName);
            if (i == 0) {
                classNames.addAll(namesOfClassesWithMetaAnnotation);
                continue;
            }
            classNames.retainAll(namesOfClassesWithMetaAnnotation);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithMetaAnnotationsAnyOf(Class<?> ... metaAnnotations) {
        return this.getNamesOfClassesWithMetaAnnotationsAnyOf(FastClasspathScanner.annotationNames(metaAnnotations));
    }

    public List<String> getNamesOfClassesWithMetaAnnotationsAnyOf(String ... metaAnnotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (String metaAnnotationName : metaAnnotationNames) {
            classNames.addAll(this.getNamesOfClassesWithMetaAnnotation(metaAnnotationName));
        }
        return new ArrayList<String>(classNames);
    }

    public FastClasspathScanner matchStaticFinalFieldNames(HashSet<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            int lastDotIdx = fullyQualifiedFieldName.lastIndexOf(46);
            if (lastDotIdx <= 0) continue;
            String className = fullyQualifiedFieldName.substring(0, lastDotIdx);
            String fieldName = fullyQualifiedFieldName.substring(lastDotIdx + 1);
            this.classGraphBuilder.addStaticFinalFieldProcessor(className, fieldName, staticFinalFieldMatchProcessor);
        }
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedStaticFinalFieldName);
        return this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedFieldName);
        }
        return this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    private static FileMatchProcessor wrapFileMatchContentsProcessor(final FileMatchContentsProcessor fileMatchContentsProcessor) {
        return new FileMatchProcessor(){

            @Override
            public void processMatch(String relativePath, InputStream inputStream, int lengthBytes) throws IOException {
                byte[] contents = new byte[lengthBytes];
                int bytesRead = Math.max(0, inputStream.read(contents));
                byte[] contentsRead = bytesRead == lengthBytes ? contents : Arrays.copyOf(contents, bytesRead);
                fileMatchContentsProcessor.processMatch(relativePath, contentsRead);
            }
        };
    }

    public FastClasspathScanner matchFilenamePattern(final String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.filePathMatchers.add(new FilePathMatcher(new FilePathTester(){
            private Pattern pattern;
            {
                this.pattern = Pattern.compile(pathRegexp);
            }

            @Override
            public boolean filePathMatches(String relativePath) {
                return this.pattern.matcher(relativePath).matches();
            }
        }, fileMatchProcessor));
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenamePattern(pathRegexp, FastClasspathScanner.wrapFileMatchContentsProcessor(fileMatchContentsProcessor));
    }

    public FastClasspathScanner matchFilenamePath(final String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.filePathMatchers.add(new FilePathMatcher(new FilePathTester(){

            @Override
            public boolean filePathMatches(String relativePath) {
                return relativePath.equals(relativePathToMatch);
            }
        }, fileMatchProcessor));
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenamePath(relativePathToMatch, FastClasspathScanner.wrapFileMatchContentsProcessor(fileMatchContentsProcessor));
    }

    public FastClasspathScanner matchFilenamePathLeaf(final String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.filePathMatchers.add(new FilePathMatcher(new FilePathTester(){
            private String leafToMatch;
            {
                this.leafToMatch = pathLeafToMatch.substring(pathLeafToMatch.lastIndexOf(47) + 1);
            }

            @Override
            public boolean filePathMatches(String relativePath) {
                String relativePathLeaf = relativePath.substring(relativePath.lastIndexOf(47) + 1);
                return relativePathLeaf.equals(this.leafToMatch);
            }
        }, fileMatchProcessor));
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenamePathLeaf(pathLeafToMatch, FastClasspathScanner.wrapFileMatchContentsProcessor(fileMatchContentsProcessor));
    }

    public FastClasspathScanner matchFilenameExtension(final String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.filePathMatchers.add(new FilePathMatcher(new FilePathTester(){
            private String suffixToMatch;
            {
                this.suffixToMatch = "." + extensionToMatch;
            }

            @Override
            public boolean filePathMatches(String relativePath) {
                return relativePath.endsWith(this.suffixToMatch);
            }
        }, fileMatchProcessor));
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenameExtension(extensionToMatch, FastClasspathScanner.wrapFileMatchContentsProcessor(fileMatchContentsProcessor));
    }

    public Set<String> getNamesOfAllClasses() {
        return this.classGraphBuilder.getNamesOfAllClasses();
    }

    private void scanFile(File file, String absolutePath, String relativePath, boolean scanTimestampsOnly) {
        this.lastModified = Math.max(this.lastModified, file.lastModified());
        if (!scanTimestampsOnly) {
            boolean filePathMatches = false;
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                block17: {
                    if (!fileMatcher.filePathMatches(relativePath)) continue;
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        fileMatcher.processMatch(relativePath, inputStream, (int)file.length());
                    }
                    catch (IOException e) {
                        if (!this.verbose) break block17;
                        Log.log(e.getMessage() + " while processing file " + file.getPath());
                    }
                }
                filePathMatches = true;
            }
            if (this.verbose && filePathMatches) {
                Log.log("Found file:    " + relativePath);
            }
        }
    }

    private void scanDir(File dir, int ignorePrefixLen, boolean inWhitelistedPath, boolean scanTimestampsOnly) {
        String relativePath = (ignorePrefixLen > dir.getPath().length() ? "" : dir.getPath().substring(ignorePrefixLen)) + "/";
        if (File.separatorChar != '/') {
            relativePath = relativePath.replace(File.separatorChar, '/');
        }
        if (this.verbose) {
            Log.log("Scanning path: " + relativePath);
        }
        for (String blacklistedPath : this.blacklistedPaths) {
            if (!relativePath.equals(blacklistedPath)) continue;
            if (this.verbose) {
                Log.log("Reached blacklisted path: " + relativePath);
            }
            return;
        }
        boolean keepRecursing = false;
        if (!inWhitelistedPath) {
            for (String whitelistedPath : this.whitelistedPaths) {
                if (relativePath.equals(whitelistedPath)) {
                    if (this.verbose) {
                        Log.log("Reached whitelisted path: " + relativePath);
                    }
                    inWhitelistedPath = true;
                    break;
                }
                if (!whitelistedPath.startsWith(relativePath) && !relativePath.equals("/")) continue;
                keepRecursing = true;
            }
        }
        if (keepRecursing || inWhitelistedPath) {
            this.lastModified = Math.max(this.lastModified, dir.lastModified());
            File[] subFiles = dir.listFiles();
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    if (subFile.isDirectory()) {
                        this.scanDir(subFile, ignorePrefixLen, inWhitelistedPath, scanTimestampsOnly);
                        continue;
                    }
                    if (!inWhitelistedPath || !subFile.isFile()) continue;
                    this.scanFile(subFile, dir.getPath() + "/" + subFile.getName(), relativePath.equals("/") ? subFile.getName() : relativePath + subFile.getName(), scanTimestampsOnly);
                }
            }
        }
    }

    private void scanZipfile(String zipfilePath, ZipFile zipFile, long zipFileLastModified, boolean scanTimestampsOnly) {
        if (this.verbose) {
            Log.log("Scanning jar:  " + zipfilePath);
        }
        boolean timestampWarning = false;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String path = entry.getName();
            boolean scanFile = false;
            for (String whitelistedPath : this.whitelistedPaths) {
                if (!path.startsWith(whitelistedPath) && !whitelistedPath.equals("/")) continue;
                scanFile = true;
                break;
            }
            for (String blacklistedPath : this.blacklistedPaths) {
                if (!path.startsWith(blacklistedPath)) continue;
                scanFile = false;
                break;
            }
            if (!scanFile) continue;
            long entryTime = zipFileLastModified;
            this.lastModified = Math.max(this.lastModified, entryTime);
            if (entryTime > System.currentTimeMillis() && !timestampWarning) {
                String msg = zipfilePath + " contains modification timestamps after the current time";
                System.err.println(msg);
                timestampWarning = true;
            }
            if (scanTimestampsOnly) continue;
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                if (!fileMatcher.filePathMatches(path)) continue;
                try {
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        fileMatcher.processMatch(path, inputStream, (int)entry.getSize());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    if (!this.verbose) continue;
                    Log.log(e.getMessage() + " while processing file " + entry.getName());
                }
            }
        }
    }

    private void clearClasspath() {
        this.classpathElements.clear();
        this.classpathElementsSet.clear();
    }

    private static boolean isJar(String path) {
        String pathLower = path.toLowerCase();
        return pathLower.endsWith(".jar") || pathLower.endsWith(".zip") || pathLower.endsWith(".war");
    }

    private void addClasspathElement(String pathElement) {
        if (!pathElement.isEmpty()) {
            File pathElementFile = new File(pathElement);
            if (pathElementFile.exists()) {
                String canonicalPath;
                try {
                    canonicalPath = pathElementFile.getCanonicalPath();
                }
                catch (IOException | SecurityException e) {
                    canonicalPath = pathElement;
                }
                if (this.classpathElementsSet.add(canonicalPath)) {
                    if (this.verbose) {
                        Log.log("Found classpath element: " + pathElement);
                    }
                    this.classpathElements.add(pathElementFile);
                    if (pathElementFile.isFile() && FastClasspathScanner.isJar(pathElement)) {
                        String manifestUrlStr = "jar:file:" + pathElement + "!/META-INF/MANIFEST.MF";
                        try (InputStream stream = new URL(manifestUrlStr).openStream();){
                            Manifest manifest = new Manifest(stream);
                            String manifestClassPath = manifest.getMainAttributes().getValue("Class-Path");
                            if (manifestClassPath != null && !manifestClassPath.isEmpty()) {
                                if (this.verbose) {
                                    Log.log("Found Class-Path entry in " + manifestUrlStr + ": " + manifestClassPath);
                                }
                                for (String manifestClassPathElement : manifestClassPath.split(" ")) {
                                    String manifestClassPathElementAbsolute = new File(pathElementFile.getParent(), manifestClassPathElement).getPath();
                                    this.addClasspathElement(manifestClassPathElementAbsolute);
                                }
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else if (this.verbose) {
                Log.log("Classpath element does not exist: " + pathElement);
            }
        }
    }

    private void parseSystemClasspath() {
        String sysClassPath = System.getProperty("java.class.path");
        if (sysClassPath == null || sysClassPath.isEmpty()) {
            sysClassPath = ".";
        }
        this.overrideClasspath(sysClassPath);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        HashSet<ClassLoader> classLoadersSet = new HashSet<ClassLoader>();
        classLoadersSet.add(ClassLoader.getSystemClassLoader());
        classLoaders.add(ClassLoader.getSystemClassLoader());
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement caller;
            ClassLoader cl;
            StackTraceElement[] stacktrace = e.getStackTrace();
            if (stacktrace.length >= 3 && classLoadersSet.add(cl = (caller = stacktrace[2]).getClass().getClassLoader())) {
                classLoaders.add(cl);
            }
            if (classLoadersSet.add(Thread.currentThread().getContextClassLoader())) {
                classLoaders.add(Thread.currentThread().getContextClassLoader());
            }
            for (ClassLoader cl2 : classLoaders) {
                if (cl2 == null) continue;
                for (URL url : ((URLClassLoader)cl2).getURLs()) {
                    String protocol = url.getProtocol();
                    if (protocol != null && !protocol.equalsIgnoreCase("file")) continue;
                    this.addClasspathElement(url.getFile());
                }
            }
            return;
        }
    }

    public FastClasspathScanner overrideClasspath(String classpath) {
        this.clearClasspath();
        for (String pathElement : classpath.split(File.pathSeparator)) {
            this.addClasspathElement(pathElement);
        }
        return this;
    }

    public ArrayList<File> getUniqueClasspathElements() {
        return this.classpathElements;
    }

    private FastClasspathScanner scan(boolean scanTimestampsOnly) {
        if (this.verbose) {
            Log.log("*** Starting scan" + (scanTimestampsOnly ? " (scanning classpath timestamps only)" : "") + " ***");
            Log.log("Classpath elements: " + this.getUniqueClasspathElements());
            Log.log("Whitelisted paths:  " + Arrays.toString(this.whitelistedPaths));
            Log.log("Blacklisted paths:  " + Arrays.toString(this.blacklistedPaths));
        }
        long scanStart = System.currentTimeMillis();
        if (!scanTimestampsOnly) {
            this.classGraphBuilder.reset();
        }
        for (File pathElt : this.getUniqueClasspathElements()) {
            String path = pathElt.getPath();
            if (this.verbose) {
                Log.log("=> Scanning classpath element: " + path);
            }
            if (pathElt.isDirectory()) {
                this.scanDir(pathElt, path.length() + 1, false, scanTimestampsOnly);
                continue;
            }
            if (pathElt.isFile()) {
                if (FastClasspathScanner.isJar(path)) {
                    ZipFile zipfile;
                    block12: {
                        zipfile = null;
                        try {
                            zipfile = new ZipFile(pathElt);
                        }
                        catch (IOException e) {
                            if (!this.verbose) break block12;
                            Log.log(e.getMessage() + " while opening zipfile " + pathElt);
                        }
                    }
                    if (zipfile == null) continue;
                    this.scanZipfile(path, zipfile, pathElt.lastModified(), scanTimestampsOnly);
                    continue;
                }
                this.scanFile(pathElt, path, pathElt.getName(), scanTimestampsOnly);
                continue;
            }
            if (!this.verbose) continue;
            Log.log("Skipping non-file/non-dir on classpath: " + pathElt.getPath());
        }
        if (!scanTimestampsOnly) {
            this.classGraphBuilder.finalizeGraph();
            for (ClassMatcher classMatcher : this.classMatchers) {
                classMatcher.lookForMatches();
            }
        }
        if (this.verbose) {
            Log.log("*** Scanning took: " + (System.currentTimeMillis() - scanStart) + " ms ***");
        }
        return this;
    }

    public FastClasspathScanner scan() {
        return this.scan(false);
    }

    public boolean classpathContentsModifiedSinceScan() {
        long oldLastModified = this.lastModified;
        if (oldLastModified == 0L) {
            return true;
        }
        this.scan(true);
        long newLastModified = this.lastModified;
        return newLastModified > oldLastModified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.lastModified;
    }

    public FastClasspathScanner verbose() {
        this.verbose = true;
        return this;
    }

    private static interface ClassMatcher {
        public void lookForMatches();
    }

    private static class FilePathMatcher {
        private FilePathTester filePathTester;
        private FileMatchProcessor fileMatchProcessor;

        public FilePathMatcher(FilePathTester filePathTester, FileMatchProcessor fileMatchProcessor) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessor = fileMatchProcessor;
        }

        public boolean filePathMatches(String relativePath) {
            return this.filePathTester.filePathMatches(relativePath);
        }

        public void processMatch(String relativePath, InputStream inputStream, int inputStreamLengthBytes) throws IOException {
            this.fileMatchProcessor.processMatch(relativePath, inputStream, inputStreamLengthBytes);
        }
    }

    private static interface FilePathTester {
        public boolean filePathMatches(String var1);
    }
}

