/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class DAGNode {
    String name;
    ArrayList<DAGNode> directSuperNodes = new ArrayList();
    ArrayList<DAGNode> directSubNodes = new ArrayList();
    HashSet<DAGNode> allSuperNodes = new HashSet();
    HashSet<DAGNode> allSubNodes = new HashSet();

    public DAGNode(String name) {
        this.name = name;
    }

    public void encounter() {
    }

    public DAGNode(String name, DAGNode subNode) {
        this.name = name;
        this.addSubNode(subNode);
    }

    public void addSubNode(DAGNode subNode) {
        subNode.directSuperNodes.add(this);
        subNode.allSuperNodes.add(this);
        this.directSubNodes.add(subNode);
        this.allSubNodes.add(subNode);
    }

    protected void topoSortRec(HashSet<DAGNode> visited, ArrayList<DAGNode> topoOrder) {
        if (visited.add(this)) {
            for (DAGNode subNode : this.directSubNodes) {
                subNode.topoSortRec(visited, topoOrder);
            }
            topoOrder.add(this);
        }
    }

    public static ArrayList<DAGNode> topoSort(Collection<? extends DAGNode> nodes) {
        ArrayList<DAGNode> topoOrder = new ArrayList<DAGNode>(nodes.size());
        HashSet<DAGNode> visited = new HashSet<DAGNode>();
        for (DAGNode dAGNode : nodes) {
            if (!dAGNode.directSuperNodes.isEmpty()) continue;
            dAGNode.topoSortRec(visited, topoOrder);
        }
        int n = topoOrder.size();
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            DAGNode tmp = topoOrder.get(i);
            topoOrder.set(i, topoOrder.get(n - 1 - i));
            topoOrder.set(n - 1 - i, tmp);
        }
        return topoOrder;
    }

    public String toString() {
        return this.name;
    }
}

