/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

class ClassfileBinaryParser {
    ClassGraphBuilder classGraphBuilder;
    private final HashSet<String> classesEncounteredSoFarDuringScan = new HashSet();
    private final HashMap<String, HashMap<String, StaticFinalFieldMatchProcessor>> classNameToStaticFieldnameToMatchProcessor = new HashMap();

    public void reset() {
        this.classesEncounteredSoFarDuringScan.clear();
    }

    public void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashMap<String, StaticFinalFieldMatchProcessor> fieldNameToMatchProcessor = this.classNameToStaticFieldnameToMatchProcessor.get(className);
        if (fieldNameToMatchProcessor == null) {
            fieldNameToMatchProcessor = new HashMap(2);
            this.classNameToStaticFieldnameToMatchProcessor.put(className, fieldNameToMatchProcessor);
        }
        fieldNameToMatchProcessor.put(fieldName, staticFinalFieldMatchProcessor);
    }

    public ClassfileBinaryParser(ClassGraphBuilder classGraphBuilder) {
        this.classGraphBuilder = classGraphBuilder;
    }

    private String readAnnotation(DataInputStream inp, Object[] constantPool) throws IOException {
        String annotationFieldDescriptor = ClassfileBinaryParser.readRefdString(inp, constantPool);
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1).replace('/', '.') : annotationFieldDescriptor;
        int numElementValuePairs = inp.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            inp.skipBytes(2);
            this.readAnnotationElementValue(inp, constantPool);
        }
        return annotationClassName;
    }

    private void readAnnotationElementValue(DataInputStream inp, Object[] constantPool) throws IOException {
        int tag = inp.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                inp.skipBytes(2);
                break;
            }
            case 101: {
                inp.skipBytes(4);
                break;
            }
            case 99: {
                inp.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(inp, constantPool);
                break;
            }
            case 91: {
                int count = inp.readUnsignedShort();
                for (int l = 0; l < count; ++l) {
                    this.readAnnotationElementValue(inp, constantPool);
                }
                break;
            }
        }
    }

    private static String readRefdString(DataInputStream inp, Object[] constantPool) throws IOException {
        return (String)constantPool[inp.readUnsignedShort()];
    }

    public void readClassInfoFromClassfileHeader(InputStream inputStream, boolean verbose) throws IOException {
        int i;
        DataInputStream inp = new DataInputStream(new BufferedInputStream(inputStream, 1024));
        if (inp.readInt() != -889275714) {
            return;
        }
        inp.readUnsignedShort();
        inp.readUnsignedShort();
        int cpCount = inp.readUnsignedShort();
        Object[] constantPool = new Object[cpCount];
        int[] indirectStringRef = new int[cpCount];
        Arrays.fill(indirectStringRef, -1);
        block30: for (i = 1; i < cpCount; ++i) {
            int tag = inp.readUnsignedByte();
            switch (tag) {
                case 1: {
                    constantPool[i] = inp.readUTF();
                    continue block30;
                }
                case 3: {
                    constantPool[i] = inp.readInt();
                    continue block30;
                }
                case 4: {
                    constantPool[i] = Float.valueOf(inp.readFloat());
                    continue block30;
                }
                case 5: {
                    constantPool[i] = inp.readLong();
                    ++i;
                    continue block30;
                }
                case 6: {
                    constantPool[i] = inp.readDouble();
                    ++i;
                    continue block30;
                }
                case 7: 
                case 8: {
                    indirectStringRef[i] = inp.readUnsignedShort();
                    continue block30;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    inp.skipBytes(4);
                    continue block30;
                }
                case 15: {
                    inp.skipBytes(3);
                    continue block30;
                }
                case 16: {
                    inp.skipBytes(2);
                    continue block30;
                }
                case 18: {
                    inp.skipBytes(4);
                    continue block30;
                }
            }
        }
        for (i = 1; i < cpCount; ++i) {
            if (indirectStringRef[i] < 0) continue;
            constantPool[i] = constantPool[indirectStringRef[i]];
        }
        int flags = inp.readUnsignedShort();
        boolean isInterface = (flags & 0x200) != 0;
        boolean isAnnotation = (flags & 0x2000) != 0;
        String className = ClassfileBinaryParser.readRefdString(inp, constantPool).replace('/', '.');
        if (className.equals("java.lang.Object")) {
            return;
        }
        if (!this.classesEncounteredSoFarDuringScan.add(className)) {
            return;
        }
        String superclassName = ClassfileBinaryParser.readRefdString(inp, constantPool).replace('/', '.');
        HashMap<String, StaticFinalFieldMatchProcessor> staticFieldnameToMatchProcessor = this.classNameToStaticFieldnameToMatchProcessor.get(className);
        int interfaceCount = inp.readUnsignedShort();
        ArrayList<String> interfaces = interfaceCount > 0 ? new ArrayList<String>(interfaceCount) : null;
        for (int i2 = 0; i2 < interfaceCount; ++i2) {
            interfaces.add(ClassfileBinaryParser.readRefdString(inp, constantPool).replace('/', '.'));
        }
        int fieldCount = inp.readUnsignedShort();
        for (int i3 = 0; i3 < fieldCount; ++i3) {
            int accessFlags = inp.readUnsignedShort();
            boolean isStaticFinal = (accessFlags & 0x18) == 24;
            String fieldName = ClassfileBinaryParser.readRefdString(inp, constantPool);
            StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor = staticFieldnameToMatchProcessor != null ? staticFieldnameToMatchProcessor.get(fieldName) : null;
            String descriptor = ClassfileBinaryParser.readRefdString(inp, constantPool);
            int attributesCount = inp.readUnsignedShort();
            if (!isStaticFinal && staticFinalFieldMatchProcessor != null) {
                System.err.println(StaticFinalFieldMatchProcessor.class.getSimpleName() + ": cannot match requested field " + className + "." + fieldName + " because it is either not static or not final");
                continue;
            }
            if (!isStaticFinal || staticFinalFieldMatchProcessor == null) {
                for (int j = 0; j < attributesCount; ++j) {
                    inp.skipBytes(2);
                    int attributeLength = inp.readInt();
                    inp.skipBytes(attributeLength);
                }
                continue;
            }
            boolean foundConstantValue = false;
            for (int j = 0; j < attributesCount; ++j) {
                String attributeName = ClassfileBinaryParser.readRefdString(inp, constantPool);
                int attributeLength = inp.readInt();
                if (attributeName.equals("ConstantValue")) {
                    Object constValue = constantPool[inp.readUnsignedShort()];
                    switch (descriptor) {
                        case "B": {
                            constValue = ((Integer)constValue).byteValue();
                            break;
                        }
                        case "C": {
                            constValue = Character.valueOf((char)((Integer)constValue).intValue());
                            break;
                        }
                        case "S": {
                            constValue = ((Integer)constValue).shortValue();
                            break;
                        }
                        case "Z": {
                            constValue = (Integer)constValue != 0;
                            break;
                        }
                        case "I": 
                        case "J": 
                        case "F": 
                        case "D": 
                        case "Ljava.lang.String;": {
                            break;
                        }
                    }
                    if (verbose) {
                        Log.log("Found static final field " + className + "." + fieldName + " = " + constValue);
                    }
                    staticFinalFieldMatchProcessor.processMatch(className, fieldName, constValue);
                    foundConstantValue = true;
                } else {
                    inp.skipBytes(attributeLength);
                }
                if (foundConstantValue) continue;
                System.err.println(StaticFinalFieldMatchProcessor.class.getSimpleName() + ": Requested static final field " + className + "." + fieldName + "is not initialized with a constant literal value, so there is no " + "initializer value in the constant pool of the classfile");
            }
        }
        int methodCount = inp.readUnsignedShort();
        for (int i4 = 0; i4 < methodCount; ++i4) {
            inp.skipBytes(6);
            int attributesCount = inp.readUnsignedShort();
            for (int j = 0; j < attributesCount; ++j) {
                inp.skipBytes(2);
                int attributeLength = inp.readInt();
                inp.skipBytes(attributeLength);
            }
        }
        int attributesCount = inp.readUnsignedShort();
        for (int i5 = 0; i5 < attributesCount; ++i5) {
            String attributeName = ClassfileBinaryParser.readRefdString(inp, constantPool);
            int attributeLength = inp.readInt();
            if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                int annotationCount = inp.readUnsignedShort();
                for (int m = 0; m < annotationCount; ++m) {
                    String annotationName = this.readAnnotation(inp, constantPool);
                    if (annotationName.startsWith("java.lang.annotation.")) continue;
                    this.classGraphBuilder.linkAnnotation(annotationName, className, isAnnotation);
                }
                continue;
            }
            inp.skipBytes(attributeLength);
        }
        if (!isAnnotation) {
            if (isInterface) {
                this.classGraphBuilder.linkInterface(interfaces, className);
            } else {
                this.classGraphBuilder.linkClass(superclassName, interfaces, className);
            }
        }
    }
}

