/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class DAGNode {
    String name;
    ArrayList<DAGNode> directSuperNodes = new ArrayList(4);
    ArrayList<DAGNode> directSubNodes = new ArrayList(4);
    HashSet<DAGNode> allSuperNodes = new HashSet(4);
    HashSet<DAGNode> allSubNodes = new HashSet(4);

    public DAGNode(String name) {
        this.name = name;
    }

    public DAGNode(String name, DAGNode subNode) {
        this.name = name;
        this.addSubNode(subNode);
    }

    public void addSubNode(DAGNode subNode) {
        subNode.directSuperNodes.add(this);
        this.directSubNodes.add(subNode);
    }

    protected <N extends DAGNode> void topoSortRec(HashSet<N> visited, ArrayList<N> topoOrder) {
        DAGNode thisGeneric = this;
        if (visited.add(thisGeneric)) {
            for (DAGNode subNode : this.directSubNodes) {
                subNode.topoSortRec(visited, topoOrder);
            }
            topoOrder.add(thisGeneric);
        }
    }

    public static <N extends DAGNode> ArrayList<N> topoSort(Collection<N> nodes) {
        ArrayList topoOrder = new ArrayList(nodes.size());
        HashSet visited = new HashSet();
        for (DAGNode node : nodes) {
            if (!node.directSuperNodes.isEmpty()) continue;
            node.topoSortRec(visited, topoOrder);
        }
        int n = topoOrder.size();
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            DAGNode tmp = (DAGNode)topoOrder.get(i);
            topoOrder.set(i, topoOrder.get(n - 1 - i));
            topoOrder.set(n - 1 - i, tmp);
        }
        return topoOrder;
    }

    public String toString() {
        return this.name;
    }
}

