/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import io.github.lukehutch.fastclasspathscanner.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.Manifest;

public class ClasspathFinder {
    private final ArrayList<File> classpathElements = new ArrayList();
    private final HashSet<String> classpathElementsSet = new HashSet();
    private boolean initialized = false;

    private void clearClasspath() {
        this.classpathElements.clear();
        this.classpathElementsSet.clear();
        this.initialized = false;
    }

    private void addClasspathElement(String pathElement) {
        if (!pathElement.isEmpty()) {
            File pathElementFile = new File(pathElement);
            if (pathElementFile.exists()) {
                String canonicalPath;
                try {
                    canonicalPath = pathElementFile.getCanonicalPath();
                }
                catch (IOException | SecurityException e) {
                    canonicalPath = pathElement;
                }
                if (this.classpathElementsSet.add(canonicalPath)) {
                    if (FastClasspathScanner.verbose) {
                        Log.log("Found classpath element: " + pathElement);
                    }
                    this.classpathElements.add(pathElementFile);
                    if (pathElementFile.isFile() && Utils.isJar(pathElement)) {
                        String manifestUrlStr = "jar:file:" + pathElement + "!/META-INF/MANIFEST.MF";
                        try (InputStream stream = new URL(manifestUrlStr).openStream();){
                            Manifest manifest = new Manifest(stream);
                            String manifestClassPath = manifest.getMainAttributes().getValue("Class-Path");
                            if (manifestClassPath != null && !manifestClassPath.isEmpty()) {
                                if (FastClasspathScanner.verbose) {
                                    Log.log("Found Class-Path entry in " + manifestUrlStr + ": " + manifestClassPath);
                                }
                                for (String manifestClassPathElement : manifestClassPath.split(" ")) {
                                    String manifestClassPathElementAbsolute = new File(pathElementFile.getParent(), manifestClassPathElement).getPath();
                                    this.addClasspathElement(manifestClassPathElementAbsolute);
                                }
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else if (FastClasspathScanner.verbose) {
                Log.log("Classpath element does not exist: " + pathElement);
            }
        }
    }

    private void parseSystemClasspath() {
        String sysClassPath = System.getProperty("java.class.path");
        if (sysClassPath == null || sysClassPath.isEmpty()) {
            sysClassPath = ".";
        }
        this.overrideClasspath(sysClassPath);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        HashSet<ClassLoader> classLoadersSet = new HashSet<ClassLoader>();
        classLoadersSet.add(ClassLoader.getSystemClassLoader());
        classLoaders.add(ClassLoader.getSystemClassLoader());
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement caller;
            ClassLoader cl;
            StackTraceElement[] stacktrace = e.getStackTrace();
            if (stacktrace.length >= 3 && classLoadersSet.add(cl = (caller = stacktrace[2]).getClass().getClassLoader())) {
                classLoaders.add(cl);
            }
            if (classLoadersSet.add(Thread.currentThread().getContextClassLoader())) {
                classLoaders.add(Thread.currentThread().getContextClassLoader());
            }
            for (ClassLoader cl2 : classLoaders) {
                if (cl2 == null) continue;
                for (URL url : ((URLClassLoader)cl2).getURLs()) {
                    String protocol = url.getProtocol();
                    if (protocol != null && !protocol.equalsIgnoreCase("file")) continue;
                    this.addClasspathElement(url.getFile());
                }
            }
            this.initialized = true;
            return;
        }
    }

    public void overrideClasspath(String classpath) {
        this.clearClasspath();
        for (String pathElement : classpath.split(File.pathSeparator)) {
            this.addClasspathElement(pathElement);
        }
        this.initialized = true;
    }

    public ArrayList<File> getUniqueClasspathElements() {
        if (!this.initialized) {
            this.parseSystemClasspath();
        }
        return this.classpathElements;
    }
}

