/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import io.github.lukehutch.fastclasspathscanner.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecursiveScanner {
    private final ClasspathFinder classpath;
    private final String[] whitelistedPaths;
    private final String[] blacklistedPaths;
    private final ArrayList<FilePathMatcher> filePathMatchers = new ArrayList();
    private long lastModified = 0L;
    private static final boolean USE_ZIPFILE_ENTRY_MODIFICATION_TIMES = false;

    public RecursiveScanner(ClasspathFinder classpath, String[] whitelistedPaths, String[] blacklistedPaths) {
        this.classpath = classpath;
        this.whitelistedPaths = whitelistedPaths;
        this.blacklistedPaths = blacklistedPaths;
    }

    public void addFilePathMatcher(FilePathMatcher filePathMatcher) {
        this.filePathMatchers.add(filePathMatcher);
    }

    private void scanFile(File file, String relativePath, boolean scanTimestampsOnly) {
        this.lastModified = Math.max(this.lastModified, file.lastModified());
        if (!scanTimestampsOnly) {
            boolean filePathMatches = false;
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                block17: {
                    if (!fileMatcher.filePathMatches(relativePath)) continue;
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        fileMatcher.processMatch(relativePath, inputStream, (int)file.length());
                    }
                    catch (IOException e) {
                        if (!FastClasspathScanner.verbose) break block17;
                        Log.log(e.getMessage() + " while processing file " + file.getPath());
                    }
                }
                filePathMatches = true;
            }
            if (FastClasspathScanner.verbose && filePathMatches) {
                Log.log("Found file:    " + relativePath);
            }
        }
    }

    private void scanZipfile(String zipfilePath, ZipFile zipFile, long zipFileLastModified, boolean scanTimestampsOnly) {
        if (FastClasspathScanner.verbose) {
            Log.log("Scanning jar:  " + zipfilePath);
        }
        boolean timestampWarning = false;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String path = entry.getName();
            boolean scanFile = false;
            for (String whitelistedPath : this.whitelistedPaths) {
                if (!path.startsWith(whitelistedPath) && !whitelistedPath.equals("/")) continue;
                scanFile = true;
                break;
            }
            for (String blacklistedPath : this.blacklistedPaths) {
                if (!path.startsWith(blacklistedPath)) continue;
                scanFile = false;
                break;
            }
            if (!scanFile) continue;
            long entryTime = zipFileLastModified;
            this.lastModified = Math.max(this.lastModified, entryTime);
            if (entryTime > System.currentTimeMillis() && !timestampWarning) {
                String msg = zipfilePath + " contains modification timestamps after the current time";
                System.err.println(msg);
                timestampWarning = true;
            }
            if (scanTimestampsOnly) continue;
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                if (!fileMatcher.filePathMatches(path)) continue;
                try {
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        fileMatcher.processMatch(path, inputStream, (int)entry.getSize());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(e.getMessage() + " while processing file " + entry.getName());
                }
            }
        }
    }

    private void scanDir(File dir, int ignorePrefixLen, boolean inWhitelistedPath, boolean scanTimestampsOnly) {
        String relativePath = (ignorePrefixLen > dir.getPath().length() ? "" : dir.getPath().substring(ignorePrefixLen)) + "/";
        if (File.separatorChar != '/') {
            relativePath = relativePath.replace(File.separatorChar, '/');
        }
        if (FastClasspathScanner.verbose) {
            Log.log("Scanning path: " + relativePath);
        }
        for (String blacklistedPath : this.blacklistedPaths) {
            if (!relativePath.equals(blacklistedPath)) continue;
            if (FastClasspathScanner.verbose) {
                Log.log("Reached blacklisted path: " + relativePath);
            }
            return;
        }
        boolean keepRecursing = false;
        if (!inWhitelistedPath) {
            for (String whitelistedPath : this.whitelistedPaths) {
                if (relativePath.equals(whitelistedPath)) {
                    if (FastClasspathScanner.verbose) {
                        Log.log("Reached whitelisted path: " + relativePath);
                    }
                    inWhitelistedPath = true;
                    break;
                }
                if (!whitelistedPath.startsWith(relativePath) && !relativePath.equals("/")) continue;
                keepRecursing = true;
            }
        }
        if (keepRecursing || inWhitelistedPath) {
            this.lastModified = Math.max(this.lastModified, dir.lastModified());
            File[] subFiles = dir.listFiles();
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    if (subFile.isDirectory()) {
                        this.scanDir(subFile, ignorePrefixLen, inWhitelistedPath, scanTimestampsOnly);
                        continue;
                    }
                    if (!inWhitelistedPath || !subFile.isFile()) continue;
                    this.scanFile(subFile, relativePath.equals("/") ? subFile.getName() : relativePath + subFile.getName(), scanTimestampsOnly);
                }
            }
        }
    }

    public void scan(boolean scanTimestampsOnly) {
        ArrayList<File> uniqueClasspathElements = this.classpath.getUniqueClasspathElements();
        if (FastClasspathScanner.verbose) {
            Log.log("*** Starting scan" + (scanTimestampsOnly ? " (scanning classpath timestamps only)" : "") + " ***");
            Log.log("Classpath elements: " + uniqueClasspathElements);
            Log.log("Whitelisted paths:  " + Arrays.toString(this.whitelistedPaths));
            Log.log("Blacklisted paths:  " + Arrays.toString(this.blacklistedPaths));
        }
        for (int classpathEltIdx = 0; classpathEltIdx < uniqueClasspathElements.size(); ++classpathEltIdx) {
            File pathElt = uniqueClasspathElements.get(classpathEltIdx);
            String path = pathElt.getPath();
            if (FastClasspathScanner.verbose) {
                Log.log("=> Scanning classpath element: " + path);
            }
            if (pathElt.isDirectory()) {
                this.scanDir(pathElt, path.length() + 1, false, scanTimestampsOnly);
                continue;
            }
            if (pathElt.isFile()) {
                if (Utils.isJar(path)) {
                    try (ZipFile zipfile = new ZipFile(pathElt);){
                        this.scanZipfile(path, zipfile, pathElt.lastModified(), scanTimestampsOnly);
                    }
                    catch (IOException e) {
                        if (!FastClasspathScanner.verbose) continue;
                        Log.log(e.getMessage() + " while opening zipfile " + pathElt);
                    }
                    continue;
                }
                this.scanFile(pathElt, pathElt.getName(), scanTimestampsOnly);
                continue;
            }
            if (!FastClasspathScanner.verbose) continue;
            Log.log("Skipping non-file/non-dir on classpath: " + pathElt.getPath());
        }
    }

    public boolean classpathContentsModifiedSinceScan() {
        long oldLastModified = this.lastModified;
        if (oldLastModified == 0L) {
            return true;
        }
        this.scan(true);
        long newLastModified = this.lastModified;
        return newLastModified > oldLastModified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.lastModified;
    }

    public static class FilePathMatcher {
        private final FilePathTester filePathTester;
        private final FileMatchProcessor fileMatchProcessor;

        public FilePathMatcher(FilePathTester filePathTester, FileMatchProcessor fileMatchProcessor) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessor = fileMatchProcessor;
        }

        public boolean filePathMatches(String relativePath) {
            return this.filePathTester.filePathMatches(relativePath);
        }

        public void processMatch(String relativePath, InputStream inputStream, int inputStreamLengthBytes) throws IOException {
            this.fileMatchProcessor.processMatch(relativePath, inputStream, inputStreamLengthBytes);
        }
    }

    public static interface FilePathTester {
        public boolean filePathMatches(String var1);
    }
}

