/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassEnumerationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.InterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.RecursiveScanner;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class FastClasspathScanner {
    private final ClasspathFinder classpathFinder = new ClasspathFinder();
    private final RecursiveScanner recursiveScanner;
    private final HashMap<String, HashMap<String, StaticFinalFieldMatchProcessor>> classNameToStaticFieldnameToMatchProcessor = new HashMap();
    private final HashMap<String, ClassInfo> relativePathToClassInfo = new HashMap();
    private ClassGraphBuilder classGraphBuilder;
    private final ArrayList<ClassMatcher> classMatchers = new ArrayList();
    public static boolean verbose = false;

    public FastClasspathScanner(String ... scanSpec) {
        this.recursiveScanner = new RecursiveScanner(this.classpathFinder, scanSpec);
        this.matchFilenameExtension("class", new FileMatchProcessor(){

            @Override
            public void processMatch(String relativePath, InputStream inputStream, int lengthBytes) throws IOException {
                if (!FastClasspathScanner.this.relativePathToClassInfo.containsKey(relativePath)) {
                    ClassInfo classInfo = ClassfileBinaryParser.readClassInfoFromClassfileHeader(relativePath, inputStream, FastClasspathScanner.this.classNameToStaticFieldnameToMatchProcessor);
                    if (classInfo != null) {
                        FastClasspathScanner.this.relativePathToClassInfo.put(relativePath, classInfo);
                    }
                } else if (verbose) {
                    Log.log(relativePath.replace('/', '.') + " occurs more than once on classpath, ignoring all but first instance");
                }
            }
        });
    }

    public FastClasspathScanner overrideClasspath(String classpath) {
        this.classpathFinder.overrideClasspath(classpath);
        return this;
    }

    private <T> Class<? extends T> loadClass(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return cls;
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError e) {
            throw new RuntimeException("Exception while loading or initializing class " + className, e);
        }
    }

    private static String annotationName(Class<?> annotation) {
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException("Class " + annotation.getName() + " is not an annotation");
        }
        return annotation.getName();
    }

    private static String[] annotationNames(Class<?>[] annotations) {
        String[] annotationNames = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotationNames[i] = FastClasspathScanner.annotationName(annotations[i]);
        }
        return annotationNames;
    }

    private static String interfaceName(Class<?> iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException("Class " + iface.getName() + " is not an interface");
        }
        return iface.getName();
    }

    private static String[] interfaceNames(Class<?>[] interfaces) {
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = FastClasspathScanner.interfaceName(interfaces[i]);
        }
        return interfaceNames;
    }

    private static String classOrInterfaceName(Class<?> classOrInterface) {
        if (classOrInterface.isAnnotation()) {
            throw new IllegalArgumentException(classOrInterface.getName() + " is an annotation, not a regular class or interface");
        }
        return classOrInterface.getName();
    }

    private static String className(Class<?> cls) {
        if (cls.isAnnotation()) {
            throw new IllegalArgumentException(cls.getName() + " is an annotation, not a regular class");
        }
        if (cls.isInterface()) {
            throw new IllegalArgumentException(cls.getName() + " is an interface, not a regular class");
        }
        return cls.getName();
    }

    public List<String> getNamesOfAllClasses() {
        return this.getScanResults().getNamesOfAllClasses();
    }

    public List<String> getNamesOfAllStandardClasses() {
        return this.getScanResults().getNamesOfAllStandardClasses();
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return this.getScanResults().getNamesOfAllInterfaceClasses();
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return this.getScanResults().getNamesOfAllAnnotationClasses();
    }

    public FastClasspathScanner matchAllClasses(final ClassEnumerationMatchProcessor classEnumerationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllClasses()) {
                    if (verbose) {
                        Log.log("Enumerating class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classEnumerationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchAllStandardClasses(final ClassEnumerationMatchProcessor classEnumerationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllStandardClasses()) {
                    if (verbose) {
                        Log.log("Enumerating standard class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classEnumerationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchAllInterfaceClasses(final ClassEnumerationMatchProcessor classEnumerationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllInterfaceClasses()) {
                    if (verbose) {
                        Log.log("Enumerating interface class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classEnumerationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchAllAnnotationClasses(final ClassEnumerationMatchProcessor classEnumerationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllAnnotationClasses()) {
                    if (verbose) {
                        Log.log("Enumerating annotation class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classEnumerationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public <T> FastClasspathScanner matchSubclassesOf(final Class<T> superclass, final SubclassMatchProcessor<T> subclassMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String superclassName = FastClasspathScanner.className(superclass);
                for (String subclassName : FastClasspathScanner.this.getNamesOfSubclassesOf(superclassName)) {
                    if (verbose) {
                        Log.log("Found subclass of " + superclassName + ": " + subclassName);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(subclassName);
                    subclassMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfSubclassesOf(Class<?> superclass) {
        return this.getNamesOfSubclassesOf(FastClasspathScanner.className(superclass));
    }

    public List<String> getNamesOfSubclassesOf(String superclassName) {
        return this.getScanResults().getNamesOfSubclassesOf(superclassName);
    }

    public List<String> getNamesOfSuperclassesOf(Class<?> subclass) {
        return this.getNamesOfSuperclassesOf(FastClasspathScanner.className(subclass));
    }

    public List<String> getNamesOfSuperclassesOf(String subclassName) {
        return this.getScanResults().getNamesOfSuperclassesOf(subclassName);
    }

    public <T> FastClasspathScanner matchSubinterfacesOf(final Class<T> superinterface, final SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String superinterfaceName = FastClasspathScanner.interfaceName(superinterface);
                for (String subinterfaceName : FastClasspathScanner.this.getNamesOfSubinterfacesOf(superinterfaceName)) {
                    if (verbose) {
                        Log.log("Found subinterface of " + superinterfaceName + ": " + subinterfaceName);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(subinterfaceName);
                    subinterfaceMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfSubinterfacesOf(Class<?> superInterface) {
        return this.getNamesOfSubinterfacesOf(FastClasspathScanner.interfaceName(superInterface));
    }

    public List<String> getNamesOfSubinterfacesOf(String superInterfaceName) {
        return this.getScanResults().getNamesOfSubinterfacesOf(superInterfaceName);
    }

    public List<String> getNamesOfSuperinterfacesOf(Class<?> subInterface) {
        return this.getNamesOfSuperinterfacesOf(FastClasspathScanner.interfaceName(subInterface));
    }

    public List<String> getNamesOfSuperinterfacesOf(String subinterfaceName) {
        return this.getScanResults().getNamesOfSuperinterfacesOf(subinterfaceName);
    }

    public <T> FastClasspathScanner matchClassesImplementing(final Class<T> implementedInterface, final InterfaceMatchProcessor<T> interfaceMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String implementedInterfaceName = FastClasspathScanner.interfaceName(implementedInterface);
                for (String implClass : FastClasspathScanner.this.getNamesOfClassesImplementing(implementedInterfaceName)) {
                    if (verbose) {
                        Log.log("Found class implementing interface " + implementedInterfaceName + ": " + implClass);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(implClass);
                    interfaceMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfClassesImplementing(Class<?> implementedInterface) {
        return this.getNamesOfClassesImplementing(FastClasspathScanner.interfaceName(implementedInterface));
    }

    public List<String> getNamesOfClassesImplementing(String implementedInterfaceName) {
        return this.getScanResults().getNamesOfClassesImplementing(implementedInterfaceName);
    }

    public List<String> getNamesOfClassesImplementingAllOf(Class<?> ... implementedInterfaces) {
        return this.getNamesOfClassesImplementingAllOf(FastClasspathScanner.interfaceNames(implementedInterfaces));
    }

    public List<String> getNamesOfClassesImplementingAllOf(String ... implementedInterfaceNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < implementedInterfaceNames.length; ++i) {
            String implementedInterfaceName = implementedInterfaceNames[i];
            List<String> namesOfImplementingClasses = this.getNamesOfClassesImplementing(implementedInterfaceName);
            if (i == 0) {
                classNames.addAll(namesOfImplementingClasses);
                continue;
            }
            classNames.retainAll(namesOfImplementingClasses);
        }
        return new ArrayList<String>(classNames);
    }

    public FastClasspathScanner matchClassesWithAnnotation(final Class<?> annotation, final ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String annotationName = FastClasspathScanner.annotationName(annotation);
                for (String classWithAnnotation : FastClasspathScanner.this.getNamesOfClassesWithAnnotation(annotationName)) {
                    if (verbose) {
                        Log.log("Found class with annotation " + annotationName + ": " + classWithAnnotation);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(classWithAnnotation);
                    classAnnotationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfClassesWithAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithAnnotation(FastClasspathScanner.annotationName(annotation));
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        return this.getScanResults().getNamesOfClassesWithAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAllOf(FastClasspathScanner.annotationNames(annotations));
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < annotationNames.length; ++i) {
            String annotationName = annotationNames[i];
            List<String> namesOfClassesWithMetaAnnotation = this.getNamesOfClassesWithAnnotation(annotationName);
            if (i == 0) {
                classNames.addAll(namesOfClassesWithMetaAnnotation);
                continue;
            }
            classNames.retainAll(namesOfClassesWithMetaAnnotation);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAnyOf(FastClasspathScanner.annotationNames(annotations));
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (String annotationName : annotationNames) {
            classNames.addAll(this.getNamesOfClassesWithAnnotation(annotationName));
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(Class<?> metaAnnotation) {
        return this.getNamesOfAnnotationsWithMetaAnnotation(FastClasspathScanner.annotationName(metaAnnotation));
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        return this.getScanResults().getNamesOfAnnotationsWithMetaAnnotation(metaAnnotationName);
    }

    public List<String> getNamesOfAnnotationsOnClass(Class<?> classOrInterface) {
        return this.getNamesOfAnnotationsOnClass(FastClasspathScanner.classOrInterfaceName(classOrInterface));
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        return this.getScanResults().getNamesOfAnnotationsOnClass(classOrInterfaceName);
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(Class<?> annotation) {
        return this.getNamesOfMetaAnnotationsOnAnnotation(FastClasspathScanner.annotationName(annotation));
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        return this.getScanResults().getNamesOfMetaAnnotationsOnAnnotation(annotationName);
    }

    private void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashMap<String, StaticFinalFieldMatchProcessor> fieldNameToMatchProcessor = this.classNameToStaticFieldnameToMatchProcessor.get(className);
        if (fieldNameToMatchProcessor == null) {
            fieldNameToMatchProcessor = new HashMap(2);
            this.classNameToStaticFieldnameToMatchProcessor.put(className, fieldNameToMatchProcessor);
        }
        fieldNameToMatchProcessor.put(fieldName, staticFinalFieldMatchProcessor);
    }

    public FastClasspathScanner matchStaticFinalFieldNames(HashSet<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            int lastDotIdx = fullyQualifiedFieldName.lastIndexOf(46);
            if (lastDotIdx <= 0) continue;
            String className = fullyQualifiedFieldName.substring(0, lastDotIdx);
            String fieldName = fullyQualifiedFieldName.substring(lastDotIdx + 1);
            this.addStaticFinalFieldProcessor(className, fieldName, staticFinalFieldMatchProcessor);
        }
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedStaticFinalFieldName);
        return this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedFieldName);
        }
        return this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    private static FileMatchProcessor wrapFileMatchContentsProcessor(final FileMatchContentsProcessor fileMatchContentsProcessor) {
        return new FileMatchProcessor(){

            @Override
            public void processMatch(String relativePath, InputStream inputStream, int lengthBytes) throws IOException {
                byte[] contents = new byte[lengthBytes];
                int bytesRead = Math.max(0, inputStream.read(contents));
                byte[] contentsRead = bytesRead == lengthBytes ? contents : Arrays.copyOf(contents, bytesRead);
                fileMatchContentsProcessor.processMatch(relativePath, contentsRead);
            }
        };
    }

    public FastClasspathScanner matchFilenamePattern(final String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.recursiveScanner.addFilePathMatcher(new RecursiveScanner.FilePathMatcher(new RecursiveScanner.FilePathTester(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(pathRegexp);
            }

            @Override
            public boolean filePathMatches(String relativePath) {
                return this.pattern.matcher(relativePath).matches();
            }
        }, fileMatchProcessor));
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenamePattern(pathRegexp, FastClasspathScanner.wrapFileMatchContentsProcessor(fileMatchContentsProcessor));
    }

    public FastClasspathScanner matchFilenamePath(final String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.recursiveScanner.addFilePathMatcher(new RecursiveScanner.FilePathMatcher(new RecursiveScanner.FilePathTester(){

            @Override
            public boolean filePathMatches(String relativePath) {
                return relativePath.equals(relativePathToMatch);
            }
        }, fileMatchProcessor));
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenamePath(relativePathToMatch, FastClasspathScanner.wrapFileMatchContentsProcessor(fileMatchContentsProcessor));
    }

    public FastClasspathScanner matchFilenamePathLeaf(final String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.recursiveScanner.addFilePathMatcher(new RecursiveScanner.FilePathMatcher(new RecursiveScanner.FilePathTester(){
            private final String leafToMatch;
            {
                this.leafToMatch = pathLeafToMatch.substring(pathLeafToMatch.lastIndexOf(47) + 1);
            }

            @Override
            public boolean filePathMatches(String relativePath) {
                String relativePathLeaf = relativePath.substring(relativePath.lastIndexOf(47) + 1);
                return relativePathLeaf.equals(this.leafToMatch);
            }
        }, fileMatchProcessor));
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenamePathLeaf(pathLeafToMatch, FastClasspathScanner.wrapFileMatchContentsProcessor(fileMatchContentsProcessor));
    }

    public FastClasspathScanner matchFilenameExtension(final String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.recursiveScanner.addFilePathMatcher(new RecursiveScanner.FilePathMatcher(new RecursiveScanner.FilePathTester(){
            private final String suffixToMatch;
            {
                this.suffixToMatch = "." + extensionToMatch.toLowerCase();
            }

            @Override
            public boolean filePathMatches(String relativePath) {
                return relativePath.toLowerCase().endsWith(this.suffixToMatch);
            }
        }, fileMatchProcessor));
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenameExtension(extensionToMatch, FastClasspathScanner.wrapFileMatchContentsProcessor(fileMatchContentsProcessor));
    }

    public List<File> getUniqueClasspathElements() {
        return this.classpathFinder.getUniqueClasspathElements();
    }

    public String generateClassGraphDotFile() {
        return this.getScanResults().generateClassGraphDotFile();
    }

    public ClassGraphBuilder getScanResults() {
        if (this.classGraphBuilder == null) {
            throw new RuntimeException("Must call .scan() before attempting to get the results of the scan");
        }
        return this.classGraphBuilder;
    }

    public FastClasspathScanner scan() {
        long scanStart = System.currentTimeMillis();
        this.relativePathToClassInfo.clear();
        this.recursiveScanner.scan();
        this.classGraphBuilder = new ClassGraphBuilder(this.relativePathToClassInfo.values());
        for (ClassMatcher classMatcher : this.classMatchers) {
            classMatcher.lookForMatches();
        }
        if (verbose) {
            Log.log("*** Time taken by .scan(): " + (System.currentTimeMillis() - scanStart) + " ms ***");
        }
        return this;
    }

    public boolean classpathContentsModifiedSinceScan() {
        long scanStart = System.currentTimeMillis();
        boolean modified = this.recursiveScanner.classpathContentsModifiedSinceScan();
        if (verbose) {
            Log.log("*** Time taken by .classpathContentsModifiedSinceScan(): " + (System.currentTimeMillis() - scanStart) + " ms ***");
        }
        return modified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.recursiveScanner.classpathContentsLastModifiedTime();
    }

    public FastClasspathScanner verbose() {
        verbose = true;
        return this;
    }

    public static interface ClassMatcher {
        public void lookForMatches();
    }
}

