/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classgraph.DAGNode;
import io.github.lukehutch.fastclasspathscanner.utils.LazyMap;
import io.github.lukehutch.fastclasspathscanner.utils.MultiSet;
import io.github.lukehutch.fastclasspathscanner.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ClassGraphBuilder {
    ArrayList<DAGNode> standardClassNodes = new ArrayList();
    ArrayList<DAGNode> interfaceNodes = new ArrayList();
    ArrayList<DAGNode> annotationNodes = new ArrayList();
    private final LazyMap<String, DAGNode> classNameToStandardClassNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (DAGNode classNode : ClassGraphBuilder.this.standardClassNodes) {
                this.map.put(classNode.name, classNode);
            }
        }
    };
    private final LazyMap<String, DAGNode> interfaceNameToInterfaceNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (DAGNode interfaceNode : ClassGraphBuilder.this.interfaceNodes) {
                this.map.put(interfaceNode.name, interfaceNode);
            }
        }
    };
    private final LazyMap<String, DAGNode> annotationNameToAnnotationNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (DAGNode annotationNode : ClassGraphBuilder.this.annotationNodes) {
                this.map.put(annotationNode.name, annotationNode);
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> namesOfAllClasses = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String ignored) {
            return Utils.sortedCopy(ClassGraphBuilder.this.classNameToStandardClassNode.keySet(), ClassGraphBuilder.this.interfaceNameToInterfaceNode.keySet(), ClassGraphBuilder.this.annotationNameToAnnotationNode.keySet());
        }
    };
    private final LazyMap<String, ArrayList<String>> namesOfAllStandardClasses = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String ignored) {
            return Utils.sortedCopy(ClassGraphBuilder.this.classNameToStandardClassNode.keySet());
        }
    };
    private final LazyMap<String, ArrayList<String>> namesOfAllInterfaceClasses = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String ignored) {
            return Utils.sortedCopy(ClassGraphBuilder.this.interfaceNameToInterfaceNode.keySet());
        }
    };
    private final LazyMap<String, ArrayList<String>> namesOfAllAnnotationClasses = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String ignored) {
            return Utils.sortedCopy(ClassGraphBuilder.this.annotationNameToAnnotationNode.keySet());
        }
    };
    private final LazyMap<String, ArrayList<String>> classNameToSubclassNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String className) {
            DAGNode classNode = (DAGNode)ClassGraphBuilder.this.classNameToStandardClassNode.get(className);
            if (classNode == null) {
                return null;
            }
            ArrayList<String> subclasses = new ArrayList<String>(classNode.allSubNodes.size());
            for (DAGNode subNode : classNode.allSubNodes) {
                subclasses.add(subNode.name);
            }
            Collections.sort(subclasses);
            return subclasses;
        }
    };
    private final LazyMap<String, ArrayList<String>> classNameToSuperclassNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String className) {
            DAGNode classNode = (DAGNode)ClassGraphBuilder.this.classNameToStandardClassNode.get(className);
            if (classNode == null) {
                return null;
            }
            ArrayList<String> superclasses = new ArrayList<String>(classNode.allSuperNodes.size());
            for (DAGNode superNode : classNode.allSuperNodes) {
                superclasses.add(superNode.name);
            }
            Collections.sort(superclasses);
            return superclasses;
        }
    };
    private final LazyMap<String, ArrayList<String>> interfaceNameToSubinterfaceNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String interfaceName) {
            DAGNode interfaceNode = (DAGNode)ClassGraphBuilder.this.interfaceNameToInterfaceNode.get(interfaceName);
            if (interfaceNode == null) {
                return null;
            }
            ArrayList<String> subinterfaces = new ArrayList<String>(interfaceNode.allSubNodes.size());
            for (DAGNode subNode : interfaceNode.allSubNodes) {
                subinterfaces.add(subNode.name);
            }
            Collections.sort(subinterfaces);
            return subinterfaces;
        }
    };
    private final LazyMap<String, ArrayList<String>> interfaceNameToSuperinterfaceNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String interfaceName) {
            DAGNode interfaceNode = (DAGNode)ClassGraphBuilder.this.interfaceNameToInterfaceNode.get(interfaceName);
            if (interfaceNode == null) {
                return null;
            }
            ArrayList<String> superinterfaces = new ArrayList<String>(interfaceNode.allSuperNodes.size());
            for (DAGNode superNode : interfaceNode.allSuperNodes) {
                superinterfaces.add(superNode.name);
            }
            Collections.sort(superinterfaces);
            return superinterfaces;
        }
    };
    private final LazyMap<String, HashSet<String>> interfaceNameToClassNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (DAGNode classNode : ClassGraphBuilder.this.classNameToStandardClassNode.values()) {
                ArrayList<DAGNode> interfaceNodes = classNode.crossLinkedNodes;
                for (DAGNode interfaceNode : interfaceNodes) {
                    MultiSet.put(this.map, interfaceNode.name, classNode.name);
                    for (DAGNode subclassNode : classNode.allSubNodes) {
                        MultiSet.put(this.map, interfaceNode.name, subclassNode.name);
                    }
                    for (DAGNode superinterfaceNode : interfaceNode.allSuperNodes) {
                        MultiSet.put(this.map, superinterfaceNode.name, classNode.name);
                        for (DAGNode subclassNode : classNode.allSubNodes) {
                            MultiSet.put(this.map, superinterfaceNode.name, subclassNode.name);
                        }
                    }
                }
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> interfaceNameToClassNames = LazyMap.convertToMultiMapSorted(this.interfaceNameToClassNamesSet);
    private final LazyMap<String, HashSet<String>> annotationNameToAnnotatedClassNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        protected HashSet<String> generateValue(String annotationName) {
            DAGNode annotationNode = (DAGNode)ClassGraphBuilder.this.annotationNameToAnnotationNode.get(annotationName);
            if (annotationNode == null) {
                return null;
            }
            HashSet<String> classNames = new HashSet<String>();
            for (DAGNode subNode : annotationNode.allSubNodes) {
                for (DAGNode crossLinkedNode : subNode.crossLinkedNodes) {
                    classNames.add(crossLinkedNode.name);
                }
            }
            for (DAGNode crossLinkedNode : annotationNode.crossLinkedNodes) {
                classNames.add(crossLinkedNode.name);
            }
            return classNames;
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToAnnotatedClassNames = LazyMap.convertToMultiMapSorted(this.annotationNameToAnnotatedClassNamesSet);
    private final LazyMap<String, ArrayList<String>> classNameToAnnotationNames = LazyMap.convertToMultiMapSorted(LazyMap.invertMultiSet(this.annotationNameToAnnotatedClassNamesSet, this.annotationNameToAnnotationNode));
    private final LazyMap<String, HashSet<String>> metaAnnotationNameToAnnotatedAnnotationNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        protected HashSet<String> generateValue(String annotationName) {
            DAGNode annotationNode = (DAGNode)ClassGraphBuilder.this.annotationNameToAnnotationNode.get(annotationName);
            if (annotationNode == null) {
                return null;
            }
            HashSet<String> subNodes = new HashSet<String>();
            for (DAGNode subNode : annotationNode.allSubNodes) {
                subNodes.add(subNode.name);
            }
            return subNodes;
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToMetaAnnotationNames = LazyMap.convertToMultiMapSorted(LazyMap.invertMultiSet(this.metaAnnotationNameToAnnotatedAnnotationNamesSet, this.annotationNameToAnnotationNode));
    private final LazyMap<String, ArrayList<String>> metaAnnotationNameToAnnotatedAnnotationNames = LazyMap.convertToMultiMapSorted(this.metaAnnotationNameToAnnotatedAnnotationNamesSet);

    public ClassGraphBuilder(Collection<ClassInfo> classInfoFromScan) {
        String className;
        ArrayList<ClassInfo> allClassInfo = new ArrayList<ClassInfo>(Utils.mergeScalaAuxClasses(classInfoFromScan));
        HashMap<String, DAGNode> classNameToDAGNode = new HashMap<String, DAGNode>();
        for (ClassInfo classInfo : allClassInfo) {
            className = classInfo.className;
            classNameToDAGNode.put(className, new DAGNode(className));
        }
        for (ClassInfo classInfo : allClassInfo) {
            className = classInfo.className;
            DAGNode classNode = (DAGNode)classNameToDAGNode.get(className);
            (classInfo.isAnnotation ? this.annotationNodes : (classInfo.isInterface ? this.interfaceNodes : this.standardClassNodes)).add(classNode);
            if (classInfo.interfaceNames != null) {
                for (String interfaceName : classInfo.interfaceNames) {
                    DAGNode interfaceNode = (DAGNode)classNameToDAGNode.get(interfaceName);
                    if (interfaceNode == null) continue;
                    if (!classInfo.isAnnotation && !classInfo.isInterface) {
                        classNode.addCrossLink(interfaceNode);
                        continue;
                    }
                    if (!classInfo.isInterface) continue;
                    interfaceNode.addSubNode(classNode);
                }
            }
            for (String superclassName : classInfo.superclassNames) {
                DAGNode superclassNode = (DAGNode)classNameToDAGNode.get(superclassName);
                if (superclassNode == null) continue;
                superclassNode.addSubNode(classNode);
            }
            if (classInfo.annotationNames == null) continue;
            for (String annotationName : classInfo.annotationNames) {
                DAGNode annotationNode = (DAGNode)classNameToDAGNode.get(annotationName);
                if (annotationNode == null) continue;
                if (classInfo.isAnnotation) {
                    annotationNode.addSubNode(classNode);
                    continue;
                }
                annotationNode.addCrossLink(classNode);
            }
        }
        DAGNode.findTransitiveClosure(this.standardClassNodes);
        DAGNode.findTransitiveClosure(this.interfaceNodes);
        DAGNode.findTransitiveClosure(this.annotationNodes);
    }

    public List<String> getNamesOfAllClasses() {
        return this.namesOfAllClasses.get("");
    }

    public List<String> getNamesOfAllStandardClasses() {
        return this.namesOfAllStandardClasses.get("");
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return this.namesOfAllInterfaceClasses.get("");
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return this.namesOfAllAnnotationClasses.get("");
    }

    public List<String> getNamesOfSubclassesOf(String className) {
        ArrayList<String> subclassNames = this.classNameToSubclassNames.get(className);
        if (subclassNames == null) {
            return Collections.emptyList();
        }
        return subclassNames;
    }

    public List<String> getNamesOfSuperclassesOf(String className) {
        ArrayList<String> superclassNames = this.classNameToSuperclassNames.get(className);
        if (superclassNames == null) {
            return Collections.emptyList();
        }
        return superclassNames;
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        ArrayList<String> subinterfaceNames = this.interfaceNameToSubinterfaceNames.get(interfaceName);
        if (subinterfaceNames == null) {
            return Collections.emptyList();
        }
        return subinterfaceNames;
    }

    public List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        ArrayList<String> superinterfaceNames = this.interfaceNameToSuperinterfaceNames.get(interfaceName);
        if (superinterfaceNames == null) {
            return Collections.emptyList();
        }
        return superinterfaceNames;
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        ArrayList<String> classes = this.interfaceNameToClassNames.get(interfaceName);
        if (classes == null) {
            return Collections.emptyList();
        }
        return classes;
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        ArrayList<String> classNames = this.annotationNameToAnnotatedClassNames.get(annotationName);
        if (classNames == null) {
            return Collections.emptyList();
        }
        return classNames;
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        ArrayList<String> annotationNames = this.classNameToAnnotationNames.get(classOrInterfaceName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        ArrayList<String> metaAnnotationNames = this.annotationNameToMetaAnnotationNames.get(annotationName);
        if (metaAnnotationNames == null) {
            return Collections.emptyList();
        }
        return metaAnnotationNames;
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        ArrayList<String> annotationNames = this.metaAnnotationNameToAnnotatedAnnotationNames.get(metaAnnotationName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }

    private static String label(DAGNode node) {
        String className = node.name;
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx < 0) {
            return className;
        }
        return className.substring(0, dotIdx + 1) + "\\n" + className.substring(dotIdx + 1);
    }

    public String generateClassGraphDotFile() {
        StringBuilder buf = new StringBuilder();
        buf.append("digraph {\n");
        buf.append("size=\"400,400\";\n");
        buf.append("layout=neato;\n");
        buf.append("overlap=false;\n");
        buf.append("splines=true;\n");
        buf.append("pack=true;\n");
        buf.append("start=\"random\";\n");
        buf.append("sep=0.1;\n");
        buf.append("edge[len=2];\n");
        buf.append("\nnode[shape=box,style=filled,fillcolor=\"#eeeeaa\"];\n");
        for (DAGNode node : this.standardClassNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\nnode[shape=diamond,style=filled,fillcolor=\"#aaeeee\"];\n");
        for (DAGNode node : this.interfaceNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\nnode[shape=oval,style=filled,fillcolor=\"#eeaaee\"];\n");
        for (DAGNode node : this.annotationNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\n");
        for (DAGNode classNode : this.standardClassNodes) {
            for (DAGNode superclassNode : classNode.directSuperNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(classNode) + "\" -> \"" + ClassGraphBuilder.label(superclassNode) + "\"\n");
            }
            for (DAGNode implementedInterfaceNode : classNode.crossLinkedNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(classNode) + "\" -> \"" + ClassGraphBuilder.label(implementedInterfaceNode) + "\" [arrowhead=odiamond]\n");
            }
        }
        for (DAGNode interfaceNode : this.interfaceNodes) {
            for (DAGNode superinterfaceNode : interfaceNode.directSuperNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(interfaceNode) + "\" -> \"" + ClassGraphBuilder.label(superinterfaceNode) + "\" [arrowhead=diamond]\n");
            }
        }
        for (DAGNode annotationNode : this.annotationNodes) {
            for (DAGNode metaAnnotationNode : annotationNode.directSuperNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(annotationNode) + "\" -> \"" + ClassGraphBuilder.label(metaAnnotationNode) + "\" [arrowhead=dot]\n");
            }
            for (DAGNode annotatedClassNode : annotationNode.crossLinkedNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(annotatedClassNode) + "\" -> \"" + ClassGraphBuilder.label(annotationNode) + "\" [arrowhead=odot]\n");
            }
        }
        buf.append("}");
        return buf.toString();
    }
}

