/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.MultiSet;
import io.github.lukehutch.fastclasspathscanner.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class LazyMap<K, V> {
    protected final HashMap<K, V> map = new HashMap();
    private boolean initialized = false;

    protected V generateValue(K key) {
        return null;
    }

    public void initialize() {
    }

    private void checkInitialized() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    public void clear() {
        this.map.clear();
        this.initialized = false;
    }

    public void generateAllValues(Collection<K> keys) {
        this.checkInitialized();
        for (K key : keys) {
            this.get(key);
        }
    }

    public V get(K key) {
        this.checkInitialized();
        V cachedVal = this.map.get(key);
        if (cachedVal == null && (cachedVal = this.generateValue(key)) != null) {
            this.map.put(key, cachedVal);
        }
        return cachedVal;
    }

    public Collection<V> values() {
        this.checkInitialized();
        return this.map.values();
    }

    public Set<K> keySet() {
        this.checkInitialized();
        return this.map.keySet();
    }

    public String toString() {
        this.checkInitialized();
        return this.map.toString();
    }

    public static <K, V, T> LazyMap<V, HashSet<K>> invertMultiSet(final LazyMap<K, HashSet<V>> lazyMap, final LazyMap<K, T> templateLazyMap) {
        return new LazyMap<V, HashSet<K>>(){

            @Override
            public void initialize() {
                lazyMap.generateAllValues(templateLazyMap.keySet());
                MultiSet.invert(lazyMap.map, this.map);
            }
        };
    }

    public static <K, V, T> LazyMap<V, HashSet<K>> invertMultiSet(final LazyMap<K, HashSet<V>> lazyMap) {
        return new LazyMap<V, HashSet<K>>(){

            @Override
            public void initialize() {
                lazyMap.checkInitialized();
                MultiSet.invert(lazyMap.map, this.map);
            }
        };
    }

    public static <K, V extends Comparable<V>> LazyMap<K, ArrayList<V>> convertToMultiMapSorted(final LazyMap<K, HashSet<V>> lazyMap) {
        return new LazyMap<K, ArrayList<V>>(){

            @Override
            protected ArrayList<V> generateValue(K key) {
                HashSet setVals = (HashSet)lazyMap.get(key);
                return setVals == null ? null : Utils.sortedCopy(setVals);
            }
        };
    }
}

