/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.AnnotationDAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classgraph.DAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.ImplementedInterfaceDAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.InterfaceDAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.StandardClassDAGNode;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LazyMap;
import io.github.lukehutch.fastclasspathscanner.utils.MultiSet;
import io.github.lukehutch.fastclasspathscanner.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassGraphBuilder {
    private final ScanSpec scanSpec;
    private final ArrayList<StandardClassDAGNode> standardClassNodes = new ArrayList();
    private final ArrayList<InterfaceDAGNode> interfaceNodes = new ArrayList();
    private final ArrayList<AnnotationDAGNode> annotationNodes = new ArrayList();
    private final HashMap<String, DAGNode> classNameToDAGNode = new HashMap();
    private final LazyMap<String, DAGNode> classNameToStandardClassNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (DAGNode classNode : ClassGraphBuilder.this.standardClassNodes) {
                this.map.put(classNode.name, classNode);
            }
        }
    };
    private final LazyMap<String, DAGNode> interfaceNameToInterfaceNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (DAGNode interfaceNode : ClassGraphBuilder.this.interfaceNodes) {
                this.map.put(interfaceNode.name, interfaceNode);
            }
        }
    };
    private final LazyMap<String, DAGNode> annotationNameToAnnotationNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (DAGNode annotationNode : ClassGraphBuilder.this.annotationNodes) {
                this.map.put(annotationNode.name, annotationNode);
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> namesOfAllClasses = this.removePlaceholdersAndSort((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, HashSet<String>>(){

        @Override
        protected HashSet<String> generateValue(String ignored) {
            return Utils.union(ClassGraphBuilder.this.classNameToStandardClassNode.keySet(), ClassGraphBuilder.this.interfaceNameToInterfaceNode.keySet(), ClassGraphBuilder.this.annotationNameToAnnotationNode.keySet());
        }
    });
    private final LazyMap<String, ArrayList<String>> namesOfAllStandardClasses = this.removePlaceholdersAndSort((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, Set<String>>(){

        @Override
        protected Set<String> generateValue(String ignored) {
            return ClassGraphBuilder.this.classNameToStandardClassNode.keySet();
        }
    });
    private final LazyMap<String, ArrayList<String>> namesOfAllInterfaceClasses = this.removePlaceholdersAndSort((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, Set<String>>(){

        @Override
        protected Set<String> generateValue(String ignored) {
            return ClassGraphBuilder.this.interfaceNameToInterfaceNode.keySet();
        }
    });
    private final LazyMap<String, ArrayList<String>> namesOfAllAnnotationClasses = this.removePlaceholdersAndSort((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, Set<String>>(){

        @Override
        protected Set<String> generateValue(String ignored) {
            return ClassGraphBuilder.this.annotationNameToAnnotationNode.keySet();
        }
    });
    private final LazyMap<String, ArrayList<String>> classNameToSubclassNames = this.removePlaceholdersAndSort((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String className) {
            DAGNode classNode = (DAGNode)ClassGraphBuilder.this.classNameToStandardClassNode.get(className);
            if (classNode == null) {
                return null;
            }
            ArrayList<String> subclasses = new ArrayList<String>(classNode.allSubNodes.size());
            for (DAGNode subNode : classNode.allSubNodes) {
                subclasses.add(subNode.name);
            }
            return subclasses;
        }
    });
    private final LazyMap<String, ArrayList<String>> classNameToSuperclassNames = this.removePlaceholdersAndSort((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String className) {
            DAGNode classNode = (DAGNode)ClassGraphBuilder.this.classNameToStandardClassNode.get(className);
            if (classNode == null) {
                return null;
            }
            ArrayList<String> superclasses = new ArrayList<String>(classNode.allSuperNodes.size());
            for (DAGNode superNode : classNode.allSuperNodes) {
                superclasses.add(superNode.name);
            }
            return superclasses;
        }
    });
    private final LazyMap<String, ArrayList<String>> fieldTypeToClassNames = this.removePlaceholdersAndSort(LazyMap.invertMultiSet(new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (StandardClassDAGNode node : ClassGraphBuilder.this.standardClassNodes) {
                if (node.whitelistedFieldTypeNodes.isEmpty()) continue;
                HashSet<String> fieldTypeNames = new HashSet<String>();
                for (DAGNode fieldType : node.whitelistedFieldTypeNodes) {
                    fieldTypeNames.add(fieldType.name);
                }
                this.map.put(node.name, fieldTypeNames);
            }
        }
    }));
    private final LazyMap<String, ArrayList<String>> interfaceNameToSubinterfaceNames = this.removePlaceholdersAndSort((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String interfaceName) {
            DAGNode interfaceNode = (DAGNode)ClassGraphBuilder.this.interfaceNameToInterfaceNode.get(interfaceName);
            if (interfaceNode == null) {
                return null;
            }
            ArrayList<String> subinterfaces = new ArrayList<String>(interfaceNode.allSubNodes.size());
            for (DAGNode subNode : interfaceNode.allSubNodes) {
                subinterfaces.add(subNode.name);
            }
            return subinterfaces;
        }
    });
    private final LazyMap<String, ArrayList<String>> interfaceNameToSuperinterfaceNames = this.removePlaceholdersAndSort((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String interfaceName) {
            DAGNode interfaceNode = (DAGNode)ClassGraphBuilder.this.interfaceNameToInterfaceNode.get(interfaceName);
            if (interfaceNode == null) {
                return null;
            }
            ArrayList<String> superinterfaces = new ArrayList<String>(interfaceNode.allSuperNodes.size());
            for (DAGNode superNode : interfaceNode.allSuperNodes) {
                superinterfaces.add(superNode.name);
            }
            return superinterfaces;
        }
    });
    private final LazyMap<String, HashSet<String>> interfaceNameToClassNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (StandardClassDAGNode classNode : ClassGraphBuilder.this.standardClassNodes) {
                ArrayList<ImplementedInterfaceDAGNode> interfaceNodes = classNode.implementedInterfaceClassNodes;
                for (DAGNode dAGNode : interfaceNodes) {
                    MultiSet.put(this.map, dAGNode.name, classNode.name);
                    for (DAGNode subclassNode : classNode.allSubNodes) {
                        MultiSet.put(this.map, dAGNode.name, subclassNode.name);
                    }
                    for (DAGNode superinterfaceNode : dAGNode.allSuperNodes) {
                        MultiSet.put(this.map, superinterfaceNode.name, classNode.name);
                        for (DAGNode subclassNode : classNode.allSubNodes) {
                            MultiSet.put(this.map, superinterfaceNode.name, subclassNode.name);
                        }
                    }
                }
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> interfaceNameToClassNames = this.removePlaceholdersAndSort(this.interfaceNameToClassNamesSet);
    private final LazyMap<String, HashSet<String>> annotationNameToAnnotatedClassNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        protected HashSet<String> generateValue(String annotationName) {
            DAGNode annotationNode = (DAGNode)ClassGraphBuilder.this.annotationNameToAnnotationNode.get(annotationName);
            if (annotationNode == null) {
                return null;
            }
            HashSet<String> classNames = new HashSet<String>();
            for (DAGNode crossLinkedNode : ((AnnotationDAGNode)annotationNode).annotatedClassNodes) {
                classNames.add(crossLinkedNode.name);
            }
            for (DAGNode subNode : annotationNode.allSubNodes) {
                for (DAGNode crossLinkedNode : ((AnnotationDAGNode)subNode).annotatedClassNodes) {
                    classNames.add(crossLinkedNode.name);
                }
            }
            return classNames;
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToAnnotatedClassNames = this.removePlaceholdersAndSort(this.annotationNameToAnnotatedClassNamesSet);
    private final LazyMap<String, ArrayList<String>> classNameToAnnotationNames = this.removePlaceholdersAndSort(LazyMap.invertMultiSet(this.annotationNameToAnnotatedClassNamesSet, this.annotationNameToAnnotationNode));
    private final LazyMap<String, HashSet<String>> metaAnnotationNameToAnnotatedAnnotationNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        protected HashSet<String> generateValue(String annotationName) {
            DAGNode annotationNode = (DAGNode)ClassGraphBuilder.this.annotationNameToAnnotationNode.get(annotationName);
            if (annotationNode == null) {
                return null;
            }
            HashSet<String> subNodes = new HashSet<String>();
            for (DAGNode subNode : annotationNode.allSubNodes) {
                subNodes.add(subNode.name);
            }
            return subNodes;
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToMetaAnnotationNames = this.removePlaceholdersAndSort(LazyMap.invertMultiSet(this.metaAnnotationNameToAnnotatedAnnotationNamesSet, this.annotationNameToAnnotationNode));
    private final LazyMap<String, ArrayList<String>> metaAnnotationNameToAnnotatedAnnotationNames = this.removePlaceholdersAndSort(this.metaAnnotationNameToAnnotatedAnnotationNamesSet);

    public ClassGraphBuilder(Collection<ClassInfo> classInfoFromScan, ScanSpec scanSpec) {
        DAGNode newNode;
        this.scanSpec = scanSpec;
        ArrayList<ClassInfo> allClassInfo = new ArrayList<ClassInfo>(Utils.mergeScalaAuxClasses(classInfoFromScan));
        HashSet<String> externalSuperclasses = new HashSet<String>();
        HashSet<String> externalInterfaces = new HashSet<String>();
        HashSet<String> externalAnnotations = new HashSet<String>();
        if (scanSpec.MATCH_REFERENCED_CLASSES) {
            ArrayList whitelistedClasses = new ArrayList();
            for (ClassInfo classInfo : allClassInfo) {
                if (classInfo.superclassNames != null) {
                    externalSuperclasses.addAll(classInfo.superclassNames);
                }
                if (classInfo.interfaceNames != null) {
                    externalInterfaces.addAll(classInfo.interfaceNames);
                }
                if (classInfo.annotationNames == null) continue;
                externalAnnotations.addAll(classInfo.annotationNames);
            }
            externalSuperclasses.removeAll(whitelistedClasses);
            externalInterfaces.removeAll(whitelistedClasses);
            externalAnnotations.removeAll(whitelistedClasses);
            externalAnnotations.removeAll(externalInterfaces);
            for (String externalSuperclassName : externalSuperclasses) {
                newNode = new StandardClassDAGNode(externalSuperclassName);
                this.classNameToDAGNode.put(externalSuperclassName, newNode);
                this.standardClassNodes.add((StandardClassDAGNode)newNode);
            }
            for (String externalInterfaceName : externalInterfaces) {
                newNode = new InterfaceDAGNode(externalInterfaceName);
                this.classNameToDAGNode.put(externalInterfaceName, newNode);
                this.interfaceNodes.add((InterfaceDAGNode)newNode);
            }
            for (String externalAnnotationName : externalAnnotations) {
                newNode = new AnnotationDAGNode(externalAnnotationName);
                this.classNameToDAGNode.put(externalAnnotationName, newNode);
                this.annotationNodes.add((AnnotationDAGNode)newNode);
            }
        }
        for (ClassInfo classInfo : allClassInfo) {
            String className = classInfo.className;
            if (classInfo.isAnnotation) {
                newNode = new AnnotationDAGNode(classInfo);
                this.classNameToDAGNode.put(className, newNode);
                this.annotationNodes.add((AnnotationDAGNode)newNode);
                continue;
            }
            if (classInfo.isInterface) {
                newNode = new InterfaceDAGNode(classInfo);
                this.classNameToDAGNode.put(className, newNode);
                this.interfaceNodes.add((InterfaceDAGNode)newNode);
                continue;
            }
            newNode = new StandardClassDAGNode(classInfo);
            this.classNameToDAGNode.put(className, newNode);
            this.standardClassNodes.add((StandardClassDAGNode)newNode);
        }
        for (DAGNode node : this.classNameToDAGNode.values()) {
            node.connect(this.classNameToDAGNode);
        }
        DAGNode.findTransitiveClosure(this.standardClassNodes);
        DAGNode.findTransitiveClosure(this.interfaceNodes);
        DAGNode.findTransitiveClosure(this.annotationNodes);
    }

    private LazyMap<String, ArrayList<String>> removePlaceholders(final LazyMap<String, ? extends Collection<String>> underlyingMap) {
        return new LazyMap<String, ArrayList<String>>(){

            @Override
            public ArrayList<String> get(String key) {
                Collection classNameList = (Collection)underlyingMap.get(key);
                if (classNameList == null) {
                    return null;
                }
                ArrayList<String> listWithoutPlaceholders = new ArrayList<String>();
                for (String className : classNameList) {
                    DAGNode dagNode = (DAGNode)ClassGraphBuilder.this.classNameToDAGNode.get(className);
                    if (dagNode.isPlaceholder && !ClassGraphBuilder.this.scanSpec.classIsWhitelisted(className)) continue;
                    listWithoutPlaceholders.add(dagNode.name);
                }
                return listWithoutPlaceholders;
            }
        };
    }

    private LazyMap<String, ArrayList<String>> removePlaceholdersAndSort(LazyMap<String, ? extends Collection<String>> underlyingMap) {
        return this.removePlaceholders(underlyingMap);
    }

    public List<String> getNamesOfAllClasses() {
        return this.namesOfAllClasses.get("");
    }

    public List<String> getNamesOfAllStandardClasses() {
        return this.namesOfAllStandardClasses.get("");
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return this.namesOfAllInterfaceClasses.get("");
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return this.namesOfAllAnnotationClasses.get("");
    }

    public List<String> getNamesOfSubclassesOf(String className) {
        ArrayList<String> subclassNames = this.classNameToSubclassNames.get(className);
        if (subclassNames == null) {
            return Collections.emptyList();
        }
        return subclassNames;
    }

    public List<String> getNamesOfSuperclassesOf(String className) {
        ArrayList<String> superclassNames = this.classNameToSuperclassNames.get(className);
        if (superclassNames == null) {
            return Collections.emptyList();
        }
        return superclassNames;
    }

    public List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        List classesWithFieldOfNamedType = this.fieldTypeToClassNames.get(fieldTypeName);
        if (classesWithFieldOfNamedType == null) {
            return Collections.emptyList();
        }
        return classesWithFieldOfNamedType;
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        ArrayList<String> subinterfaceNames = this.interfaceNameToSubinterfaceNames.get(interfaceName);
        if (subinterfaceNames == null) {
            return Collections.emptyList();
        }
        return subinterfaceNames;
    }

    public List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        ArrayList<String> superinterfaceNames = this.interfaceNameToSuperinterfaceNames.get(interfaceName);
        if (superinterfaceNames == null) {
            return Collections.emptyList();
        }
        return superinterfaceNames;
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        ArrayList<String> classes = this.interfaceNameToClassNames.get(interfaceName);
        if (classes == null) {
            return Collections.emptyList();
        }
        return classes;
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        ArrayList<String> classNames = this.annotationNameToAnnotatedClassNames.get(annotationName);
        if (classNames == null) {
            return Collections.emptyList();
        }
        return classNames;
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        ArrayList<String> annotationNames = this.classNameToAnnotationNames.get(classOrInterfaceName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        ArrayList<String> metaAnnotationNames = this.annotationNameToMetaAnnotationNames.get(annotationName);
        if (metaAnnotationNames == null) {
            return Collections.emptyList();
        }
        return metaAnnotationNames;
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        ArrayList<String> annotationNames = this.metaAnnotationNameToAnnotatedAnnotationNames.get(metaAnnotationName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }

    private static String label(DAGNode node) {
        String className = node.name;
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx < 0) {
            return className;
        }
        return className.substring(0, dotIdx + 1) + "\\n" + className.substring(dotIdx + 1);
    }

    public String generateClassGraphDotFile(float sizeX, float sizeY) {
        StringBuilder buf = new StringBuilder();
        buf.append("digraph {\n");
        buf.append("size=\"" + sizeX + "," + sizeY + "\";\n");
        buf.append("layout=dot;\n");
        buf.append("rankdir=\"BT\";\n");
        buf.append("overlap=false;\n");
        buf.append("splines=true;\n");
        buf.append("pack=true;\n");
        buf.append("\nnode[shape=box,style=filled,fillcolor=\"#fff2b6\"];\n");
        for (DAGNode dAGNode : this.standardClassNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\"\n");
        }
        buf.append("\nnode[shape=diamond,style=filled,fillcolor=\"#b6e7ff\"];\n");
        for (DAGNode dAGNode : this.interfaceNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\"\n");
        }
        buf.append("\nnode[shape=oval,style=filled,fillcolor=\"#f3c9ff\"];\n");
        for (DAGNode dAGNode : this.annotationNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\"\n");
        }
        buf.append("\n");
        for (StandardClassDAGNode standardClassDAGNode : this.standardClassNodes) {
            for (DAGNode dAGNode : standardClassDAGNode.directSuperNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(standardClassDAGNode) + "\" -> \"" + ClassGraphBuilder.label(dAGNode) + "\"\n");
            }
            for (DAGNode dAGNode : standardClassDAGNode.implementedInterfaceClassNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(standardClassDAGNode) + "\" -> \"" + ClassGraphBuilder.label(dAGNode) + "\" [arrowhead=diamond]\n");
            }
            for (DAGNode dAGNode : standardClassDAGNode.whitelistedFieldTypeNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\" -> \"" + ClassGraphBuilder.label(standardClassDAGNode) + "\" [arrowtail=obox, dir=back]\n");
            }
        }
        for (InterfaceDAGNode interfaceDAGNode : this.interfaceNodes) {
            for (DAGNode dAGNode : interfaceDAGNode.directSuperNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(interfaceDAGNode) + "\" -> \"" + ClassGraphBuilder.label(dAGNode) + "\" [arrowhead=diamond]\n");
            }
        }
        for (AnnotationDAGNode annotationDAGNode : this.annotationNodes) {
            for (DAGNode dAGNode : annotationDAGNode.directSuperNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(annotationDAGNode) + "\" -> \"" + ClassGraphBuilder.label(dAGNode) + "\" [arrowhead=dot]\n");
            }
            for (DAGNode dAGNode : annotationDAGNode.annotatedClassNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\" -> \"" + ClassGraphBuilder.label(annotationDAGNode) + "\" [arrowhead=dot]\n");
            }
        }
        buf.append("}");
        return buf.toString();
    }
}

