/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class Utils {
    public static boolean isJar(String path) {
        String pathLower = path.toLowerCase();
        return pathLower.endsWith(".jar") || pathLower.endsWith(".zip") || pathLower.endsWith(".war") || pathLower.endsWith(".car");
    }

    @SafeVarargs
    public static <T extends Comparable<T>> HashSet<T> union(Collection<T> ... collections) {
        HashSet<T> union = new HashSet<T>();
        for (Collection<T> collection : collections) {
            union.addAll(collection);
        }
        return union;
    }

    private static String scalaBaseClassName(String scalaClassName) {
        if (scalaClassName != null && scalaClassName.endsWith("$")) {
            return scalaClassName.substring(0, scalaClassName.length() - 1);
        }
        if (scalaClassName != null && scalaClassName.endsWith("$class")) {
            return scalaClassName.substring(0, scalaClassName.length() - 6);
        }
        return scalaClassName;
    }

    public static Collection<ClassInfo> mergeScalaAuxClasses(Collection<ClassInfo> classInfoFromScan) {
        HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
        ArrayList<ClassInfo> companionObjectClassInfo = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : classInfoFromScan) {
            int i;
            for (i = 0; i < classInfo.superclassNames.size(); ++i) {
                classInfo.superclassNames.set(i, Utils.scalaBaseClassName(classInfo.superclassNames.get(i)));
            }
            if (classInfo.interfaceNames != null) {
                for (i = 0; i < classInfo.interfaceNames.size(); ++i) {
                    classInfo.interfaceNames.set(i, Utils.scalaBaseClassName(classInfo.interfaceNames.get(i)));
                }
            }
            if (classInfo.annotationNames != null) {
                for (i = 0; i < classInfo.annotationNames.size(); ++i) {
                    classInfo.annotationNames.set(i, Utils.scalaBaseClassName(classInfo.annotationNames.get(i)));
                }
            }
            if (classInfo.className.endsWith("$") || classInfo.className.endsWith("$class")) {
                companionObjectClassInfo.add(classInfo);
                continue;
            }
            classNameToClassInfo.put(classInfo.className, classInfo);
        }
        for (ClassInfo companionClassInfo : companionObjectClassInfo) {
            String className;
            String classNameRaw = companionClassInfo.className;
            String string = className = classNameRaw.endsWith("$class") ? classNameRaw.substring(0, classNameRaw.length() - 6) : classNameRaw.substring(0, classNameRaw.length() - 1);
            if (!classNameToClassInfo.containsKey(className)) {
                companionClassInfo.className = className;
                classNameToClassInfo.put(className, companionClassInfo);
                continue;
            }
            ClassInfo baseClassInfo = (ClassInfo)classNameToClassInfo.get(className);
            baseClassInfo.isInterface |= companionClassInfo.isInterface;
            baseClassInfo.isAnnotation |= companionClassInfo.isAnnotation;
            baseClassInfo.superclassNames.addAll(companionClassInfo.superclassNames);
            if (baseClassInfo.interfaceNames == null) {
                baseClassInfo.interfaceNames = companionClassInfo.interfaceNames;
            } else if (companionClassInfo.interfaceNames != null) {
                baseClassInfo.interfaceNames.addAll(companionClassInfo.interfaceNames);
            }
            if (baseClassInfo.annotationNames == null) {
                baseClassInfo.annotationNames = companionClassInfo.annotationNames;
                continue;
            }
            if (companionClassInfo.annotationNames == null) continue;
            baseClassInfo.annotationNames.addAll(companionClassInfo.annotationNames);
        }
        return classNameToClassInfo.values();
    }
}

