/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecursiveScanner {
    private final ClasspathFinder classpathFinder;
    private final ScanSpec scanSpec;
    private final ArrayList<FilePathMatcher> filePathMatchers = new ArrayList();
    private long lastModified = 0L;
    private static final boolean USE_ZIPFILE_ENTRY_MODIFICATION_TIMES = false;

    public RecursiveScanner(ClasspathFinder classpathFinder, ScanSpec scanSpec) {
        this.classpathFinder = classpathFinder;
        this.scanSpec = scanSpec;
    }

    public void addFilePathMatcher(FilePathMatcher filePathMatcher) {
        this.filePathMatchers.add(filePathMatcher);
    }

    private void scanFile(File classpathElt, File file, String relativePath, boolean scanTimestampsOnly) {
        this.lastModified = Math.max(this.lastModified, file.lastModified());
        if (!scanTimestampsOnly) {
            long startTime = System.currentTimeMillis();
            boolean filePathMatches = false;
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                block17: {
                    if (!fileMatcher.filePathMatches(classpathElt, relativePath)) continue;
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        fileMatcher.processMatch(classpathElt, relativePath, inputStream, (int)file.length());
                    }
                    catch (IOException e) {
                        if (!FastClasspathScanner.verbose) break block17;
                        Log.log(e.getMessage() + " while processing file " + file.getPath());
                    }
                }
                filePathMatches = true;
            }
            if (FastClasspathScanner.verbose && filePathMatches) {
                Log.log("Scanned file " + relativePath + " in " + (System.currentTimeMillis() - startTime) + " msec");
            }
        }
    }

    private void scanZipfile(File classpathElt, ZipFile zipFile, String zipfilePath, String zipInternalRootPath, long zipFileLastModified, boolean scanTimestampsOnly) {
        if (FastClasspathScanner.verbose) {
            Log.log("Scanning jarfile: " + zipfilePath + (zipInternalRootPath.isEmpty() ? "" : " ; classpath root within jarfile: " + zipInternalRootPath));
        }
        long startTime = System.currentTimeMillis();
        boolean timestampWarning = false;
        String rootPrefix = zipInternalRootPath;
        if (rootPrefix.startsWith("/")) {
            rootPrefix = rootPrefix.substring(1);
        }
        if (!rootPrefix.isEmpty() && !rootPrefix.endsWith("/")) {
            rootPrefix = rootPrefix + "/";
        }
        int rootPrefixLen = rootPrefix.length();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String path = entry.getName();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (rootPrefixLen > 0) {
                if (!path.startsWith(rootPrefix)) continue;
                path = path.substring(rootPrefixLen);
            }
            if (!this.scanSpec.pathIsWhitelisted(path)) continue;
            long entryTime = zipFileLastModified;
            this.lastModified = Math.max(this.lastModified, entryTime);
            if (entryTime > System.currentTimeMillis() && !timestampWarning) {
                Log.log(zipfilePath + " contains modification timestamps after the current time");
                timestampWarning = true;
            }
            if (scanTimestampsOnly) continue;
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                if (!fileMatcher.filePathMatches(classpathElt, path)) continue;
                try {
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        fileMatcher.processMatch(classpathElt, path, inputStream, (int)entry.getSize());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(e.getMessage() + " while processing file " + entry.getName());
                }
            }
        }
        if (FastClasspathScanner.verbose) {
            Log.log("Scanned jarfile " + zipfilePath + " in " + (System.currentTimeMillis() - startTime) + " msec");
        }
    }

    private void scanZipfile(File classpathElt, String path, String zipInternalRootPath, boolean scanTimestampsOnly) {
        block17: {
            String jarName = classpathElt.getName();
            if (this.scanSpec.jarIsWhitelisted(jarName)) {
                try (ZipFile zipfile = new ZipFile(classpathElt);){
                    this.scanZipfile(classpathElt, zipfile, path, zipInternalRootPath, classpathElt.lastModified(), scanTimestampsOnly);
                    break block17;
                }
                catch (IOException e) {
                    if (FastClasspathScanner.verbose) {
                        Log.log("Error while opening zipfile " + classpathElt + " : " + e.toString());
                    }
                    break block17;
                }
            }
            if (FastClasspathScanner.verbose) {
                Log.log("Jarfile did not match whitelist/blacklist criteria: " + jarName);
            }
        }
    }

    private void scanDir(File classpathElt, File dir, int ignorePrefixLen, boolean inWhitelistedPath, boolean scanTimestampsOnly) {
        String relativePath = (ignorePrefixLen > dir.getPath().length() ? "" : dir.getPath().substring(ignorePrefixLen).replace(File.separatorChar, '/')) + "/";
        if (FastClasspathScanner.verbose) {
            Log.log("Scanning path: " + relativePath);
        }
        boolean keepRecursing = false;
        boolean atWhitelistedClassPackage = false;
        switch (this.scanSpec.pathWhitelistMatchStatus(relativePath)) {
            case WITHIN_BLACKLISTED_PATH: {
                if (FastClasspathScanner.verbose) {
                    Log.log("Reached blacklisted path: " + relativePath);
                }
                return;
            }
            case WITHIN_WHITELISTED_PATH: {
                if (FastClasspathScanner.verbose) {
                    Log.log("Reached whitelisted path: " + relativePath);
                }
                inWhitelistedPath = true;
                break;
            }
            case ANCESTOR_OF_WHITELISTED_PATH: {
                keepRecursing = true;
                break;
            }
            case AT_WHITELISTED_CLASS_PACKAGE: {
                atWhitelistedClassPackage = true;
                break;
            }
            case NOT_WITHIN_WHITELISTED_PATH: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown match status");
            }
        }
        if (keepRecursing || inWhitelistedPath || atWhitelistedClassPackage) {
            this.lastModified = Math.max(this.lastModified, dir.lastModified());
            File[] subFiles = dir.listFiles();
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    File subFileReal;
                    block19: {
                        subFileReal = null;
                        try {
                            subFileReal = subFile.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toFile();
                        }
                        catch (IOException | SecurityException e) {
                            if (!FastClasspathScanner.verbose) break block19;
                            Log.log("Could not access file " + subFile + ": " + e.getMessage());
                        }
                    }
                    if (subFileReal == null) continue;
                    if (subFileReal.isDirectory()) {
                        if (!inWhitelistedPath && !keepRecursing) continue;
                        this.scanDir(classpathElt, subFileReal, ignorePrefixLen, inWhitelistedPath, scanTimestampsOnly);
                        continue;
                    }
                    if (!subFileReal.isFile()) continue;
                    String subFileName = subFileReal.getName();
                    boolean fileIsWhitelisted = false;
                    if (inWhitelistedPath) {
                        fileIsWhitelisted = true;
                    } else if (atWhitelistedClassPackage && subFileName.endsWith(".class")) {
                        String className = (relativePath + subFileName.substring(0, subFileName.length() - 6)).replace('/', '.');
                        fileIsWhitelisted = this.scanSpec.classIsWhitelisted(className);
                    }
                    if (!fileIsWhitelisted) continue;
                    this.scanFile(classpathElt, subFileReal, relativePath.equals("/") ? subFileName : relativePath + subFileName, scanTimestampsOnly);
                }
            }
        }
    }

    private void scan(boolean scanTimestampsOnly) {
        ArrayList<File> uniqueClasspathElts = this.classpathFinder.getUniqueClasspathElements();
        if (FastClasspathScanner.verbose) {
            Log.log("*** Starting scan" + (scanTimestampsOnly ? " (scanning classpath timestamps only)" : "") + " ***");
        }
        for (File classpathElt : uniqueClasspathElts) {
            String path = classpathElt.getPath();
            if (FastClasspathScanner.verbose) {
                Log.log("=> Scanning classpath element: " + path);
            }
            if (!classpathElt.exists()) {
                String pathStr = classpathElt.getPath();
                int bangPos = pathStr.indexOf(33);
                if (bangPos > 0) {
                    File zipFile = Paths.get(pathStr.substring(0, bangPos), new String[0]).toFile();
                    String zipInternalRootPath = pathStr.substring(bangPos + 1).replace(File.separatorChar, '/');
                    if (zipFile.exists()) {
                        if (ClasspathFinder.isJar(path)) {
                            if (!this.scanSpec.scanJars) continue;
                            this.scanZipfile(zipFile, path, zipInternalRootPath, scanTimestampsOnly);
                            continue;
                        }
                        if (!FastClasspathScanner.verbose) continue;
                        Log.log("Not a jarfile, but illegal '!' character in classpath entry: " + pathStr);
                        continue;
                    }
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log("Jarfile on classpath no longer exists: " + zipFile);
                    continue;
                }
                if (!FastClasspathScanner.verbose) continue;
                Log.log("Classpath element no longer exists: " + path);
                continue;
            }
            if (classpathElt.isDirectory() && this.scanSpec.scanNonJars) {
                this.scanDir(classpathElt, classpathElt, path.length() + 1, false, scanTimestampsOnly);
                continue;
            }
            if (classpathElt.isFile()) {
                if (ClasspathFinder.isJar(path) && this.scanSpec.scanJars) {
                    this.scanZipfile(classpathElt, path, "", scanTimestampsOnly);
                    continue;
                }
                if (!this.scanSpec.scanNonJars) continue;
                this.scanFile(classpathElt, classpathElt, classpathElt.getName(), scanTimestampsOnly);
                continue;
            }
            if (!FastClasspathScanner.verbose) continue;
            Log.log("Skipping non-file/non-dir on classpath: " + classpathElt.getPath());
        }
    }

    public void scan() {
        this.scan(false);
    }

    public boolean classpathContentsModifiedSinceScan() {
        long oldLastModified = this.lastModified;
        if (oldLastModified == 0L) {
            return true;
        }
        this.scan(true);
        long newLastModified = this.lastModified;
        return newLastModified > oldLastModified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.lastModified;
    }

    public static class FilePathMatcher {
        private final FilePathTester filePathTester;
        private final FileMatchProcessorWithContext fileMatchProcessorWithContext;

        public FilePathMatcher(FilePathTester filePathTester, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessorWithContext = fileMatchProcessorWithContext;
        }

        public boolean filePathMatches(File classpathElt, String relativePath) {
            return this.filePathTester.filePathMatches(classpathElt, relativePath);
        }

        public void processMatch(File classpathElt, String relativePath, InputStream inputStream, int inputStreamLengthBytes) throws IOException {
            this.fileMatchProcessorWithContext.processMatch(classpathElt, relativePath, inputStream, inputStreamLengthBytes);
        }
    }

    public static interface FilePathTester {
        public boolean filePathMatches(File var1, String var2);
    }
}

