/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classgraph.DAGNode;
import io.github.lukehutch.fastclasspathscanner.utils.LazyMap;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMap;
import io.github.lukehutch.fastclasspathscanner.utils.MultiSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassGraphBuilder {
    private final ArrayList<ClassInfo> allClassInfo;
    private final LazyMap<String, DAGNode> classNameToClassNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (ClassInfo classInfo : ClassGraphBuilder.this.allClassInfo) {
                if (classInfo.isAnnotation || classInfo.isInterface) continue;
                DAGNode classNode = DAGNode.getOrNew(this.map, classInfo.className);
                if (classInfo.interfaceNames != null) {
                    for (String interfaceName : classInfo.interfaceNames) {
                        classNode.addCrossLink(interfaceName);
                    }
                }
                if (classInfo.superclassName == null) continue;
                DAGNode.getOrNew(this.map, classInfo.superclassName, classNode);
            }
            DAGNode.findTransitiveClosure(this.map.values());
        }
    };
    private final LazyMap<String, DAGNode> interfaceNameToInterfaceNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (ClassInfo classInfo : ClassGraphBuilder.this.allClassInfo) {
                if (!classInfo.isInterface) continue;
                DAGNode interfaceNode = DAGNode.getOrNew(this.map, classInfo.className);
                if (classInfo.interfaceNames == null) continue;
                for (String superInterfaceName : classInfo.interfaceNames) {
                    DAGNode.getOrNew(this.map, superInterfaceName, interfaceNode);
                }
            }
            DAGNode.findTransitiveClosure(this.map.values());
        }
    };
    private final LazyMap<String, DAGNode> annotationNameToAnnotationNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (ClassInfo classInfo : ClassGraphBuilder.this.allClassInfo) {
                if (classInfo.annotationNames == null) continue;
                for (String annotationName : classInfo.annotationNames) {
                    if (classInfo.isAnnotation) {
                        DAGNode.getOrNew(this.map, annotationName, DAGNode.getOrNew(this.map, classInfo.className));
                        continue;
                    }
                    DAGNode.getOrNew(this.map, annotationName).addCrossLink(classInfo.className);
                }
            }
            DAGNode.findTransitiveClosure(this.map.values());
        }
    };
    private final LazyMap<String, HashSet<String>> interfaceNameToClassNames = new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (DAGNode classNode : ClassGraphBuilder.this.classNameToClassNode.resolve().values()) {
                ArrayList<String> interfaceNames = classNode.crossLinkedClassNames;
                if (interfaceNames == null) continue;
                for (String interfaceName : interfaceNames) {
                    DAGNode interfaceNode = (DAGNode)ClassGraphBuilder.this.interfaceNameToInterfaceNode.resolve().get(interfaceName);
                    if (interfaceNode == null) continue;
                    MultiSet.put(this.map, interfaceName, classNode.name);
                    for (DAGNode subclassNode : classNode.allSubNodes) {
                        MultiSet.put(this.map, interfaceName, subclassNode.name);
                    }
                    for (DAGNode superinterfaceNode : interfaceNode.allSuperNodes) {
                        MultiSet.put(this.map, superinterfaceNode.name, classNode.name);
                        for (DAGNode subclassNode : classNode.allSubNodes) {
                            MultiSet.put(this.map, superinterfaceNode.name, subclassNode.name);
                        }
                    }
                }
            }
        }
    };
    private final LazyMap<String, HashSet<String>> annotationNameToAnnotatedClassNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (DAGNode annotationNode : ClassGraphBuilder.this.annotationNameToAnnotationNode.resolve().values()) {
                for (DAGNode subNode : annotationNode.allSubNodes) {
                    MultiSet.putAll(this.map, annotationNode.name, subNode.crossLinkedClassNames);
                }
                MultiSet.putAll(this.map, annotationNode.name, annotationNode.crossLinkedClassNames);
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToAnnotatedClassNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        public void initialize() {
            for (Map.Entry ent : ClassGraphBuilder.this.annotationNameToAnnotatedClassNamesSet.resolve().entrySet()) {
                MultiMap.putAll(this.map, ent.getKey(), (Iterable)ent.getValue());
            }
        }
    };
    private final LazyMap<String, HashSet<String>> annotationNameToAnnotatedAnnotationNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (DAGNode annotationNode : ClassGraphBuilder.this.annotationNameToAnnotationNode.resolve().values()) {
                for (DAGNode subNode : annotationNode.allSubNodes) {
                    MultiSet.put(this.map, annotationNode.name, subNode.name);
                }
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> classNameToAnnotationNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        public void initialize() {
            for (Map.Entry ent : MultiSet.invert(ClassGraphBuilder.this.annotationNameToAnnotatedClassNamesSet.resolve()).entrySet()) {
                MultiMap.putAll(this.map, ent.getKey(), ent.getValue());
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> metaAnnotationNameToAnnotatedAnnotationNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        public void initialize() {
            for (Map.Entry ent : ClassGraphBuilder.this.annotationNameToAnnotatedAnnotationNamesSet.resolve().entrySet()) {
                MultiMap.putAll(this.map, ent.getKey(), (Iterable)ent.getValue());
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToMetaAnnotationNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        public void initialize() {
            for (Map.Entry ent : MultiSet.invert(ClassGraphBuilder.this.annotationNameToAnnotatedAnnotationNamesSet.resolve()).entrySet()) {
                MultiMap.putAll(this.map, ent.getKey(), ent.getValue());
            }
        }
    };

    public ClassGraphBuilder(Collection<ClassInfo> relativePathToClassInfo) {
        this.allClassInfo = new ArrayList<ClassInfo>(relativePathToClassInfo);
    }

    public Set<String> getNamesOfAllClasses() {
        return this.classNameToClassNode.resolve().keySet();
    }

    public List<String> getNamesOfSubclassesOf(String className) {
        DAGNode classNode = this.classNameToClassNode.resolve().get(className);
        if (classNode == null) {
            return Collections.emptyList();
        }
        ArrayList<String> subclasses = new ArrayList<String>(classNode.allSubNodes.size());
        for (DAGNode subNode : classNode.allSubNodes) {
            subclasses.add(subNode.name);
        }
        return subclasses;
    }

    public List<String> getNamesOfSuperclassesOf(String className) {
        DAGNode classNode = this.classNameToClassNode.resolve().get(className);
        if (classNode == null) {
            return Collections.emptyList();
        }
        ArrayList<String> superclasses = new ArrayList<String>(classNode.allSuperNodes.size());
        for (DAGNode subNode : classNode.allSuperNodes) {
            superclasses.add(subNode.name);
        }
        return superclasses;
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        DAGNode interfaceNode = this.interfaceNameToInterfaceNode.resolve().get(interfaceName);
        if (interfaceNode == null) {
            return Collections.emptyList();
        }
        ArrayList<String> subinterfaces = new ArrayList<String>(interfaceNode.allSubNodes.size());
        for (DAGNode subNode : interfaceNode.allSubNodes) {
            subinterfaces.add(subNode.name);
        }
        return subinterfaces;
    }

    public List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        DAGNode interfaceNode = this.interfaceNameToInterfaceNode.resolve().get(interfaceName);
        if (interfaceNode == null) {
            return Collections.emptyList();
        }
        ArrayList<String> superinterfaces = new ArrayList<String>(interfaceNode.allSuperNodes.size());
        for (DAGNode superNode : interfaceNode.allSuperNodes) {
            superinterfaces.add(superNode.name);
        }
        return superinterfaces;
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        HashSet<String> classes = this.interfaceNameToClassNames.resolve().get(interfaceName);
        if (classes == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(classes);
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        ArrayList<String> annotationNames = this.classNameToAnnotationNames.resolve().get(classOrInterfaceName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        ArrayList<String> metaAnnotationNames = this.annotationNameToMetaAnnotationNames.resolve().get(annotationName);
        if (metaAnnotationNames == null) {
            return Collections.emptyList();
        }
        return metaAnnotationNames;
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        ArrayList<String> classNames = this.annotationNameToAnnotatedClassNames.resolve().get(annotationName);
        if (classNames == null) {
            return Collections.emptyList();
        }
        return classNames;
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        ArrayList<String> annotationNames = this.metaAnnotationNameToAnnotatedAnnotationNames.resolve().get(metaAnnotationName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }
}

