/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classfileparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClassInfo
implements Comparable<ClassInfo> {
    public String className;
    private boolean isInterface;
    private boolean isAnnotation;
    public boolean classfileScanned;
    private boolean companionObjectClassfileScanned;
    private boolean traitMethodClassfileScanned;
    public Map<RelType, HashSet<ClassInfo>> relatedTypeToClassInfoSet = new HashMap<RelType, HashSet<ClassInfo>>();
    public Map<String, Object> fieldValues;

    public ClassInfo(String className) {
        this.className = className;
    }

    public static List<ClassInfo> filterClassInfo(Collection<ClassInfo> classInfoColl, boolean removeExternalClasses, ClassType classType) {
        if (classInfoColl == null) {
            return Collections.emptyList();
        }
        ArrayList<ClassInfo> classInfoFiltered = new ArrayList<ClassInfo>(classInfoColl.size());
        for (ClassInfo classInfo : classInfoColl) {
            if (removeExternalClasses && !classInfo.classfileScanned || !(classType == ClassType.ALL || classType == ClassType.STANDARD_CLASS && classInfo.isStandardClass() || classType == ClassType.IMPLEMENTED_INTERFACE && classInfo.isImplementedInterface() || classType == ClassType.ANNOTATION && classInfo.isAnnotation()) && (classType != ClassType.INTERFACE_OR_ANNOTATION || !classInfo.isInterface && !classInfo.isAnnotation)) continue;
            classInfoFiltered.add(classInfo);
        }
        Collections.sort(classInfoFiltered);
        return classInfoFiltered;
    }

    public List<ClassInfo> getRelatedClasses(RelType relType, boolean removeExternalClasses, ClassType classType) {
        HashSet<ClassInfo> relatedClassClassInfo = this.relatedTypeToClassInfoSet.get((Object)relType);
        if (relatedClassClassInfo == null) {
            return Collections.emptyList();
        }
        return ClassInfo.filterClassInfo(relatedClassClassInfo, removeExternalClasses, classType);
    }

    public List<ClassInfo> getRelatedClasses(RelType relType) {
        return this.getRelatedClasses(relType, false, ClassType.ALL);
    }

    public static List<String> getClassNamesFiltered(Collection<ClassInfo> classInfoColl, boolean removeExternalClasses, ClassType classType) {
        List<ClassInfo> filtered = ClassInfo.filterClassInfo(classInfoColl, removeExternalClasses, classType);
        if (filtered.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> classNames = new ArrayList<String>(filtered.size());
        for (ClassInfo classInfo : filtered) {
            classNames.add(classInfo.className);
        }
        return classNames;
    }

    public List<String> getRelatedClassNames(RelType relType, boolean removeExternalClasses, ClassType classType) {
        return ClassInfo.getClassNamesFiltered((Collection<ClassInfo>)this.relatedTypeToClassInfoSet.get((Object)relType), removeExternalClasses, classType);
    }

    public List<String> getRelatedClassNames(RelType relType) {
        return this.getRelatedClassNames(relType, false, ClassType.ALL);
    }

    public boolean addRelatedClass(RelType relType, ClassInfo classInfo) {
        HashSet<ClassInfo> classInfoSet = this.relatedTypeToClassInfoSet.get((Object)relType);
        if (classInfoSet == null) {
            classInfoSet = new HashSet(4);
            this.relatedTypeToClassInfoSet.put(relType, classInfoSet);
        }
        return classInfoSet.add(classInfo);
    }

    public boolean addRelatedClasses(RelType relType, Collection<ClassInfo> classInfoSetToAdd) {
        if (classInfoSetToAdd.isEmpty()) {
            return false;
        }
        HashSet<ClassInfo> classInfoSet = this.relatedTypeToClassInfoSet.get((Object)relType);
        if (classInfoSet == null) {
            classInfoSet = new HashSet(classInfoSetToAdd.size() + 4);
            this.relatedTypeToClassInfoSet.put(relType, classInfoSet);
        }
        return classInfoSet.addAll(classInfoSetToAdd);
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isImplementedInterface() {
        return !this.getRelatedClasses(RelType.CLASSES_IMPLEMENTING).isEmpty() || this.isInterface && !this.isAnnotation;
    }

    public boolean isStandardClass() {
        return !this.isAnnotation && (!this.getRelatedClasses(RelType.SUBCLASSES).isEmpty() || !this.getRelatedClasses(RelType.SUPERCLASSES).isEmpty() || !this.isImplementedInterface());
    }

    private static String scalaBaseClassName(String className) {
        if (className != null && className.endsWith("$")) {
            return className.substring(0, className.length() - 1);
        }
        if (className != null && className.endsWith("$class")) {
            return className.substring(0, className.length() - 6);
        }
        return className;
    }

    private static ClassInfo getOrCreateClassInfo(String className, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo classInfo = classNameToClassInfo.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className);
            classNameToClassInfo.put(className, classInfo);
        }
        return classInfo;
    }

    public void addSuperclass(String superclassName, Map<String, ClassInfo> classNameToClassInfo) {
        if (superclassName != null && !"java.lang.Object".equals(superclassName)) {
            ClassInfo superclassClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(superclassName), classNameToClassInfo);
            this.addRelatedClass(RelType.SUPERCLASSES, superclassClassInfo);
            superclassClassInfo.addRelatedClass(RelType.SUBCLASSES, this);
        }
    }

    public void addAnnotation(String annotationName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(annotationName), classNameToClassInfo);
        annotationClassInfo.isAnnotation = true;
        this.addRelatedClass(RelType.ANNOTATIONS, annotationClassInfo);
        annotationClassInfo.addRelatedClass(RelType.ANNOTATED_CLASSES, this);
    }

    public void addImplementedInterface(String interfaceName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo interfaceClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(interfaceName), classNameToClassInfo);
        interfaceClassInfo.isInterface = true;
        this.addRelatedClass(RelType.IMPLEMENTED_INTERFACES, interfaceClassInfo);
        interfaceClassInfo.addRelatedClass(RelType.CLASSES_IMPLEMENTING, this);
    }

    public void addFieldType(String fieldTypeName, Map<String, ClassInfo> classNameToClassInfo) {
        String fieldTypeBaseName = ClassInfo.scalaBaseClassName(fieldTypeName);
        ClassInfo fieldTypeClassInfo = ClassInfo.getOrCreateClassInfo(fieldTypeBaseName, classNameToClassInfo);
        this.addRelatedClass(RelType.FIELD_TYPES, fieldTypeClassInfo);
    }

    public void addFieldConstantValue(String fieldName, Object constValue) {
        if (this.fieldValues == null) {
            this.fieldValues = new HashMap<String, Object>();
        }
        this.fieldValues.put(fieldName, constValue);
    }

    public static ClassInfo addScannedClass(String className, boolean isInterface, boolean isAnnotation, Map<String, ClassInfo> classNameToClassInfo) {
        boolean isCompanionObjectClass = className.endsWith("$");
        boolean isTraitMethodClass = className.endsWith("$class");
        boolean isNonAuxClass = !isCompanionObjectClass && !isTraitMethodClass;
        String classBaseName = ClassInfo.scalaBaseClassName(className);
        ClassInfo classInfo = classNameToClassInfo.get(classBaseName);
        if (classInfo == null) {
            classInfo = new ClassInfo(classBaseName);
            classNameToClassInfo.put(classBaseName, classInfo);
        } else if (isNonAuxClass && classInfo.classfileScanned || isCompanionObjectClass && classInfo.companionObjectClassfileScanned || isTraitMethodClass && classInfo.traitMethodClassfileScanned) {
            return null;
        }
        if (isTraitMethodClass) {
            classInfo.traitMethodClassfileScanned = true;
        } else if (isCompanionObjectClass) {
            classInfo.companionObjectClassfileScanned = true;
        } else {
            classInfo.classfileScanned = true;
        }
        classInfo.isInterface |= isInterface;
        classInfo.isAnnotation |= isAnnotation;
        return classInfo;
    }

    @Override
    public int compareTo(ClassInfo o) {
        return this.className.compareTo(o.className);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            ClassInfo other = (ClassInfo)obj;
            return this.className != null ? this.className.equals(other.className) : other.className == null;
        }
        return false;
    }

    public int hashCode() {
        return this.className != null ? this.className.hashCode() : 33;
    }

    public String toString() {
        return this.className;
    }

    public static enum ClassType {
        ALL,
        STANDARD_CLASS,
        IMPLEMENTED_INTERFACE,
        ANNOTATION,
        INTERFACE_OR_ANNOTATION;

    }

    public static enum RelType {
        SUPERCLASSES,
        ALL_SUPERCLASSES,
        SUBCLASSES,
        ALL_SUBCLASSES,
        IMPLEMENTED_INTERFACES,
        ALL_IMPLEMENTED_INTERFACES,
        CLASSES_IMPLEMENTING,
        ALL_CLASSES_IMPLEMENTING,
        ALL_STANDARD_CLASSES_IMPLEMENTING,
        ALL_SUBINTERFACES,
        ANNOTATIONS,
        ALL_ANNOTATIONS,
        ANNOTATED_CLASSES,
        ALL_ANNOTATED_CLASSES,
        ALL_ANNOTATED_STANDARD_CLASSES_OR_INTERFACES,
        FIELD_TYPES,
        CLASSES_WITH_FIELD_OF_TYPE;

    }
}

