/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClassGraphBuilder {
    private final Map<String, ClassInfo> classNameToClassInfo;

    public ClassGraphBuilder(Map<String, ClassInfo> classNameToClassInfo) {
        this.classNameToClassInfo = classNameToClassInfo;
        ArrayList<ClassInfo> allClassInfo = new ArrayList<ClassInfo>(classNameToClassInfo.values());
        ClassGraphBuilder.findTransitiveClosure(allClassInfo, ClassInfo.RelType.SUPERCLASSES, ClassInfo.RelType.SUBCLASSES, ClassInfo.RelType.ALL_SUBCLASSES);
        ClassGraphBuilder.findTransitiveClosure(allClassInfo, ClassInfo.RelType.SUBCLASSES, ClassInfo.RelType.SUPERCLASSES, ClassInfo.RelType.ALL_SUPERCLASSES);
        ClassGraphBuilder.findTransitiveClosure(allClassInfo, ClassInfo.RelType.IMPLEMENTED_INTERFACES, ClassInfo.RelType.CLASSES_IMPLEMENTING, ClassInfo.RelType.ALL_CLASSES_IMPLEMENTING);
        ClassGraphBuilder.findTransitiveClosure(allClassInfo, ClassInfo.RelType.CLASSES_IMPLEMENTING, ClassInfo.RelType.IMPLEMENTED_INTERFACES, ClassInfo.RelType.ALL_IMPLEMENTED_INTERFACES);
        ClassGraphBuilder.findTransitiveClosure(allClassInfo, ClassInfo.RelType.ANNOTATIONS, ClassInfo.RelType.ANNOTATED_CLASSES, ClassInfo.RelType.ALL_ANNOTATED_CLASSES);
        ClassGraphBuilder.findTransitiveClosure(allClassInfo, ClassInfo.RelType.ANNOTATED_CLASSES, ClassInfo.RelType.ANNOTATIONS, ClassInfo.RelType.ALL_ANNOTATIONS);
        for (ClassInfo classInfo : allClassInfo) {
            if (classInfo.isImplementedInterface()) {
                for (ClassInfo classInfo2 : classInfo.getRelatedClasses(ClassInfo.RelType.CLASSES_IMPLEMENTING)) {
                    List<ClassInfo> allSuperInterfaces = classInfo.getRelatedClasses(ClassInfo.RelType.ALL_IMPLEMENTED_INTERFACES);
                    List<ClassInfo> allSubClasses = classInfo2.getRelatedClasses(ClassInfo.RelType.ALL_SUBCLASSES);
                    for (ClassInfo superInterface : allSuperInterfaces) {
                        superInterface.addRelatedClass(ClassInfo.RelType.ALL_CLASSES_IMPLEMENTING, classInfo2);
                        classInfo2.addRelatedClass(ClassInfo.RelType.ALL_IMPLEMENTED_INTERFACES, superInterface);
                    }
                    for (ClassInfo subClass : allSubClasses) {
                        classInfo.addRelatedClass(ClassInfo.RelType.ALL_CLASSES_IMPLEMENTING, subClass);
                        subClass.addRelatedClass(ClassInfo.RelType.ALL_IMPLEMENTED_INTERFACES, classInfo);
                    }
                    for (ClassInfo superInterface : allSuperInterfaces) {
                        for (ClassInfo subClass : allSubClasses) {
                            superInterface.addRelatedClass(ClassInfo.RelType.ALL_CLASSES_IMPLEMENTING, subClass);
                            subClass.addRelatedClass(ClassInfo.RelType.ALL_IMPLEMENTED_INTERFACES, superInterface);
                        }
                    }
                }
            }
            for (ClassInfo classInfo3 : classInfo.getRelatedClasses(ClassInfo.RelType.ALL_CLASSES_IMPLEMENTING)) {
                if (classInfo3.isImplementedInterface()) {
                    classInfo.addRelatedClass(ClassInfo.RelType.ALL_SUBINTERFACES, classInfo3);
                    continue;
                }
                if (!classInfo3.isStandardClass()) continue;
                classInfo.addRelatedClass(ClassInfo.RelType.ALL_STANDARD_CLASSES_IMPLEMENTING, classInfo3);
            }
            for (ClassInfo classInfo4 : classInfo.getRelatedClasses(ClassInfo.RelType.ALL_ANNOTATED_CLASSES)) {
                if (classInfo4.isAnnotation()) continue;
                classInfo.addRelatedClass(ClassInfo.RelType.ALL_ANNOTATED_STANDARD_CLASSES_OR_INTERFACES, classInfo4);
            }
            List<ClassInfo> fieldTypes = classInfo.getRelatedClasses(ClassInfo.RelType.FIELD_TYPES);
            if (fieldTypes.isEmpty()) continue;
            for (ClassInfo fieldType : fieldTypes) {
                classInfo.addRelatedClasses(ClassInfo.RelType.FIELD_TYPES, fieldType.getRelatedClasses(ClassInfo.RelType.ALL_SUPERCLASSES));
                classInfo.addRelatedClasses(ClassInfo.RelType.FIELD_TYPES, fieldType.getRelatedClasses(ClassInfo.RelType.ALL_IMPLEMENTED_INTERFACES));
            }
        }
        for (ClassInfo classInfo : allClassInfo) {
            for (ClassInfo classInfo5 : classInfo.getRelatedClasses(ClassInfo.RelType.FIELD_TYPES)) {
                classInfo5.addRelatedClass(ClassInfo.RelType.CLASSES_WITH_FIELD_OF_TYPE, classInfo);
            }
        }
    }

    private static void findTransitiveClosure(ArrayList<ClassInfo> allNodes, ClassInfo.RelType directForwardLinkType, ClassInfo.RelType directBackLinkType, ClassInfo.RelType reachableBackLinkTypeToBuild) {
        HashSet<ClassInfo> activeNodes = new HashSet<ClassInfo>();
        for (ClassInfo node : allNodes) {
            List<ClassInfo> directBackLinks = node.getRelatedClasses(directBackLinkType);
            if (!directBackLinks.isEmpty()) continue;
            activeNodes.addAll(node.getRelatedClasses(directForwardLinkType));
        }
        while (!activeNodes.isEmpty()) {
            HashSet<ClassInfo> activeNodesNext = new HashSet<ClassInfo>(activeNodes.size());
            for (ClassInfo node : activeNodes) {
                List<ClassInfo> directBackLinks = node.getRelatedClasses(directBackLinkType);
                boolean changed = node.addRelatedClasses(reachableBackLinkTypeToBuild, directBackLinks);
                for (ClassInfo directBackLink : directBackLinks) {
                    List<ClassInfo> reachableBacklinksOfBacklink = directBackLink.getRelatedClasses(reachableBackLinkTypeToBuild);
                    changed |= node.addRelatedClasses(reachableBackLinkTypeToBuild, reachableBacklinksOfBacklink);
                }
                if (!changed) continue;
                List<ClassInfo> forwardRelatedClasses = node.getRelatedClasses(directForwardLinkType);
                activeNodesNext.addAll(forwardRelatedClasses);
            }
            activeNodes = activeNodesNext;
        }
    }

    private List<String> getRelatedClassNames(String className, ClassInfo.RelType relType, boolean removeExternalClasses, ClassInfo.ClassType classType) {
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        return classInfo == null ? Collections.emptyList() : classInfo.getRelatedClassNames(relType, removeExternalClasses, classType);
    }

    public List<String> getNamesOfAllClasses() {
        return ClassInfo.getClassNamesFiltered(this.classNameToClassInfo.values(), true, ClassInfo.ClassType.ALL);
    }

    public List<String> getNamesOfAllStandardClasses() {
        return ClassInfo.getClassNamesFiltered(this.classNameToClassInfo.values(), true, ClassInfo.ClassType.STANDARD_CLASS);
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return ClassInfo.getClassNamesFiltered(this.classNameToClassInfo.values(), true, ClassInfo.ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return ClassInfo.getClassNamesFiltered(this.classNameToClassInfo.values(), true, ClassInfo.ClassType.ANNOTATION);
    }

    public List<String> getNamesOfSubclassesOf(String className) {
        return this.getRelatedClassNames(className, ClassInfo.RelType.ALL_SUBCLASSES, true, ClassInfo.ClassType.ALL);
    }

    public List<String> getNamesOfSuperclassesOf(String className) {
        return this.getRelatedClassNames(className, ClassInfo.RelType.ALL_SUPERCLASSES, true, ClassInfo.ClassType.ALL);
    }

    public List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        return this.getRelatedClassNames(fieldTypeName, ClassInfo.RelType.CLASSES_WITH_FIELD_OF_TYPE, true, ClassInfo.ClassType.ALL);
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        return this.getRelatedClassNames(interfaceName, ClassInfo.RelType.ALL_CLASSES_IMPLEMENTING, true, ClassInfo.ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        return this.getRelatedClassNames(interfaceName, ClassInfo.RelType.ALL_IMPLEMENTED_INTERFACES, true, ClassInfo.ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        return this.getRelatedClassNames(interfaceName, ClassInfo.RelType.ALL_CLASSES_IMPLEMENTING, true, ClassInfo.ClassType.STANDARD_CLASS);
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        return this.getRelatedClassNames(annotationName, ClassInfo.RelType.ALL_ANNOTATED_STANDARD_CLASSES_OR_INTERFACES, true, ClassInfo.ClassType.ALL);
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        return this.getRelatedClassNames(classOrInterfaceName, ClassInfo.RelType.ALL_ANNOTATIONS, true, ClassInfo.ClassType.ALL);
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        return this.getRelatedClassNames(annotationName, ClassInfo.RelType.ALL_ANNOTATIONS, true, ClassInfo.ClassType.ALL);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        return this.getRelatedClassNames(metaAnnotationName, ClassInfo.RelType.ALL_ANNOTATIONS, true, ClassInfo.ClassType.ANNOTATION);
    }

    private static String label(ClassInfo node) {
        String className = node.className;
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx < 0) {
            return className;
        }
        return className.substring(0, dotIdx + 1) + "\\n" + className.substring(dotIdx + 1);
    }

    public String generateClassGraphDotFile(float sizeX, float sizeY) {
        StringBuilder buf = new StringBuilder();
        buf.append("digraph {\n");
        buf.append("size=\"" + sizeX + "," + sizeY + "\";\n");
        buf.append("layout=dot;\n");
        buf.append("rankdir=\"BT\";\n");
        buf.append("overlap=false;\n");
        buf.append("splines=true;\n");
        buf.append("pack=true;\n");
        Collection<ClassInfo> allClassInfo = this.classNameToClassInfo.values();
        List<ClassInfo> standardClassNodes = ClassInfo.filterClassInfo(allClassInfo, false, ClassInfo.ClassType.STANDARD_CLASS);
        List<ClassInfo> interfaceNodes = ClassInfo.filterClassInfo(allClassInfo, false, ClassInfo.ClassType.IMPLEMENTED_INTERFACE);
        List<ClassInfo> annotationNodes = ClassInfo.filterClassInfo(allClassInfo, false, ClassInfo.ClassType.ANNOTATION);
        buf.append("\nnode[shape=box,style=filled,fillcolor=\"#fff2b6\"];\n");
        for (ClassInfo node : standardClassNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\nnode[shape=diamond,style=filled,fillcolor=\"#b6e7ff\"];\n");
        for (ClassInfo node : interfaceNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\nnode[shape=oval,style=filled,fillcolor=\"#f3c9ff\"];\n");
        for (ClassInfo node : annotationNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\n");
        for (ClassInfo classNode : standardClassNodes) {
            for (ClassInfo superclassNode : classNode.getRelatedClasses(ClassInfo.RelType.SUPERCLASSES, false, ClassInfo.ClassType.ALL)) {
                buf.append("  \"" + ClassGraphBuilder.label(classNode) + "\" -> \"" + ClassGraphBuilder.label(superclassNode) + "\"\n");
            }
            for (ClassInfo implementedInterfaceNode : classNode.getRelatedClasses(ClassInfo.RelType.IMPLEMENTED_INTERFACES, false, ClassInfo.ClassType.ALL)) {
                buf.append("  \"" + ClassGraphBuilder.label(classNode) + "\" -> \"" + ClassGraphBuilder.label(implementedInterfaceNode) + "\" [arrowhead=diamond]\n");
            }
            for (ClassInfo fieldTypeNode : classNode.getRelatedClasses(ClassInfo.RelType.FIELD_TYPES, false, ClassInfo.ClassType.ALL)) {
                buf.append("  \"" + ClassGraphBuilder.label(fieldTypeNode) + "\" -> \"" + ClassGraphBuilder.label(classNode) + "\" [arrowtail=obox, dir=back]\n");
            }
        }
        for (ClassInfo interfaceNode : interfaceNodes) {
            for (ClassInfo superinterfaceNode : interfaceNode.getRelatedClasses(ClassInfo.RelType.IMPLEMENTED_INTERFACES, false, ClassInfo.ClassType.ALL)) {
                buf.append("  \"" + ClassGraphBuilder.label(interfaceNode) + "\" -> \"" + ClassGraphBuilder.label(superinterfaceNode) + "\" [arrowhead=diamond]\n");
            }
        }
        for (ClassInfo annotationNode : annotationNodes) {
            for (ClassInfo metaAnnotationNode : annotationNode.getRelatedClasses(ClassInfo.RelType.ANNOTATIONS, false, ClassInfo.ClassType.ALL)) {
                buf.append("  \"" + ClassGraphBuilder.label(annotationNode) + "\" -> \"" + ClassGraphBuilder.label(metaAnnotationNode) + "\" [arrowhead=dot]\n");
            }
            for (ClassInfo annotatedClassNode : annotationNode.getRelatedClasses(ClassInfo.RelType.ANNOTATIONS, false, ClassInfo.ClassType.ALL)) {
                buf.append("  \"" + ClassGraphBuilder.label(annotatedClassNode) + "\" -> \"" + ClassGraphBuilder.label(annotationNode) + "\" [arrowhead=dot]\n");
            }
        }
        buf.append("}");
        return buf.toString();
    }
}

