/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classfileparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassInfo
implements Comparable<ClassInfo> {
    public String className;
    private boolean isInterface;
    private boolean isAnnotation;
    public boolean classfileScanned;
    private boolean companionObjectClassfileScanned;
    private boolean traitMethodClassfileScanned;
    public Map<RelType, Set<ClassInfo>> relatedTypeToClassInfoSet = new HashMap<RelType, Set<ClassInfo>>();
    public Map<String, Object> fieldValues;

    public ClassInfo(String className) {
        this.className = className;
    }

    public static Set<ClassInfo> filterClassInfo(Set<ClassInfo> classInfoSet, boolean removeExternalClasses, ClassType ... classTypes) {
        if (classInfoSet == null) {
            return Collections.emptySet();
        }
        boolean includeAllTypes = classTypes.length == 0;
        boolean includeStandardClasses = false;
        boolean includeImplementedInterfaces = false;
        boolean includeAnnotations = false;
        block7: for (ClassType classType : classTypes) {
            switch (classType) {
                case ALL: {
                    includeAllTypes = true;
                    continue block7;
                }
                case STANDARD_CLASS: {
                    includeStandardClasses = true;
                    continue block7;
                }
                case IMPLEMENTED_INTERFACE: {
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                case ANNOTATION: {
                    includeAnnotations = true;
                    continue block7;
                }
                case INTERFACE_OR_ANNOTATION: {
                    includeAnnotations = true;
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unknown ClassType: " + (Object)((Object)classType));
                }
            }
        }
        if (includeStandardClasses && includeImplementedInterfaces && includeAnnotations) {
            includeAllTypes = true;
        }
        boolean hasFilteredOutClass = false;
        for (ClassInfo classInfo : classInfoSet) {
            if ((!removeExternalClasses || classInfo.classfileScanned) && (includeAllTypes || includeStandardClasses && classInfo.isStandardClass() || includeImplementedInterfaces && classInfo.isImplementedInterface() || includeAnnotations && classInfo.isAnnotation())) continue;
            hasFilteredOutClass = true;
            break;
        }
        if (!hasFilteredOutClass) {
            return classInfoSet;
        }
        HashSet<ClassInfo> classInfoSetFiltered = new HashSet<ClassInfo>(classInfoSet.size());
        for (ClassInfo classInfo : classInfoSet) {
            if (removeExternalClasses && !classInfo.classfileScanned || !(includeAllTypes || includeStandardClasses && classInfo.isStandardClass() || includeImplementedInterfaces && classInfo.isImplementedInterface()) && (!includeAnnotations || !classInfo.isAnnotation())) continue;
            classInfoSetFiltered.add(classInfo);
        }
        return classInfoSetFiltered;
    }

    public Set<ClassInfo> getRelatedClasses(RelType relType, boolean removeExternalClasses, ClassType ... classTypes) {
        Set<ClassInfo> relatedClassClassInfo = this.relatedTypeToClassInfoSet.get((Object)relType);
        if (relatedClassClassInfo == null) {
            return Collections.emptySet();
        }
        return ClassInfo.filterClassInfo(relatedClassClassInfo, removeExternalClasses, classTypes);
    }

    public Set<ClassInfo> getRelatedClasses(RelType relType) {
        return this.getRelatedClasses(relType, false, ClassType.ALL);
    }

    public static List<String> getClassNamesFiltered(Set<ClassInfo> classInfoColl, boolean removeExternalClasses, ClassType ... classTypes) {
        Set<ClassInfo> filteredClasses = ClassInfo.filterClassInfo(classInfoColl, removeExternalClasses, classTypes);
        return ClassInfo.getClassNames(filteredClasses);
    }

    public static List<String> getClassNames(Collection<ClassInfo> classInfoColl) {
        if (classInfoColl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> classNames = new ArrayList<String>(classInfoColl.size());
        for (ClassInfo classInfo : classInfoColl) {
            classNames.add(classInfo.className);
        }
        Collections.sort(classNames);
        return classNames;
    }

    public List<String> getRelatedClassNames(RelType relType, boolean removeExternalClasses, ClassType ... classTypes) {
        return ClassInfo.getClassNamesFiltered(this.relatedTypeToClassInfoSet.get((Object)relType), removeExternalClasses, classTypes);
    }

    public List<String> getRelatedClassNames(RelType relType) {
        return this.getRelatedClassNames(relType, false, ClassType.ALL);
    }

    public boolean addRelatedClass(RelType relType, ClassInfo classInfo) {
        Set<ClassInfo> classInfoSet = this.relatedTypeToClassInfoSet.get((Object)relType);
        if (classInfoSet == null) {
            classInfoSet = new HashSet<ClassInfo>(4);
            this.relatedTypeToClassInfoSet.put(relType, classInfoSet);
        }
        return classInfoSet.add(classInfo);
    }

    public boolean addRelatedClasses(RelType relType, Collection<ClassInfo> classInfoSetToAdd) {
        if (classInfoSetToAdd.isEmpty()) {
            return false;
        }
        Set<ClassInfo> classInfoSet = this.relatedTypeToClassInfoSet.get((Object)relType);
        if (classInfoSet == null) {
            classInfoSet = new HashSet<ClassInfo>(classInfoSetToAdd.size() + 4);
            this.relatedTypeToClassInfoSet.put(relType, classInfoSet);
        }
        return classInfoSet.addAll(classInfoSetToAdd);
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isImplementedInterface() {
        return !this.getRelatedClasses(RelType.CLASSES_IMPLEMENTING).isEmpty() || this.isInterface && !this.isAnnotation;
    }

    public boolean isStandardClass() {
        return !this.isAnnotation && (!this.getRelatedClasses(RelType.SUBCLASSES).isEmpty() || !this.getRelatedClasses(RelType.SUPERCLASSES).isEmpty() || !this.isImplementedInterface());
    }

    private static String scalaBaseClassName(String className) {
        if (className != null && className.endsWith("$")) {
            return className.substring(0, className.length() - 1);
        }
        if (className != null && className.endsWith("$class")) {
            return className.substring(0, className.length() - 6);
        }
        return className;
    }

    private static ClassInfo getOrCreateClassInfo(String className, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo classInfo = classNameToClassInfo.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className);
            classNameToClassInfo.put(className, classInfo);
        }
        return classInfo;
    }

    public void addSuperclass(String superclassName, Map<String, ClassInfo> classNameToClassInfo) {
        if (superclassName != null && !"java.lang.Object".equals(superclassName)) {
            ClassInfo superclassClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(superclassName), classNameToClassInfo);
            this.addRelatedClass(RelType.SUPERCLASSES, superclassClassInfo);
            superclassClassInfo.addRelatedClass(RelType.SUBCLASSES, this);
        }
    }

    public void addAnnotation(String annotationName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(annotationName), classNameToClassInfo);
        annotationClassInfo.isAnnotation = true;
        this.addRelatedClass(RelType.ANNOTATIONS, annotationClassInfo);
        annotationClassInfo.addRelatedClass(RelType.ANNOTATED_CLASSES, this);
    }

    public void addImplementedInterface(String interfaceName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo interfaceClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(interfaceName), classNameToClassInfo);
        interfaceClassInfo.isInterface = true;
        this.addRelatedClass(RelType.IMPLEMENTED_INTERFACES, interfaceClassInfo);
        interfaceClassInfo.addRelatedClass(RelType.CLASSES_IMPLEMENTING, this);
    }

    public void addFieldType(String fieldTypeName, Map<String, ClassInfo> classNameToClassInfo) {
        String fieldTypeBaseName = ClassInfo.scalaBaseClassName(fieldTypeName);
        ClassInfo fieldTypeClassInfo = ClassInfo.getOrCreateClassInfo(fieldTypeBaseName, classNameToClassInfo);
        this.addRelatedClass(RelType.FIELD_TYPES, fieldTypeClassInfo);
    }

    public void addFieldConstantValue(String fieldName, Object constValue) {
        if (this.fieldValues == null) {
            this.fieldValues = new HashMap<String, Object>();
        }
        this.fieldValues.put(fieldName, constValue);
    }

    public static ClassInfo addScannedClass(String className, boolean isInterface, boolean isAnnotation, Map<String, ClassInfo> classNameToClassInfo) {
        boolean isCompanionObjectClass = className.endsWith("$");
        boolean isTraitMethodClass = className.endsWith("$class");
        boolean isNonAuxClass = !isCompanionObjectClass && !isTraitMethodClass;
        String classBaseName = ClassInfo.scalaBaseClassName(className);
        ClassInfo classInfo = classNameToClassInfo.get(classBaseName);
        if (classInfo == null) {
            classInfo = new ClassInfo(classBaseName);
            classNameToClassInfo.put(classBaseName, classInfo);
        } else if (isNonAuxClass && classInfo.classfileScanned || isCompanionObjectClass && classInfo.companionObjectClassfileScanned || isTraitMethodClass && classInfo.traitMethodClassfileScanned) {
            return null;
        }
        if (isTraitMethodClass) {
            classInfo.traitMethodClassfileScanned = true;
        } else if (isCompanionObjectClass) {
            classInfo.companionObjectClassfileScanned = true;
        } else {
            classInfo.classfileScanned = true;
        }
        classInfo.isInterface |= isInterface;
        classInfo.isAnnotation |= isAnnotation;
        return classInfo;
    }

    @Override
    public int compareTo(ClassInfo o) {
        return this.className.compareTo(o.className);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            ClassInfo other = (ClassInfo)obj;
            return this.className != null ? this.className.equals(other.className) : other.className == null;
        }
        return false;
    }

    public int hashCode() {
        return this.className != null ? this.className.hashCode() : 33;
    }

    public String toString() {
        return this.className;
    }

    public static enum ClassType {
        ALL,
        STANDARD_CLASS,
        IMPLEMENTED_INTERFACE,
        ANNOTATION,
        INTERFACE_OR_ANNOTATION;

    }

    public static enum RelType {
        SUPERCLASSES,
        ALL_SUPERCLASSES,
        SUBCLASSES,
        ALL_SUBCLASSES,
        FIELD_TYPES,
        IMPLEMENTED_INTERFACES,
        ALL_IMPLEMENTED_INTERFACES,
        CLASSES_IMPLEMENTING,
        ALL_CLASSES_IMPLEMENTING,
        ANNOTATIONS,
        ALL_ANNOTATIONS,
        ANNOTATED_CLASSES,
        ALL_ANNOTATED_CLASSES;

    }
}

