/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import io.github.lukehutch.fastclasspathscanner.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.Manifest;

public class ClasspathFinder {
    private final ArrayList<File> classpathElements = new ArrayList();
    private final HashSet<String> classpathElementsSet = new HashSet();
    private final HashSet<String> knownJREPaths = new HashSet();
    private boolean initialized = false;

    private void clearClasspath() {
        this.classpathElements.clear();
        this.classpathElementsSet.clear();
        this.initialized = false;
    }

    private static String urlToPath(String pathElement) {
        if (pathElement.startsWith("jar:")) {
            pathElement = pathElement.substring(4);
        }
        try {
            URL url = new URL(pathElement);
            try {
                return new File(url.toURI()).getPath();
            }
            catch (URISyntaxException e) {
                return new File(url.getPath()).getPath();
            }
        }
        catch (MalformedURLException e) {
            return pathElement;
        }
    }

    private void addClasspathElement(String pathElement) {
        String path = ClasspathFinder.urlToPath(pathElement);
        if (!path.isEmpty()) {
            File pathFile;
            if (path.startsWith("http:") || path.startsWith("https:")) {
                Log.log("Cannot scan remote entry in classpath: " + path);
            }
            if ((pathFile = new File(path)).exists()) {
                String canonicalPath;
                try {
                    canonicalPath = pathFile.getCanonicalPath();
                }
                catch (IOException | SecurityException e) {
                    canonicalPath = path;
                }
                if (this.classpathElementsSet.add(canonicalPath)) {
                    boolean isValidClasspathElement = true;
                    if (pathFile.isFile() && Utils.isJar(path)) {
                        if (this.isJREJar(pathFile, 2)) {
                            isValidClasspathElement = false;
                            if (FastClasspathScanner.verbose) {
                                Log.log("Skipping JRE jar: " + path);
                            }
                        } else {
                            String manifestUrlStr = "jar:file:" + path + "!/META-INF/MANIFEST.MF";
                            try (InputStream stream = new URL(manifestUrlStr).openStream();){
                                Manifest manifest = new Manifest(stream);
                                String manifestClassPath = manifest.getMainAttributes().getValue("Class-Path");
                                if (manifestClassPath != null && !manifestClassPath.isEmpty()) {
                                    if (FastClasspathScanner.verbose) {
                                        Log.log("Found Class-Path entry in " + manifestUrlStr + ": " + manifestClassPath);
                                    }
                                    Path parent = FileSystems.getDefault().getPath(path, new String[0]).getParent();
                                    for (String manifestClassPathElement : manifestClassPath.split(" ")) {
                                        this.addClasspathElement(parent.resolve(ClasspathFinder.urlToPath(manifestClassPathElement)).normalize().toString());
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (isValidClasspathElement) {
                        if (FastClasspathScanner.verbose) {
                            Log.log("Found classpath element: " + path);
                        }
                        this.classpathElements.add(pathFile);
                    }
                }
            } else if (FastClasspathScanner.verbose) {
                Log.log("Classpath element does not exist: " + path);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJREJar(File file, int ancestralScanDepth) {
        if (ancestralScanDepth == 0) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (this.knownJREPaths.contains(parent.getPath())) {
            return true;
        }
        File rt = new File(parent, "rt.jar");
        if (!rt.exists()) return this.isJREJar(parent, ancestralScanDepth - 1);
        String manifestUrlStr = "jar:file:" + rt.getPath() + "!/META-INF/MANIFEST.MF";
        try (InputStream stream = new URL(manifestUrlStr).openStream();){
            Manifest manifest = new Manifest(stream);
            if (!"Java Runtime Environment".equals(manifest.getMainAttributes().getValue("Implementation-Title"))) {
                if (!"Java Platform API Specification".equals(manifest.getMainAttributes().getValue("Specification-Title"))) return this.isJREJar(parent, ancestralScanDepth - 1);
            }
            this.knownJREPaths.add(parent.getPath());
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.isJREJar(parent, ancestralScanDepth - 1);
    }

    private void parseSystemClasspath() {
        this.clearClasspath();
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        HashSet<ClassLoader> classLoadersSet = new HashSet<ClassLoader>();
        classLoadersSet.add(ClassLoader.getSystemClassLoader());
        classLoaders.add(ClassLoader.getSystemClassLoader());
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] stacktrace = e.getStackTrace();
            if (stacktrace.length >= 3) {
                ArrayList<ClassLoader> callerClassLoaders = new ArrayList<ClassLoader>();
                StackTraceElement caller = stacktrace[2];
                for (ClassLoader cl = caller.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
                    callerClassLoaders.add(cl);
                }
                for (int i = callerClassLoaders.size() - 1; i >= 0; --i) {
                    ClassLoader cl = (ClassLoader)callerClassLoaders.get(i);
                    if (!classLoadersSet.add(cl)) continue;
                    classLoaders.add(cl);
                }
            }
            if (classLoadersSet.add(Thread.currentThread().getContextClassLoader())) {
                classLoaders.add(Thread.currentThread().getContextClassLoader());
            }
            for (ClassLoader cl : classLoaders) {
                if (cl == null) continue;
                for (URL url : ((URLClassLoader)cl).getURLs()) {
                    String protocol = url.getProtocol();
                    if (protocol != null && !protocol.equalsIgnoreCase("file")) continue;
                    this.addClasspathElement(url.getFile());
                }
            }
            String classpathProperty = System.getProperty("java.class.path");
            if (classpathProperty == null || classpathProperty.isEmpty()) {
                for (String pathElement : classpathProperty.split(File.pathSeparator)) {
                    this.addClasspathElement(pathElement);
                }
            }
            this.initialized = true;
            return;
        }
    }

    public void overrideClasspath(String classpath) {
        this.clearClasspath();
        for (String pathElement : classpath.split(File.pathSeparator)) {
            this.addClasspathElement(pathElement);
        }
        this.initialized = true;
    }

    public ArrayList<File> getUniqueClasspathElements() {
        if (!this.initialized) {
            this.parseSystemClasspath();
        }
        return this.classpathElements;
    }
}

