/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import io.github.lukehutch.fastclasspathscanner.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.Manifest;

public class ClasspathFinder {
    private final ArrayList<File> classpathElements = new ArrayList();
    private final HashSet<String> classpathElementsSet = new HashSet();
    private final HashSet<String> knownJREPaths = new HashSet();
    private boolean initialized = false;

    private void clearClasspath() {
        this.classpathElements.clear();
        this.classpathElementsSet.clear();
        this.initialized = false;
    }

    private static Path urlToPath(Path resolveBasePath, String pathElementStr) {
        if (pathElementStr.isEmpty()) {
            return null;
        }
        String pathStr = pathElementStr;
        if (pathStr.startsWith("jar:")) {
            if (pathStr.indexOf(33) >= 0) {
                if (FastClasspathScanner.verbose) {
                    Log.log("Ignoring direct jar-internal URL reference in classpath: " + pathStr);
                }
                return null;
            }
            if (!((pathStr = pathStr.substring(4)).startsWith("file:") || pathStr.startsWith("http:") || pathStr.startsWith("https:"))) {
                pathStr = "file:" + pathStr;
            }
        }
        if (pathStr.startsWith("http:") || pathStr.startsWith("https:")) {
            if (FastClasspathScanner.verbose) {
                Log.log("Ignoring remote entry in classpath: " + pathStr);
            }
            return null;
        }
        try {
            return resolveBasePath.resolve(Paths.get(new URL(pathStr).toURI())).toRealPath(new LinkOption[0]);
        }
        catch (Exception e) {
            try {
                return resolveBasePath.resolve(pathStr).toRealPath(new LinkOption[0]);
            }
            catch (Exception e2) {
                block14: {
                    try {
                        File file = new File(pathElementStr);
                        if (file.exists()) {
                            return file.toPath().toRealPath(new LinkOption[0]);
                        }
                    }
                    catch (Exception e3) {
                        if (!FastClasspathScanner.verbose) break block14;
                        Log.log("Exception while trying to read classpath element " + pathStr + " : " + e.getMessage());
                    }
                }
                return null;
            }
        }
    }

    private void addClasspathElement(String pathElement) {
        Path currDirPath = Paths.get("", new String[0]).toAbsolutePath();
        Path path = ClasspathFinder.urlToPath(currDirPath, pathElement);
        if (path != null) {
            File pathFile = path.toFile();
            if (pathFile.exists()) {
                String pathStr = path.toString();
                if (this.classpathElementsSet.add(pathStr)) {
                    boolean isValidClasspathElement = true;
                    if (pathFile.isFile() && Utils.isJar(pathStr)) {
                        if (this.isJREJar(pathFile, 2)) {
                            isValidClasspathElement = false;
                            if (FastClasspathScanner.verbose) {
                                Log.log("Skipping JRE jar: " + pathStr);
                            }
                        } else {
                            String manifestUrlStr = "jar:" + pathFile.toURI() + "!/META-INF/MANIFEST.MF";
                            try (InputStream stream = new URL(manifestUrlStr).openStream();){
                                Manifest manifest = new Manifest(stream);
                                String manifestClassPath = manifest.getMainAttributes().getValue("Class-Path");
                                if (manifestClassPath != null && !manifestClassPath.isEmpty()) {
                                    if (FastClasspathScanner.verbose) {
                                        Log.log("Found Class-Path entry in " + manifestUrlStr + ": " + manifestClassPath);
                                    }
                                    Path parentPath = path.getParent();
                                    for (String manifestClassPathElement : manifestClassPath.split(" ")) {
                                        Path manifestEltPath = ClasspathFinder.urlToPath(parentPath, manifestClassPathElement);
                                        if (manifestEltPath == null) continue;
                                        this.addClasspathElement(manifestEltPath.toString());
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (isValidClasspathElement) {
                        if (FastClasspathScanner.verbose) {
                            Log.log("Found classpath element: " + path);
                        }
                        this.classpathElements.add(pathFile);
                    }
                }
            } else if (FastClasspathScanner.verbose) {
                Log.log("Classpath element does not exist: " + path);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJREJar(File file, int ancestralScanDepth) {
        if (ancestralScanDepth == 0) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (this.knownJREPaths.contains(parent.getPath())) {
            return true;
        }
        File rt = new File(parent, "rt.jar");
        if (!rt.exists()) return this.isJREJar(parent, ancestralScanDepth - 1);
        String manifestUrlStr = "jar:" + rt.toURI() + "!/META-INF/MANIFEST.MF";
        try (InputStream stream = new URL(manifestUrlStr).openStream();){
            Manifest manifest = new Manifest(stream);
            if (!"Java Runtime Environment".equals(manifest.getMainAttributes().getValue("Implementation-Title"))) {
                if (!"Java Platform API Specification".equals(manifest.getMainAttributes().getValue("Specification-Title"))) return this.isJREJar(parent, ancestralScanDepth - 1);
            }
            this.knownJREPaths.add(parent.getPath());
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.isJREJar(parent, ancestralScanDepth - 1);
    }

    private void parseSystemClasspath() {
        this.clearClasspath();
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        HashSet<ClassLoader> classLoadersSet = new HashSet<ClassLoader>();
        classLoadersSet.add(ClassLoader.getSystemClassLoader());
        classLoaders.add(ClassLoader.getSystemClassLoader());
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] stacktrace = e.getStackTrace();
            if (stacktrace.length >= 3) {
                ArrayList<ClassLoader> callerClassLoaders = new ArrayList<ClassLoader>();
                StackTraceElement caller = stacktrace[2];
                for (ClassLoader cl = caller.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
                    callerClassLoaders.add(cl);
                }
                for (int i = callerClassLoaders.size() - 1; i >= 0; --i) {
                    ClassLoader cl = (ClassLoader)callerClassLoaders.get(i);
                    if (!classLoadersSet.add(cl)) continue;
                    classLoaders.add(cl);
                }
            }
            if (classLoadersSet.add(Thread.currentThread().getContextClassLoader())) {
                classLoaders.add(Thread.currentThread().getContextClassLoader());
            }
            for (ClassLoader cl : classLoaders) {
                if (cl == null) continue;
                for (URL url : ((URLClassLoader)cl).getURLs()) {
                    String protocol = url.getProtocol();
                    if (protocol != null && !protocol.equalsIgnoreCase("file")) continue;
                    this.addClasspathElement(url.getFile());
                }
            }
            String classpathProperty = System.getProperty("java.class.path");
            if (classpathProperty == null || classpathProperty.isEmpty()) {
                for (String pathElement : classpathProperty.split(File.pathSeparator)) {
                    this.addClasspathElement(pathElement);
                }
            }
            this.initialized = true;
            return;
        }
    }

    public void overrideClasspath(String classpath) {
        this.clearClasspath();
        for (String pathElement : classpath.split(File.pathSeparator)) {
            this.addClasspathElement(pathElement);
        }
        this.initialized = true;
    }

    public ArrayList<File> getUniqueClasspathElements() {
        if (!this.initialized) {
            this.parseSystemClasspath();
        }
        return this.classpathElements;
    }
}

