/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ClassfileBinaryParser {
    private static String readAnnotation(DataInputStream inp, Object[] constantPool) throws IOException {
        String annotationFieldDescriptor = ClassfileBinaryParser.readRefdString(inp, constantPool);
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1).replace('/', '.') : annotationFieldDescriptor;
        int numElementValuePairs = inp.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            inp.skipBytes(2);
            ClassfileBinaryParser.readAnnotationElementValue(inp, constantPool);
        }
        return annotationClassName;
    }

    private static void readAnnotationElementValue(DataInputStream inp, Object[] constantPool) throws IOException {
        int tag = inp.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                inp.skipBytes(2);
                break;
            }
            case 101: {
                inp.skipBytes(4);
                break;
            }
            case 99: {
                inp.skipBytes(2);
                break;
            }
            case 64: {
                ClassfileBinaryParser.readAnnotation(inp, constantPool);
                break;
            }
            case 91: {
                int count = inp.readUnsignedShort();
                for (int l = 0; l < count; ++l) {
                    ClassfileBinaryParser.readAnnotationElementValue(inp, constantPool);
                }
                break;
            }
        }
    }

    private static String readRefdString(DataInputStream inp, Object[] constantPool) throws IOException {
        return (String)constantPool[inp.readUnsignedShort()];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassInfo readClassInfoFromClassfileHeader(String relativePath, InputStream inputStream, HashMap<String, HashMap<String, StaticFinalFieldMatchProcessor>> classNameToStaticFieldnameToMatchProcessor) {
        try (DataInputStream inp = new DataInputStream(new BufferedInputStream(inputStream, 8192));){
            int methodCount;
            int i;
            if (inp.readInt() != -889275714) {
                if (FastClasspathScanner.verbose) {
                    Log.log("File does not have correct classfile magic number: " + relativePath);
                }
                ClassInfo classInfo = null;
                return classInfo;
            }
            inp.readUnsignedShort();
            inp.readUnsignedShort();
            int cpCount = inp.readUnsignedShort();
            Object[] constantPool = new Object[cpCount];
            int[] indirectStringRef = new int[cpCount];
            Arrays.fill(indirectStringRef, -1);
            block50: for (i = 1; i < cpCount; ++i) {
                int tag = inp.readUnsignedByte();
                switch (tag) {
                    case 1: {
                        constantPool[i] = inp.readUTF();
                        continue block50;
                    }
                    case 3: {
                        constantPool[i] = inp.readInt();
                        continue block50;
                    }
                    case 4: {
                        constantPool[i] = Float.valueOf(inp.readFloat());
                        continue block50;
                    }
                    case 5: {
                        constantPool[i] = inp.readLong();
                        ++i;
                        continue block50;
                    }
                    case 6: {
                        constantPool[i] = inp.readDouble();
                        ++i;
                        continue block50;
                    }
                    case 7: 
                    case 8: {
                        indirectStringRef[i] = inp.readUnsignedShort();
                        continue block50;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        inp.skipBytes(4);
                        continue block50;
                    }
                    case 15: {
                        inp.skipBytes(3);
                        continue block50;
                    }
                    case 16: {
                        inp.skipBytes(2);
                        continue block50;
                    }
                    case 18: {
                        inp.skipBytes(4);
                        continue block50;
                    }
                }
            }
            for (i = 1; i < cpCount; ++i) {
                if (indirectStringRef[i] < 0) continue;
                constantPool[i] = constantPool[indirectStringRef[i]];
            }
            int flags = inp.readUnsignedShort();
            boolean isInterface = (flags & 0x200) != 0;
            boolean isAnnotation = (flags & 0x2000) != 0;
            String classNamePath = ClassfileBinaryParser.readRefdString(inp, constantPool);
            String className = classNamePath.replace('/', '.');
            String superclassName = ClassfileBinaryParser.readRefdString(inp, constantPool);
            if (superclassName != null) {
                superclassName = superclassName.replace('/', '.');
            }
            if (className.equals("java.lang.Object")) {
                ClassInfo classInfo = null;
                return classInfo;
            }
            if (!className.equals(relativePath.substring(0, relativePath.length() - 6).replace('/', '.'))) {
                if (FastClasspathScanner.verbose) {
                    Log.log("Class " + className + " is at incorrect relative path " + relativePath + " -- ignoring");
                }
                ClassInfo classInfo = null;
                return classInfo;
            }
            ClassInfo classInfo = new ClassInfo(className, isInterface, isAnnotation, superclassName);
            int interfaceCount = inp.readUnsignedShort();
            classInfo.interfaceNames = interfaceCount > 0 ? new ArrayList(interfaceCount) : null;
            for (int i2 = 0; i2 < interfaceCount; ++i2) {
                classInfo.interfaceNames.add(ClassfileBinaryParser.readRefdString(inp, constantPool).replace('/', '.'));
            }
            HashMap<String, StaticFinalFieldMatchProcessor> staticFieldnameToMatchProcessor = classNameToStaticFieldnameToMatchProcessor.get(classInfo.className);
            int fieldCount = inp.readUnsignedShort();
            int i3 = 0;
            while (true) {
                block76: {
                    boolean foundConstantValue;
                    int attributesCount;
                    String descriptor;
                    StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor;
                    String fieldName;
                    block78: {
                        block74: {
                            block77: {
                                boolean isStaticFinal;
                                block75: {
                                    if (i3 >= fieldCount) break block74;
                                    int accessFlags = inp.readUnsignedShort();
                                    isStaticFinal = (accessFlags & 0x18) == 24;
                                    fieldName = ClassfileBinaryParser.readRefdString(inp, constantPool);
                                    staticFinalFieldMatchProcessor = staticFieldnameToMatchProcessor != null ? staticFieldnameToMatchProcessor.get(fieldName) : null;
                                    descriptor = ClassfileBinaryParser.readRefdString(inp, constantPool);
                                    attributesCount = inp.readUnsignedShort();
                                    if (isStaticFinal || staticFinalFieldMatchProcessor == null) break block75;
                                    System.err.println(StaticFinalFieldMatchProcessor.class.getSimpleName() + ": cannot match requested field " + classInfo.className + "." + fieldName + " because it is either not static or not final");
                                    break block76;
                                }
                                if (isStaticFinal && staticFinalFieldMatchProcessor != null) break block77;
                                for (int j = 0; j < attributesCount; ++j) {
                                    inp.skipBytes(2);
                                    int attributeLength = inp.readInt();
                                    inp.skipBytes(attributeLength);
                                }
                                break block76;
                            }
                            foundConstantValue = false;
                            break block78;
                        }
                        methodCount = inp.readUnsignedShort();
                        break;
                    }
                    for (int j = 0; j < attributesCount; ++j) {
                        String attributeName = ClassfileBinaryParser.readRefdString(inp, constantPool);
                        int attributeLength = inp.readInt();
                        if (attributeName.equals("ConstantValue")) {
                            Object constValue = constantPool[inp.readUnsignedShort()];
                            switch (descriptor) {
                                case "B": {
                                    constValue = ((Integer)constValue).byteValue();
                                    break;
                                }
                                case "C": {
                                    constValue = Character.valueOf((char)((Integer)constValue).intValue());
                                    break;
                                }
                                case "S": {
                                    constValue = ((Integer)constValue).shortValue();
                                    break;
                                }
                                case "Z": {
                                    constValue = (Integer)constValue != 0;
                                    break;
                                }
                                case "I": 
                                case "J": 
                                case "F": 
                                case "D": 
                                case "Ljava.lang.String;": {
                                    break;
                                }
                            }
                            if (FastClasspathScanner.verbose) {
                                Log.log("Found static final field " + classInfo.className + "." + fieldName + " = " + constValue);
                            }
                            staticFinalFieldMatchProcessor.processMatch(classInfo.className, fieldName, constValue);
                            foundConstantValue = true;
                        } else {
                            inp.skipBytes(attributeLength);
                        }
                        if (foundConstantValue) continue;
                        System.err.println(StaticFinalFieldMatchProcessor.class.getSimpleName() + ": Requested static final field " + classInfo.className + "." + fieldName + "is not initialized with a constant literal value, so there is no " + "initializer value in the constant pool of the classfile");
                    }
                }
                ++i3;
            }
            for (int i4 = 0; i4 < methodCount; ++i4) {
                inp.skipBytes(6);
                int attributesCount = inp.readUnsignedShort();
                for (int j = 0; j < attributesCount; ++j) {
                    inp.skipBytes(2);
                    int attributeLength = inp.readInt();
                    inp.skipBytes(attributeLength);
                }
            }
            classInfo.annotationNames = null;
            int attributesCount = inp.readUnsignedShort();
            for (int i5 = 0; i5 < attributesCount; ++i5) {
                String attributeName = ClassfileBinaryParser.readRefdString(inp, constantPool);
                int attributeLength = inp.readInt();
                if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                    int annotationCount = inp.readUnsignedShort();
                    for (int m = 0; m < annotationCount; ++m) {
                        String annotationName = ClassfileBinaryParser.readAnnotation(inp, constantPool);
                        if (annotationName.startsWith("java.lang.annotation.")) continue;
                        if (classInfo.annotationNames == null) {
                            classInfo.annotationNames = new ArrayList();
                        }
                        classInfo.annotationNames.add(annotationName);
                    }
                    continue;
                }
                inp.skipBytes(attributeLength);
            }
            ClassInfo classInfo2 = classInfo;
            return classInfo2;
        }
        catch (IOException e) {
            Log.log("IOException while attempting to load classfile " + relativePath + ": " + e.getMessage());
            return null;
        }
    }
}

