/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import io.github.lukehutch.fastclasspathscanner.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecursiveScanner {
    private boolean scanJars = true;
    private boolean scanNonJars = true;
    private final HashSet<String> whitelistedJars = new HashSet();
    private final HashSet<String> blacklistedJars = new HashSet();
    private final String[] whitelistedPaths;
    private final String[] blacklistedPaths;
    private final ClasspathFinder classpathFinder;
    private final ArrayList<FilePathMatcher> filePathMatchers = new ArrayList();
    private long lastModified = 0L;
    private static final boolean USE_ZIPFILE_ENTRY_MODIFICATION_TIMES = false;

    public RecursiveScanner(ClasspathFinder classpathFinder, String[] scanSpecs) {
        this.classpathFinder = classpathFinder;
        HashSet<String> uniqueWhitelistedPaths = new HashSet<String>();
        HashSet<String> uniqueBlacklistedPaths = new HashSet<String>();
        for (String scanSpecEntry : scanSpecs) {
            boolean isJar;
            String spec = scanSpecEntry;
            boolean blacklisted = spec.startsWith("-");
            if (blacklisted) {
                spec = spec.substring(1);
            }
            if (isJar = spec.startsWith("jar:")) {
                if ((spec = spec.substring(4)).isEmpty()) {
                    if (blacklisted) {
                        this.scanJars = false;
                        continue;
                    }
                    this.scanNonJars = false;
                    continue;
                }
                if (blacklisted) {
                    this.blacklistedJars.add(spec);
                    continue;
                }
                this.whitelistedJars.add(spec);
                continue;
            }
            spec = spec.replace('.', '/') + "/";
            if (blacklisted) {
                if (spec.equals("/") || spec.isEmpty()) {
                    Log.log("Ignoring blacklist of root package, it would prevent all scanning");
                    continue;
                }
                uniqueBlacklistedPaths.add(spec);
                continue;
            }
            uniqueWhitelistedPaths.add(spec);
        }
        uniqueWhitelistedPaths.removeAll(uniqueBlacklistedPaths);
        this.whitelistedJars.removeAll(this.blacklistedJars);
        if (!this.whitelistedJars.isEmpty()) {
            this.scanNonJars = false;
        }
        if (uniqueWhitelistedPaths.isEmpty() || uniqueWhitelistedPaths.contains("/")) {
            this.whitelistedPaths = new String[]{"/"};
        } else {
            this.whitelistedPaths = new String[uniqueWhitelistedPaths.size()];
            int i = 0;
            for (String path : uniqueWhitelistedPaths) {
                this.whitelistedPaths[i++] = path;
            }
        }
        this.blacklistedPaths = new String[uniqueBlacklistedPaths.size()];
        int i = 0;
        for (String path : uniqueBlacklistedPaths) {
            this.blacklistedPaths[i++] = path;
        }
    }

    public void addFilePathMatcher(FilePathMatcher filePathMatcher) {
        this.filePathMatchers.add(filePathMatcher);
    }

    private void scanFile(File file, String relativePath, boolean scanTimestampsOnly) {
        this.lastModified = Math.max(this.lastModified, file.lastModified());
        if (!scanTimestampsOnly) {
            long startTime = System.currentTimeMillis();
            boolean filePathMatches = false;
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                block17: {
                    if (!fileMatcher.filePathMatches(relativePath)) continue;
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        fileMatcher.processMatch(relativePath, inputStream, (int)file.length());
                    }
                    catch (IOException e) {
                        if (!FastClasspathScanner.verbose) break block17;
                        Log.log(e.getMessage() + " while processing file " + file.getPath());
                    }
                }
                filePathMatches = true;
            }
            if (FastClasspathScanner.verbose && filePathMatches) {
                Log.log("Scanned file " + relativePath + " in " + (System.currentTimeMillis() - startTime) + " msec");
            }
        }
    }

    private void scanZipfile(String zipfilePath, String zipInternalRootPath, ZipFile zipFile, long zipFileLastModified, boolean scanTimestampsOnly) {
        if (FastClasspathScanner.verbose) {
            Log.log("Scanning jarfile: " + zipfilePath + (zipInternalRootPath.isEmpty() ? "" : " ; classpath root within jarfile: " + zipInternalRootPath));
        }
        long startTime = System.currentTimeMillis();
        boolean timestampWarning = false;
        String rootPrefix = zipInternalRootPath;
        if (rootPrefix.startsWith("/")) {
            rootPrefix = rootPrefix.substring(1);
        }
        if (!rootPrefix.isEmpty() && !rootPrefix.endsWith("/")) {
            rootPrefix = rootPrefix + "/";
        }
        int rootPrefixLen = rootPrefix.length();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String path = entry.getName();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (rootPrefixLen > 0) {
                if (!path.startsWith(rootPrefix)) continue;
                path = path.substring(rootPrefixLen);
            }
            boolean scanFile = false;
            for (String whitelistedPath : this.whitelistedPaths) {
                if (!path.startsWith(whitelistedPath) && !whitelistedPath.equals("/")) continue;
                scanFile = true;
                break;
            }
            for (String blacklistedPath : this.blacklistedPaths) {
                if (!path.startsWith(blacklistedPath)) continue;
                scanFile = false;
                break;
            }
            if (!scanFile) continue;
            long entryTime = zipFileLastModified;
            this.lastModified = Math.max(this.lastModified, entryTime);
            if (entryTime > System.currentTimeMillis() && !timestampWarning) {
                Log.log(zipfilePath + " contains modification timestamps after the current time");
                timestampWarning = true;
            }
            if (scanTimestampsOnly) continue;
            for (FilePathMatcher fileMatcher : this.filePathMatchers) {
                if (!fileMatcher.filePathMatches(path)) continue;
                try {
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        fileMatcher.processMatch(path, inputStream, (int)entry.getSize());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(e.getMessage() + " while processing file " + entry.getName());
                }
            }
        }
        if (FastClasspathScanner.verbose) {
            Log.log("Scanned jarfile " + zipfilePath + " in " + (System.currentTimeMillis() - startTime) + " msec");
        }
    }

    private void scanZipfile(File pathElt, String path, String zipInternalRootPath, boolean scanTimestampsOnly) {
        block17: {
            String jarName = pathElt.getName();
            if ((this.whitelistedJars.isEmpty() || this.whitelistedJars.contains(jarName)) && !this.blacklistedJars.contains(jarName)) {
                try (ZipFile zipfile = new ZipFile(pathElt);){
                    this.scanZipfile(path, zipInternalRootPath, zipfile, pathElt.lastModified(), scanTimestampsOnly);
                    break block17;
                }
                catch (IOException e) {
                    if (FastClasspathScanner.verbose) {
                        Log.log("Error while opening zipfile " + pathElt + " : " + e.toString());
                    }
                    break block17;
                }
            }
            if (FastClasspathScanner.verbose) {
                Log.log("Jarfile did not match whitelist/blacklist criteria: " + jarName);
            }
        }
    }

    private void scanDir(File dir, int ignorePrefixLen, boolean inWhitelistedPath, boolean scanTimestampsOnly) {
        String relativePath = (ignorePrefixLen > dir.getPath().length() ? "" : dir.getPath().substring(ignorePrefixLen).replace(File.separatorChar, '/')) + "/";
        if (FastClasspathScanner.verbose) {
            Log.log("Scanning path: " + relativePath);
        }
        for (String blacklistedPath : this.blacklistedPaths) {
            if (!relativePath.equals(blacklistedPath)) continue;
            if (FastClasspathScanner.verbose) {
                Log.log("Reached blacklisted path: " + relativePath);
            }
            return;
        }
        boolean keepRecursing = false;
        if (!inWhitelistedPath) {
            for (String whitelistedPath : this.whitelistedPaths) {
                if (relativePath.equals(whitelistedPath)) {
                    if (FastClasspathScanner.verbose) {
                        Log.log("Reached whitelisted path: " + relativePath);
                    }
                    inWhitelistedPath = true;
                    break;
                }
                if (!whitelistedPath.startsWith(relativePath) && !relativePath.equals("/")) continue;
                keepRecursing = true;
            }
        }
        if (keepRecursing || inWhitelistedPath) {
            this.lastModified = Math.max(this.lastModified, dir.lastModified());
            File[] subFiles = dir.listFiles();
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    File subFileReal;
                    block13: {
                        subFileReal = null;
                        try {
                            subFileReal = subFile.toPath().toRealPath(new LinkOption[0]).toFile();
                        }
                        catch (IOException | SecurityException e) {
                            if (!FastClasspathScanner.verbose) break block13;
                            Log.log("Could not access file " + subFile + ": " + e.getMessage());
                        }
                    }
                    if (subFileReal == null) continue;
                    if (subFileReal.isDirectory()) {
                        this.scanDir(subFileReal, ignorePrefixLen, inWhitelistedPath, scanTimestampsOnly);
                        continue;
                    }
                    if (!inWhitelistedPath || !subFileReal.isFile()) continue;
                    this.scanFile(subFileReal, relativePath.equals("/") ? subFileReal.getName() : relativePath + subFileReal.getName(), scanTimestampsOnly);
                }
            }
        }
    }

    private void scan(boolean scanTimestampsOnly) {
        ArrayList<File> uniqueClasspathElements = this.classpathFinder.getUniqueClasspathElements();
        if (FastClasspathScanner.verbose) {
            Log.log("*** Starting scan" + (scanTimestampsOnly ? " (scanning classpath timestamps only)" : "") + " ***");
            Log.log("Classpath elements: " + uniqueClasspathElements);
            Log.log("Whitelisted paths:  " + Arrays.toString(this.whitelistedPaths));
            Log.log("Blacklisted paths:  " + Arrays.toString(this.blacklistedPaths));
        }
        for (File pathElt : uniqueClasspathElements) {
            String path = pathElt.getPath();
            if (FastClasspathScanner.verbose) {
                Log.log("=> Scanning classpath element: " + path);
            }
            if (!pathElt.exists()) {
                String pathStr = pathElt.getPath();
                int bangPos = pathStr.indexOf(33);
                if (bangPos > 0) {
                    File zipFile = Paths.get(pathStr.substring(0, bangPos), new String[0]).toFile();
                    String zipInternalRootPath = pathStr.substring(bangPos + 1).replace(File.separatorChar, '/');
                    if (zipFile.exists()) {
                        if (Utils.isJar(path)) {
                            if (!this.scanJars) continue;
                            this.scanZipfile(zipFile, path, zipInternalRootPath, scanTimestampsOnly);
                            continue;
                        }
                        if (!FastClasspathScanner.verbose) continue;
                        Log.log("Not a jarfile, but illegal '!' character in classpath entry: " + pathStr);
                        continue;
                    }
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log("Jarfile on classpath no longer exists: " + zipFile);
                    continue;
                }
                if (!FastClasspathScanner.verbose) continue;
                Log.log("Classpath element no longer exists: " + path);
                continue;
            }
            if (pathElt.isDirectory() && this.scanNonJars) {
                this.scanDir(pathElt, path.length() + 1, false, scanTimestampsOnly);
                continue;
            }
            if (pathElt.isFile()) {
                if (Utils.isJar(path) && this.scanJars) {
                    this.scanZipfile(pathElt, path, "", scanTimestampsOnly);
                    continue;
                }
                if (!this.scanNonJars) continue;
                this.scanFile(pathElt, pathElt.getName(), scanTimestampsOnly);
                continue;
            }
            if (!FastClasspathScanner.verbose) continue;
            Log.log("Skipping non-file/non-dir on classpath: " + pathElt.getPath());
        }
    }

    public void scan() {
        this.scan(false);
    }

    public boolean classpathContentsModifiedSinceScan() {
        long oldLastModified = this.lastModified;
        if (oldLastModified == 0L) {
            return true;
        }
        this.scan(true);
        long newLastModified = this.lastModified;
        return newLastModified > oldLastModified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.lastModified;
    }

    public static class FilePathMatcher {
        private final FilePathTester filePathTester;
        private final FileMatchProcessor fileMatchProcessor;

        public FilePathMatcher(FilePathTester filePathTester, FileMatchProcessor fileMatchProcessor) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessor = fileMatchProcessor;
        }

        public boolean filePathMatches(String relativePath) {
            return this.filePathTester.filePathMatches(relativePath);
        }

        public void processMatch(String relativePath, InputStream inputStream, int inputStreamLengthBytes) throws IOException {
            this.fileMatchProcessor.processMatch(relativePath, inputStream, inputStreamLengthBytes);
        }
    }

    public static interface FilePathTester {
        public boolean filePathMatches(String var1);
    }
}

