/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.classloaderhandler.ClassLoaderHandler;
import java.lang.reflect.Method;

public class WeblogicClassLoaderHandler
extends ClassLoaderHandler {
    public WeblogicClassLoaderHandler(ClasspathFinder classpathFinder) {
        super(classpathFinder);
    }

    @Override
    public boolean handle(ClassLoader classloader) throws Exception {
        for (Class<?> c = classloader.getClass(); c != Object.class; c = c.getSuperclass()) {
            if (!c.getName().equals("weblogic.utils.classloaders.ChangeAwareClassLoader")) continue;
            Method getClassPath = c.getDeclaredMethod("getClassPath", new Class[0]);
            if (!getClassPath.isAccessible()) {
                getClassPath.setAccessible(true);
            }
            String classpath = (String)getClassPath.invoke((Object)classloader, new Object[0]);
            this.classpathFinder.addClasspathElements(classpath);
            return true;
        }
        return false;
    }
}

