/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classgraph.DAGNode;
import io.github.lukehutch.fastclasspathscanner.utils.LazyMap;
import io.github.lukehutch.fastclasspathscanner.utils.MultiSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ClassGraphBuilder {
    private final ArrayList<ClassInfo> allClassInfo;
    private final LazyMap<String, DAGNode> classNameToClassNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (ClassInfo classInfo : ClassGraphBuilder.this.allClassInfo) {
                if (classInfo.isAnnotation || classInfo.isInterface) continue;
                DAGNode classNode = DAGNode.getOrNew(this.map, classInfo.className);
                if (classInfo.interfaceNames != null) {
                    for (String interfaceName : classInfo.interfaceNames) {
                        classNode.addCrossLink(interfaceName);
                    }
                }
                for (String superclassName : classInfo.superclassNames) {
                    DAGNode.getOrNew(this.map, superclassName).addSubNode(classNode);
                }
            }
            DAGNode.findTransitiveClosure(this.map.values());
        }
    };
    private final LazyMap<String, DAGNode> interfaceNameToInterfaceNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (ClassInfo classInfo : ClassGraphBuilder.this.allClassInfo) {
                DAGNode classNodeIfInterface;
                DAGNode dAGNode = classNodeIfInterface = classInfo.isInterface ? DAGNode.getOrNew(this.map, classInfo.className) : null;
                if (classInfo.interfaceNames == null) continue;
                for (String implementedInterfaceName : classInfo.interfaceNames) {
                    DAGNode implementedInterfaceNode = DAGNode.getOrNew(this.map, implementedInterfaceName);
                    if (classNodeIfInterface == null) continue;
                    implementedInterfaceNode.addSubNode(classNodeIfInterface);
                }
            }
            DAGNode.findTransitiveClosure(this.map.values());
        }
    };
    private final LazyMap<String, DAGNode> annotationNameToAnnotationNode = new LazyMap<String, DAGNode>(){

        @Override
        public void initialize() {
            for (ClassInfo classInfo : ClassGraphBuilder.this.allClassInfo) {
                if (classInfo.isAnnotation) {
                    DAGNode classNode = DAGNode.getOrNew(this.map, classInfo.className);
                    if (classInfo.annotationNames == null) continue;
                    for (String annotationName : classInfo.annotationNames) {
                        DAGNode.getOrNew(this.map, annotationName).addSubNode(classNode);
                    }
                    continue;
                }
                if (classInfo.annotationNames == null) continue;
                for (String annotationName : classInfo.annotationNames) {
                    DAGNode.getOrNew(this.map, annotationName).addCrossLink(classInfo.className);
                }
            }
            DAGNode.findTransitiveClosure(this.map.values());
        }
    };
    private final LazyMap<String, ArrayList<String>> namesOfAllClasses = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String ignored) {
            ArrayList<String> classNames = new ArrayList<String>(ClassGraphBuilder.this.classNameToClassNode.keySet());
            Collections.sort(classNames);
            return classNames;
        }
    };
    private final LazyMap<String, ArrayList<String>> classNameToSubclassNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String className) {
            DAGNode classNode = (DAGNode)ClassGraphBuilder.this.classNameToClassNode.get(className);
            if (classNode == null) {
                return null;
            }
            ArrayList<String> subclasses = new ArrayList<String>(classNode.allSubNodes.size());
            for (DAGNode subNode : classNode.allSubNodes) {
                subclasses.add(subNode.name);
            }
            return subclasses;
        }
    };
    private final LazyMap<String, ArrayList<String>> classNameToSuperclassNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String className) {
            DAGNode classNode = (DAGNode)ClassGraphBuilder.this.classNameToClassNode.get(className);
            if (classNode == null) {
                return null;
            }
            ArrayList<String> superclasses = new ArrayList<String>(classNode.allSuperNodes.size());
            for (DAGNode superNode : classNode.allSuperNodes) {
                superclasses.add(superNode.name);
            }
            return superclasses;
        }
    };
    private final LazyMap<String, ArrayList<String>> interfaceNameToSubinterfaceNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String interfaceName) {
            DAGNode interfaceNode = (DAGNode)ClassGraphBuilder.this.interfaceNameToInterfaceNode.get(interfaceName);
            if (interfaceNode == null) {
                return null;
            }
            ArrayList<String> subinterfaces = new ArrayList<String>(interfaceNode.allSubNodes.size());
            for (DAGNode subNode : interfaceNode.allSubNodes) {
                subinterfaces.add(subNode.name);
            }
            return subinterfaces;
        }
    };
    private final LazyMap<String, ArrayList<String>> interfaceNameToSuperinterfaceNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        protected ArrayList<String> generateValue(String interfaceName) {
            DAGNode interfaceNode = (DAGNode)ClassGraphBuilder.this.interfaceNameToInterfaceNode.get(interfaceName);
            if (interfaceNode == null) {
                return null;
            }
            ArrayList<String> superinterfaces = new ArrayList<String>(interfaceNode.allSuperNodes.size());
            for (DAGNode superNode : interfaceNode.allSuperNodes) {
                superinterfaces.add(superNode.name);
            }
            return superinterfaces;
        }
    };
    private final LazyMap<String, HashSet<String>> interfaceNameToClassNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (DAGNode classNode : ClassGraphBuilder.this.classNameToClassNode.values()) {
                ArrayList<String> interfaceNames = classNode.crossLinkedClassNames;
                if (interfaceNames == null) continue;
                for (String interfaceName : interfaceNames) {
                    DAGNode interfaceNode = (DAGNode)ClassGraphBuilder.this.interfaceNameToInterfaceNode.get(interfaceName);
                    if (interfaceNode == null) continue;
                    MultiSet.put(this.map, interfaceName, classNode.name);
                    for (DAGNode subclassNode : classNode.allSubNodes) {
                        MultiSet.put(this.map, interfaceName, subclassNode.name);
                    }
                    for (DAGNode superinterfaceNode : interfaceNode.allSuperNodes) {
                        MultiSet.put(this.map, superinterfaceNode.name, classNode.name);
                        for (DAGNode subclassNode : classNode.allSubNodes) {
                            MultiSet.put(this.map, superinterfaceNode.name, subclassNode.name);
                        }
                    }
                }
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> interfaceNameToClassNames = LazyMap.convertToMultiMap(this.interfaceNameToClassNamesSet);
    private final LazyMap<String, HashSet<String>> annotationNameToAnnotatedClassNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        protected HashSet<String> generateValue(String annotationName) {
            DAGNode annotationNode = (DAGNode)ClassGraphBuilder.this.annotationNameToAnnotationNode.get(annotationName);
            if (annotationNode == null) {
                return null;
            }
            HashSet<String> classNames = new HashSet<String>();
            for (DAGNode subNode : annotationNode.allSubNodes) {
                classNames.addAll(subNode.crossLinkedClassNames);
            }
            classNames.addAll(annotationNode.crossLinkedClassNames);
            return classNames;
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToAnnotatedClassNames = LazyMap.convertToMultiMap(this.annotationNameToAnnotatedClassNamesSet);
    private final LazyMap<String, ArrayList<String>> classNameToAnnotationNames = LazyMap.convertToMultiMap(LazyMap.invertMultiSet(this.annotationNameToAnnotatedClassNamesSet, this.annotationNameToAnnotationNode));
    private final LazyMap<String, HashSet<String>> metaAnnotationNameToAnnotatedAnnotationNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        protected HashSet<String> generateValue(String annotationName) {
            DAGNode annotationNode = (DAGNode)ClassGraphBuilder.this.annotationNameToAnnotationNode.get(annotationName);
            if (annotationNode == null) {
                return null;
            }
            HashSet<String> subNodes = new HashSet<String>();
            for (DAGNode subNode : annotationNode.allSubNodes) {
                subNodes.add(subNode.name);
            }
            return subNodes;
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToMetaAnnotationNames = LazyMap.convertToMultiMap(LazyMap.invertMultiSet(this.metaAnnotationNameToAnnotatedAnnotationNamesSet, this.annotationNameToAnnotationNode));
    private final LazyMap<String, ArrayList<String>> metaAnnotationNameToAnnotatedAnnotationNames = LazyMap.convertToMultiMap(this.metaAnnotationNameToAnnotatedAnnotationNamesSet);

    public ClassGraphBuilder(Collection<ClassInfo> classInfoFromScan) {
        this.allClassInfo = new ArrayList<ClassInfo>(ClassGraphBuilder.handleScalaAuxClasses(classInfoFromScan));
    }

    private static String scalaBaseClassName(String scalaClassName) {
        if (scalaClassName != null && scalaClassName.endsWith("$")) {
            return scalaClassName.substring(0, scalaClassName.length() - 1);
        }
        if (scalaClassName != null && scalaClassName.endsWith("$class")) {
            return scalaClassName.substring(0, scalaClassName.length() - 6);
        }
        return scalaClassName;
    }

    private static Collection<ClassInfo> handleScalaAuxClasses(Collection<ClassInfo> classInfoFromScan) {
        HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
        ArrayList<ClassInfo> companionObjectClassInfo = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : classInfoFromScan) {
            int i;
            for (i = 0; i < classInfo.superclassNames.size(); ++i) {
                classInfo.superclassNames.set(i, ClassGraphBuilder.scalaBaseClassName(classInfo.superclassNames.get(i)));
            }
            if (classInfo.interfaceNames != null) {
                for (i = 0; i < classInfo.interfaceNames.size(); ++i) {
                    classInfo.interfaceNames.set(i, ClassGraphBuilder.scalaBaseClassName(classInfo.interfaceNames.get(i)));
                }
            }
            if (classInfo.annotationNames != null) {
                for (i = 0; i < classInfo.annotationNames.size(); ++i) {
                    classInfo.annotationNames.set(i, ClassGraphBuilder.scalaBaseClassName(classInfo.annotationNames.get(i)));
                }
            }
            if (classInfo.className.endsWith("$") || classInfo.className.endsWith("$class")) {
                companionObjectClassInfo.add(classInfo);
                continue;
            }
            classNameToClassInfo.put(classInfo.className, classInfo);
        }
        for (ClassInfo companionClassInfo : companionObjectClassInfo) {
            String className;
            String classNameRaw = companionClassInfo.className;
            String string = className = classNameRaw.endsWith("$class") ? classNameRaw.substring(0, classNameRaw.length() - 6) : classNameRaw.substring(0, classNameRaw.length() - 1);
            if (!classNameToClassInfo.containsKey(className)) {
                companionClassInfo.className = className;
                classNameToClassInfo.put(className, companionClassInfo);
                continue;
            }
            ClassInfo baseClassInfo = (ClassInfo)classNameToClassInfo.get(className);
            baseClassInfo.isInterface |= companionClassInfo.isInterface;
            baseClassInfo.isAnnotation |= companionClassInfo.isAnnotation;
            baseClassInfo.superclassNames.addAll(companionClassInfo.superclassNames);
            if (baseClassInfo.interfaceNames == null) {
                baseClassInfo.interfaceNames = companionClassInfo.interfaceNames;
            } else if (companionClassInfo.interfaceNames != null) {
                baseClassInfo.interfaceNames.addAll(companionClassInfo.interfaceNames);
            }
            if (baseClassInfo.annotationNames == null) {
                baseClassInfo.annotationNames = companionClassInfo.annotationNames;
                continue;
            }
            if (companionClassInfo.annotationNames == null) continue;
            baseClassInfo.annotationNames.addAll(companionClassInfo.annotationNames);
        }
        return classNameToClassInfo.values();
    }

    public List<String> getNamesOfAllClasses() {
        return this.namesOfAllClasses.get("");
    }

    public List<String> getNamesOfSubclassesOf(String className) {
        ArrayList<String> subclassNames = this.classNameToSubclassNames.get(className);
        if (subclassNames == null) {
            return Collections.emptyList();
        }
        return subclassNames;
    }

    public List<String> getNamesOfSuperclassesOf(String className) {
        ArrayList<String> superclassNames = this.classNameToSuperclassNames.get(className);
        if (superclassNames == null) {
            return Collections.emptyList();
        }
        return superclassNames;
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        ArrayList<String> subinterfaceNames = this.interfaceNameToSubinterfaceNames.get(interfaceName);
        if (subinterfaceNames == null) {
            return Collections.emptyList();
        }
        return subinterfaceNames;
    }

    public List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        ArrayList<String> superinterfaceNames = this.interfaceNameToSuperinterfaceNames.get(interfaceName);
        if (superinterfaceNames == null) {
            return Collections.emptyList();
        }
        return superinterfaceNames;
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        ArrayList<String> classes = this.interfaceNameToClassNames.get(interfaceName);
        if (classes == null) {
            return Collections.emptyList();
        }
        return classes;
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        ArrayList<String> classNames = this.annotationNameToAnnotatedClassNames.get(annotationName);
        if (classNames == null) {
            return Collections.emptyList();
        }
        return classNames;
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        ArrayList<String> annotationNames = this.classNameToAnnotationNames.get(classOrInterfaceName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        ArrayList<String> metaAnnotationNames = this.annotationNameToMetaAnnotationNames.get(annotationName);
        if (metaAnnotationNames == null) {
            return Collections.emptyList();
        }
        return metaAnnotationNames;
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        ArrayList<String> annotationNames = this.metaAnnotationNameToAnnotatedAnnotationNames.get(metaAnnotationName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }
}

