/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

class DAGNode {
    final String name;
    ArrayList<DAGNode> directSuperNodes = new ArrayList(4);
    ArrayList<DAGNode> directSubNodes = new ArrayList(4);
    HashSet<DAGNode> allSuperNodes = new HashSet(4);
    HashSet<DAGNode> allSubNodes = new HashSet(4);
    ArrayList<String> crossLinkedClassNames = new ArrayList(2);

    public DAGNode(String name) {
        this.name = name;
    }

    public static DAGNode getOrNew(HashMap<String, DAGNode> map, String name) {
        DAGNode node = map.get(name);
        if (node == null) {
            node = new DAGNode(name);
            map.put(name, node);
        }
        return node;
    }

    public DAGNode addSubNode(DAGNode subNode) {
        subNode.directSuperNodes.add(this);
        this.directSubNodes.add(subNode);
        return this;
    }

    public DAGNode addCrossLink(String crossLinkedClassName) {
        this.crossLinkedClassNames.add(crossLinkedClassName);
        return this;
    }

    public String toString() {
        return this.name;
    }

    public static void findTransitiveClosure(Collection<? extends DAGNode> nodes) {
        HashSet<DAGNode> activeTopDownNodes = new HashSet<DAGNode>();
        for (DAGNode dAGNode : nodes) {
            if (!dAGNode.directSuperNodes.isEmpty()) continue;
            activeTopDownNodes.addAll(dAGNode.directSubNodes);
        }
        while (!activeTopDownNodes.isEmpty()) {
            HashSet<DAGNode> activeTopDownNodesNext = new HashSet<DAGNode>(activeTopDownNodes.size());
            for (DAGNode dAGNode : activeTopDownNodes) {
                boolean changed = dAGNode.allSuperNodes.addAll(dAGNode.directSuperNodes);
                for (DAGNode superNode : dAGNode.directSuperNodes) {
                    changed |= dAGNode.allSuperNodes.addAll(superNode.allSuperNodes);
                }
                if (!changed) continue;
                for (DAGNode subNode : dAGNode.directSubNodes) {
                    activeTopDownNodesNext.add(subNode);
                }
            }
            activeTopDownNodes = activeTopDownNodesNext;
        }
        HashSet<DAGNode> activeBottomUpNodes = new HashSet<DAGNode>();
        for (DAGNode dAGNode : nodes) {
            if (!dAGNode.directSubNodes.isEmpty()) continue;
            activeBottomUpNodes.addAll(dAGNode.directSuperNodes);
        }
        while (!activeBottomUpNodes.isEmpty()) {
            HashSet<DAGNode> hashSet = new HashSet<DAGNode>(activeBottomUpNodes.size());
            for (DAGNode node : activeBottomUpNodes) {
                boolean changed = node.allSubNodes.addAll(node.directSubNodes);
                for (DAGNode subNode : node.directSubNodes) {
                    changed |= node.allSubNodes.addAll(subNode.allSubNodes);
                }
                if (!changed) continue;
                for (DAGNode superNode : node.directSuperNodes) {
                    hashSet.add(superNode);
                }
            }
            activeBottomUpNodes = hashSet;
        }
    }
}

