/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.classpath.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.InterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.RecursiveScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class FastClasspathScanner {
    private final String[] scanSpecArgs;
    private ScanSpec scanSpec;
    private ClasspathFinder classpathFinder;
    private RecursiveScanner recursiveScanner;
    private final Map<String, ArrayList<StaticFinalFieldMatchProcessor>> fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors = new HashMap<String, ArrayList<StaticFinalFieldMatchProcessor>>();
    private final Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch = new HashMap<String, HashSet<String>>();
    private final ArrayList<ClassMatcher> classMatchers = new ArrayList();
    public static boolean verbose = false;
    private static final String MAVEN_PACKAGE = "io.github.lukehutch";
    private static final String MAVEN_ARTIFACT = "fast-classpath-scanner";

    public FastClasspathScanner(String ... scanSpec) {
        this.scanSpecArgs = scanSpec;
        verbose = false;
    }

    public synchronized void registerClassLoaderHandler(ClassLoaderHandler extraClassLoaderHandler) {
        this.getClasspathFinder().registerClassLoaderHandler(extraClassLoaderHandler);
    }

    public synchronized FastClasspathScanner overrideClasspath(String classpath) {
        this.getClasspathFinder().overrideClasspath(classpath);
        return this;
    }

    private synchronized ClasspathFinder getClasspathFinder() {
        if (this.classpathFinder == null) {
            this.classpathFinder = new ClasspathFinder();
        }
        return this.classpathFinder;
    }

    private synchronized RecursiveScanner getRecursiveScanner() {
        if (this.recursiveScanner == null) {
            this.recursiveScanner = new RecursiveScanner(this.getClasspathFinder(), this.getScanSpec(), this.classMatchers, this.classNameToStaticFinalFieldsToMatch, this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors);
        }
        return this.recursiveScanner;
    }

    private synchronized ScanSpec getScanSpec() {
        if (this.scanSpec == null) {
            this.scanSpec = new ScanSpec(this.scanSpecArgs);
        }
        return this.scanSpec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final synchronized String getVersion() {
        Object classfileName;
        Class<FastClasspathScanner> cls;
        block39: {
            cls = FastClasspathScanner.class;
            try {
                String className = cls.getName();
                classfileName = "/" + className.replace('.', '/') + ".class";
                URL classfileResource = cls.getResource((String)classfileName);
                if (classfileResource == null) break block39;
                Path absolutePackagePath = Paths.get(classfileResource.toURI()).getParent();
                int packagePathSegments = className.length() - className.replace(".", "").length();
                Path path = absolutePackagePath;
                int segmentsToRemove = packagePathSegments + 2;
                for (int i = 0; i < segmentsToRemove; ++i) {
                    if (path == null) continue;
                    path = path.getParent();
                }
                if (path == null) break block39;
                Path pom = path.resolve("pom.xml");
                try (InputStream is2 = Files.newInputStream(pom, new OpenOption[0]);){
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is2);
                    doc.getDocumentElement().normalize();
                    String version = (String)XPathFactory.newInstance().newXPath().compile("/project/version").evaluate(doc, XPathConstants.STRING);
                    if (version != null && !(version = version.trim()).isEmpty()) {
                        String string2 = version;
                        return string2;
                    }
                }
            }
            catch (Exception className) {
                // empty catch block
            }
        }
        try {
            InputStream is322 = cls.getResourceAsStream("/META-INF/maven/io.github.lukehutch/fast-classpath-scanner/pom.properties");
            classfileName = null;
            try {
                if (is322 != null) {
                    Properties p = new Properties();
                    p.load(is322);
                    String version = p.getProperty("version", "").trim();
                    if (!version.isEmpty()) {
                        String string = version;
                        return string;
                    }
                }
            }
            catch (Throwable throwable) {
                classfileName = throwable;
                throw throwable;
            }
            finally {
                if (is322 != null) {
                    if (classfileName != null) {
                        try {
                            is322.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)classfileName).addSuppressed(throwable);
                        }
                    } else {
                        is322.close();
                    }
                }
            }
        }
        catch (Exception is322) {
            // empty catch block
        }
        Package pkg = cls.getPackage();
        if (pkg == null) return "unknown";
        String version = pkg.getImplementationVersion();
        if (version == null) {
            version = "";
        }
        if ((version = version.trim()).isEmpty()) {
            version = pkg.getSpecificationVersion();
            if (version == null) {
                version = "";
            }
            version = version.trim();
        }
        if (version.isEmpty()) return "unknown";
        return version;
    }

    private synchronized <T> Class<? extends T> loadClass(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return cls;
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError e) {
            throw new RuntimeException("Exception while loading or initializing class " + className, e);
        }
    }

    private synchronized void checkClassNameIsNotBlacklisted(String className) {
        if (!this.getScanSpec().classIsNotBlacklisted(className)) {
            throw new IllegalArgumentException("Can't scan for " + className + ", it is in a blacklisted package. You can explicitly override this by naming the class in the scan spec when you call the " + FastClasspathScanner.class.getSimpleName() + " constructor.");
        }
    }

    private synchronized String annotationName(Class<?> annotation) {
        String annotationName = annotation.getName();
        this.checkClassNameIsNotBlacklisted(annotationName);
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException(annotationName + " is not an annotation");
        }
        return annotation.getName();
    }

    private synchronized String[] annotationNames(Class<?>[] annotations) {
        String[] annotationNames = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotationNames[i] = this.annotationName(annotations[i]);
        }
        return annotationNames;
    }

    private synchronized String interfaceName(Class<?> iface) {
        String ifaceName = iface.getName();
        this.checkClassNameIsNotBlacklisted(ifaceName);
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(ifaceName + " is not an interface");
        }
        return iface.getName();
    }

    private synchronized String[] interfaceNames(Class<?>[] interfaces) {
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = this.interfaceName(interfaces[i]);
        }
        return interfaceNames;
    }

    private synchronized String classOrInterfaceName(Class<?> classOrInterface) {
        String classOrIfaceName = classOrInterface.getName();
        this.checkClassNameIsNotBlacklisted(classOrIfaceName);
        if (classOrInterface.isAnnotation()) {
            throw new IllegalArgumentException(classOrIfaceName + " is an annotation, not a regular class or interface");
        }
        return classOrInterface.getName();
    }

    private synchronized String standardClassName(Class<?> cls) {
        String className = cls.getName();
        this.checkClassNameIsNotBlacklisted(className);
        if (cls.isAnnotation()) {
            throw new IllegalArgumentException(className + " is an annotation, not a standard class");
        }
        if (cls.isInterface()) {
            throw new IllegalArgumentException(cls.getName() + " is an interface, not a standard class");
        }
        return className;
    }

    private synchronized String className(Class<?> cls) {
        String className = cls.getName();
        this.checkClassNameIsNotBlacklisted(className);
        return className;
    }

    public synchronized List<String> getNamesOfAllClasses() {
        return this.getScanResults().getNamesOfAllClasses();
    }

    public synchronized List<String> getNamesOfAllStandardClasses() {
        return this.getScanResults().getNamesOfAllStandardClasses();
    }

    public synchronized List<String> getNamesOfAllInterfaceClasses() {
        return this.getScanResults().getNamesOfAllInterfaceClasses();
    }

    public synchronized List<String> getNamesOfAllAnnotationClasses() {
        return this.getScanResults().getNamesOfAllAnnotationClasses();
    }

    public synchronized FastClasspathScanner matchAllClasses(final ClassMatchProcessor classMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllClasses()) {
                    if (verbose) {
                        Log.log(3, "Matched class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public synchronized FastClasspathScanner matchAllStandardClasses(final ClassMatchProcessor classMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllStandardClasses()) {
                    if (verbose) {
                        Log.log(3, "Matched standard class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public synchronized FastClasspathScanner matchAllInterfaceClasses(final ClassMatchProcessor ClassMatchProcessor2) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllInterfaceClasses()) {
                    if (verbose) {
                        Log.log(3, "Matched interface class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    ClassMatchProcessor2.processMatch(cls);
                }
            }
        });
        return this;
    }

    public synchronized FastClasspathScanner matchAllAnnotationClasses(final ClassMatchProcessor ClassMatchProcessor2) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllAnnotationClasses()) {
                    if (verbose) {
                        Log.log(3, "Matched annotation class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    ClassMatchProcessor2.processMatch(cls);
                }
            }
        });
        return this;
    }

    public synchronized <T> FastClasspathScanner matchSubclassesOf(final Class<T> superclass, final SubclassMatchProcessor<T> subclassMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String superclassName = FastClasspathScanner.this.standardClassName(superclass);
                for (String subclassName : FastClasspathScanner.this.getNamesOfSubclassesOf(superclassName)) {
                    if (verbose) {
                        Log.log(3, "Matched subclass of " + superclassName + ": " + subclassName);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(subclassName);
                    subclassMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public synchronized List<String> getNamesOfSubclassesOf(Class<?> superclass) {
        return this.getNamesOfSubclassesOf(this.standardClassName(superclass));
    }

    public synchronized List<String> getNamesOfSubclassesOf(String superclassName) {
        return this.getScanResults().getNamesOfSubclassesOf(superclassName);
    }

    public synchronized List<String> getNamesOfSuperclassesOf(Class<?> subclass) {
        return this.getNamesOfSuperclassesOf(this.standardClassName(subclass));
    }

    public synchronized List<String> getNamesOfSuperclassesOf(String subclassName) {
        return this.getScanResults().getNamesOfSuperclassesOf(subclassName);
    }

    public synchronized <T> FastClasspathScanner matchSubinterfacesOf(final Class<T> superinterface, final SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String superinterfaceName = FastClasspathScanner.this.interfaceName(superinterface);
                for (String subinterfaceName : FastClasspathScanner.this.getNamesOfSubinterfacesOf(superinterfaceName)) {
                    if (verbose) {
                        Log.log(3, "Matched subinterface of " + superinterfaceName + ": " + subinterfaceName);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(subinterfaceName);
                    subinterfaceMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public synchronized List<String> getNamesOfSubinterfacesOf(Class<?> superInterface) {
        return this.getNamesOfSubinterfacesOf(this.interfaceName(superInterface));
    }

    public synchronized List<String> getNamesOfSubinterfacesOf(String superInterfaceName) {
        return this.getScanResults().getNamesOfSubinterfacesOf(superInterfaceName);
    }

    public synchronized List<String> getNamesOfSuperinterfacesOf(Class<?> subInterface) {
        return this.getNamesOfSuperinterfacesOf(this.interfaceName(subInterface));
    }

    public synchronized List<String> getNamesOfSuperinterfacesOf(String subinterfaceName) {
        return this.getScanResults().getNamesOfSuperinterfacesOf(subinterfaceName);
    }

    public synchronized <T> FastClasspathScanner matchClassesImplementing(final Class<T> implementedInterface, final InterfaceMatchProcessor<T> interfaceMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String implementedInterfaceName = FastClasspathScanner.this.interfaceName(implementedInterface);
                for (String implClass : FastClasspathScanner.this.getNamesOfClassesImplementing(implementedInterfaceName)) {
                    if (verbose) {
                        Log.log(3, "Matched class implementing interface " + implementedInterfaceName + ": " + implClass);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(implClass);
                    interfaceMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public synchronized List<String> getNamesOfClassesImplementing(Class<?> implementedInterface) {
        return this.getNamesOfClassesImplementing(this.interfaceName(implementedInterface));
    }

    public synchronized List<String> getNamesOfClassesImplementing(String implementedInterfaceName) {
        return this.getScanResults().getNamesOfClassesImplementing(implementedInterfaceName);
    }

    public synchronized List<String> getNamesOfClassesImplementingAllOf(Class<?> ... implementedInterfaces) {
        return this.getNamesOfClassesImplementingAllOf(this.interfaceNames(implementedInterfaces));
    }

    public synchronized List<String> getNamesOfClassesImplementingAllOf(String ... implementedInterfaceNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < implementedInterfaceNames.length; ++i) {
            String implementedInterfaceName = implementedInterfaceNames[i];
            List<String> namesOfImplementingClasses = this.getNamesOfClassesImplementing(implementedInterfaceName);
            if (i == 0) {
                classNames.addAll(namesOfImplementingClasses);
                continue;
            }
            classNames.retainAll(namesOfImplementingClasses);
        }
        return new ArrayList<String>(classNames);
    }

    public synchronized <T> FastClasspathScanner matchClassesWithFieldOfType(final Class<T> fieldType, final ClassMatchProcessor classMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String fieldTypeName = FastClasspathScanner.this.className(fieldType);
                for (String klass : FastClasspathScanner.this.getNamesOfClassesWithFieldOfType(fieldTypeName)) {
                    if (verbose) {
                        Log.log(3, "Matched class with field of type " + fieldTypeName + ": " + klass);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(klass);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public synchronized List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        return this.getScanResults().getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public synchronized List<String> getNamesOfClassesWithFieldOfType(Class<?> fieldType) {
        String fieldTypeName = fieldType.getName();
        this.checkClassNameIsNotBlacklisted(fieldTypeName);
        return this.getScanResults().getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public synchronized FastClasspathScanner matchClassesWithAnnotation(final Class<?> annotation, final ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String annotationName = FastClasspathScanner.this.annotationName(annotation);
                for (String classWithAnnotation : FastClasspathScanner.this.getNamesOfClassesWithAnnotation(annotationName)) {
                    if (verbose) {
                        Log.log(3, "Matched class with annotation " + annotationName + ": " + classWithAnnotation);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(classWithAnnotation);
                    classAnnotationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public synchronized List<String> getNamesOfClassesWithAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithAnnotation(this.annotationName(annotation));
    }

    public synchronized List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        return this.getScanResults().getNamesOfClassesWithAnnotation(annotationName);
    }

    public synchronized List<String> getNamesOfClassesWithAnnotationsAllOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAllOf(this.annotationNames(annotations));
    }

    public synchronized List<String> getNamesOfClassesWithAnnotationsAllOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < annotationNames.length; ++i) {
            String annotationName = annotationNames[i];
            List<String> namesOfClassesWithMetaAnnotation = this.getNamesOfClassesWithAnnotation(annotationName);
            if (i == 0) {
                classNames.addAll(namesOfClassesWithMetaAnnotation);
                continue;
            }
            classNames.retainAll(namesOfClassesWithMetaAnnotation);
        }
        return new ArrayList<String>(classNames);
    }

    public synchronized List<String> getNamesOfClassesWithAnnotationsAnyOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAnyOf(this.annotationNames(annotations));
    }

    public synchronized List<String> getNamesOfClassesWithAnnotationsAnyOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (String annotationName : annotationNames) {
            classNames.addAll(this.getNamesOfClassesWithAnnotation(annotationName));
        }
        return new ArrayList<String>(classNames);
    }

    public synchronized List<String> getNamesOfAnnotationsWithMetaAnnotation(Class<?> metaAnnotation) {
        return this.getNamesOfAnnotationsWithMetaAnnotation(this.annotationName(metaAnnotation));
    }

    public synchronized List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        return this.getScanResults().getNamesOfAnnotationsWithMetaAnnotation(metaAnnotationName);
    }

    public synchronized List<String> getNamesOfAnnotationsOnClass(Class<?> classOrInterface) {
        return this.getNamesOfAnnotationsOnClass(this.classOrInterfaceName(classOrInterface));
    }

    public synchronized List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        return this.getScanResults().getNamesOfAnnotationsOnClass(classOrInterfaceName);
    }

    public synchronized List<String> getNamesOfMetaAnnotationsOnAnnotation(Class<?> annotation) {
        return this.getNamesOfMetaAnnotationsOnAnnotation(this.annotationName(annotation));
    }

    public synchronized List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        return this.getScanResults().getNamesOfMetaAnnotationsOnAnnotation(annotationName);
    }

    private synchronized void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        String fullyQualifiedFieldName = className + "." + fieldName;
        ArrayList<StaticFinalFieldMatchProcessor> matchProcessorList = this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.get(fullyQualifiedFieldName);
        if (matchProcessorList == null) {
            matchProcessorList = new ArrayList(1);
            this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.put(fullyQualifiedFieldName, matchProcessorList);
        }
        matchProcessorList.add(staticFinalFieldMatchProcessor);
        HashSet<String> staticFinalFieldsToMatch = this.classNameToStaticFinalFieldsToMatch.get(className);
        if (staticFinalFieldsToMatch == null) {
            staticFinalFieldsToMatch = new HashSet();
            this.classNameToStaticFinalFieldsToMatch.put(className, staticFinalFieldsToMatch);
        }
        staticFinalFieldsToMatch.add(fieldName);
    }

    public synchronized FastClasspathScanner matchStaticFinalFieldNames(Set<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            int lastDotIdx = fullyQualifiedFieldName.lastIndexOf(46);
            if (lastDotIdx <= 0) continue;
            String className = fullyQualifiedFieldName.substring(0, lastDotIdx);
            String fieldName = fullyQualifiedFieldName.substring(lastDotIdx + 1);
            this.addStaticFinalFieldProcessor(className, fieldName, staticFinalFieldMatchProcessor);
        }
        return this;
    }

    public synchronized FastClasspathScanner matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedStaticFinalFieldName);
        return this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    public synchronized FastClasspathScanner matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedFieldName);
        }
        return this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    private static byte[] readAllBytes(InputStream inputStream, long fileSize) throws IOException {
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException("File larger that 2GB, cannot read contents into a Java array");
        }
        byte[] bytes = new byte[(int)fileSize];
        int bytesRead = inputStream.read(bytes);
        if ((long)bytesRead < fileSize) {
            throw new IOException("Could not read whole file");
        }
        return bytes;
    }

    private static RecursiveScanner.FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchProcessor fileMatchProcessor) {
        return new RecursiveScanner.FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchProcessor.processMatch(relativePath, inputStream, fileSize);
            }
        };
    }

    private static RecursiveScanner.FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        return new RecursiveScanner.FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchProcessorWithContext.processMatch(classpathElt, relativePath, inputStream, fileSize);
            }
        };
    }

    private static RecursiveScanner.FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchContentsProcessor fileMatchContentsProcessor) {
        return new RecursiveScanner.FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchContentsProcessor.processMatch(relativePath, FastClasspathScanner.readAllBytes(inputStream, fileSize));
            }
        };
    }

    private static RecursiveScanner.FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        return new RecursiveScanner.FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchContentsProcessorWithContext.processMatch(classpathElt, relativePath, FastClasspathScanner.readAllBytes(inputStream, fileSize));
            }
        };
    }

    private static RecursiveScanner.FilePathTester makeFilePathTesterMatchingRegexp(final String pathRegexp) {
        return new RecursiveScanner.FilePathTester(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(pathRegexp);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr) {
                boolean matched = this.pattern.matcher(relativePathStr).matches();
                if (matched && verbose) {
                    Log.log(3, "File " + relativePathStr + " matched filename pattern " + pathRegexp);
                }
                return matched;
            }
        };
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingRegexp(pathRegexp), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingRegexp(pathRegexp), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchProcessor));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingRegexp(pathRegexp), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingRegexp(pathRegexp), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
        return this;
    }

    private static RecursiveScanner.FilePathTester makeFilePathTesterMatchingRelativePath(final String relativePathToMatch) {
        return new RecursiveScanner.FilePathTester(){

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr) {
                boolean matched = relativePathStr.equals(relativePathToMatch);
                if (matched && verbose) {
                    Log.log(3, "Matched filename path " + relativePathToMatch);
                }
                return matched;
            }
        };
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingRelativePath(relativePathToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingRelativePath(relativePathToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchProcessor));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingRelativePath(relativePathToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingRelativePath(relativePathToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
        return this;
    }

    private static RecursiveScanner.FilePathTester makeFilePathTesterMatchingPathLeaf(final String pathLeafToMatch) {
        return new RecursiveScanner.FilePathTester(){
            private final String leafToMatch;
            {
                this.leafToMatch = pathLeafToMatch.substring(pathLeafToMatch.lastIndexOf(47) + 1);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr) {
                String relativePathLeaf = relativePathStr.substring(relativePathStr.lastIndexOf(47) + 1);
                boolean matched = relativePathLeaf.equals(this.leafToMatch);
                if (matched && verbose) {
                    Log.log(3, "File " + relativePathStr + " matched path leaf " + pathLeafToMatch);
                }
                return matched;
            }
        };
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchProcessor));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
        return this;
    }

    private static RecursiveScanner.FilePathTester makeFilePathTesterMatchingFilenameExtension(final String extensionToMatch) {
        return new RecursiveScanner.FilePathTester(){
            private final String suffixToMatch;
            {
                this.suffixToMatch = "." + extensionToMatch.toLowerCase();
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePath) {
                boolean matched;
                boolean bl = matched = relativePath.endsWith(this.suffixToMatch) || relativePath.toLowerCase().endsWith(this.suffixToMatch);
                if (matched && verbose) {
                    Log.log(3, "File " + relativePath + " matched extension ." + extensionToMatch);
                }
                return matched;
            }
        };
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchProcessor));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getRecursiveScanner().addFilePathMatcher(FastClasspathScanner.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), FastClasspathScanner.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
        return this;
    }

    public synchronized List<File> getUniqueClasspathElements() {
        return this.getClasspathFinder().getUniqueClasspathElements();
    }

    public synchronized String generateClassGraphDotFile(float sizeX, float sizeY) {
        if (verbose) {
            Log.log("Generating .dot file");
        }
        return this.getScanResults().generateClassGraphDotFile(sizeX, sizeY);
    }

    public synchronized ClassGraphBuilder getScanResults() {
        ClassGraphBuilder classGraphBuilder = this.getRecursiveScanner().getClassGraphBuilder();
        if (classGraphBuilder == null) {
            throw new RuntimeException("Must call .scan() before attempting to get the results of the scan");
        }
        return classGraphBuilder;
    }

    public synchronized FastClasspathScanner scan() {
        long scanStart = System.nanoTime();
        if (verbose) {
            Log.log("FastClasspathScanner version " + FastClasspathScanner.getVersion());
            Log.log("Classpath elements: " + this.getClasspathFinder().getUniqueClasspathElements());
        }
        this.getRecursiveScanner().scan();
        if (verbose) {
            Log.log("Finished .scan()", System.nanoTime() - scanStart);
        }
        return this;
    }

    public synchronized boolean classpathContentsModifiedSinceScan() {
        long scanStart = System.nanoTime();
        if (this.getRecursiveScanner().getClassGraphBuilder() == null) {
            return true;
        }
        boolean modified = this.getRecursiveScanner().classpathContentsModifiedSinceScan();
        if (verbose) {
            Log.log("Finished .classpathContentsModifiedSinceScan()", System.nanoTime() - scanStart);
        }
        return modified;
    }

    public synchronized long classpathContentsLastModifiedTime() {
        this.getScanResults();
        return this.getRecursiveScanner().classpathContentsLastModifiedTime();
    }

    public synchronized FastClasspathScanner verbose() {
        verbose = true;
        return this;
    }

    public synchronized FastClasspathScanner verbose(boolean verbosity) {
        verbose = verbosity;
        return this;
    }

    public static interface ClassMatcher {
        public void lookForMatches();
    }
}

