/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecursiveScanner {
    private final int NUM_THREADS = 5;
    private final ClasspathFinder classpathFinder;
    private final ScanSpec scanSpec;
    private final ArrayList<FastClasspathScanner.ClassMatcher> classMatchers;
    private final Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch;
    private final Map<String, ArrayList<StaticFinalFieldMatchProcessor>> fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors;
    private final List<FilePathTesterAndMatchProcessorWrapper> filePathTestersAndMatchProcessorWrappers = new ArrayList<FilePathTesterAndMatchProcessorWrapper>();
    private final Set<String> previouslyScannedCanonicalPaths = new HashSet<String>();
    private final Set<String> previouslyScannedRelativePaths = new HashSet<String>();
    private final Map<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
    private ClassGraphBuilder classGraphBuilder;
    private final AtomicInteger numDirsScanned = new AtomicInteger();
    private final AtomicInteger numJarfileDirsScanned = new AtomicInteger();
    private final AtomicInteger numFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfileFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfilesScanned = new AtomicInteger();
    private final AtomicInteger numClassfilesScanned = new AtomicInteger();
    private long lastModified = 0L;

    public void addFilePathMatcher(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
        this.filePathTestersAndMatchProcessorWrappers.add(new FilePathTesterAndMatchProcessorWrapper(filePathTester, fileMatchProcessorWrapper));
    }

    public RecursiveScanner(ClasspathFinder classpathFinder, ScanSpec scanSpec, ArrayList<FastClasspathScanner.ClassMatcher> classMatchers, Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch, Map<String, ArrayList<StaticFinalFieldMatchProcessor>> fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors) {
        this.classpathFinder = classpathFinder;
        this.scanSpec = scanSpec;
        this.classMatchers = classMatchers;
        this.classNameToStaticFinalFieldsToMatch = classNameToStaticFinalFieldsToMatch;
        this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors = fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors;
    }

    private boolean previouslyScanned(File fileOrDir) {
        try {
            return !this.previouslyScannedCanonicalPaths.add(fileOrDir.getCanonicalPath());
        }
        catch (IOException | SecurityException e) {
            return true;
        }
    }

    private boolean previouslyScanned(String relativePath) {
        return !this.previouslyScannedRelativePaths.add(relativePath);
    }

    private void scanDir(File classpathElt, File dir, int ignorePrefixLen, boolean inWhitelistedPath, boolean scanTimestampsOnly, Queue<String> whitelistedClassfileRelativePaths) {
        if (this.previouslyScanned(dir)) {
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Reached duplicate directory, ignoring: " + dir);
            }
            return;
        }
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanning directory: " + dir);
        }
        this.updateLastModifiedTimestamp(dir.lastModified());
        this.numDirsScanned.incrementAndGet();
        String dirPath = dir.getPath();
        String dirRelativePath = ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        ScanSpec.ScanSpecPathMatch matchStatus = this.scanSpec.pathWhitelistMatchStatus(dirRelativePath);
        if (matchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH) {
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Reached non-whitelisted (or blacklisted) directory: " + dirRelativePath);
            }
            return;
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) {
            inWhitelistedPath = true;
        }
        long startTime = System.nanoTime();
        File[] filesInDir = dir.listFiles();
        if (filesInDir == null) {
            if (FastClasspathScanner.verbose) {
                Log.log(4, "Invalid directory " + dir);
            }
            return;
        }
        for (File fileInDir : filesInDir) {
            String fileInDirRelativePath;
            if (fileInDir.isDirectory()) {
                if (!inWhitelistedPath && matchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) continue;
                this.scanDir(classpathElt, fileInDir, ignorePrefixLen, inWhitelistedPath, scanTimestampsOnly, whitelistedClassfileRelativePaths);
                continue;
            }
            if (!fileInDir.isFile()) continue;
            String string = fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? fileInDir.getName() : dirRelativePath + fileInDir.getName();
            if (!inWhitelistedPath && (matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(fileInDirRelativePath))) continue;
            boolean subFilePreviouslyScannedCanonical = this.previouslyScanned(fileInDir);
            boolean subFilePreviouslyScannedRelative = this.previouslyScanned(fileInDirRelativePath);
            if (subFilePreviouslyScannedRelative || subFilePreviouslyScannedCanonical) {
                if (!FastClasspathScanner.verbose) continue;
                Log.log(3, "Reached duplicate path, ignoring: " + fileInDirRelativePath);
                continue;
            }
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Found whitelisted file: " + fileInDirRelativePath);
            }
            this.updateLastModifiedTimestamp(fileInDir.lastModified());
            if (scanTimestampsOnly) continue;
            boolean isClassfile = fileInDirRelativePath.endsWith(".class");
            if (isClassfile) {
                whitelistedClassfileRelativePaths.add(fileInDirRelativePath);
                this.numClassfilesScanned.incrementAndGet();
            }
            boolean matchedFile = isClassfile;
            for (FilePathTesterAndMatchProcessorWrapper fileMatcher : this.filePathTestersAndMatchProcessorWrappers) {
                if (!fileMatcher.filePathTester.filePathMatches(classpathElt, fileInDirRelativePath)) continue;
                try {
                    matchedFile = true;
                    long fileStartTime = System.nanoTime();
                    try (FileInputStream inputStream = new FileInputStream(fileInDir);){
                        fileMatcher.fileMatchProcessorWrapper.processMatch(classpathElt, fileInDirRelativePath, inputStream, fileInDir.length());
                    }
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(4, "Processed file match " + fileInDirRelativePath, System.nanoTime() - fileStartTime);
                }
                catch (Exception e) {
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(3, "Reached non-whitelisted (or blacklisted) file, ignoring: " + fileInDirRelativePath);
                }
            }
            if (!matchedFile) continue;
            this.numFilesScanned.incrementAndGet();
        }
        if (FastClasspathScanner.verbose) {
            Log.log(4, "Scanned directory " + dir + " and any subdirectories", System.nanoTime() - startTime);
        }
    }

    private void scanZipfile(File classpathElt, ZipFile zipFile, Queue<String> whitelistedClassfileRelativePathsOut) {
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanning jarfile: " + classpathElt);
        }
        long startTime = System.nanoTime();
        String prevParentRelativePath = null;
        ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            boolean isClassfile;
            long entryStartTime = System.nanoTime();
            ZipEntry zipEntry = entries.nextElement();
            String relativePath = zipEntry.getName();
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (zipEntry.isDirectory()) {
                if (prevParentMatchStatus != ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) continue;
                this.numJarfileDirsScanned.incrementAndGet();
                if (!FastClasspathScanner.verbose) continue;
                this.numJarfileFilesScanned.incrementAndGet();
                Log.log(4, "Reached jarfile-internal directory " + relativePath, System.nanoTime() - entryStartTime);
                continue;
            }
            if (this.previouslyScanned(relativePath)) {
                if (!FastClasspathScanner.verbose) continue;
                Log.log(3, "Reached duplicate relative path, ignoring: " + relativePath);
                continue;
            }
            int lastSlashIdx = relativePath.lastIndexOf("/");
            String parentRelativePath = lastSlashIdx < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
            ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || !parentRelativePath.equals(prevParentRelativePath) ? this.scanSpec.pathWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
            boolean parentPathChanged = !parentRelativePath.equals(prevParentRelativePath);
            prevParentRelativePath = parentRelativePath;
            prevParentMatchStatus = parentMatchStatus;
            if (!(parentMatchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE && this.scanSpec.isSpecificallyWhitelistedClass(relativePath))) {
                if (!FastClasspathScanner.verbose || !parentPathChanged) continue;
                Log.log(3, "Reached non-whitelisted (or blacklisted) file in jar, ignoring: " + parentRelativePath);
                continue;
            }
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Found whitelisted file in jarfile: " + relativePath);
            }
            if (isClassfile = relativePath.endsWith(".class")) {
                whitelistedClassfileRelativePathsOut.add(relativePath);
                this.numClassfilesScanned.incrementAndGet();
            }
            boolean matchedFile = isClassfile;
            for (FilePathTesterAndMatchProcessorWrapper fileMatcher : this.filePathTestersAndMatchProcessorWrappers) {
                if (!fileMatcher.filePathTester.filePathMatches(classpathElt, relativePath)) continue;
                try {
                    matchedFile = true;
                    long fileStartTime = System.nanoTime();
                    try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                        fileMatcher.fileMatchProcessorWrapper.processMatch(classpathElt, relativePath, inputStream, zipEntry.getSize());
                    }
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(4, "Processed file match " + relativePath, System.nanoTime() - fileStartTime);
                }
                catch (Exception e) {
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(3, "Reached non-whitelisted (or blacklisted) file, ignoring: " + relativePath);
                }
            }
            if (!matchedFile) continue;
            this.numJarfileFilesScanned.incrementAndGet();
        }
        if (FastClasspathScanner.verbose) {
            Log.log(4, "Scanned jarfile " + classpathElt, System.nanoTime() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scan(boolean scanTimestampsOnly) {
        ExecutorService executorService = null;
        try {
            executorService = Executors.newFixedThreadPool(5);
            final Log.DeferredLog[] logs = new Log.DeferredLog[5];
            for (int i = 0; i < 5; ++i) {
                logs[i] = new Log.DeferredLog();
            }
            List<File> uniqueClasspathElts = this.classpathFinder.getUniqueClasspathElements();
            if (FastClasspathScanner.verbose) {
                Log.log(1, "Starting scan" + (scanTimestampsOnly ? " (scanning classpath timestamps only)" : ""));
            }
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "false");
            this.previouslyScannedCanonicalPaths.clear();
            this.previouslyScannedRelativePaths.clear();
            this.numDirsScanned.set(0);
            this.numFilesScanned.set(0);
            this.numJarfileDirsScanned.set(0);
            this.numJarfileFilesScanned.set(0);
            this.numJarfilesScanned.set(0);
            this.numClassfilesScanned.set(0);
            if (!scanTimestampsOnly) {
                this.classNameToClassInfo.clear();
            }
            final ConcurrentLinkedQueue<String> whitelistedClassfileRelativePaths = new ConcurrentLinkedQueue<String>();
            for (final File classpathElt : uniqueClasspathElts) {
                ExecutorCompletionService<Void> completionService;
                ConcurrentLinkedQueue classInfoUnlinked;
                boolean isJar;
                String path = classpathElt.getPath();
                boolean isDirectory = classpathElt.isDirectory();
                boolean isFile = classpathElt.isFile();
                if (!isDirectory && !isFile) {
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(2, "Skipping non-file/non-dir on classpath: " + classpathElt);
                    continue;
                }
                boolean bl = isJar = isFile && ClasspathFinder.isJar(path);
                if (FastClasspathScanner.verbose) {
                    Log.log(2, "Found " + (isDirectory ? "directory" : (isJar ? "jar" : "file")) + " on classpath: " + path);
                }
                if (isDirectory && this.scanSpec.scanNonJars) {
                    this.scanDir(classpathElt, classpathElt, path.length() + 1, false, scanTimestampsOnly, whitelistedClassfileRelativePaths);
                    classInfoUnlinked = new ConcurrentLinkedQueue();
                    completionService = new ExecutorCompletionService<Void>(executorService);
                    int i = 0;
                    while (i < 5) {
                        final int threadIdx = i++;
                        completionService.submit(new Callable<Void>(){

                            @Override
                            public Void call() {
                                String relativePath;
                                Log.DeferredLog log = logs[threadIdx];
                                while ((relativePath = (String)whitelistedClassfileRelativePaths.poll()) != null) {
                                    long fileStartTime;
                                    block16: {
                                        File classpathFile = new File(classpathElt.getPath() + File.separator + (File.separatorChar == '/' ? relativePath : relativePath.replace('/', File.separatorChar)));
                                        fileStartTime = System.nanoTime();
                                        try (FileInputStream inputStream = new FileInputStream(classpathFile);){
                                            ClassInfo.ClassInfoUnlinked thisClassInfoUnlinked = ClassfileBinaryParser.readClassInfoFromClassfileHeader(relativePath, inputStream, RecursiveScanner.this.classNameToStaticFinalFieldsToMatch, RecursiveScanner.this.scanSpec, log);
                                            if (thisClassInfoUnlinked != null) {
                                                classInfoUnlinked.add(thisClassInfoUnlinked);
                                            }
                                        }
                                        catch (IOException e) {
                                            if (!FastClasspathScanner.verbose) break block16;
                                            log.log(4, "Exception while trying to open " + classpathFile + ": " + e);
                                        }
                                    }
                                    if (!FastClasspathScanner.verbose) continue;
                                    log.log(6, "Parsed classfile " + relativePath, System.nanoTime() - fileStartTime);
                                }
                                return null;
                            }
                        });
                    }
                    for (i = 0; i < 5; ++i) {
                        logs[i].flushSynchronized();
                        try {
                            completionService.take().get();
                            continue;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            Log.log(4, "Exception while processing classpath element " + classpathElt + ": " + e);
                        }
                    }
                    for (ClassInfo.ClassInfoUnlinked c : classInfoUnlinked) {
                        c.link(this.classNameToClassInfo);
                    }
                    continue;
                }
                if (isJar && this.scanSpec.scanJars) {
                    block46: {
                        if (this.previouslyScanned(classpathElt)) {
                            if (!FastClasspathScanner.verbose) continue;
                            Log.log(3, "Reached duplicate jarfile, ignoring: " + classpathElt);
                            continue;
                        }
                        if (!this.scanSpec.jarIsWhitelisted(classpathElt.getName())) {
                            if (!FastClasspathScanner.verbose) continue;
                            Log.log(3, "Skipping jarfile that did not match whitelist/blacklist criteria: " + classpathElt.getName());
                            continue;
                        }
                        this.updateLastModifiedTimestamp(classpathElt.lastModified());
                        this.numJarfilesScanned.incrementAndGet();
                        if (scanTimestampsOnly) continue;
                        try {
                            ZipFile zipFile = new ZipFile(classpathElt);
                            completionService = null;
                            try {
                                long startTime = System.nanoTime();
                                this.scanZipfile(classpathElt, zipFile, whitelistedClassfileRelativePaths);
                                if (FastClasspathScanner.verbose) {
                                    Log.log(2, "Scanned jarfile " + classpathElt, System.nanoTime() - startTime);
                                }
                            }
                            catch (Throwable startTime) {
                                completionService = startTime;
                                throw startTime;
                            }
                            finally {
                                if (zipFile != null) {
                                    if (completionService != null) {
                                        try {
                                            zipFile.close();
                                        }
                                        catch (Throwable startTime) {
                                            ((Throwable)((Object)completionService)).addSuppressed(startTime);
                                        }
                                    } else {
                                        zipFile.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            if (!FastClasspathScanner.verbose) break block46;
                            Log.log(3, "Error while closing zipfile " + classpathElt + " : " + e);
                        }
                    }
                    classInfoUnlinked = new ConcurrentLinkedQueue();
                    completionService = new ExecutorCompletionService<Void>(executorService);
                    int i = 0;
                    while (i < 5) {
                        final int threadIdx = i++;
                        completionService.submit(new Callable<Void>(){

                            @Override
                            public Void call() {
                                block31: {
                                    Log.DeferredLog log = logs[threadIdx];
                                    try (ZipFile zipFile = new ZipFile(classpathElt);){
                                        String relativePath;
                                        while ((relativePath = (String)whitelistedClassfileRelativePaths.poll()) != null) {
                                            long fileStartTime;
                                            block30: {
                                                fileStartTime = System.nanoTime();
                                                ZipEntry zipEntry = zipFile.getEntry(relativePath);
                                                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                                                    ClassInfo.ClassInfoUnlinked thisClassInfoUnlinked = ClassfileBinaryParser.readClassInfoFromClassfileHeader(relativePath, inputStream, RecursiveScanner.this.classNameToStaticFinalFieldsToMatch, RecursiveScanner.this.scanSpec, log);
                                                    if (thisClassInfoUnlinked != null) {
                                                        classInfoUnlinked.add(thisClassInfoUnlinked);
                                                    }
                                                }
                                                catch (IOException e) {
                                                    if (!FastClasspathScanner.verbose) break block30;
                                                    log.log(4, "Exception while trying to open " + relativePath + " in zipfile " + classpathElt + ": " + e);
                                                }
                                            }
                                            if (!FastClasspathScanner.verbose) continue;
                                            log.log(6, "Parsed classfile " + relativePath, System.nanoTime() - fileStartTime);
                                        }
                                    }
                                    catch (IOException e) {
                                        if (!FastClasspathScanner.verbose) break block31;
                                        log.log(4, "Exception while reading zipfile " + classpathElt + " : " + e);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    for (i = 0; i < 5; ++i) {
                        logs[i].flushSynchronized();
                        try {
                            completionService.take().get();
                            continue;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            Log.log(4, "Exception while processing classpath element " + classpathElt + ": " + e);
                        }
                    }
                    for (ClassInfo.ClassInfoUnlinked c : classInfoUnlinked) {
                        c.link(this.classNameToClassInfo);
                    }
                    continue;
                }
                if (!FastClasspathScanner.verbose) continue;
                Log.log(2, "Skipping classpath element: " + path);
            }
            if (!scanTimestampsOnly) {
                this.classGraphBuilder = new ClassGraphBuilder(this.classNameToClassInfo);
                for (FastClasspathScanner.ClassMatcher classMatcher : this.classMatchers) {
                    classMatcher.lookForMatches();
                }
                for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
                    if (classInfo.fieldValues == null) continue;
                    for (Map.Entry<String, Object> ent : classInfo.fieldValues.entrySet()) {
                        String fieldName = ent.getKey();
                        Object constValue = ent.getValue();
                        String fullyQualifiedFieldName = classInfo.className + "." + fieldName;
                        ArrayList<StaticFinalFieldMatchProcessor> staticFinalFieldMatchProcessors = this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.get(fullyQualifiedFieldName);
                        if (staticFinalFieldMatchProcessors == null) continue;
                        if (FastClasspathScanner.verbose) {
                            Log.log(1, "Calling MatchProcessor for static final field " + classInfo.className + "." + fieldName + " = " + constValue);
                        }
                        for (StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor : staticFinalFieldMatchProcessors) {
                            staticFinalFieldMatchProcessor.processMatch(classInfo.className, fieldName, constValue);
                        }
                    }
                }
            }
            if (FastClasspathScanner.verbose) {
                Log.log(1, "Number of resources scanned: directories: " + this.numDirsScanned.get() + "; files: " + this.numFilesScanned.get() + "; jarfiles: " + this.numJarfilesScanned.get() + "; jarfile-internal directories: " + this.numJarfileDirsScanned + "; jarfile-internal files: " + this.numJarfileFilesScanned + "; classfiles: " + this.numClassfilesScanned);
            }
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
                executorService = null;
            }
        }
    }

    public void scan() {
        this.scan(false);
    }

    public ClassGraphBuilder getClassGraphBuilder() {
        return this.classGraphBuilder;
    }

    private void updateLastModifiedTimestamp(long fileLastModified) {
        this.lastModified = Math.max(this.lastModified, Math.min(System.currentTimeMillis(), fileLastModified));
    }

    public boolean classpathContentsModifiedSinceScan() {
        long oldLastModified = this.lastModified;
        if (oldLastModified == 0L) {
            return true;
        }
        this.scan(true);
        long newLastModified = this.lastModified;
        return newLastModified > oldLastModified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.lastModified;
    }

    private static class FilePathTesterAndMatchProcessorWrapper {
        FilePathTester filePathTester;
        FileMatchProcessorWrapper fileMatchProcessorWrapper;

        public FilePathTesterAndMatchProcessorWrapper(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessorWrapper = fileMatchProcessorWrapper;
        }
    }

    public static interface FileMatchProcessorWrapper {
        public void processMatch(File var1, String var2, InputStream var3, long var4) throws IOException;
    }

    public static interface FilePathTester {
        public boolean filePathMatches(File var1, String var2);
    }
}

