/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class Log {
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmX").withZone(ZoneOffset.UTC);
    private static DecimalFormat nanoFormatter = new DecimalFormat("0.000000");

    private Log() {
    }

    private static String indent(int indentLevel, String msg) {
        int numIndentChars = 2 * indentLevel;
        StringBuilder buf = new StringBuilder(msg.length() + numIndentChars);
        for (int i = 0; i < numIndentChars - 1; ++i) {
            buf.append('-');
        }
        if (numIndentChars > 0) {
            buf.append(" ");
        }
        buf.append(msg);
        return buf.toString();
    }

    public static void log(int indentLevel, String msg) {
        System.err.println(dateTimeFormatter.format(Instant.now()) + "\t" + FastClasspathScanner.class.getSimpleName() + "\t" + Log.indent(indentLevel, msg));
    }

    public static void log(String msg) {
        Log.log(0, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int indentLevel, String msg, long elapsedTimeNanos) {
        String elapsed;
        DecimalFormat decimalFormat = nanoFormatter;
        synchronized (decimalFormat) {
            elapsed = nanoFormatter.format((double)elapsedTimeNanos * 1.0E-9);
        }
        System.err.println(dateTimeFormatter.format(Instant.now()) + "\t" + FastClasspathScanner.class.getSimpleName() + "\t" + Log.indent(indentLevel, msg) + " in " + elapsed + " sec");
    }

    public static void log(String msg, long elapsedTimeNanos) {
        Log.log(0, msg, elapsedTimeNanos);
    }

    public static void flush() {
        System.err.flush();
    }

    public static class DeferredLog {
        private final List<DeferredLogEntry> logEntries = new ArrayList<DeferredLogEntry>();
        private static Object lock = new Object();

        public void log(int indentLevel, String msg) {
            this.logEntries.add(new DeferredLogEntry(indentLevel, msg));
        }

        public void log(String msg) {
            this.logEntries.add(new DeferredLogEntry(0, msg));
        }

        public void log(int indentLevel, String msg, long elapsedTimeNanos) {
            this.logEntries.add(new DeferredLogEntry(indentLevel, msg, elapsedTimeNanos));
        }

        public void log(String msg, long elapsedTimeNanos) {
            this.logEntries.add(new DeferredLogEntry(0, msg, elapsedTimeNanos));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushSynchronized() {
            if (!this.logEntries.isEmpty()) {
                Object object = lock;
                synchronized (object) {
                    for (DeferredLogEntry entry : this.logEntries) {
                        entry.sendToLog();
                    }
                    this.logEntries.clear();
                    Log.flush();
                }
            }
        }

        private static class DeferredLogEntry {
            final int indentLevel;
            final String msg;
            final long elapsedTimeNanos;

            public DeferredLogEntry(int indentLevel, String msg, long elapsedTimeNanos) {
                this.indentLevel = indentLevel;
                this.msg = msg;
                this.elapsedTimeNanos = elapsedTimeNanos;
            }

            public DeferredLogEntry(int indentLevel, String msg) {
                this.indentLevel = indentLevel;
                this.msg = msg;
                this.elapsedTimeNanos = -1L;
            }

            public void sendToLog() {
                if (this.elapsedTimeNanos < 0L) {
                    Log.log(this.indentLevel, this.msg);
                } else {
                    Log.log(this.indentLevel, this.msg, this.elapsedTimeNanos);
                }
            }
        }
    }
}

