/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classpath;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classpath.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.jar.Manifest;

public class ClasspathFinder {
    private final ScanSpec scanSpec;
    private final ArrayList<File> classpathElements = new ArrayList();
    private final HashSet<String> classpathElementsSet = new HashSet();
    private final HashSet<String> knownJREPaths = new HashSet();
    private final HashSet<ClassLoaderHandler> extraClassLoaderHandlers = new HashSet();
    private boolean initialized = false;
    private static CallerResolver CALLER_RESOLVER;

    public ClasspathFinder(ScanSpec scanSpec) {
        this.scanSpec = scanSpec;
    }

    private void clearClasspath() {
        this.classpathElements.clear();
        this.classpathElementsSet.clear();
        this.initialized = false;
    }

    private static boolean isJarMatchCase(String path) {
        return path.endsWith(".jar") || path.endsWith(".zip") || path.endsWith(".war") || path.endsWith(".car");
    }

    public static boolean isJar(String path) {
        return ClasspathFinder.isJarMatchCase(path) || ClasspathFinder.isJarMatchCase(path.toLowerCase());
    }

    private static File urlToFile(File resolveBaseFile, String relativePathStr) {
        if (relativePathStr.isEmpty()) {
            return null;
        }
        String pathStr = relativePathStr;
        if (pathStr.startsWith("jar:")) {
            pathStr = pathStr.substring(4);
        }
        if (pathStr.startsWith("http:") || pathStr.startsWith("https:")) {
            if (FastClasspathScanner.verbose) {
                Log.log("Ignoring remote entry in classpath: " + pathStr);
            }
            return null;
        }
        if (pathStr.indexOf(92) >= 0) {
            pathStr = pathStr.replace('\\', '/');
        }
        if (pathStr.startsWith("file://")) {
            pathStr = pathStr.substring(7);
        }
        if (pathStr.startsWith("file:")) {
            pathStr = pathStr.substring(5);
        }
        if (pathStr.length() > 2 && Character.isLetter(pathStr.charAt(0)) && pathStr.charAt(1) == ':') {
            pathStr = '/' + pathStr;
        }
        if (pathStr.endsWith("/") && !pathStr.equals("/")) {
            pathStr = pathStr.substring(0, pathStr.length() - 1);
        }
        pathStr = pathStr.replace("//", "/");
        pathStr = pathStr.replace(" ", "%20");
        try {
            if (pathStr.startsWith("/")) {
                return new File(new URL("file:" + pathStr).toURI());
            }
            if (resolveBaseFile == null) {
                return new File(new URL(pathStr).toURI());
            }
            String base = resolveBaseFile.toURI().toString();
            if (!base.endsWith("/")) {
                base = base + "/";
            }
            return new File(new URL(base + pathStr).toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            if (FastClasspathScanner.verbose) {
                Log.log("Exception while constructing classpath entry from base file " + resolveBaseFile + " and relative path " + relativePathStr + ": " + e);
            }
            return null;
        }
    }

    public void addClasspathElement(String pathElement) {
        this.addClasspathElement(null, pathElement);
    }

    public void addClasspathElement(File baseFile, String pathElement) {
        String pathStr;
        File pathFile = ClasspathFinder.urlToFile(baseFile, pathElement);
        if (pathFile == null) {
            return;
        }
        if (!pathFile.exists()) {
            if (FastClasspathScanner.verbose) {
                Log.log("Classpath element does not exist: " + pathElement);
            }
            return;
        }
        try {
            pathStr = pathFile.getCanonicalPath();
        }
        catch (IOException e) {
            if (FastClasspathScanner.verbose) {
                Log.log("Exception while getting canonical path for classpath element " + pathElement + ": " + e);
            }
            return;
        }
        if (!this.classpathElementsSet.add(pathStr)) {
            if (FastClasspathScanner.verbose) {
                Log.log("Ignoring duplicate classpath element: " + pathElement);
            }
            return;
        }
        if (pathFile.isFile()) {
            if (!ClasspathFinder.isJar(pathStr)) {
                if (FastClasspathScanner.verbose) {
                    Log.log("Ignoring non-jar file on classpath: " + pathElement);
                }
                return;
            }
            if (this.scanSpec.blacklistSystemJars() && this.isJREJar(pathFile, 2)) {
                if (FastClasspathScanner.verbose) {
                    Log.log("Skipping JRE jar: " + pathElement);
                }
                return;
            }
            String manifestUrlStr = "jar:" + pathFile.toURI() + "!/META-INF/MANIFEST.MF";
            try (InputStream stream = new URL(manifestUrlStr).openStream();){
                Manifest manifest = new Manifest(stream);
                String manifestClassPath = manifest.getMainAttributes().getValue("Class-Path");
                if (manifestClassPath != null && !manifestClassPath.isEmpty()) {
                    if (FastClasspathScanner.verbose) {
                        Log.log("Found Class-Path entry in " + manifestUrlStr + ": " + manifestClassPath);
                    }
                    File parentPathFile = pathFile.getParentFile();
                    for (String manifestClassPathElement : manifestClassPath.split(" ")) {
                        File manifestEltPath = ClasspathFinder.urlToFile(parentPathFile, manifestClassPathElement);
                        if (manifestEltPath != null) {
                            this.addClasspathElement(manifestEltPath.toString());
                            continue;
                        }
                        if (!FastClasspathScanner.verbose) continue;
                        Log.log("Classpath element " + manifestEltPath + " not found -- from Class-Path entry " + manifestClassPathElement + " in " + manifestUrlStr);
                    }
                }
            }
            catch (IOException iOException) {}
        } else if (!pathFile.isDirectory()) {
            if (FastClasspathScanner.verbose) {
                Log.log("Ignoring invalid classpath element: " + pathElement);
            }
            return;
        }
        if (FastClasspathScanner.verbose) {
            Log.log("Found classpath element: " + pathElement);
        }
        this.classpathElements.add(pathFile);
    }

    public void addClasspathElements(String pathStr) {
        if (pathStr != null && !pathStr.isEmpty()) {
            for (String pathElement : pathStr.split(File.pathSeparator)) {
                this.addClasspathElement(pathElement);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJREJar(File file, int ancestralScanDepth) {
        File parent;
        if (ancestralScanDepth == 0) {
            return false;
        }
        try {
            parent = file.getParentFile().getCanonicalFile();
            if (parent == null) {
                return false;
            }
        }
        catch (IOException e1) {
            return false;
        }
        String parentPathStr = parent.getPath();
        if (this.knownJREPaths.contains(parentPathStr)) {
            return true;
        }
        File rt = new File(parent, "rt.jar");
        if (!rt.exists() && !(rt = new File(new File(parent, "lib"), "rt.jar")).exists()) {
            rt = new File(new File(new File(parent, "jre"), "lib.jar"), "rt.jar");
        }
        if (!rt.exists()) return this.isJREJar(parent, ancestralScanDepth - 1);
        String manifestUrlStr = "jar:" + rt.toURI() + "!/META-INF/MANIFEST.MF";
        try (InputStream stream = new URL(manifestUrlStr).openStream();){
            Manifest manifest = new Manifest(stream);
            if (!"Java Runtime Environment".equals(manifest.getMainAttributes().getValue("Implementation-Title"))) {
                if (!"Java Platform API Specification".equals(manifest.getMainAttributes().getValue("Specification-Title"))) return this.isJREJar(parent, ancestralScanDepth - 1);
            }
            this.knownJREPaths.add(parentPathStr);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.isJREJar(parent, ancestralScanDepth - 1);
    }

    private static void addAllParentClassloaders(ClassLoader classLoader, AdditionOrderedSet<ClassLoader> classLoadersSetOut) {
        ArrayList<ClassLoader> callerClassLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            callerClassLoaders.add(cl);
        }
        for (int i = callerClassLoaders.size() - 1; i >= 0; --i) {
            classLoadersSetOut.add((ClassLoader)callerClassLoaders.get(i));
        }
    }

    private static void addAllParentClassloaders(Class<?> klass, AdditionOrderedSet<ClassLoader> classLoadersSetOut) {
        ClasspathFinder.addAllParentClassloaders(klass.getClassLoader(), classLoadersSetOut);
    }

    public void registerClassLoaderHandler(ClassLoaderHandler extraClassLoaderHandler) {
        this.extraClassLoaderHandlers.add(extraClassLoaderHandler);
    }

    public void overrideClasspath(String classpath) {
        this.clearClasspath();
        this.addClasspathElements(classpath);
        this.initialized = true;
    }

    public List<File> getUniqueClasspathElements() {
        if (!this.initialized) {
            this.clearClasspath();
            AdditionOrderedSet<ClassLoader> classLoadersSet = new AdditionOrderedSet<ClassLoader>();
            ClasspathFinder.addAllParentClassloaders(ClassLoader.getSystemClassLoader(), classLoadersSet);
            if (CALLER_RESOLVER != null) {
                Class<?>[] callStack;
                for (Class<?> callStackClass : callStack = CALLER_RESOLVER.getClassContext()) {
                    ClasspathFinder.addAllParentClassloaders(callStackClass, classLoadersSet);
                }
            } else if (FastClasspathScanner.verbose) {
                Log.log(ClasspathFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
            }
            ClasspathFinder.addAllParentClassloaders(Thread.currentThread().getContextClassLoader(), classLoadersSet);
            ClasspathFinder.addAllParentClassloaders(ClasspathFinder.class, classLoadersSet);
            List<ClassLoader> classLoaders = classLoadersSet.getList();
            classLoaders.remove(null);
            HashSet<ClassLoaderHandler> classLoaderHandlers = new HashSet<ClassLoaderHandler>();
            classLoaderHandlers.add(new URLClassLoaderHandler());
            for (ClassLoaderHandler handler : ServiceLoader.load(ClassLoaderHandler.class, null)) {
                classLoaderHandlers.add(handler);
            }
            for (ClassLoader classLoader : classLoaders) {
                ServiceLoader<ClassLoaderHandler> classLoaderHandlerLoader = ServiceLoader.load(ClassLoaderHandler.class, classLoader);
                for (ClassLoaderHandler handler : classLoaderHandlerLoader) {
                    classLoaderHandlers.add(handler);
                }
            }
            classLoaderHandlers.addAll(this.extraClassLoaderHandlers);
            HashSet<String> classLoaderHandlerNames = new HashSet<String>();
            ArrayList<ClassLoaderHandler> classLoaderHandlersUnique = new ArrayList<ClassLoaderHandler>();
            for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                if (!classLoaderHandlerNames.add(classLoaderHandler.getClass().getName())) continue;
                classLoaderHandlersUnique.add(classLoaderHandler);
            }
            if (FastClasspathScanner.verbose && !classLoaderHandlers.isEmpty()) {
                Log.log("ClassLoaderHandlers loaded: " + String.join((CharSequence)", ", classLoaderHandlerNames));
            }
            for (ClassLoader classLoader : classLoaders) {
                boolean classloaderFound = false;
                for (ClassLoaderHandler handler : classLoaderHandlersUnique) {
                    try {
                        if (!handler.handle(classLoader, this)) continue;
                        if (FastClasspathScanner.verbose) {
                            Log.log("Classpath elements from ClassLoader " + classLoader.getClass().getName() + " were extracted by ClassLoaderHandler " + handler.getClass().getName());
                        }
                        classloaderFound = true;
                        break;
                    }
                    catch (Exception e) {
                        if (!FastClasspathScanner.verbose) continue;
                        Log.log("Exception in " + classLoader.getClass().getName() + ": " + e.toString());
                    }
                }
                if (classloaderFound || !FastClasspathScanner.verbose) continue;
                Log.log("Found unknown ClassLoader type, cannot scan classes: " + classLoader.getClass().getName());
            }
            this.addClasspathElements(System.getProperty("java.class.path"));
            this.initialized = true;
        }
        return this.classpathElements;
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class URLClassLoaderHandler
    implements ClassLoaderHandler {
        private URLClassLoaderHandler() {
        }

        @Override
        public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder) {
            if (classloader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)classloader).getURLs();
                if (urls != null) {
                    for (URL url : urls) {
                        if (url == null) continue;
                        classpathFinder.addClasspathElement(url.toString());
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

