/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classpath.classloaderhandlers;

import io.github.lukehutch.fastclasspathscanner.classpath.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Array;

public class JBossClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder) throws Exception {
        for (Class<?> c = classloader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"org.jboss.modules.ModuleClassLoader".equals(c.getName())) continue;
            Object vfsResourceLoaders = ReflectionUtils.invokeMethod(classloader, "getResourceLoaders");
            if (vfsResourceLoaders != null) {
                int n = Array.getLength(vfsResourceLoaders);
                for (int i = 0; i < n; ++i) {
                    Object resourceLoader = Array.get(vfsResourceLoaders, i);
                    if (resourceLoader == null) continue;
                    Object root = ReflectionUtils.getFieldVal(resourceLoader, "root");
                    String pathElement = (String)ReflectionUtils.invokeMethod(root, "getPathName");
                    classpathFinder.addClasspathElement(pathElement);
                }
            }
            return true;
        }
        return false;
    }
}

