/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;

public class ClassInfoLinkerCaller
implements Callable<Void> {
    private int endOfQueueMarkersExpected;
    private LinkedBlockingQueue<ClassInfoUnlinked> classInfoUnlinked;
    private Map<String, ClassInfo> classNameToClassInfo;
    private InterruptionChecker interruptionChecker;

    public ClassInfoLinkerCaller(int endOfQueueMarkersExpected, LinkedBlockingQueue<ClassInfoUnlinked> classInfoUnlinked, Map<String, ClassInfo> classNameToClassInfo, InterruptionChecker interruptionChecker) {
        this.endOfQueueMarkersExpected = endOfQueueMarkersExpected;
        this.classInfoUnlinked = classInfoUnlinked;
        this.classNameToClassInfo = classNameToClassInfo;
        this.interruptionChecker = interruptionChecker;
    }

    @Override
    public Void call() {
        int endOfQueueMarkersNeeded = this.endOfQueueMarkersExpected;
        while (endOfQueueMarkersNeeded > 0) {
            try {
                ClassInfoUnlinked c = this.classInfoUnlinked.take();
                if (c == ClassInfoUnlinked.END_OF_QUEUE) {
                    --endOfQueueMarkersNeeded;
                } else {
                    c.link(this.classNameToClassInfo);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.interruptionChecker.check();
        }
        return null;
    }
}

