/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileResource;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.ZipFile;

class ClassfileBinaryParserCaller
implements Callable<Void> {
    private final LinkedBlockingQueue<ClassfileResource> classfileResourcesIn;
    private final Queue<ClassInfoUnlinked> classInfoUnlinkedOut;
    private final ScanSpec scanSpec;
    private final Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch;
    private final ConcurrentHashMap<String, String> stringInternMap;
    private final InterruptionChecker interruptionChecker;
    private final Log.DeferredLog log;

    public ClassfileBinaryParserCaller(LinkedBlockingQueue<ClassfileResource> classfileResourcesIn, Queue<ClassInfoUnlinked> classInfoUnlinkedOut, ScanSpec scanSpec, Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch, ConcurrentHashMap<String, String> stringInternMap, InterruptionChecker interruptionChecker, Log.DeferredLog log) {
        this.classfileResourcesIn = classfileResourcesIn;
        this.classInfoUnlinkedOut = classInfoUnlinkedOut;
        this.scanSpec = scanSpec;
        this.classNameToStaticFinalFieldsToMatch = classNameToStaticFinalFieldsToMatch;
        this.stringInternMap = stringInternMap;
        this.interruptionChecker = interruptionChecker;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() {
        ZipFile currentlyOpenZipFile = null;
        try {
            ClassfileResource prevClassfileResource = null;
            ClassfileBinaryParser classfileBinaryParser = new ClassfileBinaryParser(this.scanSpec, this.interruptionChecker, this.log);
            while (true) {
                long fileStartTime;
                ClassfileResource classfileResource;
                block38: {
                    if ((classfileResource = this.classfileResourcesIn.take()) == ClassfileResource.END_OF_QUEUE) {
                        this.classInfoUnlinkedOut.add(ClassInfoUnlinked.END_OF_QUEUE);
                        Void void_ = null;
                        return void_;
                    }
                    this.interruptionChecker.check();
                    fileStartTime = System.nanoTime();
                    boolean classfileResourceIsJar = classfileResource.classpathElt.isFile();
                    if (prevClassfileResource == null || classfileResource.classpathElt != prevClassfileResource.classpathElt) {
                        if (currentlyOpenZipFile != null) {
                            try {
                                currentlyOpenZipFile.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            currentlyOpenZipFile = null;
                        }
                        if (classfileResourceIsJar) {
                            try {
                                currentlyOpenZipFile = new ZipFile(classfileResource.classpathElt);
                            }
                            catch (IOException e) {
                                if (!FastClasspathScanner.verbose) continue;
                                this.log.log(2, "Exception while trying to open " + classfileResource.classpathElt + ": " + e);
                                continue;
                            }
                        }
                    }
                    try (InputStream inputStream = classfileResourceIsJar ? currentlyOpenZipFile.getInputStream(currentlyOpenZipFile.getEntry(classfileResource.relativePath)) : new FileInputStream(classfileResource.classpathElt.getPath() + File.separatorChar + (File.separatorChar == '/' ? classfileResource.relativePath : classfileResource.relativePath.replace('/', File.separatorChar)));){
                        this.interruptionChecker.check();
                        ClassInfoUnlinked thisClassInfoUnlinked = classfileBinaryParser.readClassInfoFromClassfileHeader(inputStream, classfileResource.relativePath, this.classNameToStaticFinalFieldsToMatch, this.stringInternMap);
                        if (thisClassInfoUnlinked != null) {
                            this.classInfoUnlinkedOut.add(thisClassInfoUnlinked);
                            thisClassInfoUnlinked.logClassInfo(this.log);
                        }
                    }
                    catch (IOException e) {
                        if (!FastClasspathScanner.verbose) break block38;
                        this.log.log(2, "Exception while trying to open " + classfileResource.relativePath + ": " + e);
                    }
                }
                if (FastClasspathScanner.verbose) {
                    this.log.log(3, "Parsed classfile " + classfileResource.relativePath + " on classpath element " + classfileResource.classpathElt, System.nanoTime() - fileStartTime);
                }
                prevClassfileResource = classfileResource;
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            this.interruptionChecker.interrupt();
            return null;
        }
        finally {
            if (currentlyOpenZipFile != null) {
                try {
                    currentlyOpenZipFile.close();
                }
                catch (IOException iOException) {}
                currentlyOpenZipFile = null;
            }
        }
    }
}

