/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoLinkerCaller;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParserCaller;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileResource;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanInterruptedException;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecursiveScanner {
    private final ClasspathFinder classpathFinder;
    private final ScanSpec scanSpec;
    private boolean scanTimestampsOnly;
    private final Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch;
    private final List<FilePathTesterAndMatchProcessorWrapper> filePathTestersAndMatchProcessorWrappers = new ArrayList<FilePathTesterAndMatchProcessorWrapper>();
    private final Set<String> previouslyScannedCanonicalPaths = new HashSet<String>();
    private final Set<String> previouslyScannedRelativePaths = new HashSet<String>();
    final ConcurrentHashMap<String, String> stringInternMap = new ConcurrentHashMap();
    private final InterruptionChecker interruptionChecker = new InterruptionChecker();
    private final LinkedBlockingQueue<ClassfileResource> classfileResourcesToScan = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<ClassInfoUnlinked> classInfoUnlinked = new LinkedBlockingQueue();
    private final Map<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
    private ClassGraphBuilder classGraphBuilder;
    private final AtomicInteger numDirsScanned = new AtomicInteger();
    private final AtomicInteger numJarfileDirsScanned = new AtomicInteger();
    private final AtomicInteger numFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfileFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfilesScanned = new AtomicInteger();
    private final AtomicInteger numClassfilesScanned = new AtomicInteger();
    private long lastModified = 0L;

    public void addFilePathMatcher(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
        this.filePathTestersAndMatchProcessorWrappers.add(new FilePathTesterAndMatchProcessorWrapper(filePathTester, fileMatchProcessorWrapper));
    }

    public RecursiveScanner(ClasspathFinder classpathFinder, ScanSpec scanSpec, Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch) {
        this.classpathFinder = classpathFinder;
        this.scanSpec = scanSpec;
        this.classNameToStaticFinalFieldsToMatch = classNameToStaticFinalFieldsToMatch;
    }

    private boolean previouslyScanned(File fileOrDir) {
        try {
            return !this.previouslyScannedCanonicalPaths.add(fileOrDir.getCanonicalPath());
        }
        catch (IOException | SecurityException e) {
            return true;
        }
    }

    private boolean previouslyScanned(String relativePath) {
        return !this.previouslyScannedRelativePaths.add(relativePath);
    }

    private void scanDir(File classpathElt, File dir, int ignorePrefixLen, boolean inWhitelistedPath) {
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanning directory: " + dir);
        }
        this.updateLastModifiedTimestamp(dir.lastModified());
        this.numDirsScanned.incrementAndGet();
        String dirPath = dir.getPath();
        String dirRelativePath = ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        ScanSpec.ScanSpecPathMatch matchStatus = this.scanSpec.pathWhitelistMatchStatus(dirRelativePath);
        if (matchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH) {
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Reached non-whitelisted (or blacklisted) directory: " + dirRelativePath);
            }
            return;
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) {
            inWhitelistedPath = true;
        }
        long startTime = System.nanoTime();
        File[] filesInDir = dir.listFiles();
        if (filesInDir == null) {
            if (FastClasspathScanner.verbose) {
                Log.log(4, "Invalid directory " + dir);
            }
            return;
        }
        for (File fileInDir : filesInDir) {
            String fileInDirRelativePath;
            this.interruptionChecker.check();
            if (fileInDir.isDirectory()) {
                if (!inWhitelistedPath && matchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) continue;
                this.scanDir(classpathElt, fileInDir, ignorePrefixLen, inWhitelistedPath);
                continue;
            }
            if (!fileInDir.isFile()) continue;
            String string = fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? fileInDir.getName() : dirRelativePath + fileInDir.getName();
            if (!inWhitelistedPath && (matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(fileInDirRelativePath))) continue;
            boolean subFilePreviouslyScannedCanonical = this.previouslyScanned(fileInDir);
            boolean subFilePreviouslyScannedRelative = this.previouslyScanned(fileInDirRelativePath);
            if (subFilePreviouslyScannedRelative || subFilePreviouslyScannedCanonical) {
                if (!FastClasspathScanner.verbose) continue;
                Log.log(3, "Reached duplicate path, ignoring: " + fileInDirRelativePath);
                continue;
            }
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Found whitelisted file: " + fileInDirRelativePath);
            }
            this.updateLastModifiedTimestamp(fileInDir.lastModified());
            if (this.scanTimestampsOnly) continue;
            boolean matchedFile = false;
            if (fileInDirRelativePath.endsWith(".class")) {
                matchedFile = true;
                this.classfileResourcesToScan.add(new ClassfileResource(classpathElt, fileInDirRelativePath));
                this.numClassfilesScanned.incrementAndGet();
            }
            for (FilePathTesterAndMatchProcessorWrapper fileMatcher : this.filePathTestersAndMatchProcessorWrappers) {
                if (!fileMatcher.filePathTester.filePathMatches(classpathElt, fileInDirRelativePath)) continue;
                matchedFile = true;
                long fileStartTime = System.nanoTime();
                try (FileInputStream inputStream = new FileInputStream(fileInDir);){
                    fileMatcher.fileMatchProcessorWrapper.processMatch(classpathElt, fileInDirRelativePath, inputStream, fileInDir.length());
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while processing match " + fileInDirRelativePath, e);
                }
                if (!FastClasspathScanner.verbose) continue;
                Log.log(4, "Processed file match " + fileInDirRelativePath, System.nanoTime() - fileStartTime);
            }
            if (!matchedFile) continue;
            this.numFilesScanned.incrementAndGet();
        }
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanned directory " + dir + " and subdirectories", System.nanoTime() - startTime);
        }
    }

    private void scanZipfile(File classpathElt, ZipFile zipFile) {
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanning jarfile: " + classpathElt);
        }
        long startTime = System.nanoTime();
        String prevParentRelativePath = null;
        ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            boolean isDir;
            this.interruptionChecker.check();
            ZipEntry zipEntry = entries.nextElement();
            String relativePath = zipEntry.getName();
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (isDir = zipEntry.isDirectory()) {
                if (prevParentMatchStatus != ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) continue;
                this.numJarfileDirsScanned.incrementAndGet();
                if (!FastClasspathScanner.verbose) continue;
                this.numJarfileFilesScanned.incrementAndGet();
                continue;
            }
            if (this.previouslyScanned(relativePath)) {
                if (!FastClasspathScanner.verbose) continue;
                Log.log(3, "Reached duplicate relative path, ignoring: " + relativePath);
                continue;
            }
            int lastSlashIdx = relativePath.lastIndexOf("/");
            String parentRelativePath = lastSlashIdx < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
            ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || !parentRelativePath.equals(prevParentRelativePath) ? this.scanSpec.pathWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
            prevParentRelativePath = parentRelativePath;
            prevParentMatchStatus = parentMatchStatus;
            if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH && (parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(relativePath))) continue;
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Found whitelisted file in jarfile: " + relativePath);
            }
            boolean matchedFile = false;
            if (relativePath.endsWith(".class")) {
                matchedFile = true;
                this.classfileResourcesToScan.add(new ClassfileResource(classpathElt, relativePath));
                this.numClassfilesScanned.incrementAndGet();
            }
            for (FilePathTesterAndMatchProcessorWrapper fileMatcher : this.filePathTestersAndMatchProcessorWrappers) {
                if (!fileMatcher.filePathTester.filePathMatches(classpathElt, relativePath)) continue;
                try {
                    matchedFile = true;
                    long fileStartTime = System.nanoTime();
                    try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                        fileMatcher.fileMatchProcessorWrapper.processMatch(classpathElt, relativePath, inputStream, zipEntry.getSize());
                    }
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(4, "Processed file match " + relativePath, System.nanoTime() - fileStartTime);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while processing match " + relativePath, e);
                }
            }
            if (!matchedFile) continue;
            this.numJarfileFilesScanned.incrementAndGet();
        }
        if (FastClasspathScanner.verbose) {
            Log.log(4, "Scanned jarfile " + classpathElt, System.nanoTime() - startTime);
        }
    }

    private synchronized void scan(boolean scanTimestampsOnly, ExecutorService executorService, int numWorkerThreads) {
        int i;
        int n;
        int numClassfileParserThreads;
        long scanStart = System.nanoTime();
        List<File> uniqueClasspathElts = this.classpathFinder.getUniqueClasspathElements();
        if (FastClasspathScanner.verbose) {
            Log.log("Classpath elements: " + this.classpathFinder.getUniqueClasspathElements());
            Log.log(1, "Starting scan" + (scanTimestampsOnly ? " (scanning classpath timestamps only)" : ""));
        }
        this.scanTimestampsOnly = scanTimestampsOnly;
        this.previouslyScannedCanonicalPaths.clear();
        this.previouslyScannedRelativePaths.clear();
        this.numDirsScanned.set(0);
        this.numFilesScanned.set(0);
        this.numJarfileDirsScanned.set(0);
        this.numJarfileFilesScanned.set(0);
        this.numJarfilesScanned.set(0);
        this.numClassfilesScanned.set(0);
        this.classfileResourcesToScan.clear();
        this.classInfoUnlinked.clear();
        if (!scanTimestampsOnly) {
            this.classNameToClassInfo.clear();
        }
        ArrayList<Future<Void>> futures = null;
        ArrayList<Log.DeferredLog> logs = null;
        boolean startWorkerThreads = !scanTimestampsOnly && executorService != null && numWorkerThreads >= 2;
        int n2 = numClassfileParserThreads = startWorkerThreads ? numWorkerThreads - 1 : 0;
        if (startWorkerThreads) {
            futures = new ArrayList<Future<Void>>(numClassfileParserThreads + 1);
            logs = new ArrayList<Log.DeferredLog>(numClassfileParserThreads + 1);
            for (int i2 = 0; i2 < numClassfileParserThreads; ++i2) {
                Log.DeferredLog log = new Log.DeferredLog();
                logs.add(log);
                futures.add(executorService.submit(new ClassfileBinaryParserCaller(this.classfileResourcesToScan, this.classInfoUnlinked, this.scanSpec, this.classNameToStaticFinalFieldsToMatch, this.stringInternMap, this.interruptionChecker, log)));
            }
            logs.add(new Log.DeferredLog());
            futures.add(executorService.submit(new ClassInfoLinkerCaller(numClassfileParserThreads, this.classInfoUnlinked, this.classNameToClassInfo, this.interruptionChecker)));
        } else if (FastClasspathScanner.verbose) {
            Log.log("Scanning in single-threaded mode");
        }
        for (File classpathElt : uniqueClasspathElts) {
            boolean isJar;
            long eltStartTime = System.nanoTime();
            String path = classpathElt.getPath();
            boolean isDirectory = classpathElt.isDirectory();
            boolean bl = isJar = !isDirectory;
            if (this.previouslyScanned(classpathElt)) {
                if (!FastClasspathScanner.verbose) continue;
                Log.log(3, "Reached duplicate classpath entry, ignoring: " + classpathElt);
                continue;
            }
            if (FastClasspathScanner.verbose) {
                Log.log(2, "Found " + (isDirectory ? "directory" : "jar") + " on classpath: " + path);
            }
            if (isDirectory && this.scanSpec.scanNonJars) {
                this.scanDir(classpathElt, classpathElt, path.length() + 1, false);
                if (!FastClasspathScanner.verbose) continue;
                Log.log(2, "Scanned classpath directory " + classpathElt, System.nanoTime() - eltStartTime);
                continue;
            }
            if (isJar && this.scanSpec.scanJars) {
                if (!this.scanSpec.jarIsWhitelisted(classpathElt.getName())) {
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(3, "Skipping jarfile that did not match whitelist/blacklist criteria: " + classpathElt.getName());
                    continue;
                }
                this.updateLastModifiedTimestamp(classpathElt.lastModified());
                this.numJarfilesScanned.incrementAndGet();
                if (scanTimestampsOnly) continue;
                try (ZipFile zipFile = new ZipFile(classpathElt);){
                    this.scanZipfile(classpathElt, zipFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!FastClasspathScanner.verbose) continue;
                Log.log(2, "Scanned classpath jarfile " + classpathElt, System.nanoTime() - eltStartTime);
                continue;
            }
            if (!FastClasspathScanner.verbose) continue;
            Log.log(2, "Skipping classpath element " + path);
        }
        int n3 = n = numClassfileParserThreads == 0 ? 1 : numClassfileParserThreads;
        for (i = 0; i < n; ++i) {
            this.classfileResourcesToScan.add(ClassfileResource.END_OF_QUEUE);
        }
        if (!scanTimestampsOnly) {
            if (startWorkerThreads) {
                for (i = 0; i < futures.size(); ++i) {
                    Future future = (Future)futures.get(i);
                    Log.DeferredLog log = (Log.DeferredLog)logs.get(i);
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof ScanInterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        throw new RuntimeException("Exception while parsing classfiles", e);
                    }
                    log.flush();
                    this.interruptionChecker.check();
                }
            } else {
                Log.DeferredLog log = new Log.DeferredLog();
                new ClassfileBinaryParserCaller(this.classfileResourcesToScan, this.classInfoUnlinked, this.scanSpec, this.classNameToStaticFinalFieldsToMatch, this.stringInternMap, this.interruptionChecker, log).call();
                new ClassInfoLinkerCaller(numClassfileParserThreads, this.classInfoUnlinked, this.classNameToClassInfo, this.interruptionChecker).call();
                log.flush();
            }
            long graphStartTime = System.nanoTime();
            this.classGraphBuilder = new ClassGraphBuilder(this.classNameToClassInfo);
            if (FastClasspathScanner.verbose) {
                Log.log(2, "Built class graph", System.nanoTime() - graphStartTime);
            }
        }
        if (FastClasspathScanner.verbose) {
            Log.log(1, "Number of resources scanned: directories: " + this.numDirsScanned.get() + "; files: " + this.numFilesScanned.get() + "; jarfiles: " + this.numJarfilesScanned.get() + "; jarfile-internal directories: " + this.numJarfileDirsScanned + "; jarfile-internal files: " + this.numJarfileFilesScanned + "; classfiles: " + this.numClassfilesScanned);
        }
        if (FastClasspathScanner.verbose) {
            Log.log("Finished scan", System.nanoTime() - scanStart);
        }
    }

    public void scan(ExecutorService executorService, int numWorkerThreads) {
        this.scan(false, executorService, numWorkerThreads);
    }

    public ClassGraphBuilder getClassGraphBuilder() {
        return this.classGraphBuilder;
    }

    private void updateLastModifiedTimestamp(long fileLastModified) {
        this.lastModified = Math.max(this.lastModified, Math.min(System.currentTimeMillis(), fileLastModified));
    }

    public boolean classpathContentsModifiedSinceScan() {
        long oldLastModified = this.lastModified;
        if (oldLastModified == 0L) {
            return true;
        }
        this.scan(true, null, 0);
        long newLastModified = this.lastModified;
        return newLastModified > oldLastModified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.lastModified;
    }

    private static class FilePathTesterAndMatchProcessorWrapper {
        FilePathTester filePathTester;
        FileMatchProcessorWrapper fileMatchProcessorWrapper;

        public FilePathTesterAndMatchProcessorWrapper(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessorWrapper = fileMatchProcessorWrapper;
        }
    }

    public static interface FileMatchProcessorWrapper {
        public void processMatch(File var1, String var2, InputStream var3, long var4) throws IOException;
    }

    public static interface FilePathTester {
        public boolean filePathMatches(File var1, String var2);
    }
}

