/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classfileparser;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassfileBinaryParser {
    private InputStream inputStream;
    private static final int BUFFER_CHUNK_SIZE = 16536;
    private byte[] buf = new byte[16536];
    private int used = 0;
    private int curr = 0;
    private int[] offset;
    private int[] tag;
    private int[] indirectStringRefs;
    private static final Pattern TYPE_PARAM_PATTERN = Pattern.compile("(^[\\[]*|[;<]+)[+-]?L([^;<>*]+)");

    private void readMore(int amountToRead) throws IOException {
        int bytesRead;
        int newBufLen;
        int totReadAhead = amountToRead + 16536;
        int newUsed = this.used + totReadAhead;
        for (newBufLen = this.buf.length; newBufLen < newUsed; newBufLen <<= 1) {
        }
        if (newBufLen > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, newBufLen);
        }
        if ((bytesRead = this.inputStream.read(this.buf, this.used, totReadAhead)) < 0) {
            throw new IOException("Premature EOF while reading classfile");
        }
        this.used += bytesRead;
    }

    private int readUnsignedByte() throws IOException {
        if (this.curr > this.used - 1) {
            this.readMore(1);
        }
        return this.buf[this.curr++] & 0xFF;
    }

    private int readUnsignedByte(int offset) {
        return this.buf[offset] & 0xFF;
    }

    private int readUnsignedShort() throws IOException {
        if (this.curr > this.used - 2) {
            this.readMore(2);
        }
        int val = (this.buf[this.curr] & 0xFF) << 8 | this.buf[this.curr + 1] & 0xFF;
        this.curr += 2;
        return val;
    }

    private int readUnsignedShort(int offset) {
        return (this.buf[offset] & 0xFF) << 8 | this.buf[offset + 1] & 0xFF;
    }

    private int readInt() throws IOException {
        if (this.curr > this.used - 4) {
            this.readMore(4);
        }
        int val = (this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF;
        this.curr += 4;
        return val;
    }

    private int readInt(int offset) throws IOException {
        return (this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF;
    }

    private long readLong() throws IOException {
        if (this.curr > this.used - 8) {
            this.readMore(8);
        }
        long val = (long)((this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF) << 32 | (long)((this.buf[this.curr + 4] & 0xFF) << 24) | (long)((this.buf[this.curr + 5] & 0xFF) << 16) | (long)((this.buf[this.curr + 6] & 0xFF) << 8) | (long)(this.buf[this.curr + 7] & 0xFF);
        this.curr += 8;
        return val;
    }

    private long readLong(int offset) throws IOException {
        return (long)((this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF) << 32 | (long)((this.buf[offset + 4] & 0xFF) << 24) | (long)((this.buf[offset + 5] & 0xFF) << 16) | (long)((this.buf[offset + 6] & 0xFF) << 8) | (long)(this.buf[offset + 7] & 0xFF);
    }

    private void skip(int bytesToSkip) throws IOException {
        if (this.curr > this.used - bytesToSkip) {
            this.readMore(bytesToSkip);
        }
        this.curr += bytesToSkip;
    }

    private String readString(int offset) {
        int c;
        int byteIdx;
        int utfLen = this.readUnsignedShort(offset);
        int start = offset + 2;
        char[] chars = new char[utfLen];
        int charIdx = 0;
        for (byteIdx = 0; byteIdx < utfLen && (c = this.buf[start + byteIdx] & 0xFF) <= 127; ++byteIdx) {
            chars[charIdx++] = (char)c;
        }
        block6: while (byteIdx < utfLen) {
            c = this.buf[start + byteIdx] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteIdx;
                    chars[charIdx++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((byteIdx += 2) > utfLen) {
                        throw new IllegalArgumentException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[start + byteIdx - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new IllegalArgumentException("Bad modified UTF8");
                    }
                    chars[charIdx++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((byteIdx += 3) > utfLen) {
                        throw new IllegalArgumentException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[start + byteIdx - 2];
                    byte c3 = this.buf[start + byteIdx - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new IllegalArgumentException("Bad modified UTF8");
                    }
                    chars[charIdx++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Bad modified UTF8");
        }
        if (charIdx < utfLen) {
            return new String(chars, 0, charIdx);
        }
        return new String(chars);
    }

    private String getConstantPoolString(int constantPoolIdx) {
        int t = this.tag[constantPoolIdx];
        if (t != 1 && t != 7 && t != 8) {
            throw new IllegalArgumentException("Wrong tag number at constant pool index " + constantPoolIdx);
        }
        int cpIdx = constantPoolIdx;
        if (t == 7 || t == 8) {
            int indirIdx = this.indirectStringRefs[constantPoolIdx];
            if (indirIdx == -1) {
                throw new RuntimeException("Internal inconsistency");
            }
            if (indirIdx == 0) {
                return null;
            }
            cpIdx = indirIdx;
        }
        return this.readString(this.offset[cpIdx]);
    }

    private String getConstantPoolClassName(int constantPoolIdx) {
        String str = this.getConstantPoolString(constantPoolIdx);
        return str == null ? null : str.replace('/', '.');
    }

    private Object getConstantPoolValue(int constantPoolIdx) throws IOException {
        switch (this.tag[constantPoolIdx]) {
            case 1: {
                return this.getConstantPoolString(constantPoolIdx);
            }
            case 3: {
                return new Integer(this.readInt(this.offset[constantPoolIdx]));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(this.offset[constantPoolIdx])));
            }
            case 5: {
                return new Long(this.readLong(this.offset[constantPoolIdx]));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(this.offset[constantPoolIdx])));
            }
            case 7: 
            case 8: {
                return this.getConstantPoolString(constantPoolIdx);
            }
        }
        throw new IllegalArgumentException("Constant pool entry type unsupported");
    }

    private String readAnnotation(String className) throws IOException {
        String annotationFieldDescriptor = this.getConstantPoolClassName(this.readUnsignedShort());
        String annotationClassName = annotationFieldDescriptor.charAt(0) == 'L' && annotationFieldDescriptor.charAt(annotationFieldDescriptor.length() - 1) == ';' ? annotationFieldDescriptor.substring(1, annotationFieldDescriptor.length() - 1) : annotationFieldDescriptor;
        int numElementValuePairs = this.readUnsignedShort();
        for (int i = 0; i < numElementValuePairs; ++i) {
            this.skip(2);
            this.readAnnotationElementValue(className);
        }
        return annotationClassName;
    }

    private void readAnnotationElementValue(String className) throws IOException {
        int tag = this.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                this.skip(2);
                break;
            }
            case 101: {
                this.skip(4);
                break;
            }
            case 99: {
                this.skip(2);
                break;
            }
            case 64: {
                this.readAnnotation(className);
                break;
            }
            case 91: {
                int count = this.readUnsignedShort();
                for (int l = 0; l < count; ++l) {
                    this.readAnnotationElementValue(className);
                }
                break;
            }
            default: {
                throw new RuntimeException("Class " + className + " has unknown annotation element type tag '" + (char)tag + "': element size unknown, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
            }
        }
    }

    private static void addFieldTypeDescriptorParts(ClassInfo.ClassInfoUnlinked classInfoUnlinked, String className, String typeDescriptor, ScanSpec scanSpec, HashSet<String> loggedFieldTypeNames, Log.DeferredLog log) {
        Matcher matcher = TYPE_PARAM_PATTERN.matcher(typeDescriptor);
        while (matcher.find()) {
            String descriptorPart = matcher.group(2);
            String fieldTypeName = descriptorPart.replace('/', '.');
            if (!scanSpec.classIsNotBlacklisted(fieldTypeName) || fieldTypeName.startsWith("java.lang.") || fieldTypeName.startsWith("java.util.")) continue;
            if (FastClasspathScanner.verbose && loggedFieldTypeNames.add(fieldTypeName)) {
                log.log(5, "Class " + className + " has a field with type or type parameter " + fieldTypeName);
            }
            classInfoUnlinked.addFieldType(fieldTypeName);
        }
    }

    public ClassInfo.ClassInfoUnlinked readClassInfoFromClassfileHeader(String relativePath, InputStream inputStream, Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch, ScanSpec scanSpec, Log.DeferredLog log) throws IOException {
        try {
            int attributeLength;
            this.inputStream = inputStream;
            this.used = inputStream.read(this.buf);
            if ((this.used < 4 || this.readInt() != -889275714) && FastClasspathScanner.verbose) {
                throw new IOException("File " + relativePath + " does not have correct classfile magic number");
            }
            this.readUnsignedShort();
            this.readUnsignedShort();
            int cpCount = this.readUnsignedShort();
            if (this.offset == null || this.offset.length < cpCount) {
                this.offset = new int[cpCount];
                this.tag = new int[cpCount];
                this.indirectStringRefs = new int[cpCount];
            }
            Arrays.fill(this.indirectStringRefs, 0, cpCount, -1);
            block30: for (int i = 1; i < cpCount; ++i) {
                this.tag[i] = this.readUnsignedByte();
                this.offset[i] = this.curr;
                switch (this.tag[i]) {
                    case 1: {
                        int strLen = this.readUnsignedShort();
                        this.skip(strLen);
                        continue block30;
                    }
                    case 3: 
                    case 4: {
                        this.skip(4);
                        continue block30;
                    }
                    case 5: 
                    case 6: {
                        this.skip(8);
                        ++i;
                        continue block30;
                    }
                    case 7: 
                    case 8: {
                        this.indirectStringRefs[i] = this.readUnsignedShort();
                        continue block30;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.skip(4);
                        continue block30;
                    }
                    case 15: {
                        this.skip(3);
                        continue block30;
                    }
                    case 16: {
                        this.skip(2);
                        continue block30;
                    }
                    case 18: {
                        this.skip(4);
                        continue block30;
                    }
                    default: {
                        throw new IOException("Unknown constant pool tag " + this.tag + " (element size unknown, cannot continue reading class. Please report this on the FastClasspathScanner GitHub page.");
                    }
                }
            }
            int flags = this.readUnsignedShort();
            boolean isInterface = (flags & 0x200) != 0;
            boolean isAnnotation = (flags & 0x2000) != 0;
            String className = this.getConstantPoolClassName(this.readUnsignedShort());
            if ("java.lang.Object".equals(className)) {
                return null;
            }
            if (!className.equals(relativePath.substring(0, relativePath.length() - 6).replace('/', '.'))) {
                if (FastClasspathScanner.verbose) {
                    log.log(5, "Class " + className + " is at incorrect relative path " + relativePath + " -- ignoring");
                }
                return null;
            }
            String superclassName = this.getConstantPoolClassName(this.readUnsignedShort());
            ClassInfo.ClassInfoUnlinked classInfoUnlinked = new ClassInfo.ClassInfoUnlinked(className, isInterface, isAnnotation);
            if (FastClasspathScanner.verbose) {
                log.log(5, "Found " + (isAnnotation ? "annotation class" : (isInterface ? "interface class" : "class")) + " " + className + (superclassName == null || "java.lang.Object".equals(superclassName) ? "" : " with " + (isInterface && !isAnnotation ? "superinterface" : "superclass") + " " + superclassName));
            }
            if (scanSpec.classIsNotBlacklisted(superclassName)) {
                classInfoUnlinked.addSuperclass(superclassName);
            }
            int interfaceCount = this.readUnsignedShort();
            for (int i = 0; i < interfaceCount; ++i) {
                String interfaceName = this.getConstantPoolClassName(this.readUnsignedShort());
                if (!scanSpec.classIsNotBlacklisted(interfaceName)) continue;
                if (FastClasspathScanner.verbose) {
                    log.log(6, "Class " + className + " implements interface " + interfaceName);
                }
                classInfoUnlinked.addImplementedInterface(interfaceName);
            }
            HashSet<String> staticFinalFieldsToMatch = classNameToStaticFinalFieldsToMatch.get(className);
            HashSet<String> loggedFieldTypeNames = FastClasspathScanner.verbose ? new HashSet<String>() : null;
            int fieldCount = this.readUnsignedShort();
            for (int i = 0; i < fieldCount; ++i) {
                int accessFlags = this.readUnsignedShort();
                boolean isStaticFinal = (accessFlags & 0x18) == 24;
                String fieldName = this.getConstantPoolString(this.readUnsignedShort());
                boolean isMatchedFieldName = staticFinalFieldsToMatch != null && staticFinalFieldsToMatch.contains(fieldName);
                String fieldTypeDescriptor = this.getConstantPoolString(this.readUnsignedShort());
                int attributesCount = this.readUnsignedShort();
                ClassfileBinaryParser.addFieldTypeDescriptorParts(classInfoUnlinked, className, fieldTypeDescriptor, scanSpec, loggedFieldTypeNames, log);
                if (!isStaticFinal && isMatchedFieldName) {
                    log.log(6, "Cannot match requested field " + classInfoUnlinked.className + "." + fieldName + " because it is either not static or not final");
                }
                boolean foundConstantValue = false;
                for (int j = 0; j < attributesCount; ++j) {
                    String attributeName = this.getConstantPoolString(this.readUnsignedShort());
                    int attributeLength2 = this.readInt();
                    if (isStaticFinal && isMatchedFieldName && "ConstantValue".equals(attributeName)) {
                        Object constValue = this.getConstantPoolValue(this.readUnsignedShort());
                        switch (fieldTypeDescriptor) {
                            case "B": {
                                constValue = new Byte(((Integer)constValue).byteValue());
                                break;
                            }
                            case "C": {
                                constValue = new Character((char)((Integer)constValue).intValue());
                                break;
                            }
                            case "S": {
                                constValue = new Short(((Integer)constValue).shortValue());
                                break;
                            }
                            case "Z": {
                                constValue = new Boolean((Integer)constValue != 0);
                                break;
                            }
                            case "I": 
                            case "J": 
                            case "F": 
                            case "D": 
                            case "Ljava.lang.String;": {
                                break;
                            }
                        }
                        if (FastClasspathScanner.verbose) {
                            log.log(6, "Class " + className + " has field " + fieldName + " with static constant initializer " + constValue);
                        }
                        classInfoUnlinked.addFieldConstantValue(fieldName, constValue);
                        foundConstantValue = true;
                    } else if ("Signature".equals(attributeName)) {
                        String fieldTypeSignature = this.getConstantPoolString(this.readUnsignedShort());
                        ClassfileBinaryParser.addFieldTypeDescriptorParts(classInfoUnlinked, className, fieldTypeSignature, scanSpec, loggedFieldTypeNames, log);
                    } else {
                        this.skip(attributeLength2);
                    }
                    if (foundConstantValue || !isStaticFinal || !isMatchedFieldName) continue;
                    log.log(6, "Requested static final field " + classInfoUnlinked.className + "." + fieldName + " is not initialized with a constant literal value, so there is no initializer value in the constant pool of the classfile");
                }
            }
            int methodCount = this.readUnsignedShort();
            for (int i = 0; i < methodCount; ++i) {
                this.skip(6);
                int attributesCount = this.readUnsignedShort();
                for (int j = 0; j < attributesCount; ++j) {
                    this.skip(2);
                    attributeLength = this.readInt();
                    this.skip(attributeLength);
                }
            }
            int attributesCount = this.readUnsignedShort();
            for (int i = 0; i < attributesCount; ++i) {
                String attributeName = this.getConstantPoolString(this.readUnsignedShort());
                attributeLength = this.readInt();
                if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                    int annotationCount = this.readUnsignedShort();
                    for (int m = 0; m < annotationCount; ++m) {
                        String annotationName = this.readAnnotation(className);
                        if (!scanSpec.classIsNotBlacklisted(annotationName) || annotationName.startsWith("java.lang.annotation.")) continue;
                        if (FastClasspathScanner.verbose) {
                            log.log(6, "Class " + className + " has annotation " + annotationName);
                        }
                        classInfoUnlinked.addAnnotation(annotationName);
                    }
                    continue;
                }
                this.skip(attributeLength);
            }
            return classInfoUnlinked;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(6, "Exception while attempting to load classfile " + relativePath + ": " + e);
            return null;
        }
    }
}

