/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classpath;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classpath.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.jar.Manifest;

public class ClasspathFinder {
    private final ArrayList<File> classpathElements = new ArrayList();
    private final HashSet<String> classpathElementsSet = new HashSet();
    private final HashSet<String> knownJREPaths = new HashSet();
    private final HashSet<ClassLoaderHandler> extraClassLoaderHandlers = new HashSet();
    private boolean initialized = false;

    private void clearClasspath() {
        this.classpathElements.clear();
        this.classpathElementsSet.clear();
        this.initialized = false;
    }

    private static boolean isJarMatchCase(String path) {
        return path.endsWith(".jar") || path.endsWith(".zip") || path.endsWith(".war") || path.endsWith(".car");
    }

    public static boolean isJar(String path) {
        return ClasspathFinder.isJarMatchCase(path) || ClasspathFinder.isJarMatchCase(path.toLowerCase());
    }

    private static Path urlToPath(Path resolveBasePath, String pathElementStr) {
        if (pathElementStr.isEmpty()) {
            return null;
        }
        String pathStr = pathElementStr;
        if (pathStr.startsWith("jar:") && !(pathStr = pathStr.substring(4)).startsWith("file:") && !pathStr.startsWith("http:") && !pathStr.startsWith("https:")) {
            pathStr = "file:" + pathStr;
        }
        if (pathStr.startsWith("http:") || pathStr.startsWith("https:")) {
            if (FastClasspathScanner.verbose) {
                Log.log("Ignoring remote entry in classpath: " + pathStr);
            }
            return null;
        }
        try {
            return resolveBasePath.resolve(Paths.get(new URL(pathStr).toURI())).toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        catch (Exception e) {
            try {
                return resolveBasePath.resolve(pathStr).toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
            catch (Exception e2) {
                try {
                    return new File(pathElementStr).toPath().toRealPath(LinkOption.NOFOLLOW_LINKS);
                }
                catch (Exception e3) {
                    return null;
                }
            }
        }
    }

    public void addClasspathElement(String pathElement) {
        Path currDirPath = Paths.get("", new String[0]).toAbsolutePath();
        Path path = ClasspathFinder.urlToPath(currDirPath, pathElement);
        if (path != null) {
            File pathFile = path.toFile();
            if (pathFile.exists()) {
                String pathStr = path.toString();
                if (this.classpathElementsSet.add(pathStr)) {
                    boolean isValidClasspathElement = true;
                    if (pathFile.isFile() && ClasspathFinder.isJar(pathStr)) {
                        if (this.isJREJar(pathFile, 2)) {
                            isValidClasspathElement = false;
                            if (FastClasspathScanner.verbose) {
                                Log.log("Skipping JRE jar: " + pathStr);
                            }
                        } else {
                            String manifestUrlStr = "jar:" + pathFile.toURI() + "!/META-INF/MANIFEST.MF";
                            try (InputStream stream = new URL(manifestUrlStr).openStream();){
                                Manifest manifest = new Manifest(stream);
                                String manifestClassPath = manifest.getMainAttributes().getValue("Class-Path");
                                if (manifestClassPath != null && !manifestClassPath.isEmpty()) {
                                    if (FastClasspathScanner.verbose) {
                                        Log.log("Found Class-Path entry in " + manifestUrlStr + ": " + manifestClassPath);
                                    }
                                    Path parentPath = path.getParent();
                                    for (String manifestClassPathElement : manifestClassPath.split(" ")) {
                                        Path manifestEltPath = ClasspathFinder.urlToPath(parentPath, manifestClassPathElement);
                                        if (manifestEltPath != null) {
                                            this.addClasspathElement(manifestEltPath.toString());
                                            continue;
                                        }
                                        if (!FastClasspathScanner.verbose) continue;
                                        Log.log("Classpath element " + new File(pathFile.getParent(), manifestClassPathElement) + " not found -- from Class-Path entry " + manifestClassPathElement + " in " + manifestUrlStr);
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (isValidClasspathElement) {
                        if (FastClasspathScanner.verbose) {
                            Log.log("Found classpath element: " + path);
                        }
                        this.classpathElements.add(pathFile);
                    }
                }
            } else if (FastClasspathScanner.verbose) {
                Log.log("Classpath element does not exist: " + path);
            }
        }
    }

    public void addClasspathElements(String pathStr) {
        if (pathStr != null && !pathStr.isEmpty()) {
            for (String pathElement : pathStr.split(File.pathSeparator)) {
                this.addClasspathElement(pathElement);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJREJar(File file, int ancestralScanDepth) {
        File parent;
        if (ancestralScanDepth == 0) {
            return false;
        }
        try {
            parent = file.getParentFile().getCanonicalFile();
            if (parent == null) {
                return false;
            }
        }
        catch (IOException e1) {
            return false;
        }
        String parentPathStr = parent.getPath();
        if (this.knownJREPaths.contains(parentPathStr)) {
            return true;
        }
        File rt = new File(parent, "rt.jar");
        if (!rt.exists() && !(rt = new File(new File(parent, "lib"), "rt.jar")).exists()) {
            rt = new File(new File(new File(parent, "jre"), "lib.jar"), "rt.jar");
        }
        if (!rt.exists()) return this.isJREJar(parent, ancestralScanDepth - 1);
        String manifestUrlStr = "jar:" + rt.toURI() + "!/META-INF/MANIFEST.MF";
        try (InputStream stream = new URL(manifestUrlStr).openStream();){
            Manifest manifest = new Manifest(stream);
            if (!"Java Runtime Environment".equals(manifest.getMainAttributes().getValue("Implementation-Title"))) {
                if (!"Java Platform API Specification".equals(manifest.getMainAttributes().getValue("Specification-Title"))) return this.isJREJar(parent, ancestralScanDepth - 1);
            }
            this.knownJREPaths.add(parentPathStr);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.isJREJar(parent, ancestralScanDepth - 1);
    }

    private static void addAllParentClassloaders(Class<?> klass, AdditionOrderedSet<ClassLoader> classLoadersSetOut) {
        ArrayList<ClassLoader> callerClassLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader cl = klass.getClassLoader(); cl != null; cl = cl.getParent()) {
            callerClassLoaders.add(cl);
        }
        for (int i = callerClassLoaders.size() - 1; i >= 0; --i) {
            classLoadersSetOut.add((ClassLoader)callerClassLoaders.get(i));
        }
    }

    public void registerClassLoaderHandler(ClassLoaderHandler extraClassLoaderHandler) {
        this.extraClassLoaderHandlers.add(extraClassLoaderHandler);
    }

    public void overrideClasspath(String classpath) {
        this.clearClasspath();
        this.addClasspathElements(classpath);
        this.initialized = true;
    }

    public List<File> getUniqueClasspathElements() {
        if (!this.initialized) {
            this.clearClasspath();
            AdditionOrderedSet<ClassLoader> classLoadersSet = new AdditionOrderedSet<ClassLoader>();
            classLoadersSet.add(ClassLoader.getSystemClassLoader());
            try {
                throw new Exception();
            }
            catch (Exception e) {
                StackTraceElement[] stacktrace = e.getStackTrace();
                if (stacktrace.length >= 1) {
                    for (StackTraceElement ste : stacktrace) {
                        try {
                            ClasspathFinder.addAllParentClassloaders(Class.forName(ste.getClassName()), classLoadersSet);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                classLoadersSet.add(Thread.currentThread().getContextClassLoader());
                ClasspathFinder.addAllParentClassloaders(ClasspathFinder.class, classLoadersSet);
                List<ClassLoader> classLoaders = classLoadersSet.getList();
                classLoaders.remove(null);
                HashSet<ClassLoaderHandler> classLoaderHandlers = new HashSet<ClassLoaderHandler>();
                classLoaderHandlers.add(new URLClassLoaderHandler());
                for (ClassLoader classLoader : classLoaders) {
                    ServiceLoader<ClassLoaderHandler> classLoaderHandlerLoader = ServiceLoader.load(ClassLoaderHandler.class, classLoader);
                    for (ClassLoaderHandler handler : classLoaderHandlerLoader) {
                        classLoaderHandlers.add(handler);
                    }
                }
                classLoaderHandlers.addAll(this.extraClassLoaderHandlers);
                boolean classloaderFound = false;
                for (ClassLoader classLoader : classLoaders) {
                    for (ClassLoaderHandler handler : classLoaderHandlers) {
                        try {
                            if (!handler.handle(classLoader, this)) continue;
                            if (FastClasspathScanner.verbose) {
                                Log.log("Classpath elements from ClassLoader " + classLoader.getClass().getName() + " were extracted by ClassLoaderHandler " + handler.getClass().getName());
                            }
                            classloaderFound = true;
                            break;
                        }
                        catch (Exception e2) {
                            Log.log("Was not able to call getPaths() in " + classLoader.getClass().getName() + ": " + e2.toString());
                        }
                    }
                    if (classloaderFound) continue;
                    Log.log(4, "Found unknown ClassLoader type, cannot scan classes: " + classLoader.getClass().getName());
                }
                this.addClasspathElements(System.getProperty("java.class.path"));
                this.initialized = true;
            }
        }
        return this.classpathElements;
    }

    private static class URLClassLoaderHandler
    implements ClassLoaderHandler {
        private URLClassLoaderHandler() {
        }

        @Override
        public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder) {
            if (classloader instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)classloader).getURLs()) {
                    classpathFinder.addClasspathElement(url.toString());
                }
                return true;
            }
            return false;
        }
    }
}

