/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;

public class ScanSpec {
    private final ArrayList<String> whitelistedPathPrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPathPrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPackagePrefixes = new ArrayList();
    private final HashSet<String> specificallyWhitelistedClassRelativePaths = new HashSet();
    private final HashSet<String> specificallyWhitelistedClassParentRelativePaths = new HashSet();
    private final HashSet<String> specificallyBlacklistedClassRelativePaths = new HashSet();
    private final HashSet<String> specificallyBlacklistedClassNames = new HashSet();
    private final HashSet<String> whitelistedJars = new HashSet();
    private final HashSet<String> blacklistedJars = new HashSet();
    private final ArrayList<Pattern> whitelistedJarPatterns = new ArrayList();
    private final ArrayList<Pattern> blacklistedJarPatterns = new ArrayList();
    public final boolean scanJars;
    public final boolean scanNonJars;
    public boolean blacklistSystemJars = true;
    public boolean blacklistSystemPackages = true;

    public ScanSpec(String[] scanSpecs) {
        HashSet<String> uniqueWhitelistedPathPrefixes = new HashSet<String>();
        HashSet<String> uniqueBlacklistedPathPrefixes = new HashSet<String>();
        boolean scanJars = true;
        boolean scanNonJars = true;
        String[] stringArray = scanSpecs;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String scanSpecEntry;
            String spec = scanSpecEntry = stringArray[i];
            if ("!".equals(scanSpecEntry)) {
                this.blacklistSystemPackages = false;
                continue;
            }
            if ("!!".equals(scanSpecEntry)) {
                this.blacklistSystemJars = false;
                this.blacklistSystemPackages = false;
                continue;
            }
            boolean blacklisted = spec.startsWith("-");
            if (blacklisted) {
                spec = spec.substring(1);
            }
            if (spec.startsWith("jar:")) {
                if ((spec = spec.substring(4)).indexOf(47) >= 0) {
                    Log.log("Only a leaf filename may be used with a \"jar:\" entry in the scan spec, got \"" + spec + "\" -- ignoring");
                    continue;
                }
                if (spec.isEmpty()) {
                    if (blacklisted) {
                        scanJars = false;
                        continue;
                    }
                    scanNonJars = false;
                    continue;
                }
                if (blacklisted) {
                    if (spec.contains("*")) {
                        this.blacklistedJarPatterns.add(ScanSpec.specToPattern(spec));
                        continue;
                    }
                    this.blacklistedJars.add(spec);
                    continue;
                }
                if (spec.contains("*")) {
                    this.whitelistedJarPatterns.add(ScanSpec.specToPattern(spec));
                    continue;
                }
                this.whitelistedJars.add(spec);
                continue;
            }
            String specPath = spec.replace('.', '/');
            boolean isClassName = false;
            int lastSlashIdx = specPath.lastIndexOf(47);
            if (lastSlashIdx < specPath.length() - 1) {
                isClassName = Character.isUpperCase(specPath.charAt(lastSlashIdx + 1));
            }
            if (isClassName) {
                if (blacklisted) {
                    this.specificallyBlacklistedClassNames.add(spec);
                    this.specificallyBlacklistedClassRelativePaths.add(specPath + ".class");
                    continue;
                }
                this.specificallyWhitelistedClassRelativePaths.add(specPath + ".class");
                continue;
            }
            if (blacklisted) {
                uniqueBlacklistedPathPrefixes.add(specPath + "/");
                continue;
            }
            uniqueWhitelistedPathPrefixes.add(specPath + "/");
        }
        if (uniqueBlacklistedPathPrefixes.contains("/")) {
            Log.log("Ignoring blacklist of root package, it would prevent all scanning");
            uniqueBlacklistedPathPrefixes.remove("/");
        }
        uniqueWhitelistedPathPrefixes.removeAll(uniqueBlacklistedPathPrefixes);
        this.whitelistedJars.removeAll(this.blacklistedJars);
        if (!this.whitelistedJars.isEmpty() || !this.whitelistedJarPatterns.isEmpty()) {
            scanNonJars = false;
        }
        if (!scanJars && !scanNonJars) {
            Log.log("Scanning of jars and non-jars are both disabled -- re-enabling scanning of non-jars");
            scanNonJars = true;
        }
        if (uniqueWhitelistedPathPrefixes.isEmpty() || uniqueWhitelistedPathPrefixes.contains("/")) {
            this.whitelistedPathPrefixes.add("");
        } else {
            this.whitelistedPathPrefixes.addAll(uniqueWhitelistedPathPrefixes);
        }
        if (this.blacklistSystemPackages) {
            uniqueBlacklistedPathPrefixes.add("java/");
            uniqueBlacklistedPathPrefixes.add("sun/");
        }
        this.blacklistedPathPrefixes.addAll(uniqueBlacklistedPathPrefixes);
        for (String prefix : this.blacklistedPathPrefixes) {
            this.blacklistedPackagePrefixes.add(prefix.replace('/', '.'));
        }
        this.specificallyWhitelistedClassRelativePaths.removeAll(this.specificallyBlacklistedClassRelativePaths);
        for (String whitelistedClass : this.specificallyWhitelistedClassRelativePaths) {
            int lastSlashIdx = whitelistedClass.lastIndexOf(47);
            this.specificallyWhitelistedClassParentRelativePaths.add(whitelistedClass.substring(0, lastSlashIdx + 1));
        }
        this.scanJars = scanJars;
        this.scanNonJars = scanNonJars;
        if (FastClasspathScanner.verbose) {
            Log.log("Whitelisted relative path prefixes:  " + this.whitelistedPathPrefixes);
            if (!this.blacklistedPathPrefixes.isEmpty()) {
                Log.log("Blacklisted relative path prefixes:  " + this.blacklistedPathPrefixes);
            }
            if (!this.whitelistedJars.isEmpty()) {
                Log.log("Whitelisted jars:  " + this.whitelistedJars);
            }
            if (!this.whitelistedJarPatterns.isEmpty()) {
                Log.log("Whitelisted jars with glob wildcards:  " + this.whitelistedJarPatterns);
            }
            if (!this.blacklistedJars.isEmpty()) {
                Log.log("Blacklisted jars:  " + this.blacklistedJars);
            }
            if (!this.blacklistedJarPatterns.isEmpty()) {
                Log.log("Whitelisted jars with glob wildcards:  " + this.blacklistedJarPatterns);
            }
            if (!this.specificallyWhitelistedClassRelativePaths.isEmpty()) {
                Log.log("Specifically-whitelisted classfiles: " + this.specificallyWhitelistedClassRelativePaths);
            }
            if (!this.specificallyBlacklistedClassRelativePaths.isEmpty()) {
                Log.log("Specifically-blacklisted classfiles: " + this.specificallyBlacklistedClassRelativePaths);
            }
            if (!scanJars) {
                Log.log("Scanning of jarfiles is disabled");
            }
            if (!scanNonJars) {
                Log.log("Scanning of directories (i.e. non-jarfiles) is disabled");
            }
        }
    }

    private static Pattern specToPattern(String spec) {
        return Pattern.compile("^" + spec.replace(".", "\\.").replace("*", ".*") + "$");
    }

    public ScanSpecPathMatch pathWhitelistMatchStatus(String relativePath) {
        for (String blacklistedPath : this.blacklistedPathPrefixes) {
            if (!relativePath.startsWith(blacklistedPath)) continue;
            return ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH;
        }
        for (String whitelistedPath : this.whitelistedPathPrefixes) {
            if (relativePath.startsWith(whitelistedPath)) {
                return ScanSpecPathMatch.WITHIN_WHITELISTED_PATH;
            }
            if (!whitelistedPath.startsWith(relativePath) && !"/".equals(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (this.specificallyWhitelistedClassParentRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE;
        }
        for (String whitelistedClassPathPrefix : this.specificallyWhitelistedClassParentRelativePaths) {
            if (!whitelistedClassPathPrefix.startsWith(relativePath) && !"/".equals(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        return ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH;
    }

    public boolean isSpecificallyWhitelistedClass(String relativePath) {
        return this.specificallyWhitelistedClassRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath);
    }

    public boolean classIsNotBlacklisted(String className) {
        if (this.specificallyBlacklistedClassNames.contains(className)) {
            return false;
        }
        for (String blacklistedPackagePrefix : this.blacklistedPackagePrefixes) {
            if (!className.startsWith(blacklistedPackagePrefix)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsJarName(HashSet<String> jarNames, ArrayList<Pattern> jarNamePatterns, String jarName) {
        if (jarNames.contains(jarName)) {
            return true;
        }
        for (Pattern jarNamePattern : jarNamePatterns) {
            if (!jarNamePattern.matcher(jarName).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean jarIsWhitelisted(String jarName) {
        return (this.whitelistedJars.isEmpty() && this.whitelistedJarPatterns.isEmpty() || ScanSpec.containsJarName(this.whitelistedJars, this.whitelistedJarPatterns, jarName)) && !ScanSpec.containsJarName(this.blacklistedJars, this.blacklistedJarPatterns, jarName);
    }

    public boolean blacklistSystemJars() {
        return this.blacklistSystemJars;
    }

    public static enum ScanSpecPathMatch {
        WITHIN_BLACKLISTED_PATH,
        WITHIN_WHITELISTED_PATH,
        ANCESTOR_OF_WHITELISTED_PATH,
        AT_WHITELISTED_CLASS_PACKAGE,
        NOT_WITHIN_WHITELISTED_PATH,
        WHITELISTED_FILE,
        NON_WHITELISTED_FILE;

    }
}

