/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classpath.classloaderhandlers;

import io.github.lukehutch.fastclasspathscanner.classpath.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class JBossClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder) throws Exception {
        for (Class<?> c = classloader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"org.jboss.modules.ModuleClassLoader".equals(c.getName())) continue;
            Method getResourceLoaders = c.getDeclaredMethod("getResourceLoaders", new Class[0]);
            if (!getResourceLoaders.isAccessible()) {
                getResourceLoaders.setAccessible(true);
            }
            Object result = getResourceLoaders.invoke((Object)classloader, new Object[0]);
            int n = Array.getLength(result);
            for (int i = 0; i < n; ++i) {
                Object rootVal;
                Method getPathName;
                Object resourceLoader = Array.get(result, i);
                Field root = resourceLoader.getClass().getDeclaredField("root");
                if (!root.isAccessible()) {
                    root.setAccessible(true);
                }
                if (!(getPathName = (rootVal = root.get(resourceLoader)).getClass().getDeclaredMethod("getPathName", new Class[0])).isAccessible()) {
                    getPathName.setAccessible(true);
                }
                String pathElement = (String)getPathName.invoke(rootVal, new Object[0]);
                classpathFinder.addClasspathElement(pathElement);
            }
            return true;
        }
        return false;
    }
}

