/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RecursiveScanner {
    private final int NUM_THREADS = 6;
    private final ClasspathFinder classpathFinder;
    private final ScanSpec scanSpec;
    private final ArrayList<FastClasspathScanner.ClassMatcher> classMatchers;
    private final Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch;
    private final Map<String, ArrayList<StaticFinalFieldMatchProcessor>> fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors;
    private final List<FilePathTesterAndMatchProcessorWrapper> filePathTestersAndMatchProcessorWrappers = new ArrayList<FilePathTesterAndMatchProcessorWrapper>();
    private final Set<String> previouslyScannedCanonicalPaths = new HashSet<String>();
    private final Set<String> previouslyScannedRelativePaths = new HashSet<String>();
    private final Map<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
    private ClassGraphBuilder classGraphBuilder;
    private final AtomicInteger numDirsScanned = new AtomicInteger();
    private final AtomicInteger numJarfileDirsScanned = new AtomicInteger();
    private final AtomicInteger numFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfileFilesScanned = new AtomicInteger();
    private final AtomicInteger numJarfilesScanned = new AtomicInteger();
    private final AtomicInteger numClassfilesScanned = new AtomicInteger();
    private long lastModified = 0L;

    public void addFilePathMatcher(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
        this.filePathTestersAndMatchProcessorWrappers.add(new FilePathTesterAndMatchProcessorWrapper(filePathTester, fileMatchProcessorWrapper));
    }

    public RecursiveScanner(ClasspathFinder classpathFinder, ScanSpec scanSpec, ArrayList<FastClasspathScanner.ClassMatcher> classMatchers, Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch, Map<String, ArrayList<StaticFinalFieldMatchProcessor>> fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors) {
        this.classpathFinder = classpathFinder;
        this.scanSpec = scanSpec;
        this.classMatchers = classMatchers;
        this.classNameToStaticFinalFieldsToMatch = classNameToStaticFinalFieldsToMatch;
        this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors = fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors;
    }

    private boolean previouslyScanned(File fileOrDir) {
        try {
            return !this.previouslyScannedCanonicalPaths.add(fileOrDir.getCanonicalPath());
        }
        catch (IOException | SecurityException e) {
            return true;
        }
    }

    private boolean previouslyScanned(String relativePath) {
        return !this.previouslyScannedRelativePaths.add(relativePath);
    }

    private void scanDir(File classpathElt, File dir, int ignorePrefixLen, boolean inWhitelistedPath, boolean scanTimestampsOnly, Queue<ClassfileResource> classfileResourcesToScanOut) {
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanning directory: " + dir);
        }
        this.updateLastModifiedTimestamp(dir.lastModified());
        this.numDirsScanned.incrementAndGet();
        String dirPath = dir.getPath();
        String dirRelativePath = ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        ScanSpec.ScanSpecPathMatch matchStatus = this.scanSpec.pathWhitelistMatchStatus(dirRelativePath);
        if (matchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH) {
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Reached non-whitelisted (or blacklisted) directory: " + dirRelativePath);
            }
            return;
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) {
            inWhitelistedPath = true;
        }
        long startTime = System.nanoTime();
        File[] filesInDir = dir.listFiles();
        if (filesInDir == null) {
            if (FastClasspathScanner.verbose) {
                Log.log(4, "Invalid directory " + dir);
            }
            return;
        }
        for (File fileInDir : filesInDir) {
            String fileInDirRelativePath;
            if (fileInDir.isDirectory()) {
                if (!inWhitelistedPath && matchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) continue;
                this.scanDir(classpathElt, fileInDir, ignorePrefixLen, inWhitelistedPath, scanTimestampsOnly, classfileResourcesToScanOut);
                continue;
            }
            if (!fileInDir.isFile()) continue;
            String string = fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? fileInDir.getName() : dirRelativePath + fileInDir.getName();
            if (!inWhitelistedPath && (matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(fileInDirRelativePath))) continue;
            boolean subFilePreviouslyScannedCanonical = this.previouslyScanned(fileInDir);
            boolean subFilePreviouslyScannedRelative = this.previouslyScanned(fileInDirRelativePath);
            if (subFilePreviouslyScannedRelative || subFilePreviouslyScannedCanonical) {
                if (!FastClasspathScanner.verbose) continue;
                Log.log(3, "Reached duplicate path, ignoring: " + fileInDirRelativePath);
                continue;
            }
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Found whitelisted file: " + fileInDirRelativePath);
            }
            this.updateLastModifiedTimestamp(fileInDir.lastModified());
            if (scanTimestampsOnly) continue;
            boolean matchedFile = false;
            if (fileInDirRelativePath.endsWith(".class")) {
                matchedFile = true;
                classfileResourcesToScanOut.add(new ClassfileResource(classpathElt, fileInDirRelativePath));
                this.numClassfilesScanned.incrementAndGet();
            }
            for (FilePathTesterAndMatchProcessorWrapper fileMatcher : this.filePathTestersAndMatchProcessorWrappers) {
                if (!fileMatcher.filePathTester.filePathMatches(classpathElt, fileInDirRelativePath)) continue;
                matchedFile = true;
                long fileStartTime = System.nanoTime();
                try (FileInputStream inputStream = new FileInputStream(fileInDir);){
                    fileMatcher.fileMatchProcessorWrapper.processMatch(classpathElt, fileInDirRelativePath, inputStream, fileInDir.length());
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while processing match " + fileInDirRelativePath, e);
                }
                if (!FastClasspathScanner.verbose) continue;
                Log.log(4, "Processed file match " + fileInDirRelativePath, System.nanoTime() - fileStartTime);
            }
            if (!matchedFile) continue;
            this.numFilesScanned.incrementAndGet();
        }
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanned directory " + dir + " and subdirectories", System.nanoTime() - startTime);
        }
    }

    private void scanZipfile(File classpathElt, ZipFile zipFile, Queue<ClassfileResource> classfileResourcesToScanOut) {
        if (FastClasspathScanner.verbose) {
            Log.log(3, "Scanning jarfile: " + classpathElt);
        }
        long startTime = System.nanoTime();
        String prevParentRelativePath = null;
        ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            boolean isDir;
            ZipEntry zipEntry = entries.nextElement();
            String relativePath = zipEntry.getName();
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (isDir = zipEntry.isDirectory()) {
                if (prevParentMatchStatus != ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) continue;
                this.numJarfileDirsScanned.incrementAndGet();
                if (!FastClasspathScanner.verbose) continue;
                this.numJarfileFilesScanned.incrementAndGet();
                continue;
            }
            if (this.previouslyScanned(relativePath)) {
                if (!FastClasspathScanner.verbose) continue;
                Log.log(3, "Reached duplicate relative path, ignoring: " + relativePath);
                continue;
            }
            int lastSlashIdx = relativePath.lastIndexOf("/");
            String parentRelativePath = lastSlashIdx < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
            ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || !parentRelativePath.equals(prevParentRelativePath) ? this.scanSpec.pathWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
            prevParentRelativePath = parentRelativePath;
            prevParentMatchStatus = parentMatchStatus;
            if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH && (parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(relativePath))) continue;
            if (FastClasspathScanner.verbose) {
                Log.log(3, "Found whitelisted file in jarfile: " + relativePath);
            }
            boolean matchedFile = false;
            if (relativePath.endsWith(".class")) {
                matchedFile = true;
                classfileResourcesToScanOut.add(new ClassfileResource(classpathElt, relativePath));
                this.numClassfilesScanned.incrementAndGet();
            }
            for (FilePathTesterAndMatchProcessorWrapper fileMatcher : this.filePathTestersAndMatchProcessorWrappers) {
                if (!fileMatcher.filePathTester.filePathMatches(classpathElt, relativePath)) continue;
                try {
                    matchedFile = true;
                    long fileStartTime = System.nanoTime();
                    try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                        fileMatcher.fileMatchProcessorWrapper.processMatch(classpathElt, relativePath, inputStream, zipEntry.getSize());
                    }
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(4, "Processed file match " + relativePath, System.nanoTime() - fileStartTime);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while processing match " + relativePath, e);
                }
            }
            if (!matchedFile) continue;
            this.numJarfileFilesScanned.incrementAndGet();
        }
        if (FastClasspathScanner.verbose) {
            Log.log(4, "Scanned jarfile " + classpathElt, System.nanoTime() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scan(boolean scanTimestampsOnly) {
        int i;
        if (FastClasspathScanner.verbose) {
            Log.log("FastClasspathScanner version " + FastClasspathScanner.getVersion());
        }
        long scanStart = System.nanoTime();
        List<File> uniqueClasspathElts = this.classpathFinder.getUniqueClasspathElements();
        if (FastClasspathScanner.verbose) {
            Log.log("Classpath elements: " + this.classpathFinder.getUniqueClasspathElements());
        }
        this.previouslyScannedCanonicalPaths.clear();
        this.previouslyScannedRelativePaths.clear();
        this.numDirsScanned.set(0);
        this.numFilesScanned.set(0);
        this.numJarfileDirsScanned.set(0);
        this.numJarfileFilesScanned.set(0);
        this.numJarfilesScanned.set(0);
        this.numClassfilesScanned.set(0);
        if (!scanTimestampsOnly) {
            this.classNameToClassInfo.clear();
        }
        if (FastClasspathScanner.verbose) {
            Log.log(1, "Starting scan" + (scanTimestampsOnly ? " (scanning classpath timestamps only)" : ""));
        }
        ConcurrentLinkedQueue<ClassfileResource> classfileResourcesToScan = new ConcurrentLinkedQueue<ClassfileResource>();
        for (File classpathElt : uniqueClasspathElts) {
            boolean isJar;
            long eltStartTime = System.nanoTime();
            String path = classpathElt.getPath();
            boolean isDirectory = classpathElt.isDirectory();
            boolean bl = isJar = !isDirectory;
            if (this.previouslyScanned(classpathElt)) {
                if (!FastClasspathScanner.verbose) continue;
                Log.log(3, "Reached duplicate classpath entry, ignoring: " + classpathElt);
                continue;
            }
            if (FastClasspathScanner.verbose) {
                Log.log(2, "Found " + (isDirectory ? "directory" : "jar") + " on classpath: " + path);
            }
            if (isDirectory && this.scanSpec.scanNonJars) {
                this.scanDir(classpathElt, classpathElt, path.length() + 1, false, scanTimestampsOnly, classfileResourcesToScan);
                if (!FastClasspathScanner.verbose) continue;
                Log.log(2, "Scanned classpath directory " + classpathElt, System.nanoTime() - eltStartTime);
                continue;
            }
            if (isJar && this.scanSpec.scanJars) {
                if (!this.scanSpec.jarIsWhitelisted(classpathElt.getName())) {
                    if (!FastClasspathScanner.verbose) continue;
                    Log.log(3, "Skipping jarfile that did not match whitelist/blacklist criteria: " + classpathElt.getName());
                    continue;
                }
                this.updateLastModifiedTimestamp(classpathElt.lastModified());
                this.numJarfilesScanned.incrementAndGet();
                if (scanTimestampsOnly) continue;
                try (ZipFile zipFile2 = new ZipFile(classpathElt);){
                    this.scanZipfile(classpathElt, zipFile2, classfileResourcesToScan);
                }
                catch (IOException zipFile2) {
                    // empty catch block
                }
                if (!FastClasspathScanner.verbose) continue;
                Log.log(2, "Scanned classpath jarfile " + classpathElt, System.nanoTime() - eltStartTime);
                continue;
            }
            if (!FastClasspathScanner.verbose) continue;
            Log.log(2, "Skipping classpath element " + path);
        }
        if (FastClasspathScanner.verbose) {
            Log.log(1, "Starting parallel scan of classfile binaries");
        }
        long parseStartTime = System.nanoTime();
        Log.DeferredLog[] logs = new Log.DeferredLog[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            logs[i2] = new Log.DeferredLog();
        }
        ConcurrentLinkedQueue<ClassInfo.ClassInfoUnlinked> classInfoUnlinked = new ConcurrentLinkedQueue<ClassInfo.ClassInfoUnlinked>();
        ConcurrentHashMap<String, String> stringInternMap = new ConcurrentHashMap<String, String>();
        Thread[] threads = new Thread[6];
        try {
            for (i = 0; i < 6; ++i) {
                threads[i] = new ClassfileBinaryParserCaller(classfileResourcesToScan, classInfoUnlinked, stringInternMap, logs[i]);
                threads[i].start();
            }
        }
        catch (Throwable throwable) {
            for (int i3 = 0; i3 < 6; ++i3) {
                if (threads[i3] != null) {
                    try {
                        threads[i3].join();
                        threads[i3] = null;
                    }
                    catch (InterruptedException e) {
                        for (int j = i3; j < 6; ++j) {
                            threads[i3].interrupt();
                        }
                        break;
                    }
                }
                if (FastClasspathScanner.verbose) {
                    Log.log(1, "Parallel scan logs from thread " + i3 + ":");
                }
                logs[i3].flush();
            }
            throw throwable;
        }
        for (i = 0; i < 6; ++i) {
            if (threads[i] != null) {
                try {
                    threads[i].join();
                    threads[i] = null;
                }
                catch (InterruptedException e) {
                    for (int j = i; j < 6; ++j) {
                        threads[i].interrupt();
                    }
                    break;
                }
            }
            if (FastClasspathScanner.verbose) {
                Log.log(1, "Parallel scan logs from thread " + i + ":");
            }
            logs[i].flush();
        }
        if (FastClasspathScanner.verbose) {
            Log.log(1, "Finished parallel scan of classfile binaries", System.nanoTime() - parseStartTime);
        }
        long graphStartTime = System.nanoTime();
        for (ClassInfo.ClassInfoUnlinked c : classInfoUnlinked) {
            c.link(this.classNameToClassInfo);
        }
        if (!scanTimestampsOnly) {
            this.classGraphBuilder = new ClassGraphBuilder(this.classNameToClassInfo);
            for (FastClasspathScanner.ClassMatcher classMatcher : this.classMatchers) {
                classMatcher.lookForMatches();
            }
            if (this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors != null) {
                for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
                    if (classInfo.fieldValues == null) continue;
                    for (Map.Entry<String, Object> ent : classInfo.fieldValues.entrySet()) {
                        String constValueStrRep;
                        String fieldName = ent.getKey();
                        Object constValue = ent.getValue();
                        String fullyQualifiedFieldName = classInfo.className + "." + fieldName;
                        ArrayList<StaticFinalFieldMatchProcessor> staticFinalFieldMatchProcessors = this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.get(fullyQualifiedFieldName);
                        if (staticFinalFieldMatchProcessors == null) continue;
                        String string = constValue instanceof Character ? '\'' + constValue.toString().replace("'", "\\'") + '\'' : (constValueStrRep = constValue instanceof String ? '\"' + constValue.toString().replace("\"", "\\\"") + '\"' : constValue.toString());
                        if (FastClasspathScanner.verbose) {
                            Log.log(1, "Calling MatchProcessor for static final field " + classInfo.className + "." + fieldName + " = " + constValueStrRep);
                        }
                        for (StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor : staticFinalFieldMatchProcessors) {
                            staticFinalFieldMatchProcessor.processMatch(classInfo.className, fieldName, constValue);
                        }
                    }
                }
            }
        }
        if (FastClasspathScanner.verbose) {
            Log.log(2, "Built class graph", System.nanoTime() - graphStartTime);
        }
        if (FastClasspathScanner.verbose) {
            Log.log(1, "Number of resources scanned: directories: " + this.numDirsScanned.get() + "; files: " + this.numFilesScanned.get() + "; jarfiles: " + this.numJarfilesScanned.get() + "; jarfile-internal directories: " + this.numJarfileDirsScanned + "; jarfile-internal files: " + this.numJarfileFilesScanned + "; classfiles: " + this.numClassfilesScanned);
        }
        if (FastClasspathScanner.verbose) {
            Log.log("Finished scan", System.nanoTime() - scanStart);
        }
    }

    public void scan() {
        this.scan(false);
    }

    public ClassGraphBuilder getClassGraphBuilder() {
        return this.classGraphBuilder;
    }

    private void updateLastModifiedTimestamp(long fileLastModified) {
        this.lastModified = Math.max(this.lastModified, Math.min(System.currentTimeMillis(), fileLastModified));
    }

    public boolean classpathContentsModifiedSinceScan() {
        long oldLastModified = this.lastModified;
        if (oldLastModified == 0L) {
            return true;
        }
        this.scan(true);
        long newLastModified = this.lastModified;
        return newLastModified > oldLastModified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.lastModified;
    }

    private class ClassfileBinaryParserCaller
    extends Thread {
        private final Queue<ClassfileResource> classpathResources;
        private final Queue<ClassInfo.ClassInfoUnlinked> classInfoUnlinkedOut;
        private final ConcurrentHashMap<String, String> stringInternMap;
        private final Log.DeferredLog log;

        public ClassfileBinaryParserCaller(Queue<ClassfileResource> classfileResourcesToScan, Queue<ClassInfo.ClassInfoUnlinked> classInfoUnlinkedOut, ConcurrentHashMap<String, String> stringInternMap, Log.DeferredLog log) {
            this.classpathResources = classfileResourcesToScan;
            this.classInfoUnlinkedOut = classInfoUnlinkedOut;
            this.stringInternMap = stringInternMap;
            this.log = log;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ZipFile currentlyOpenZipFile = null;
            try {
                ClassfileResource classfileResource;
                ClassfileResource prevClassfileResource = null;
                ClassfileBinaryParser classfileBinaryParser = new ClassfileBinaryParser(RecursiveScanner.this.scanSpec, this.log);
                while ((classfileResource = this.classpathResources.poll()) != null) {
                    block37: {
                        long fileStartTime;
                        block38: {
                            if (Thread.interrupted()) {
                                return;
                            }
                            fileStartTime = System.nanoTime();
                            boolean classfileResourceIsJar = classfileResource.classpathElt.isFile();
                            if (prevClassfileResource == null || classfileResource.classpathElt != prevClassfileResource.classpathElt) {
                                if (currentlyOpenZipFile != null) {
                                    try {
                                        currentlyOpenZipFile.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    currentlyOpenZipFile = null;
                                }
                                if (classfileResourceIsJar) {
                                    try {
                                        currentlyOpenZipFile = new ZipFile(classfileResource.classpathElt);
                                    }
                                    catch (IOException e) {
                                        if (FastClasspathScanner.verbose) {
                                            this.log.log(2, "Exception while trying to open " + classfileResource.classpathElt + ": " + e);
                                        }
                                        break block37;
                                    }
                                }
                            }
                            try (InputStream inputStream = classfileResourceIsJar ? currentlyOpenZipFile.getInputStream(currentlyOpenZipFile.getEntry(classfileResource.relativePath)) : new FileInputStream(classfileResource.classpathElt.getPath() + File.separator + (File.separatorChar == '/' ? classfileResource.relativePath : classfileResource.relativePath.replace('/', File.separatorChar)));){
                                ClassInfo.ClassInfoUnlinked thisClassInfoUnlinked = classfileBinaryParser.readClassInfoFromClassfileHeader(inputStream, classfileResource.relativePath, RecursiveScanner.this.classNameToStaticFinalFieldsToMatch, this.stringInternMap);
                                if (thisClassInfoUnlinked != null) {
                                    this.classInfoUnlinkedOut.add(thisClassInfoUnlinked);
                                    thisClassInfoUnlinked.logClassInfo(this.log);
                                }
                            }
                            catch (IOException e) {
                                if (!FastClasspathScanner.verbose) break block38;
                                this.log.log(2, "Exception while trying to open " + classfileResource.relativePath + ": " + e);
                            }
                        }
                        if (FastClasspathScanner.verbose) {
                            this.log.log(3, "Parsed classfile " + classfileResource.relativePath, System.nanoTime() - fileStartTime);
                        }
                    }
                    prevClassfileResource = classfileResource;
                }
            }
            finally {
                if (currentlyOpenZipFile != null) {
                    try {
                        currentlyOpenZipFile.close();
                    }
                    catch (IOException iOException) {}
                    currentlyOpenZipFile = null;
                }
            }
        }
    }

    private static class ClassfileResource {
        final File classpathElt;
        final String relativePath;

        public ClassfileResource(File classpathElt, String relativePath) {
            this.classpathElt = classpathElt;
            this.relativePath = relativePath;
        }
    }

    private static class FilePathTesterAndMatchProcessorWrapper {
        FilePathTester filePathTester;
        FileMatchProcessorWrapper fileMatchProcessorWrapper;

        public FilePathTesterAndMatchProcessorWrapper(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessorWrapper = fileMatchProcessorWrapper;
        }
    }

    public static interface FileMatchProcessorWrapper {
        public void processMatch(File var1, String var2, InputStream var3, long var4) throws IOException;
    }

    public static interface FilePathTester {
        public boolean filePathMatches(File var1, String var2);
    }
}

