/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classpath.classloaderhandlers;

import io.github.lukehutch.fastclasspathscanner.classpath.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class EquinoxClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder) throws Exception {
        boolean foundFile = false;
        for (Class<?> c = classloader.getClass(); c != null; c = c.getSuperclass()) {
            Object entries;
            Object manager;
            if (!"org.eclipse.osgi.internal.loader.EquinoxClassLoader".equals(c.getName())) continue;
            Field managerField = c.getDeclaredField("manager");
            if (!managerField.isAccessible()) {
                managerField.setAccessible(true);
            }
            if ((manager = managerField.get(classloader)) == null) continue;
            Field entriesField = manager.getClass().getDeclaredField("entries");
            if (!entriesField.isAccessible()) {
                entriesField.setAccessible(true);
            }
            if ((entries = entriesField.get(manager)) == null) continue;
            int n = Array.getLength(entries);
            for (int i = 0; i < n; ++i) {
                Object bundlefile;
                Object entry = Array.get(entries, i);
                Field bundlefileField = entry.getClass().getDeclaredField("bundlefile");
                if (!bundlefileField.isAccessible()) {
                    bundlefileField.setAccessible(true);
                }
                if ((bundlefile = bundlefileField.get(entry)) == null) continue;
                Object basefile = null;
                for (Class<?> bundlefileClass = bundlefile.getClass(); bundlefileClass != null; bundlefileClass = bundlefileClass.getSuperclass()) {
                    try {
                        Field basefileField = bundlefileClass.getDeclaredField("basefile");
                        if (!basefileField.isAccessible()) {
                            basefileField.setAccessible(true);
                        }
                        basefile = basefileField.get(bundlefile);
                        break;
                    }
                    catch (NoSuchFieldException basefileField) {
                        continue;
                    }
                }
                Object cp = null;
                for (Class<?> bundlefileClass = bundlefile.getClass(); bundlefileClass != null; bundlefileClass = bundlefileClass.getSuperclass()) {
                    try {
                        Field cpField = bundlefileClass.getDeclaredField("cp");
                        if (!cpField.isAccessible()) {
                            cpField.setAccessible(true);
                        }
                        cp = cpField.get(bundlefile);
                        break;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        continue;
                    }
                }
                if (basefile == null) continue;
                if (cp != null) {
                    classpathFinder.addClasspathElement(basefile.toString() + "/" + cp.toString());
                } else {
                    classpathFinder.addClasspathElement(basefile.toString());
                }
                foundFile = true;
            }
        }
        return foundFile;
    }
}

