/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassInfoUnlinked {
    public String className;
    public boolean isInterface;
    public boolean isAnnotation;
    public String superclassName;
    public List<String> implementedInterfaces;
    public List<String> annotations;
    public Set<String> fieldTypes;
    public Map<String, Object> staticFinalFieldValues;
    private ConcurrentHashMap<String, String> stringInternMap;
    public static final ClassInfoUnlinked END_OF_QUEUE = new ClassInfoUnlinked();

    private ClassInfoUnlinked() {
    }

    private String intern(String string) {
        String oldValue = this.stringInternMap.putIfAbsent(string, string);
        return oldValue == null ? string : oldValue;
    }

    public ClassInfoUnlinked(String className, boolean isInterface, boolean isAnnotation, ConcurrentHashMap<String, String> stringInternMap) {
        this.stringInternMap = stringInternMap;
        this.className = this.intern(className);
        this.isInterface = isInterface;
        this.isAnnotation = isAnnotation;
    }

    public void addSuperclass(String superclassName) {
        this.superclassName = this.intern(superclassName);
    }

    public void addImplementedInterface(String interfaceName) {
        if (this.implementedInterfaces == null) {
            this.implementedInterfaces = new ArrayList<String>();
        }
        this.implementedInterfaces.add(this.intern(interfaceName));
    }

    public void addAnnotation(String annotationName) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<String>();
        }
        this.annotations.add(this.intern(annotationName));
    }

    public void addFieldType(String fieldTypeName) {
        if (this.fieldTypes == null) {
            this.fieldTypes = new HashSet<String>();
        }
        this.fieldTypes.add(this.intern(fieldTypeName));
    }

    public void addFieldConstantValue(String fieldName, Object staticFinalFieldValue) {
        if (this.staticFinalFieldValues == null) {
            this.staticFinalFieldValues = new HashMap<String, Object>();
        }
        this.staticFinalFieldValues.put(this.intern(fieldName), staticFinalFieldValue);
    }

    public void link(Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo classInfo = ClassInfo.addScannedClass(this.className, this.isInterface, this.isAnnotation, classNameToClassInfo);
        if (this.superclassName != null) {
            classInfo.addSuperclass(this.superclassName, classNameToClassInfo);
        }
        if (this.implementedInterfaces != null) {
            for (String string : this.implementedInterfaces) {
                classInfo.addImplementedInterface(string, classNameToClassInfo);
            }
        }
        if (this.annotations != null) {
            for (String string : this.annotations) {
                classInfo.addAnnotation(string, classNameToClassInfo);
            }
        }
        if (this.fieldTypes != null) {
            for (String string : this.fieldTypes) {
                classInfo.addFieldType(string, classNameToClassInfo);
            }
        }
        if (this.staticFinalFieldValues != null) {
            for (Map.Entry entry : this.staticFinalFieldValues.entrySet()) {
                classInfo.addFieldConstantValue((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void logClassInfo(Log.DeferredLog log) {
        if (FastClasspathScanner.verbose) {
            log.log(2, "Found " + (this.isAnnotation ? "annotation class" : (this.isInterface ? "interface class" : "class")) + " " + this.className);
            if (this.superclassName != null && !"java.lang.Object".equals(this.superclassName)) {
                log.log(3, "Super" + (this.isInterface && !this.isAnnotation ? "interface" : "class") + ": " + this.superclassName);
            }
            if (this.implementedInterfaces != null) {
                log.log(3, "Interfaces: " + String.join((CharSequence)", ", this.implementedInterfaces));
            }
            if (this.annotations != null) {
                log.log(3, "Annotations: " + String.join((CharSequence)", ", this.annotations));
            }
            if (this.fieldTypes != null) {
                log.log(3, "Field types: " + String.join((CharSequence)", ", this.fieldTypes));
            }
            if (this.staticFinalFieldValues != null) {
                ArrayList<String> fieldInitializers = new ArrayList<String>();
                for (Map.Entry<String, Object> ent : this.staticFinalFieldValues.entrySet()) {
                    fieldInitializers.add(ent.getKey() + " = " + ent.getValue());
                }
                log.log(3, "Static final field values: " + String.join((CharSequence)", ", fieldInitializers));
            }
        }
    }
}

