/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanInterruptedException;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.util.concurrent.atomic.AtomicBoolean;

public class InterruptionChecker {
    private AtomicBoolean interrupted = new AtomicBoolean(false);

    public void check() {
        if (Thread.interrupted() || this.interrupted.get()) {
            this.interrupt();
        }
    }

    public void interrupt() {
        Thread.currentThread().interrupt();
        this.interrupted.set(true);
        String msg = "Thread " + Thread.currentThread().getName() + " was interrupted";
        if (FastClasspathScanner.verbose) {
            Log.log(msg);
        }
        throw new ScanInterruptedException(msg);
    }
}

