/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.InterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResource;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResourceQueueProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.FileMatchProcessorWrapper;
import io.github.lukehutch.fastclasspathscanner.scanner.FilePathTester;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.utils.ThreadLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;

public class ScanSpec {
    private final ArrayList<String> whitelistedPathPrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPathPrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPackagePrefixes = new ArrayList();
    private final HashSet<String> specificallyWhitelistedClassRelativePaths = new HashSet();
    private final HashSet<String> specificallyWhitelistedClassParentRelativePaths = new HashSet();
    private final HashSet<String> specificallyBlacklistedClassRelativePaths = new HashSet();
    private final HashSet<String> specificallyBlacklistedClassNames = new HashSet();
    private final HashSet<String> whitelistedJars = new HashSet();
    private final HashSet<String> blacklistedJars = new HashSet();
    private final ArrayList<Pattern> whitelistedJarPatterns = new ArrayList();
    private final ArrayList<Pattern> blacklistedJarPatterns = new ArrayList();
    public final boolean scanJars;
    public final boolean scanNonJars;
    private Map<String, ArrayList<StaticFinalFieldMatchProcessor>> fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors;
    private Map<String, HashSet<String>> classNameToStaticFinalFieldsToMatch;
    private ArrayList<ClassMatcher> classMatchers;
    private final List<FilePathTesterAndMatchProcessorWrapper> filePathTestersAndMatchProcessorWrappers = new ArrayList<FilePathTesterAndMatchProcessorWrapper>();
    public boolean blacklistSystemJars = true;
    public boolean blacklistSystemPackages = true;
    public boolean ignoreFieldVisibility = false;
    private ThreadLog log;

    public Map<String, HashSet<String>> getClassNameToStaticFinalFieldsToMatch() {
        return this.classNameToStaticFinalFieldsToMatch;
    }

    public ScanSpec(String[] scanSpec, ThreadLog log) {
        this.log = log;
        HashSet<String> uniqueWhitelistedPathPrefixes = new HashSet<String>();
        HashSet<String> uniqueBlacklistedPathPrefixes = new HashSet<String>();
        boolean scanJars = true;
        boolean scanNonJars = true;
        String[] stringArray = scanSpec;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String scanSpecEntry;
            String spec = scanSpecEntry = stringArray[i];
            if ("!".equals(scanSpecEntry)) {
                this.blacklistSystemPackages = false;
                continue;
            }
            if ("!!".equals(scanSpecEntry)) {
                this.blacklistSystemJars = false;
                this.blacklistSystemPackages = false;
                continue;
            }
            boolean blacklisted = spec.startsWith("-");
            if (blacklisted) {
                spec = spec.substring(1);
            }
            if (spec.startsWith("jar:")) {
                if ((spec = spec.substring(4)).indexOf(47) >= 0) {
                    log.log("Only a leaf filename may be used with a \"jar:\" entry in the scan spec, got \"" + spec + "\" -- ignoring");
                    continue;
                }
                if (spec.isEmpty()) {
                    if (blacklisted) {
                        scanJars = false;
                        continue;
                    }
                    scanNonJars = false;
                    continue;
                }
                if (blacklisted) {
                    if (spec.contains("*")) {
                        this.blacklistedJarPatterns.add(ScanSpec.specToPattern(spec));
                        continue;
                    }
                    this.blacklistedJars.add(spec);
                    continue;
                }
                if (spec.contains("*")) {
                    this.whitelistedJarPatterns.add(ScanSpec.specToPattern(spec));
                    continue;
                }
                this.whitelistedJars.add(spec);
                continue;
            }
            String specPath = spec.replace('.', '/');
            boolean isClassName = false;
            int lastSlashIdx = specPath.lastIndexOf(47);
            if (lastSlashIdx < specPath.length() - 1) {
                isClassName = Character.isUpperCase(specPath.charAt(lastSlashIdx + 1));
            }
            if (isClassName) {
                if (blacklisted) {
                    this.specificallyBlacklistedClassNames.add(spec);
                    this.specificallyBlacklistedClassRelativePaths.add(specPath + ".class");
                    continue;
                }
                this.specificallyWhitelistedClassRelativePaths.add(specPath + ".class");
                continue;
            }
            if (blacklisted) {
                uniqueBlacklistedPathPrefixes.add(specPath + "/");
                continue;
            }
            uniqueWhitelistedPathPrefixes.add(specPath + "/");
        }
        if (uniqueBlacklistedPathPrefixes.contains("/")) {
            log.log("Ignoring blacklist of root package, it would prevent all scanning");
            uniqueBlacklistedPathPrefixes.remove("/");
        }
        uniqueWhitelistedPathPrefixes.removeAll(uniqueBlacklistedPathPrefixes);
        this.whitelistedJars.removeAll(this.blacklistedJars);
        if (!this.whitelistedJars.isEmpty() || !this.whitelistedJarPatterns.isEmpty()) {
            scanNonJars = false;
        }
        if (!scanJars && !scanNonJars) {
            log.log("Scanning of jars and non-jars are both disabled -- re-enabling scanning of non-jars");
            scanNonJars = true;
        }
        if (uniqueWhitelistedPathPrefixes.isEmpty() || uniqueWhitelistedPathPrefixes.contains("/")) {
            this.whitelistedPathPrefixes.add("");
        } else {
            this.whitelistedPathPrefixes.addAll(uniqueWhitelistedPathPrefixes);
        }
        if (this.blacklistSystemPackages) {
            uniqueBlacklistedPathPrefixes.add("java/");
            uniqueBlacklistedPathPrefixes.add("sun/");
        }
        this.blacklistedPathPrefixes.addAll(uniqueBlacklistedPathPrefixes);
        for (String prefix : this.blacklistedPathPrefixes) {
            this.blacklistedPackagePrefixes.add(prefix.replace('/', '.'));
        }
        this.specificallyWhitelistedClassRelativePaths.removeAll(this.specificallyBlacklistedClassRelativePaths);
        for (String whitelistedClass : this.specificallyWhitelistedClassRelativePaths) {
            int lastSlashIdx = whitelistedClass.lastIndexOf(47);
            this.specificallyWhitelistedClassParentRelativePaths.add(whitelistedClass.substring(0, lastSlashIdx + 1));
        }
        this.scanJars = scanJars;
        this.scanNonJars = scanNonJars;
        if (FastClasspathScanner.verbose) {
            log.log("Whitelisted relative path prefixes:  " + this.whitelistedPathPrefixes);
            if (!this.blacklistedPathPrefixes.isEmpty()) {
                log.log("Blacklisted relative path prefixes:  " + this.blacklistedPathPrefixes);
            }
            if (!this.whitelistedJars.isEmpty()) {
                log.log("Whitelisted jars:  " + this.whitelistedJars);
            }
            if (!this.whitelistedJarPatterns.isEmpty()) {
                log.log("Whitelisted jars with glob wildcards:  " + this.whitelistedJarPatterns);
            }
            if (!this.blacklistedJars.isEmpty()) {
                log.log("Blacklisted jars:  " + this.blacklistedJars);
            }
            if (!this.blacklistedJarPatterns.isEmpty()) {
                log.log("Whitelisted jars with glob wildcards:  " + this.blacklistedJarPatterns);
            }
            if (!this.specificallyWhitelistedClassRelativePaths.isEmpty()) {
                log.log("Specifically-whitelisted classfiles: " + this.specificallyWhitelistedClassRelativePaths);
            }
            if (!this.specificallyBlacklistedClassRelativePaths.isEmpty()) {
                log.log("Specifically-blacklisted classfiles: " + this.specificallyBlacklistedClassRelativePaths);
            }
            if (!scanJars) {
                log.log("Scanning of jarfiles is disabled");
            }
            if (!scanNonJars) {
                log.log("Scanning of directories (i.e. non-jarfiles) is disabled");
            }
        }
    }

    public void callMatchProcessors(ScanResult scanResult, LinkedBlockingQueue<ClasspathResource> matchingFiles) throws InterruptedException {
        final ThreadLog log = new ThreadLog();
        ClasspathResourceQueueProcessor.processClasspathResourceQueue(matchingFiles, new ClasspathResourceQueueProcessor.ClasspathResourceProcessor(){

            @Override
            public void processClasspathResource(ClasspathResource classpathResource, InputStream inputStream, long inputStreamLength) {
                block2: {
                    try {
                        classpathResource.fileMatchProcessorWrapper.processMatch(classpathResource.classpathElt, classpathResource.relativePath, inputStream, inputStreamLength);
                    }
                    catch (Exception e) {
                        if (!FastClasspathScanner.verbose) break block2;
                        log.log(4, "Exception while calling FileMatchProcessor for file " + classpathResource.relativePath + " : " + e);
                    }
                }
            }
        }, new ClasspathResourceQueueProcessor.EndOfClasspathResourceQueueProcessor(){

            @Override
            public void processEndOfQueue() {
            }
        }, log);
        log.flush();
        if (this.classMatchers != null) {
            for (ClassMatcher classMatcher : this.classMatchers) {
                try {
                    classMatcher.lookForMatches(scanResult);
                }
                catch (Exception e) {
                    if (!FastClasspathScanner.verbose) continue;
                    log.log(4, "Exception while calling ClassMatchProcessor: " + e);
                }
            }
        }
        if (this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors != null) {
            for (ClassInfo classInfo : scanResult.getClassNameToClassInfo().values()) {
                if (classInfo.fieldValues == null) continue;
                for (Map.Entry<String, Object> ent : classInfo.fieldValues.entrySet()) {
                    String fieldName = ent.getKey();
                    Object constValue = ent.getValue();
                    String fullyQualifiedFieldName = classInfo.className + "." + fieldName;
                    ArrayList<StaticFinalFieldMatchProcessor> staticFinalFieldMatchProcessors = this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.get(fullyQualifiedFieldName);
                    if (staticFinalFieldMatchProcessors == null) continue;
                    if (FastClasspathScanner.verbose) {
                        log.log(1, "Calling MatchProcessor for static final field " + classInfo.className + "." + fieldName + " = " + (constValue instanceof Character ? '\'' + constValue.toString().replace("'", "\\'") + '\'' : (constValue instanceof String ? '\"' + constValue.toString().replace("\"", "\\\"") + '\"' : constValue.toString())));
                    }
                    for (StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor : staticFinalFieldMatchProcessors) {
                        try {
                            staticFinalFieldMatchProcessor.processMatch(classInfo.className, fieldName, constValue);
                        }
                        catch (Exception e) {
                            if (!FastClasspathScanner.verbose) continue;
                            log.log(4, "Exception while calling StaticFinalFieldMatchProcessor: " + e);
                        }
                    }
                }
            }
        }
    }

    private static Pattern specToPattern(String spec) {
        return Pattern.compile("^" + spec.replace(".", "\\.").replace("*", ".*") + "$");
    }

    public ScanSpecPathMatch pathWhitelistMatchStatus(String relativePath) {
        for (String blacklistedPath : this.blacklistedPathPrefixes) {
            if (!relativePath.startsWith(blacklistedPath)) continue;
            return ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH;
        }
        for (String whitelistedPath : this.whitelistedPathPrefixes) {
            if (relativePath.startsWith(whitelistedPath)) {
                return ScanSpecPathMatch.WITHIN_WHITELISTED_PATH;
            }
            if (!whitelistedPath.startsWith(relativePath) && !"/".equals(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (this.specificallyWhitelistedClassParentRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE;
        }
        for (String whitelistedClassPathPrefix : this.specificallyWhitelistedClassParentRelativePaths) {
            if (!whitelistedClassPathPrefix.startsWith(relativePath) && !"/".equals(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        return ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH;
    }

    public boolean isSpecificallyWhitelistedClass(String relativePath) {
        return this.specificallyWhitelistedClassRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath);
    }

    public boolean classIsNotBlacklisted(String className) {
        if (this.specificallyBlacklistedClassNames.contains(className)) {
            return false;
        }
        for (String blacklistedPackagePrefix : this.blacklistedPackagePrefixes) {
            if (!className.startsWith(blacklistedPackagePrefix)) continue;
            return false;
        }
        return true;
    }

    public synchronized void checkClassIsNotBlacklisted(String className) {
        if (!this.classIsNotBlacklisted(className)) {
            boolean isSystemPackage = className.startsWith("java.") || className.startsWith("sun.");
            throw new IllegalArgumentException("Can't scan for " + className + ", it is in a blacklisted " + (!isSystemPackage ? "package" : "system package -- you can override this by adding \"!\" or \"!!\" to the scan spec to disable system package blacklisting or system jar blacklisting respectively (see the docs)"));
        }
    }

    private static boolean containsJarName(HashSet<String> jarNames, ArrayList<Pattern> jarNamePatterns, String jarName) {
        if (jarNames.contains(jarName)) {
            return true;
        }
        for (Pattern jarNamePattern : jarNamePatterns) {
            if (!jarNamePattern.matcher(jarName).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean jarIsWhitelisted(String jarName) {
        return (this.whitelistedJars.isEmpty() && this.whitelistedJarPatterns.isEmpty() || ScanSpec.containsJarName(this.whitelistedJars, this.whitelistedJarPatterns, jarName)) && !ScanSpec.containsJarName(this.blacklistedJars, this.blacklistedJarPatterns, jarName);
    }

    public boolean blacklistSystemJars() {
        return this.blacklistSystemJars;
    }

    private synchronized <T> Class<? extends T> loadClass(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return cls;
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError e) {
            throw new RuntimeException("Exception while loading or initializing class " + className, e);
        }
    }

    public synchronized String getAnnotationName(Class<?> annotation) {
        String annotationName = annotation.getName();
        this.checkClassIsNotBlacklisted(annotationName);
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException(annotationName + " is not an annotation");
        }
        return annotation.getName();
    }

    public synchronized String[] getAnnotationNames(Class<?>[] annotations) {
        String[] annotationNames = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotationNames[i] = this.getAnnotationName(annotations[i]);
        }
        return annotationNames;
    }

    public synchronized String getInterfaceName(Class<?> iface) {
        String ifaceName = iface.getName();
        this.checkClassIsNotBlacklisted(ifaceName);
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(ifaceName + " is not an interface");
        }
        return iface.getName();
    }

    public synchronized String[] getInterfaceNames(Class<?>[] interfaces) {
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = this.getInterfaceName(interfaces[i]);
        }
        return interfaceNames;
    }

    public synchronized String getClassOrInterfaceName(Class<?> classOrInterface) {
        String classOrIfaceName = classOrInterface.getName();
        this.checkClassIsNotBlacklisted(classOrIfaceName);
        if (classOrInterface.isAnnotation()) {
            throw new IllegalArgumentException(classOrIfaceName + " is an annotation, not a regular class or interface");
        }
        return classOrInterface.getName();
    }

    public synchronized String getStandardClassName(Class<?> cls) {
        String className = cls.getName();
        this.checkClassIsNotBlacklisted(className);
        if (cls.isAnnotation()) {
            throw new IllegalArgumentException(className + " is an annotation, not a standard class");
        }
        if (cls.isInterface()) {
            throw new IllegalArgumentException(cls.getName() + " is an interface, not a standard class");
        }
        return className;
    }

    public synchronized String getClassName(Class<?> cls) {
        String className = cls.getName();
        this.checkClassIsNotBlacklisted(className);
        return className;
    }

    public synchronized void matchAllClasses(final ClassMatchProcessor classMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult) {
                for (String className : scanResult.getNamesOfAllClasses()) {
                    if (FastClasspathScanner.verbose) {
                        ScanSpec.this.log.log(3, "Matched class: " + className);
                    }
                    Class cls = ScanSpec.this.loadClass(className);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized void matchAllStandardClasses(final ClassMatchProcessor classMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult) {
                for (String className : scanResult.getNamesOfAllStandardClasses()) {
                    if (FastClasspathScanner.verbose) {
                        ScanSpec.this.log.log(3, "Matched standard class: " + className);
                    }
                    Class cls = ScanSpec.this.loadClass(className);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized void matchAllInterfaceClasses(final ClassMatchProcessor ClassMatchProcessor2) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult) {
                for (String className : scanResult.getNamesOfAllInterfaceClasses()) {
                    if (FastClasspathScanner.verbose) {
                        ScanSpec.this.log.log(3, "Matched interface class: " + className);
                    }
                    Class cls = ScanSpec.this.loadClass(className);
                    ClassMatchProcessor2.processMatch(cls);
                }
            }
        });
    }

    public synchronized void matchAllAnnotationClasses(final ClassMatchProcessor ClassMatchProcessor2) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult) {
                for (String className : scanResult.getNamesOfAllAnnotationClasses()) {
                    if (FastClasspathScanner.verbose) {
                        ScanSpec.this.log.log(3, "Matched annotation class: " + className);
                    }
                    Class cls = ScanSpec.this.loadClass(className);
                    ClassMatchProcessor2.processMatch(cls);
                }
            }
        });
    }

    public synchronized <T> void matchSubclassesOf(final Class<T> superclass, final SubclassMatchProcessor<T> subclassMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult) {
                String superclassName = ScanSpec.this.getStandardClassName(superclass);
                for (String subclassName : scanResult.getNamesOfSubclassesOf(superclassName)) {
                    if (FastClasspathScanner.verbose) {
                        ScanSpec.this.log.log(3, "Matched subclass of " + superclassName + ": " + subclassName);
                    }
                    Class cls = ScanSpec.this.loadClass(subclassName);
                    subclassMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized <T> void matchSubinterfacesOf(final Class<T> superinterface, final SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult) {
                String superinterfaceName = ScanSpec.this.getInterfaceName(superinterface);
                for (String subinterfaceName : scanResult.getNamesOfSubinterfacesOf(superinterfaceName)) {
                    if (FastClasspathScanner.verbose) {
                        ScanSpec.this.log.log(3, "Matched subinterface of " + superinterfaceName + ": " + subinterfaceName);
                    }
                    Class cls = ScanSpec.this.loadClass(subinterfaceName);
                    subinterfaceMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized <T> void matchClassesImplementing(final Class<T> implementedInterface, final InterfaceMatchProcessor<T> interfaceMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult) {
                String implementedInterfaceName = ScanSpec.this.getInterfaceName(implementedInterface);
                for (String implClass : scanResult.getNamesOfClassesImplementing(implementedInterfaceName)) {
                    if (FastClasspathScanner.verbose) {
                        ScanSpec.this.log.log(3, "Matched class implementing interface " + implementedInterfaceName + ": " + implClass);
                    }
                    Class cls = ScanSpec.this.loadClass(implClass);
                    interfaceMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized <T> void matchClassesWithFieldOfType(final Class<T> fieldType, final ClassMatchProcessor classMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult) {
                String fieldTypeName = ScanSpec.this.getClassName(fieldType);
                for (String klass : scanResult.getNamesOfClassesWithFieldOfType(fieldTypeName)) {
                    if (FastClasspathScanner.verbose) {
                        ScanSpec.this.log.log(3, "Matched class with field of type " + fieldTypeName + ": " + klass);
                    }
                    Class cls = ScanSpec.this.loadClass(klass);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    public synchronized void matchClassesWithAnnotation(final Class<?> annotation, final ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult) {
                String annotationName = ScanSpec.this.getAnnotationName(annotation);
                for (String classWithAnnotation : scanResult.getNamesOfClassesWithAnnotation(annotationName)) {
                    if (FastClasspathScanner.verbose) {
                        ScanSpec.this.log.log(3, "Matched class with annotation " + annotationName + ": " + classWithAnnotation);
                    }
                    Class cls = ScanSpec.this.loadClass(classWithAnnotation);
                    classAnnotationMatchProcessor.processMatch(cls);
                }
            }
        });
    }

    private synchronized void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        ArrayList<StaticFinalFieldMatchProcessor> matchProcessorList;
        String fullyQualifiedFieldName = className + "." + fieldName;
        if (this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors == null) {
            this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors = new HashMap<String, ArrayList<StaticFinalFieldMatchProcessor>>();
            this.classNameToStaticFinalFieldsToMatch = new HashMap<String, HashSet<String>>();
        }
        if ((matchProcessorList = this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.get(fullyQualifiedFieldName)) == null) {
            matchProcessorList = new ArrayList(4);
            this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.put(fullyQualifiedFieldName, matchProcessorList);
        }
        matchProcessorList.add(staticFinalFieldMatchProcessor);
        HashSet<String> staticFinalFieldsToMatch = this.classNameToStaticFinalFieldsToMatch.get(className);
        if (staticFinalFieldsToMatch == null) {
            staticFinalFieldsToMatch = new HashSet();
            this.classNameToStaticFinalFieldsToMatch.put(className, staticFinalFieldsToMatch);
        }
        staticFinalFieldsToMatch.add(fieldName);
    }

    public synchronized void matchStaticFinalFieldNames(Set<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            int lastDotIdx = fullyQualifiedFieldName.lastIndexOf(46);
            if (lastDotIdx <= 0) continue;
            String className = fullyQualifiedFieldName.substring(0, lastDotIdx);
            String fieldName = fullyQualifiedFieldName.substring(lastDotIdx + 1);
            this.addStaticFinalFieldProcessor(className, fieldName, staticFinalFieldMatchProcessor);
        }
    }

    public synchronized void matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedStaticFinalFieldName);
        this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    public synchronized void matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedFieldName);
        }
        this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    public void addFilePathMatcher(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
        this.filePathTestersAndMatchProcessorWrappers.add(new FilePathTesterAndMatchProcessorWrapper(filePathTester, fileMatchProcessorWrapper));
    }

    List<FilePathTesterAndMatchProcessorWrapper> getFilePathTestersAndMatchProcessorWrappers() {
        return this.filePathTestersAndMatchProcessorWrappers;
    }

    private static byte[] readAllBytes(InputStream inputStream, long fileSize) throws IOException {
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException("File larger that 2GB, cannot read contents into a Java array");
        }
        byte[] bytes = new byte[(int)fileSize];
        int bytesRead = inputStream.read(bytes);
        if ((long)bytesRead < fileSize) {
            throw new IOException("Could not read whole file");
        }
        return bytes;
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchProcessor fileMatchProcessor) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchProcessor.processMatch(relativePath, inputStream, fileSize);
            }
        };
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchProcessorWithContext.processMatch(classpathElt, relativePath, inputStream, fileSize);
            }
        };
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchContentsProcessor fileMatchContentsProcessor) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchContentsProcessor.processMatch(relativePath, ScanSpec.readAllBytes(inputStream, fileSize));
            }
        };
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchContentsProcessorWithContext.processMatch(classpathElt, relativePath, ScanSpec.readAllBytes(inputStream, fileSize));
            }
        };
    }

    private FilePathTester makeFilePathTesterMatchingRegexp(final String pathRegexp) {
        return new FilePathTester(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(pathRegexp);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr) {
                boolean matched = this.pattern.matcher(relativePathStr).matches();
                if (matched && FastClasspathScanner.verbose) {
                    ScanSpec.this.log.log(3, "File " + relativePathStr + " matched filename pattern " + pathRegexp);
                }
                return matched;
            }
        };
    }

    public synchronized void matchFilenamePattern(String pathRegexp, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public synchronized void matchFilenamePattern(String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public synchronized void matchFilenamePattern(String pathRegexp, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    public synchronized void matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    private FilePathTester makeFilePathTesterMatchingRelativePath(final String relativePathToMatch) {
        return new FilePathTester(){

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr) {
                boolean matched = relativePathStr.equals(relativePathToMatch);
                if (matched && FastClasspathScanner.verbose) {
                    ScanSpec.this.log.log(3, "Matched filename path " + relativePathToMatch);
                }
                return matched;
            }
        };
    }

    public synchronized void matchFilenamePath(String relativePathToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public synchronized void matchFilenamePath(String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public synchronized void matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    public synchronized void matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    private FilePathTester makeFilePathTesterMatchingPathLeaf(final String pathLeafToMatch) {
        return new FilePathTester(){
            private final String leafToMatch;
            {
                this.leafToMatch = pathLeafToMatch.substring(pathLeafToMatch.lastIndexOf(47) + 1);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr) {
                String relativePathLeaf = relativePathStr.substring(relativePathStr.lastIndexOf(47) + 1);
                boolean matched = relativePathLeaf.equals(this.leafToMatch);
                if (matched && FastClasspathScanner.verbose) {
                    ScanSpec.this.log.log(3, "File " + relativePathStr + " matched path leaf " + pathLeafToMatch);
                }
                return matched;
            }
        };
    }

    public synchronized void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public synchronized void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public synchronized void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    public synchronized void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    private FilePathTester makeFilePathTesterMatchingFilenameExtension(final String extensionToMatch) {
        return new FilePathTester(){
            private final String suffixToMatch;
            {
                this.suffixToMatch = "." + extensionToMatch.toLowerCase();
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePath) {
                boolean matched;
                boolean bl = matched = relativePath.endsWith(this.suffixToMatch) || relativePath.toLowerCase().endsWith(this.suffixToMatch);
                if (matched && FastClasspathScanner.verbose) {
                    ScanSpec.this.log.log(3, "File " + relativePath + " matched extension ." + extensionToMatch);
                }
                return matched;
            }
        };
    }

    public synchronized void matchFilenameExtension(String extensionToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public synchronized void matchFilenameExtension(String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public synchronized void matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    public synchronized void matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    public static class FilePathTesterAndMatchProcessorWrapper {
        FilePathTester filePathTester;
        FileMatchProcessorWrapper fileMatchProcessorWrapper;

        public FilePathTesterAndMatchProcessorWrapper(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessorWrapper = fileMatchProcessorWrapper;
        }
    }

    public static enum ScanSpecPathMatch {
        WITHIN_BLACKLISTED_PATH,
        WITHIN_WHITELISTED_PATH,
        ANCESTOR_OF_WHITELISTED_PATH,
        AT_WHITELISTED_CLASS_PACKAGE,
        NOT_WITHIN_WHITELISTED_PATH,
        WHITELISTED_FILE,
        NON_WHITELISTED_FILE;

    }

    private static interface ClassMatcher {
        public void lookForMatches(ScanResult var1);
    }
}

