/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.classpath.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.InterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanExecutor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanInterruptedException;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.VersionFinder;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class FastClasspathScanner {
    private final String[] scanSpecArgs;
    private ScanSpec scanSpec;
    private static final int DEFAULT_NUM_WORKER_THREADS = 7;
    public static boolean verbose = false;

    public synchronized FastClasspathScanner verbose() {
        verbose = true;
        return this;
    }

    public synchronized FastClasspathScanner verbose(boolean verbosity) {
        verbose = verbosity;
        return this;
    }

    public FastClasspathScanner(String ... scanSpec) {
        this.scanSpecArgs = scanSpec;
        verbose = false;
    }

    public synchronized void registerClassLoaderHandler(ClassLoaderHandler extraClassLoaderHandler) {
        this.getScanSpec().extraClassLoaderHandlers.add(extraClassLoaderHandler);
    }

    public synchronized FastClasspathScanner overrideClasspath(String classpath) {
        this.getScanSpec().overrideClasspath = classpath;
        return this;
    }

    private synchronized ScanSpec getScanSpec() {
        if (this.scanSpec == null) {
            this.scanSpec = new ScanSpec(this.scanSpecArgs);
        }
        return this.scanSpec;
    }

    public static final synchronized String getVersion() {
        return VersionFinder.getVersion();
    }

    public FastClasspathScanner ignoreFieldVisibility(boolean ignoreFieldVisibility) {
        this.getScanSpec().ignoreFieldVisibility = ignoreFieldVisibility;
        return this;
    }

    public FastClasspathScanner ignoreFieldVisibility() {
        this.ignoreFieldVisibility(true);
        return this;
    }

    public synchronized FastClasspathScanner matchAllClasses(ClassMatchProcessor classMatchProcessor) {
        this.getScanSpec().matchAllClasses(classMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchAllStandardClasses(ClassMatchProcessor classMatchProcessor) {
        this.getScanSpec().matchAllStandardClasses(classMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchAllInterfaceClasses(ClassMatchProcessor ClassMatchProcessor2) {
        this.getScanSpec().matchAllInterfaceClasses(ClassMatchProcessor2);
        return this;
    }

    public synchronized FastClasspathScanner matchAllAnnotationClasses(ClassMatchProcessor ClassMatchProcessor2) {
        this.getScanSpec().matchAllAnnotationClasses(ClassMatchProcessor2);
        return this;
    }

    public synchronized <T> FastClasspathScanner matchSubclassesOf(Class<T> superclass, SubclassMatchProcessor<T> subclassMatchProcessor) {
        this.getScanSpec().matchSubclassesOf(superclass, subclassMatchProcessor);
        return this;
    }

    public synchronized <T> FastClasspathScanner matchSubinterfacesOf(Class<T> superinterface, SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        this.getScanSpec().matchSubinterfacesOf(superinterface, subinterfaceMatchProcessor);
        return this;
    }

    public synchronized <T> FastClasspathScanner matchClassesImplementing(Class<T> implementedInterface, InterfaceMatchProcessor<T> interfaceMatchProcessor) {
        this.getScanSpec().matchClassesImplementing(implementedInterface, interfaceMatchProcessor);
        return this;
    }

    public synchronized <T> FastClasspathScanner matchClassesWithFieldOfType(Class<T> fieldType, ClassMatchProcessor classMatchProcessor) {
        this.getScanSpec().matchClassesWithFieldOfType(fieldType, classMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchClassesWithAnnotation(Class<?> annotation, ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        this.getScanSpec().matchClassesWithAnnotation(annotation, classAnnotationMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchStaticFinalFieldNames(Set<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNames, staticFinalFieldMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldName, staticFinalFieldMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNames, staticFinalFieldMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchContentsProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchContentsProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchContentsProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(pathLeafToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePath(pathLeafToMatch, fileMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(pathLeafToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePath(pathLeafToMatch, fileMatchContentsProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(extensionToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePath(extensionToMatch, fileMatchProcessor);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(extensionToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public synchronized FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePath(extensionToMatch, fileMatchContentsProcessor);
        return this;
    }

    public synchronized Future<ScanResult> scanAsync(ExecutorService executorService, int numWorkerThreads) {
        return ScanExecutor.scan(this.getScanSpec(), executorService, Math.max(numWorkerThreads, 1));
    }

    public synchronized ScanResult scan(ExecutorService executorService, int numWorkerThreads) {
        try {
            return this.scanAsync(executorService, numWorkerThreads).get();
        }
        catch (InterruptedException e) {
            throw new ScanInterruptedException();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ScanResult scan(int numWorkerThreads) {
        ExecutorService executorService = null;
        try {
            final AtomicInteger threadIdx = new AtomicInteger();
            executorService = Executors.newFixedThreadPool(Math.max(numWorkerThreads, 1), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "FastClasspathScanner-worker-" + threadIdx.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            ScanResult scanResult = this.scan(executorService, numWorkerThreads);
            return scanResult;
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
        }
    }

    public synchronized ScanResult scan() {
        return this.scan(7);
    }
}

