/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.classfileparser.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResource;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResourceQueueProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.RecursiveScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ThreadLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class ScanExecutor {
    public static Future<ScanResult> scan(final ScanSpec scanSpec, ExecutorService executorService, final int numWorkerThreads) {
        final long scanStart = System.nanoTime();
        final ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(numWorkerThreads);
        final ArrayList<ThreadLog> logs = new ArrayList<ThreadLog>(numWorkerThreads);
        final LinkedBlockingQueue<ClasspathResource> matchingFiles = new LinkedBlockingQueue<ClasspathResource>();
        final LinkedBlockingQueue<ClasspathResource> matchingClassfiles = new LinkedBlockingQueue<ClasspathResource>();
        final HashMap<File, Long> fileToTimestamp = new HashMap<File, Long>();
        ThreadLog initialLog = new ThreadLog();
        if (FastClasspathScanner.verbose) {
            initialLog.log("Starting scan");
        }
        scanSpec.log(initialLog);
        final List<File> classpathElts = new ClasspathFinder(scanSpec, initialLog).getUniqueClasspathElements();
        logs.add(initialLog);
        futures.add(executorService.submit(new RecursiveScanner(classpathElts, scanSpec, matchingFiles, matchingClassfiles, fileToTimestamp, numWorkerThreads, initialLog)));
        final LinkedBlockingQueue classInfoUnlinked = new LinkedBlockingQueue();
        final ConcurrentHashMap stringInternMap = new ConcurrentHashMap();
        for (int i = 0; i < numWorkerThreads; ++i) {
            final ThreadLog workerLog = new ThreadLog();
            logs.add(workerLog);
            futures.add(executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    final ClassfileBinaryParser classfileBinaryParser = new ClassfileBinaryParser(scanSpec, workerLog);
                    ClasspathResourceQueueProcessor.processClasspathResourceQueue(matchingClassfiles, new ClasspathResourceQueueProcessor.ClasspathResourceProcessor(){

                        @Override
                        public void processClasspathResource(ClasspathResource classpathResource, InputStream inputStream, long inputStreamLength) throws IOException {
                            ClassInfoUnlinked thisClassInfoUnlinked = classfileBinaryParser.readClassInfoFromClassfileHeader(classpathResource.relativePath, inputStream, scanSpec.getClassNameToStaticFinalFieldsToMatch(), stringInternMap);
                            if (thisClassInfoUnlinked != null) {
                                classInfoUnlinked.add(thisClassInfoUnlinked);
                                thisClassInfoUnlinked.logClassInfo(workerLog);
                            }
                        }
                    }, new ClasspathResourceQueueProcessor.EndOfClasspathResourceQueueProcessor(){

                        @Override
                        public void processEndOfQueue() {
                            classInfoUnlinked.add(ClassInfoUnlinked.END_OF_QUEUE);
                        }
                    }, workerLog);
                    return null;
                }
            }));
        }
        final HashMap classNameToClassInfo = new HashMap();
        logs.add(new ThreadLog());
        Future<Void> linkerFuture = executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                int threadsStillRunning = numWorkerThreads;
                while (threadsStillRunning > 0 && !Thread.currentThread().isInterrupted()) {
                    try {
                        ClassInfoUnlinked c = (ClassInfoUnlinked)classInfoUnlinked.take();
                        if (c == ClassInfoUnlinked.END_OF_QUEUE) {
                            --threadsStillRunning;
                            continue;
                        }
                        c.link(classNameToClassInfo);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                return null;
            }
        });
        futures.add(linkerFuture);
        Future<ScanResult> scanResult = executorService.submit(new Callable<ScanResult>(){

            @Override
            public ScanResult call() throws Exception {
                for (int i = 0; i < futures.size(); ++i) {
                    ((Future)futures.get(i)).get();
                    ((ThreadLog)logs.get(i)).flush();
                }
                ThreadLog log = new ThreadLog();
                ScanResult scanResult = new ScanResult(scanSpec, classpathElts, classNameToClassInfo, fileToTimestamp, log);
                long startMatchProcessors = System.nanoTime();
                scanSpec.callMatchProcessors(scanResult, matchingFiles, classNameToClassInfo, log);
                if (FastClasspathScanner.verbose) {
                    log.log(1, "Finished calling MatchProcessors", System.nanoTime() - startMatchProcessors);
                    log.log("Finished scan", System.nanoTime() - scanStart);
                }
                log.flush();
                return scanResult;
            }
        });
        return scanResult;
    }
}

