/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreadLog {
    private static AtomicBoolean versionLogged = new AtomicBoolean(false);
    private final Queue<ThreadLogEntry> logEntries = new ConcurrentLinkedQueue<ThreadLogEntry>();

    public void log(int indentLevel, String msg) {
        this.logEntries.add(new ThreadLogEntry(indentLevel, msg));
    }

    public void log(String msg) {
        this.logEntries.add(new ThreadLogEntry(0, msg));
    }

    public void log(int indentLevel, String msg, long elapsedTimeNanos) {
        this.logEntries.add(new ThreadLogEntry(indentLevel, msg, elapsedTimeNanos));
    }

    public void log(String msg, long elapsedTimeNanos) {
        this.logEntries.add(new ThreadLogEntry(0, msg, elapsedTimeNanos));
    }

    public void flush() {
        if (!this.logEntries.isEmpty()) {
            ThreadLogEntry logEntry;
            StringBuilder buf = new StringBuilder();
            if (versionLogged.compareAndSet(false, true) && FastClasspathScanner.verbose) {
                buf.append(new ThreadLogEntry(0, "FastClasspathScanner version " + FastClasspathScanner.getVersion()).toString());
                buf.append('\n');
            }
            while ((logEntry = this.logEntries.poll()) != null) {
                buf.append(logEntry.toString());
                buf.append('\n');
            }
            System.err.print(buf.toString());
            System.err.flush();
            this.logEntries.clear();
        }
    }

    private static class ThreadLogEntry {
        private final int indentLevel;
        private final Date time;
        private final String msg;
        private final long elapsedTimeNanos;
        private final SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmX");
        private final DecimalFormat nanoFormatter = new DecimalFormat("0.000000");

        public ThreadLogEntry(int indentLevel, String msg, long elapsedTimeNanos) {
            this.indentLevel = indentLevel;
            this.msg = msg;
            this.time = Calendar.getInstance().getTime();
            this.elapsedTimeNanos = elapsedTimeNanos;
        }

        public ThreadLogEntry(int indentLevel, String msg) {
            this(indentLevel, msg, -1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder buf = new StringBuilder();
            SimpleDateFormat simpleDateFormat = this.dateTimeFormatter;
            synchronized (simpleDateFormat) {
                buf.append(this.dateTimeFormatter.format(this.time));
            }
            buf.append('\t');
            buf.append(FastClasspathScanner.class.getSimpleName());
            buf.append('\t');
            int numIndentChars = 2 * this.indentLevel;
            for (int i = 0; i < numIndentChars - 1; ++i) {
                buf.append('-');
            }
            if (numIndentChars > 0) {
                buf.append(" ");
            }
            buf.append(this.msg);
            if (this.elapsedTimeNanos >= 0L) {
                buf.append(" in ");
                buf.append(this.nanoFormatter.format((double)this.elapsedTimeNanos * 1.0E-9));
                buf.append(" sec");
            }
            return buf.toString();
        }
    }
}

