/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.utils.Join;
import io.github.lukehutch.fastclasspathscanner.utils.LoggedThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ClassInfoUnlinked {
    String className;
    private boolean isInterface;
    private boolean isAnnotation;
    private String superclassName;
    private List<String> implementedInterfaces;
    private List<String> annotations;
    private Set<String> fieldTypes;
    private Map<String, Object> staticFinalFieldValues;
    private ConcurrentHashMap<String, String> stringInternMap;

    ClassInfoUnlinked() {
    }

    private String intern(String string) {
        String oldValue = this.stringInternMap.putIfAbsent(string, string);
        return oldValue == null ? string : oldValue;
    }

    ClassInfoUnlinked(String className, boolean isInterface, boolean isAnnotation, ConcurrentHashMap<String, String> stringInternMap) {
        this.stringInternMap = stringInternMap;
        this.className = this.intern(className);
        this.isInterface = isInterface;
        this.isAnnotation = isAnnotation;
    }

    void addSuperclass(String superclassName) {
        this.superclassName = this.intern(superclassName);
    }

    void addImplementedInterface(String interfaceName) {
        if (this.implementedInterfaces == null) {
            this.implementedInterfaces = new ArrayList<String>();
        }
        this.implementedInterfaces.add(this.intern(interfaceName));
    }

    void addAnnotation(String annotationName) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<String>();
        }
        this.annotations.add(this.intern(annotationName));
    }

    void addFieldType(String fieldTypeName) {
        if (this.fieldTypes == null) {
            this.fieldTypes = new HashSet<String>();
        }
        this.fieldTypes.add(this.intern(fieldTypeName));
    }

    void addFieldConstantValue(String fieldName, Object staticFinalFieldValue) {
        if (this.staticFinalFieldValues == null) {
            this.staticFinalFieldValues = new HashMap<String, Object>();
        }
        this.staticFinalFieldValues.put(this.intern(fieldName), staticFinalFieldValue);
    }

    void link(Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo classInfo = ClassInfo.addScannedClass(this.className, this.isInterface, this.isAnnotation, classNameToClassInfo);
        if (this.superclassName != null) {
            classInfo.addSuperclass(this.superclassName, classNameToClassInfo);
        }
        if (this.implementedInterfaces != null) {
            for (String string : this.implementedInterfaces) {
                classInfo.addImplementedInterface(string, classNameToClassInfo);
            }
        }
        if (this.annotations != null) {
            for (String string : this.annotations) {
                classInfo.addAnnotation(string, classNameToClassInfo);
            }
        }
        if (this.fieldTypes != null) {
            for (String string : this.fieldTypes) {
                classInfo.addFieldType(string, classNameToClassInfo);
            }
        }
        if (this.staticFinalFieldValues != null) {
            for (Map.Entry entry : this.staticFinalFieldValues.entrySet()) {
                classInfo.addFieldConstantValue((String)entry.getKey(), entry.getValue());
            }
        }
    }

    void logTo(LoggedThread.ThreadLog log) {
        if (FastClasspathScanner.verbose) {
            log.log(2, "Found " + (this.isAnnotation ? "annotation class" : (this.isInterface ? "interface class" : "class")) + " " + this.className);
            if (this.superclassName != null && !"java.lang.Object".equals(this.superclassName)) {
                log.log(3, "Super" + (this.isInterface && !this.isAnnotation ? "interface" : "class") + ": " + this.superclassName);
            }
            if (this.implementedInterfaces != null) {
                log.log(3, "Interfaces: " + Join.join(", ", this.implementedInterfaces));
            }
            if (this.annotations != null) {
                log.log(3, "Annotations: " + Join.join(", ", this.annotations));
            }
            if (this.fieldTypes != null) {
                log.log(3, "Field types: " + Join.join(", ", this.fieldTypes));
            }
            if (this.staticFinalFieldValues != null) {
                ArrayList<String> fieldInitializers = new ArrayList<String>();
                for (Map.Entry<String, Object> ent : this.staticFinalFieldValues.entrySet()) {
                    fieldInitializers.add(ent.getKey() + " = " + ent.getValue());
                }
                log.log(3, "Static final field values: " + Join.join(", ", fieldInitializers));
            }
        }
    }
}

