/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResource;
import io.github.lukehutch.fastclasspathscanner.utils.LoggedThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClasspathResourceQueueProcessor {
    ClasspathResourceQueueProcessor() {
    }

    public static void processClasspathResourceQueue(LinkedBlockingQueue<ClasspathResource> queue, ClasspathResource endOfQueueMarker, ClasspathResourceProcessor classpathResourceProcessor, LoggedThread.ThreadLog log) throws InterruptedException {
        ZipFile currentlyOpenZipFile = null;
        try {
            ClasspathResource prevClasspathResource = null;
            while (true) {
                long fileStartTime;
                ClasspathResource classpathResource;
                block49: {
                    if ((classpathResource = queue.take()) == endOfQueueMarker) {
                        return;
                    }
                    fileStartTime = System.nanoTime();
                    boolean classpathResourceIsJar = classpathResource.classpathElt.isFile();
                    if (prevClasspathResource == null || classpathResource.classpathElt != prevClasspathResource.classpathElt) {
                        if (currentlyOpenZipFile != null) {
                            try {
                                currentlyOpenZipFile.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            currentlyOpenZipFile = null;
                        }
                        if (classpathResourceIsJar) {
                            try {
                                currentlyOpenZipFile = new ZipFile(classpathResource.classpathElt);
                            }
                            catch (IOException e) {
                                if (!FastClasspathScanner.verbose) continue;
                                log.log(2, "Exception while trying to open jarfile " + classpathResource.classpathElt + ": " + e);
                                continue;
                            }
                        }
                    }
                    if (classpathResourceIsJar) {
                        ZipEntry zipEntry = currentlyOpenZipFile.getEntry(classpathResource.relativePath);
                        try (InputStream inputStream = currentlyOpenZipFile.getInputStream(currentlyOpenZipFile.getEntry(classpathResource.relativePath));){
                            classpathResourceProcessor.processClasspathResource(classpathResource, inputStream, zipEntry.getSize());
                            break block49;
                        }
                        catch (IOException e) {
                            if (FastClasspathScanner.verbose) {
                                log.log(2, "Exception while trying to open entry " + classpathResource.relativePath + " in jarfile " + classpathResource.classpathElt + " : " + e);
                            }
                            break block49;
                        }
                    }
                    String filename = classpathResource.classpathElt.getPath() + File.separatorChar + (File.separatorChar == '/' ? classpathResource.relativePath : classpathResource.relativePath.replace('/', File.separatorChar));
                    File file = new File(filename);
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        classpathResourceProcessor.processClasspathResource(classpathResource, inputStream, file.length());
                    }
                    catch (IOException e) {
                        if (!FastClasspathScanner.verbose) break block49;
                        log.log(2, "Exception while trying to open file " + filename + " : " + e);
                    }
                }
                if (FastClasspathScanner.verbose) {
                    log.log(3, "Parsed classfile " + classpathResource.relativePath + " on classpath element " + classpathResource.classpathElt, System.nanoTime() - fileStartTime);
                }
                prevClasspathResource = classpathResource;
                if (Thread.currentThread().isInterrupted()) break;
            }
            throw new InterruptedException();
        }
        finally {
            if (currentlyOpenZipFile != null) {
                try {
                    currentlyOpenZipFile.close();
                }
                catch (IOException iOException) {}
                currentlyOpenZipFile = null;
            }
        }
    }

    public static interface ClasspathResourceProcessor {
        public void processClasspathResource(ClasspathResource var1, InputStream var2, long var3) throws IOException, InterruptedException;
    }
}

