/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResource;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResourceQueueProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.RecursiveScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LoggedThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ScanExecutor {
    public static Future<ScanResult> scan(final ScanSpec scanSpec, final List<File> classpathElts, ExecutorService executorService, final int numWorkerThreads) {
        final long scanStart = System.nanoTime();
        final ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(numWorkerThreads);
        final LinkedBlockingQueue matchingFiles = new LinkedBlockingQueue();
        final LinkedBlockingQueue matchingClassfiles = new LinkedBlockingQueue();
        final ClasspathResource END_OF_CLASSPATH_RESOURCE_QUEUE = new ClasspathResource();
        final HashMap fileToTimestamp = new HashMap();
        final AtomicBoolean killAllThreads = new AtomicBoolean(false);
        futures.add(executorService.submit(new LoggedThread<Void>(){

            @Override
            public Void doWork() throws Exception {
                try {
                    new RecursiveScanner(classpathElts, scanSpec, matchingFiles, matchingClassfiles, fileToTimestamp, killAllThreads, this.log).scan();
                    if (Thread.currentThread().isInterrupted()) {
                        killAllThreads.set(true);
                    }
                    if (killAllThreads.get()) {
                        matchingClassfiles.clear();
                        matchingFiles.clear();
                    }
                }
                finally {
                    for (int i = 0; i < numWorkerThreads; ++i) {
                        matchingClassfiles.add(END_OF_CLASSPATH_RESOURCE_QUEUE);
                        matchingFiles.add(END_OF_CLASSPATH_RESOURCE_QUEUE);
                    }
                }
                return null;
            }
        }));
        final LinkedBlockingQueue classInfoUnlinked = new LinkedBlockingQueue();
        final ClassInfoUnlinked END_OF_CLASSINFO_UNLINKED_QUEUE = new ClassInfoUnlinked();
        final ConcurrentHashMap stringInternMap = new ConcurrentHashMap();
        for (int i = 0; i < numWorkerThreads; ++i) {
            futures.add(executorService.submit(new LoggedThread<Void>(){

                @Override
                public Void doWork() throws Exception {
                    try {
                        final ClassfileBinaryParser classfileBinaryParser = new ClassfileBinaryParser(scanSpec, this.log);
                        ClasspathResourceQueueProcessor.processClasspathResourceQueue(matchingClassfiles, END_OF_CLASSPATH_RESOURCE_QUEUE, new ClasspathResourceQueueProcessor.ClasspathResourceProcessor(){

                            @Override
                            public void processClasspathResource(ClasspathResource classpathResource, InputStream inputStream, long inputStreamLength) throws IOException, InterruptedException {
                                ClassInfoUnlinked thisClassInfoUnlinked = classfileBinaryParser.readClassInfoFromClassfileHeader(classpathResource.relativePath, inputStream, scanSpec.getClassNameToStaticFinalFieldsToMatch(), stringInternMap);
                                if (thisClassInfoUnlinked != null) {
                                    classInfoUnlinked.add(thisClassInfoUnlinked);
                                    thisClassInfoUnlinked.logTo(log);
                                }
                                if (Thread.currentThread().isInterrupted()) {
                                    throw new InterruptedException();
                                }
                            }
                        }, this.log);
                    }
                    catch (InterruptedException e) {
                        classInfoUnlinked.clear();
                        killAllThreads.set(true);
                    }
                    finally {
                        classInfoUnlinked.add(END_OF_CLASSINFO_UNLINKED_QUEUE);
                    }
                    return null;
                }
            }));
        }
        final HashMap classNameToClassInfo = new HashMap();
        Future<Void> linkerFuture = executorService.submit(new LoggedThread<Void>(){

            @Override
            public Void doWork() {
                try {
                    int threadsStillRunning = numWorkerThreads;
                    while (threadsStillRunning > 0) {
                        ClassInfoUnlinked c = (ClassInfoUnlinked)classInfoUnlinked.take();
                        if (c == END_OF_CLASSINFO_UNLINKED_QUEUE) {
                            --threadsStillRunning;
                        } else {
                            c.link(classNameToClassInfo);
                        }
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                }
                catch (InterruptedException e) {
                    killAllThreads.set(true);
                }
                return null;
            }
        });
        futures.add(linkerFuture);
        Future<ScanResult> scanResult = executorService.submit(new LoggedThread<ScanResult>(){

            @Override
            public ScanResult doWork() throws Exception {
                try {
                    for (int i = 0; i < futures.size(); ++i) {
                        ((Future)futures.get(i)).get();
                        if (!killAllThreads.get() && !Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                    ScanResult scanResult = new ScanResult(scanSpec, classNameToClassInfo, fileToTimestamp, this.log);
                    long startMatchProcessors = System.nanoTime();
                    scanSpec.callMatchProcessors(scanResult, matchingFiles, END_OF_CLASSPATH_RESOURCE_QUEUE, classNameToClassInfo, this.log);
                    if (FastClasspathScanner.verbose) {
                        this.log.log(1, "Finished calling MatchProcessors", System.nanoTime() - startMatchProcessors);
                        this.log.log("Finished scan", System.nanoTime() - scanStart);
                    }
                    return scanResult;
                }
                catch (InterruptedException e) {
                    killAllThreads.set(true);
                    throw e;
                }
            }
        });
        return scanResult;
    }
}

